#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class UserCreate(APIObject):
    """
    Attributes
    ----------
    first_name:str
         First name of the user being created.
    user_type:str
         External name for UserType such as AcademicUser, BasicUser, ProUser.
    username:str
         Email address of new user.
    country:str [optional]
         Country where the user lives.. 
    expiration_date:datetime [optional]
         Datetime, RFC3339, at which the user should expire.. 
    language:str [optional]
         Sets the language in the app for the user, and the language of the invite email, if the user is being invited (i.e. the password is omitted). Value must be a valid ISO-639-1 language code. Available options are: `en`, `ja`, `fr`, `ko`. System's default language will be used if omitted.. 
    last_name:str [optional]
         Last name of the user being created.. 
    max_gpu_workers:int [optional]
         Amount of user's available GPU workers.. 
    max_upload_size:int [optional]
         The upper limit for the allowed upload size for this user.. 
    max_upload_size_catalog:int [optional]
         The upper limit for the allowed upload size in the AI catalog for this user.. 
    max_workers:int [optional]
         Amount of user's available workers.. 
    organization_id:str [optional]
         ID of the organization to add the user to.. 
    password:str [optional]
         Creates user with this password, if blank sends username invite.. 
    require_clickthrough_agreement:bool [optional]
         Boolean to require the user to agree to a clickthrough.. 
    """
    _converter = t.Dict(
        {
            t.Key("first_name"):  t.String(),
            t.Key("user_type"):  t.String(),
            t.Key("username"):  t.String(),
            t.Key("country", optional=True):  t.String(),
            t.Key("expiration_date", optional=True):  t.DateTime(),
            t.Key("language", optional=True):  t.String(),
            t.Key("last_name", optional=True):  t.String(),
            t.Key("max_gpu_workers", optional=True):  t.Int(),
            t.Key("max_upload_size", optional=True):  t.Int(),
            t.Key("max_upload_size_catalog", optional=True):  t.Int(),
            t.Key("max_workers", optional=True):  t.Int(),
            t.Key("organization_id", optional=True):  t.String(),
            t.Key("password", optional=True):  t.String(),
            t.Key("require_clickthrough_agreement", optional=True):  t.Bool(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        first_name,
        user_type,
        username,
        country=None,
        expiration_date=None,
        language=None,
        last_name=None,
        max_gpu_workers=None,
        max_upload_size=None,
        max_upload_size_catalog=None,
        max_workers=None,
        organization_id=None,
        password=None,
        require_clickthrough_agreement=None,
    ):
        self.first_name = first_name
        self.user_type = user_type
        self.username = username
        self.country = country
        self.expiration_date = expiration_date
        self.language = language
        self.last_name = last_name
        self.max_gpu_workers = max_gpu_workers
        self.max_upload_size = max_upload_size
        self.max_upload_size_catalog = max_upload_size_catalog
        self.max_workers = max_workers
        self.organization_id = organization_id
        self.password = password
        self.require_clickthrough_agreement = require_clickthrough_agreement

    def __repr__(self):
        return (
            "UserCreate("
            "first_name={0.first_name}, "
            "user_type={0.user_type}, "
            "username={0.username}, "
            "country={0.country}, "
            "expiration_date={0.expiration_date}, "
            "language={0.language}, "
            "last_name={0.last_name}, "
            "max_gpu_workers={0.max_gpu_workers}, "
            "max_upload_size={0.max_upload_size}, "
            "max_upload_size_catalog={0.max_upload_size_catalog}, "
            "max_workers={0.max_workers}, "
            "organization_id={0.organization_id}, "
            "password={0.password}, "
            "require_clickthrough_agreement={0.require_clickthrough_agreement}, "
        ).format(self)
