#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.notify_status import NotifyStatus

class UserCreateResponse(APIObject):
    """
    Attributes
    ----------
    user_id:str
         The ID of the user.
    username:str
         The username of the user.
    notify_status:NotifyStatus [optional]
         
    """
    _converter = t.Dict(
        {
            t.Key("user_id"):  t.String(),
            t.Key("username"):  t.String(),
            t.Key("notify_status", optional=True):  t.Any(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        user_id,
        username,
        notify_status=None,
    ):
        self.user_id = user_id
        self.username = username
        self.notify_status = notify_status

    def __repr__(self):
        return (
            "UserCreateResponse("
            "user_id={0.user_id}, "
            "username={0.username}, "
            "notify_status={0.notify_status}, "
        ).format(self)
