#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class UserGroupCreate(APIObject):
    """
    Attributes
    ----------
    name:str
         The name of the new user group. Must be unique.
    access_role_id:str [optional]
         The identifier of the access role assigned to the group.. 
    description:str [optional]
         The description of this user group.. 
    email:str [optional]
         The email that can be used to contact this user group.. 
    org_id:str [optional]
         The organization identifier of this user group.. 
    """
    _converter = t.Dict(
        {
            t.Key("name"):  t.String(),
            t.Key("access_role_id", optional=True):  t.String(),
            t.Key("description", optional=True):  t.String(),
            t.Key("email", optional=True):  t.String(),
            t.Key("org_id", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        name,
        access_role_id=None,
        description=None,
        email=None,
        org_id=None,
    ):
        self.name = name
        self.access_role_id = access_role_id
        self.description = description
        self.email = email
        self.org_id = org_id

    def __repr__(self):
        return (
            "UserGroupCreate("
            "name={0.name}, "
            "access_role_id={0.access_role_id}, "
            "description={0.description}, "
            "email={0.email}, "
            "org_id={0.org_id}, "
        ).format(self)
