#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class UserGroupResponse(APIObject):
    """
    Attributes
    ----------
    access_role_id:str, none_type
         The identifier of the access role assigned to the group.
    access_role_name:str, none_type
         The name of the access role assigned to the group.
    account_permissions:{str: (bool,)}
         Account permissions of this user group. Each key is a permission name.
    created_by:str, none_type
         The identifier of the user who created this user group.
    description:str, none_type
         The description of this user group.
    email:str, none_type
         The email of this user group.
    id:str
         The identifier of the user group.
    max_app_count_limit:int, none_type
         The upper limit for the allowed applications count.
    max_custom_deployments_limit:int, none_type
         Maximum allowed value for maxCustomDeployment for the user group.
    max_eda_workers:int, none_type
         The upper limit for a number of EDA workers to be run for users of this user group.
    max_ram:int, none_type
         The upper limit for amount of RAM available to users of this user group.
    max_upload_catalog_size_limit:int, none_type
         The upper limit for the allowed upload size in the AI catalog for this user group.
    max_upload_size_limit:int, none_type
         The upper limit for the allowed upload size.
    max_workers:int, none_type
         The upper limit for a number of workers to be run for users of this user group.
    members_count:int
         The number of members in this user group.
    name:str
         The name of the user group.
    org_id:str, none_type
         The identifier of the organization the user group belongs to.
    org_name:str, none_type
         The name of the organization this user group belongs to.
    """
    _converter = t.Dict(
        {
            t.Key("access_role_id"):  t.String(),
            t.Key("access_role_name"):  t.String(),
            t.Key("account_permissions"):  t.Mapping(t.String(), t.Any()),
            t.Key("created_by"):  t.String(),
            t.Key("description"):  t.String(),
            t.Key("email"):  t.String(),
            t.Key("id"):  t.String(),
            t.Key("max_app_count_limit"):  t.Int(),
            t.Key("max_custom_deployments_limit"):  t.Int(),
            t.Key("max_eda_workers"):  t.Int(),
            t.Key("max_ram"):  t.Int(),
            t.Key("max_upload_catalog_size_limit"):  t.Int(),
            t.Key("max_upload_size_limit"):  t.Int(),
            t.Key("max_workers"):  t.Int(),
            t.Key("members_count"):  t.Int(),
            t.Key("name"):  t.String(),
            t.Key("org_id"):  t.String(),
            t.Key("org_name"):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        access_role_id,
        access_role_name,
        account_permissions,
        created_by,
        description,
        email,
        id,
        max_app_count_limit,
        max_custom_deployments_limit,
        max_eda_workers,
        max_ram,
        max_upload_catalog_size_limit,
        max_upload_size_limit,
        max_workers,
        members_count,
        name,
        org_id,
        org_name,
    ):
        self.access_role_id = access_role_id
        self.access_role_name = access_role_name
        self.account_permissions = account_permissions
        self.created_by = created_by
        self.description = description
        self.email = email
        self.id = id
        self.max_app_count_limit = max_app_count_limit
        self.max_custom_deployments_limit = max_custom_deployments_limit
        self.max_eda_workers = max_eda_workers
        self.max_ram = max_ram
        self.max_upload_catalog_size_limit = max_upload_catalog_size_limit
        self.max_upload_size_limit = max_upload_size_limit
        self.max_workers = max_workers
        self.members_count = members_count
        self.name = name
        self.org_id = org_id
        self.org_name = org_name

    def __repr__(self):
        return (
            "UserGroupResponse("
            "access_role_id={0.access_role_id}, "
            "access_role_name={0.access_role_name}, "
            "account_permissions={0.account_permissions}, "
            "created_by={0.created_by}, "
            "description={0.description}, "
            "email={0.email}, "
            "id={0.id}, "
            "max_app_count_limit={0.max_app_count_limit}, "
            "max_custom_deployments_limit={0.max_custom_deployments_limit}, "
            "max_eda_workers={0.max_eda_workers}, "
            "max_ram={0.max_ram}, "
            "max_upload_catalog_size_limit={0.max_upload_catalog_size_limit}, "
            "max_upload_size_limit={0.max_upload_size_limit}, "
            "max_workers={0.max_workers}, "
            "members_count={0.members_count}, "
            "name={0.name}, "
            "org_id={0.org_id}, "
            "org_name={0.org_name}, "
        ).format(self)
