#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class UserGroupUpdate(APIObject):
    """
    Attributes
    ----------
    access_role_id:str, none_type [optional]
         The identifier of the access role to assign to the group.. 
    account_permissions:{str: (bool,)} [optional]
         Account permissions to set for this user group. Each key is a permission name.. 
    description:str [optional]
         The description of this user group.. 
    email:str [optional]
         The email of this user group.. 
    max_app_count:int, none_type [optional]
         The upper limit for the allowed applications count for the user group.. 
    max_custom_deployments:int, none_type [optional]
         Maximum allowed value for maxCustomDeployment for the user group.. 
    max_eda_workers:int [optional]
         The upper limit for a number of EDA workers to be run for users of this user group.. 
    max_ram:int [optional]
         The upper limit for amount of RAM available to users of this user group.. 
    max_upload_size:int, none_type [optional]
         The upper limit for the allowed upload size for the user group.. 
    max_upload_size_catalog:int, none_type [optional]
         The upper limit for the allowed upload size in the AI catalog for this user group.. 
    max_workers:int [optional]
         The upper limit for a number of workers to be run for users of this user group.. 
    name:str [optional]
         The new name for the user group.. 
    org_id:str [optional]
         The id of the organization to assign the user group to.. 
    """
    _converter = t.Dict(
        {
            t.Key("access_role_id", optional=True):  t.String(),
            t.Key("account_permissions", optional=True):  t.Mapping(t.String(), t.Any()),
            t.Key("description", optional=True):  t.String(),
            t.Key("email", optional=True):  t.String(),
            t.Key("max_app_count", optional=True):  t.Int(),
            t.Key("max_custom_deployments", optional=True):  t.Int(),
            t.Key("max_eda_workers", optional=True):  t.Int(),
            t.Key("max_ram", optional=True):  t.Int(),
            t.Key("max_upload_size", optional=True):  t.Int(),
            t.Key("max_upload_size_catalog", optional=True):  t.Int(),
            t.Key("max_workers", optional=True):  t.Int(),
            t.Key("name", optional=True):  t.String(),
            t.Key("org_id", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        access_role_id=None,
        account_permissions=None,
        description=None,
        email=None,
        max_app_count=None,
        max_custom_deployments=None,
        max_eda_workers=None,
        max_ram=None,
        max_upload_size=None,
        max_upload_size_catalog=None,
        max_workers=None,
        name=None,
        org_id=None,
    ):
        self.access_role_id = access_role_id
        self.account_permissions = account_permissions
        self.description = description
        self.email = email
        self.max_app_count = max_app_count
        self.max_custom_deployments = max_custom_deployments
        self.max_eda_workers = max_eda_workers
        self.max_ram = max_ram
        self.max_upload_size = max_upload_size
        self.max_upload_size_catalog = max_upload_size_catalog
        self.max_workers = max_workers
        self.name = name
        self.org_id = org_id

    def __repr__(self):
        return (
            "UserGroupUpdate("
            "access_role_id={0.access_role_id}, "
            "account_permissions={0.account_permissions}, "
            "description={0.description}, "
            "email={0.email}, "
            "max_app_count={0.max_app_count}, "
            "max_custom_deployments={0.max_custom_deployments}, "
            "max_eda_workers={0.max_eda_workers}, "
            "max_ram={0.max_ram}, "
            "max_upload_size={0.max_upload_size}, "
            "max_upload_size_catalog={0.max_upload_size_catalog}, "
            "max_workers={0.max_workers}, "
            "name={0.name}, "
            "org_id={0.org_id}, "
        ).format(self)
