#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class UserInGroup(APIObject):
    """
    Attributes
    ----------
    first_name:str, none_type
         The first name of the user.
    last_name:str, none_type
         The last name of the user.
    organization:str, none_type
         The name of the organization the user is part of.
    status:str, none_type
         The status of the user, `active` if the has been activated, `inactive` otherwise.
    user_id:str, none_type
         The identifier of the user.
    username:str
         The name of the user.
    scheduled_for_deletion:bool [optional]
         If the user is scheduled for deletion. Will be returned when an appropriate FF is enabled.. 
    """
    _converter = t.Dict(
        {
            t.Key("first_name"):  t.String(),
            t.Key("last_name"):  t.String(),
            t.Key("organization"):  t.String(),
            t.Key("status"):  t.String(),
            t.Key("user_id"):  t.String(),
            t.Key("username"):  t.String(),
            t.Key("scheduled_for_deletion", optional=True):  t.Bool(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        first_name,
        last_name,
        organization,
        status,
        user_id,
        username,
        scheduled_for_deletion=None,
    ):
        self.first_name = first_name
        self.last_name = last_name
        self.organization = organization
        self.status = status
        self.user_id = user_id
        self.username = username
        self.scheduled_for_deletion = scheduled_for_deletion

    def __repr__(self):
        return (
            "UserInGroup("
            "first_name={0.first_name}, "
            "last_name={0.last_name}, "
            "organization={0.organization}, "
            "status={0.status}, "
            "user_id={0.user_id}, "
            "username={0.username}, "
            "scheduled_for_deletion={0.scheduled_for_deletion}, "
        ).format(self)
