#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class UserNotificationRelatedCommentResponse(APIObject):
    """
    Attributes
    ----------
    comment_id:str
         The ID of the comment
    entity_id:str
         The ID of the commented entity
    comment_link:str [optional]
         The link to the comment.. 
    entity_type:str [optional]
         The type of the commented entity.. 
    inactive:bool [optional]
         True if the comment was deleted.. 
    """
    _converter = t.Dict(
        {
            t.Key("comment_id"):  t.String(),
            t.Key("entity_id"):  t.String(),
            t.Key("comment_link", optional=True):  t.String(),
            t.Key("entity_type", optional=True):  t.String(),
            t.Key("inactive", optional=True):  t.Bool(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        comment_id,
        entity_id,
        comment_link=None,
        entity_type=None,
        inactive=None,
    ):
        self.comment_id = comment_id
        self.entity_id = entity_id
        self.comment_link = comment_link
        self.entity_type = entity_type
        self.inactive = inactive

    def __repr__(self):
        return (
            "UserNotificationRelatedCommentResponse("
            "comment_id={0.comment_id}, "
            "entity_id={0.entity_id}, "
            "comment_link={0.comment_link}, "
            "entity_type={0.entity_type}, "
            "inactive={0.inactive}, "
        ).format(self)
