#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class UserNotificationRelatedDeploymentResponse(APIObject):
    """
    Attributes
    ----------
    deployment_id:str
         The ID of the deployment
    deployment_name:str, none_type [optional]
         Deployment's label. 
    deployment_url:str [optional]
         The link to the deployment. 
    inactive:bool [optional]
         True if the deployment was deleted.. 
    model_id:str, none_type [optional]
         The ID of the related model. 
    project_id:str, none_type [optional]
         The ID of the related project. 
    user_id:str, none_type [optional]
         The ID of the related user. 
    """
    _converter = t.Dict(
        {
            t.Key("deployment_id"):  t.String(),
            t.Key("deployment_name", optional=True):  t.String(),
            t.Key("deployment_url", optional=True):  t.String(),
            t.Key("inactive", optional=True):  t.Bool(),
            t.Key("model_id", optional=True):  t.String(),
            t.Key("project_id", optional=True):  t.String(),
            t.Key("user_id", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        deployment_id,
        deployment_name=None,
        deployment_url=None,
        inactive=None,
        model_id=None,
        project_id=None,
        user_id=None,
    ):
        self.deployment_id = deployment_id
        self.deployment_name = deployment_name
        self.deployment_url = deployment_url
        self.inactive = inactive
        self.model_id = model_id
        self.project_id = project_id
        self.user_id = user_id

    def __repr__(self):
        return (
            "UserNotificationRelatedDeploymentResponse("
            "deployment_id={0.deployment_id}, "
            "deployment_name={0.deployment_name}, "
            "deployment_url={0.deployment_url}, "
            "inactive={0.inactive}, "
            "model_id={0.model_id}, "
            "project_id={0.project_id}, "
            "user_id={0.user_id}, "
        ).format(self)
