#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class UserNotificationRelatedProjectResponse(APIObject):
    """
    Attributes
    ----------
    pid:str
         The ID of the project
    inactive:bool [optional]
         True if the project was deleted.. 
    project_link:str [optional]
         The link to the project.. 
    project_name:str, none_type [optional]
         Project name.. 
    """
    _converter = t.Dict(
        {
            t.Key("pid"):  t.String(),
            t.Key("inactive", optional=True):  t.Bool(),
            t.Key("project_link", optional=True):  t.String(),
            t.Key("project_name", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        pid,
        inactive=None,
        project_link=None,
        project_name=None,
    ):
        self.pid = pid
        self.inactive = inactive
        self.project_link = project_link
        self.project_name = project_name

    def __repr__(self):
        return (
            "UserNotificationRelatedProjectResponse("
            "pid={0.pid}, "
            "inactive={0.inactive}, "
            "project_link={0.project_link}, "
            "project_name={0.project_name}, "
        ).format(self)
