#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class UserNotificationRelatedUserResponse(APIObject):
    """
    Attributes
    ----------
    uid:str
         The ID of the user
    full_name:str, none_type [optional]
         User's full name.. 
    gravatar_hash:str [optional]
         User's gravatar hash.. 
    inactive:bool [optional]
         True if the user was deleted.. 
    username:str [optional]
         Username of the user.. 
    """
    _converter = t.Dict(
        {
            t.Key("uid"):  t.String(),
            t.Key("full_name", optional=True):  t.String(),
            t.Key("gravatar_hash", optional=True):  t.String(),
            t.Key("inactive", optional=True):  t.Bool(),
            t.Key("username", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        uid,
        full_name=None,
        gravatar_hash=None,
        inactive=None,
        username=None,
    ):
        self.uid = uid
        self.full_name = full_name
        self.gravatar_hash = gravatar_hash
        self.inactive = inactive
        self.username = username

    def __repr__(self):
        return (
            "UserNotificationRelatedUserResponse("
            "uid={0.uid}, "
            "full_name={0.full_name}, "
            "gravatar_hash={0.gravatar_hash}, "
            "inactive={0.inactive}, "
            "username={0.username}, "
        ).format(self)
