#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.user_notification_related_comment_response import UserNotificationRelatedCommentResponse
from datarobot.models.full_api.generated.model.user_notification_related_deployment_response import UserNotificationRelatedDeploymentResponse
from datarobot.models.full_api.generated.model.user_notification_related_project_response import UserNotificationRelatedProjectResponse
from datarobot.models.full_api.generated.model.user_notification_related_user_response import UserNotificationRelatedUserResponse
from datarobot.models.full_api.generated.model.user_notification_related_users_delete_response import UserNotificationRelatedUsersDeleteResponse

class UserNotificationResponse(APIObject):
    """
    Attributes
    ----------
    caller_user:UserNotificationRelatedUserResponse
        
    created:datetime
         The ISO 8601 formatted date and time when the notification was created.
    description:str, none_type
         Notification's description
    event_type:str
         The type of the notification.
    is_read:bool
         True if the notification is already read.
    link:str
         Call-to-action link for the notification
    push_notification_sent:bool
         True if the notification was also sent via push notifications.
    title:str, none_type
         Notification's title
    updated:datetime
         The ISO 8601 formatted date and time when the notification was updated.
    user_notification_id:str
         The ID of the notification
    related_comment:UserNotificationRelatedCommentResponse [optional]
         
    related_deployment:UserNotificationRelatedDeploymentResponse [optional]
         
    related_project:UserNotificationRelatedProjectResponse [optional]
         
    related_users_delete:UserNotificationRelatedUsersDeleteResponse [optional]
         
    shared_users:[UserNotificationRelatedUserResponse] [optional]
         List of the user details a resource was shared with.. 
    status_id:str [optional]
         Asynchronous job status ID. 
    """
    _converter = t.Dict(
        {
            t.Key("caller_user"):  t.Any(),
            t.Key("created"):  t.DateTime(),
            t.Key("description"):  t.String(),
            t.Key("event_type"):  t.String(),
            t.Key("is_read"):  t.Bool(),
            t.Key("link"):  t.String(),
            t.Key("push_notification_sent"):  t.Bool(),
            t.Key("title"):  t.String(),
            t.Key("updated"):  t.DateTime(),
            t.Key("user_notification_id"):  t.String(),
            t.Key("related_comment", optional=True):  t.Any(),
            t.Key("related_deployment", optional=True):  t.Any(),
            t.Key("related_project", optional=True):  t.Any(),
            t.Key("related_users_delete", optional=True):  t.Any(),
            t.Key("shared_users", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("status_id", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        caller_user,
        created,
        description,
        event_type,
        is_read,
        link,
        push_notification_sent,
        title,
        updated,
        user_notification_id,
        related_comment=None,
        related_deployment=None,
        related_project=None,
        related_users_delete=None,
        shared_users=None,
        status_id=None,
    ):
        self.caller_user = caller_user
        self.created = created
        self.description = description
        self.event_type = event_type
        self.is_read = is_read
        self.link = link
        self.push_notification_sent = push_notification_sent
        self.title = title
        self.updated = updated
        self.user_notification_id = user_notification_id
        self.related_comment = related_comment
        self.related_deployment = related_deployment
        self.related_project = related_project
        self.related_users_delete = related_users_delete
        self.shared_users = shared_users
        self.status_id = status_id

    def __repr__(self):
        return (
            "UserNotificationResponse("
            "caller_user={0.caller_user}, "
            "created={0.created}, "
            "description={0.description}, "
            "event_type={0.event_type}, "
            "is_read={0.is_read}, "
            "link={0.link}, "
            "push_notification_sent={0.push_notification_sent}, "
            "title={0.title}, "
            "updated={0.updated}, "
            "user_notification_id={0.user_notification_id}, "
            "related_comment={0.related_comment}, "
            "related_deployment={0.related_deployment}, "
            "related_project={0.related_project}, "
            "related_users_delete={0.related_users_delete}, "
            "shared_users={0.shared_users}, "
            "status_id={0.status_id}, "
        ).format(self)
