#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class UserRoleWithGrant(APIObject):
    """
    Attributes
    ----------
    role:str, none_type
         The role to set on the entity. When it is None, the role of this user will be removedfrom this entity.
    username:str
         Username of the user to update the access role for.
    can_share:bool [optional]
         Whether the org/group/user should be able to share with others.If true, the org/group/user will be able to grant any role up to and includingtheir own to other orgs/groups/user. If `role` is `NO_ROLE` `canShare` is ignored..  if omitted the server will use the default value of True
    """
    _converter = t.Dict(
        {
            t.Key("role"):  t.String(),
            t.Key("username"):  t.String(),
            t.Key("can_share", optional=True):  t.Bool(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        role,
        username,
        can_share=None,
    ):
        self.role = role
        self.username = username
        self.can_share = can_share

    def __repr__(self):
        return (
            "UserRoleWithGrant("
            "role={0.role}, "
            "username={0.username}, "
            "can_share={0.can_share}, "
        ).format(self)
