#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class UsernamePasswordCatalogDataSourcePayload(APIObject):
    """
    Attributes
    ----------
    datasource_id:str
         Id of the Catalog object
    password:str
         User password to connect to the data location
    type_id:str
         Id of the target, currently only `catalog`. defaults to "catalog", must be one of ["catalog", ]
    user_name:str
         User name to connect to the data location
    """
    _converter = t.Dict(
        {
            t.Key("datasource_id"):  t.String(),
            t.Key("password"):  t.String(),
            t.Key("type_id"):  t.String(),
            t.Key("user_name"):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        datasource_id,
        password,
        type_id,
        user_name,
    ):
        self.datasource_id = datasource_id
        self.password = password
        self.type_id = type_id
        self.user_name = user_name

    def __repr__(self):
        return (
            "UsernamePasswordCatalogDataSourcePayload("
            "datasource_id={0.datasource_id}, "
            "password={0.password}, "
            "type_id={0.type_id}, "
            "user_name={0.user_name}, "
        ).format(self)
