#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class UsersPermadelete(APIObject):
    """
    Attributes
    ----------
    force_deployment_delete:bool
         If true, any deployment this user group has a role on, including those shared outside the users, will be deleted.. defaults to False
    force_project_delete:bool
         If true, any project this user group has a role on, including those shared outside the users, will be deleted.. defaults to False
    org_id:str, none_type [optional]
         Organization which's users to be permanently deleted..  if omitted the server will use the default value of "null"
    orphans_owner:str, none_type [optional]
         User which becomes an owner of any projects or deployments that otherwise cause an error because they would be orphaned..  if omitted the server will use the default value of "null"
    user_ids:[str], none_type [optional]
         Users to be permanently deleted.. 
    """
    _converter = t.Dict(
        {
            t.Key("force_deployment_delete"):  t.Bool(),
            t.Key("force_project_delete"):  t.Bool(),
            t.Key("org_id", optional=True):  t.String(),
            t.Key("orphans_owner", optional=True):  t.String(),
            t.Key("user_ids", optional=True):  t.List(t.Dict().allow_extra("*")),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        force_deployment_delete,
        force_project_delete,
        org_id=None,
        orphans_owner=None,
        user_ids=None,
    ):
        self.force_deployment_delete = force_deployment_delete
        self.force_project_delete = force_project_delete
        self.org_id = org_id
        self.orphans_owner = orphans_owner
        self.user_ids = user_ids

    def __repr__(self):
        return (
            "UsersPermadelete("
            "force_deployment_delete={0.force_deployment_delete}, "
            "force_project_delete={0.force_project_delete}, "
            "org_id={0.org_id}, "
            "orphans_owner={0.orphans_owner}, "
            "user_ids={0.user_ids}, "
        ).format(self)
