#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class WordCloudNgram(APIObject):
    """
    Attributes
    ----------
    coefficient:float
         Describes effect of this ngram on the target. A large negative value means a strong effect toward the negative class in classification projects and a smaller predicted target value in regression projects. A large positive value means a strong effect toward the positive class and a larger predicted target value respectively.
    count:int
         Number of rows in the training sample where this ngram appears.
    frequency:float
         Frequency of this ngram relative to the most common ngram.
    is_stopword:bool
         True for ngrams that DataRobot evaluates as stopwords.
    ngram:str
         Word or ngram value.
    variable:str
         String representation of the ngram source - contains column name and, for some models, preprocessing details. E.g. NGRAM_OCCUR_L2_colname will be for ngram occurrences count using L2 normalization from the colname column.
    _class:str, none_type [optional]
         For classification - values of the target class for corresponding word or ngram. For regression - null.. 
    """
    _converter = t.Dict(
        {
            t.Key("coefficient"):  t.Float(),
            t.Key("count"):  t.Int(),
            t.Key("frequency"):  t.Float(),
            t.Key("is_stopword"):  t.Bool(),
            t.Key("ngram"):  t.String(),
            t.Key("variable"):  t.String(),
            t.Key("_class", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        coefficient,
        count,
        frequency,
        is_stopword,
        ngram,
        variable,
        _class=None,
    ):
        self.coefficient = coefficient
        self.count = count
        self.frequency = frequency
        self.is_stopword = is_stopword
        self.ngram = ngram
        self.variable = variable
        self._class = _class

    def __repr__(self):
        return (
            "WordCloudNgram("
            "coefficient={0.coefficient}, "
            "count={0.count}, "
            "frequency={0.frequency}, "
            "is_stopword={0.is_stopword}, "
            "ngram={0.ngram}, "
            "variable={0.variable}, "
            "_class={0._class}, "
        ).format(self)
