#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class WorkspaceSourceDatasetWithCredsResponse(APIObject):
    """
    Attributes
    ----------
    alias:str
         Alias to be used as the table name.
    dataset_id:str
         ID of a dataset in the catalog.
    dataset_version_id:str
         ID of a dataset version in the catalog.
    needs_credentials:bool
         Whether a user must provide credentials for source datasets.
    """
    _converter = t.Dict(
        {
            t.Key("alias"):  t.String(),
            t.Key("dataset_id"):  t.String(),
            t.Key("dataset_version_id"):  t.String(),
            t.Key("needs_credentials"):  t.Bool(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        alias,
        dataset_id,
        dataset_version_id,
        needs_credentials,
    ):
        self.alias = alias
        self.dataset_id = dataset_id
        self.dataset_version_id = dataset_version_id
        self.needs_credentials = needs_credentials

    def __repr__(self):
        return (
            "WorkspaceSourceDatasetWithCredsResponse("
            "alias={0.alias}, "
            "dataset_id={0.dataset_id}, "
            "dataset_version_id={0.dataset_version_id}, "
            "needs_credentials={0.needs_credentials}, "
        ).format(self)
