#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.workspace_source_dataset_with_creds_response import WorkspaceSourceDatasetWithCredsResponse

class WorkspaceStateResponse(APIObject):
    """
    Attributes
    ----------
    datasets:[WorkspaceSourceDatasetWithCredsResponse]
         Source datasets in the Data Engine workspace.
    language:str
         Language of the Data Engine query.
    query:str
         Actual body of the Data Engine query.
    query_generator_id:str, none_type
         Query generator id.
    run_time:float, none_type
         Data Engine query execution time.
    """
    _converter = t.Dict(
        {
            t.Key("datasets"):  t.List(t.Dict().allow_extra("*")),
            t.Key("language"):  t.String(),
            t.Key("query"):  t.String(),
            t.Key("query_generator_id"):  t.String(),
            t.Key("run_time"):  t.Float(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        datasets,
        language,
        query,
        query_generator_id,
        run_time,
    ):
        self.datasets = datasets
        self.language = language
        self.query = query
        self.query_generator_id = query_generator_id
        self.run_time = run_time

    def __repr__(self):
        return (
            "WorkspaceStateResponse("
            "datasets={0.datasets}, "
            "language={0.language}, "
            "query={0.query}, "
            "query_generator_id={0.query_generator_id}, "
            "run_time={0.run_time}, "
        ).format(self)
