#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import json
import responses
from six.moves.urllib.parse import urljoin
from dateutil import parser
from datarobot.models.full_api.generated.model.custom_task_copy import CustomTaskCopy
from datarobot.models.full_api.generated.model.custom_task_create import CustomTaskCreate
from datarobot.models.full_api.generated.model.custom_task_list_response import CustomTaskListResponse
from datarobot.models.full_api.generated.model.custom_task_response import CustomTaskResponse
from datarobot.models.full_api.generated.model.custom_task_update import CustomTaskUpdate
from datarobot.models.full_api.generated.model.custom_task_version_create_from_repository import CustomTaskVersionCreateFromRepository
from datarobot.models.full_api.generated.model.custom_task_version_list_response import CustomTaskVersionListResponse
from datarobot.models.full_api.generated.model.custom_task_version_metadata_update import CustomTaskVersionMetadataUpdate
from datarobot.models.full_api.generated.model.custom_task_version_response import CustomTaskVersionResponse
from datarobot.utils import from_api
from datarobot.models.full_api.generated.model import *

from datarobot.models.full_api.generated.api.custom_tasks_api import CustomTasksApi




@responses.activate
def test_custom_tasks_api_custom_task_version_create_from_latest(unittest_endpoint):
    responses.add(
        responses.PATCH,
        '{endpoint}/api/v2/customTasks/{customTaskId}/versions/'.format(endpoint=unittest_endpoint,
        customTaskId="customTaskId_example", isMajorUpdate="True", ),
        status=201,
        content_type='application/json',
        body=json.dumps({
  "baseEnvironmentVersionId" : "baseEnvironmentVersionId",
  "baseEnvironmentId" : "baseEnvironmentId",
  "created" : "created",
  "description" : "description",
  "label" : "label",
  "dependencies" : [ {
    "line" : "line",
    "packageName" : "packageName",
    "lineNumber" : 5,
    "constraints" : [ {
      "constraintType" : "<",
      "version" : "version"
    }, {
      "constraintType" : "<",
      "version" : "version"
    } ]
  }, {
    "line" : "line",
    "packageName" : "packageName",
    "lineNumber" : 5,
    "constraints" : [ {
      "constraintType" : "<",
      "version" : "version"
    }, {
      "constraintType" : "<",
      "version" : "version"
    } ]
  } ],
  "requiredMetadata" : "{}",
  "customModelId" : "customModelId",
  "customTaskId" : "customTaskId",
  "warning" : [ "warning", "warning" ],
  "id" : "id",
  "isFrozen" : True,
  "requiredMetadataValues" : [ {
    "fieldName" : "fieldName",
    "value" : "value"
  }, {
    "fieldName" : "fieldName",
    "value" : "value"
  } ],
  "versionMajor" : 1,
  "versionMinor" : 5,
  "items" : [ {
    "fileName" : "fileName",
    "ref" : "ref",
    "repositoryLocation" : "repositoryLocation",
    "created" : "created",
    "filePath" : "filePath",
    "fileSource" : "fileSource",
    "commitSha" : "commitSha",
    "id" : "id",
    "repositoryName" : "repositoryName",
    "repositoryFilePath" : "repositoryFilePath"
  }, {
    "fileName" : "fileName",
    "ref" : "ref",
    "repositoryLocation" : "repositoryLocation",
    "created" : "created",
    "filePath" : "filePath",
    "fileSource" : "fileSource",
    "commitSha" : "commitSha",
    "id" : "id",
    "repositoryName" : "repositoryName",
    "repositoryFilePath" : "repositoryFilePath"
  } ]
})
    )
    result = CustomTasksApi.custom_task_version_create_from_latest(custom_task_id="customTaskId_example", is_major_update="True", )
    assert isinstance(result, CustomTaskVersionResponse)


@responses.activate
def test_custom_tasks_api_custom_tasks_create(unittest_endpoint):
    responses.add(
        responses.POST,
       '{endpoint}/api/v2/customTasks/'.format(endpoint=unittest_endpoint),
        status=201,
        content_type='application/json',
        body=json.dumps({
  "createdBy" : "createdBy",
  "deploymentsCount" : 6,
  "latestVersion" : {
    "baseEnvironmentVersionId" : "baseEnvironmentVersionId",
    "baseEnvironmentId" : "baseEnvironmentId",
    "created" : "created",
    "description" : "description",
    "label" : "label",
    "dependencies" : [ {
      "line" : "line",
      "packageName" : "packageName",
      "lineNumber" : 5,
      "constraints" : [ {
        "constraintType" : "<",
        "version" : "version"
      }, {
        "constraintType" : "<",
        "version" : "version"
      } ]
    }, {
      "line" : "line",
      "packageName" : "packageName",
      "lineNumber" : 5,
      "constraints" : [ {
        "constraintType" : "<",
        "version" : "version"
      }, {
        "constraintType" : "<",
        "version" : "version"
      } ]
    } ],
    "requiredMetadata" : "{}",
    "customModelId" : "customModelId",
    "customTaskId" : "customTaskId",
    "warning" : [ "warning", "warning" ],
    "id" : "id",
    "isFrozen" : True,
    "requiredMetadataValues" : [ {
      "fieldName" : "fieldName",
      "value" : "value"
    }, {
      "fieldName" : "fieldName",
      "value" : "value"
    } ],
    "versionMajor" : 1,
    "versionMinor" : 5,
    "items" : [ {
      "fileName" : "fileName",
      "ref" : "ref",
      "repositoryLocation" : "repositoryLocation",
      "created" : "created",
      "filePath" : "filePath",
      "fileSource" : "fileSource",
      "commitSha" : "commitSha",
      "id" : "id",
      "repositoryName" : "repositoryName",
      "repositoryFilePath" : "repositoryFilePath"
    }, {
      "fileName" : "fileName",
      "ref" : "ref",
      "repositoryLocation" : "repositoryLocation",
      "created" : "created",
      "filePath" : "filePath",
      "fileSource" : "fileSource",
      "commitSha" : "commitSha",
      "id" : "id",
      "repositoryName" : "repositoryName",
      "repositoryFilePath" : "repositoryFilePath"
    } ]
  },
  "created" : "created",
  "calibratePredictions" : True,
  "name" : "name",
  "customModelType" : "training",
  "description" : "description",
  "language" : "language",
  "targetType" : "Binary",
  "id" : "id",
  "updated" : "updated"
})
    )
    result = CustomTasksApi.custom_tasks_create()
    assert isinstance(result, CustomTaskResponse)


@responses.activate
def test_custom_tasks_api_custom_tasks_delete(unittest_endpoint):
    responses.add(
        responses.DELETE,
        '{endpoint}/api/v2/customTasks/{customTaskId}/'.format(endpoint=unittest_endpoint,
        customTaskId="customTaskId_example", ),
        status=204,
        content_type='',
    )
    result = CustomTasksApi.custom_tasks_delete(custom_task_id="customTaskId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_custom_tasks_api_custom_tasks_download_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/customTasks/{customTaskId}/download/'.format(endpoint=unittest_endpoint,
        customTaskId="customTaskId_example", ),
        status=200,
        content_type='',
    )
    result = CustomTasksApi.custom_tasks_download_list(custom_task_id="customTaskId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_custom_tasks_api_custom_tasks_from_custom_task_create(unittest_endpoint):
    responses.add(
        responses.POST,
       '{endpoint}/api/v2/customTasks/fromCustomTask/'.format(endpoint=unittest_endpoint),
        status=201,
        content_type='application/json',
        body=json.dumps({
  "createdBy" : "createdBy",
  "deploymentsCount" : 6,
  "latestVersion" : {
    "baseEnvironmentVersionId" : "baseEnvironmentVersionId",
    "baseEnvironmentId" : "baseEnvironmentId",
    "created" : "created",
    "description" : "description",
    "label" : "label",
    "dependencies" : [ {
      "line" : "line",
      "packageName" : "packageName",
      "lineNumber" : 5,
      "constraints" : [ {
        "constraintType" : "<",
        "version" : "version"
      }, {
        "constraintType" : "<",
        "version" : "version"
      } ]
    }, {
      "line" : "line",
      "packageName" : "packageName",
      "lineNumber" : 5,
      "constraints" : [ {
        "constraintType" : "<",
        "version" : "version"
      }, {
        "constraintType" : "<",
        "version" : "version"
      } ]
    } ],
    "requiredMetadata" : "{}",
    "customModelId" : "customModelId",
    "customTaskId" : "customTaskId",
    "warning" : [ "warning", "warning" ],
    "id" : "id",
    "isFrozen" : True,
    "requiredMetadataValues" : [ {
      "fieldName" : "fieldName",
      "value" : "value"
    }, {
      "fieldName" : "fieldName",
      "value" : "value"
    } ],
    "versionMajor" : 1,
    "versionMinor" : 5,
    "items" : [ {
      "fileName" : "fileName",
      "ref" : "ref",
      "repositoryLocation" : "repositoryLocation",
      "created" : "created",
      "filePath" : "filePath",
      "fileSource" : "fileSource",
      "commitSha" : "commitSha",
      "id" : "id",
      "repositoryName" : "repositoryName",
      "repositoryFilePath" : "repositoryFilePath"
    }, {
      "fileName" : "fileName",
      "ref" : "ref",
      "repositoryLocation" : "repositoryLocation",
      "created" : "created",
      "filePath" : "filePath",
      "fileSource" : "fileSource",
      "commitSha" : "commitSha",
      "id" : "id",
      "repositoryName" : "repositoryName",
      "repositoryFilePath" : "repositoryFilePath"
    } ]
  },
  "created" : "created",
  "calibratePredictions" : True,
  "name" : "name",
  "customModelType" : "training",
  "description" : "description",
  "language" : "language",
  "targetType" : "Binary",
  "id" : "id",
  "updated" : "updated"
})
    )
    result = CustomTasksApi.custom_tasks_from_custom_task_create()
    assert isinstance(result, CustomTaskResponse)


@responses.activate
def test_custom_tasks_api_custom_tasks_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/customTasks/'.format(endpoint=unittest_endpoint,
        offset=0, limit=1000, ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "createdBy" : "createdBy",
    "deploymentsCount" : 6,
    "latestVersion" : {
      "baseEnvironmentVersionId" : "baseEnvironmentVersionId",
      "baseEnvironmentId" : "baseEnvironmentId",
      "created" : "created",
      "description" : "description",
      "label" : "label",
      "dependencies" : [ {
        "line" : "line",
        "packageName" : "packageName",
        "lineNumber" : 5,
        "constraints" : [ {
          "constraintType" : "<",
          "version" : "version"
        }, {
          "constraintType" : "<",
          "version" : "version"
        } ]
      }, {
        "line" : "line",
        "packageName" : "packageName",
        "lineNumber" : 5,
        "constraints" : [ {
          "constraintType" : "<",
          "version" : "version"
        }, {
          "constraintType" : "<",
          "version" : "version"
        } ]
      } ],
      "requiredMetadata" : "{}",
      "customModelId" : "customModelId",
      "customTaskId" : "customTaskId",
      "warning" : [ "warning", "warning" ],
      "id" : "id",
      "isFrozen" : True,
      "requiredMetadataValues" : [ {
        "fieldName" : "fieldName",
        "value" : "value"
      }, {
        "fieldName" : "fieldName",
        "value" : "value"
      } ],
      "versionMajor" : 1,
      "versionMinor" : 5,
      "items" : [ {
        "fileName" : "fileName",
        "ref" : "ref",
        "repositoryLocation" : "repositoryLocation",
        "created" : "created",
        "filePath" : "filePath",
        "fileSource" : "fileSource",
        "commitSha" : "commitSha",
        "id" : "id",
        "repositoryName" : "repositoryName",
        "repositoryFilePath" : "repositoryFilePath"
      }, {
        "fileName" : "fileName",
        "ref" : "ref",
        "repositoryLocation" : "repositoryLocation",
        "created" : "created",
        "filePath" : "filePath",
        "fileSource" : "fileSource",
        "commitSha" : "commitSha",
        "id" : "id",
        "repositoryName" : "repositoryName",
        "repositoryFilePath" : "repositoryFilePath"
      } ]
    },
    "created" : "created",
    "calibratePredictions" : True,
    "name" : "name",
    "customModelType" : "training",
    "description" : "description",
    "language" : "language",
    "targetType" : "Binary",
    "id" : "id",
    "updated" : "updated"
  }, {
    "createdBy" : "createdBy",
    "deploymentsCount" : 6,
    "latestVersion" : {
      "baseEnvironmentVersionId" : "baseEnvironmentVersionId",
      "baseEnvironmentId" : "baseEnvironmentId",
      "created" : "created",
      "description" : "description",
      "label" : "label",
      "dependencies" : [ {
        "line" : "line",
        "packageName" : "packageName",
        "lineNumber" : 5,
        "constraints" : [ {
          "constraintType" : "<",
          "version" : "version"
        }, {
          "constraintType" : "<",
          "version" : "version"
        } ]
      }, {
        "line" : "line",
        "packageName" : "packageName",
        "lineNumber" : 5,
        "constraints" : [ {
          "constraintType" : "<",
          "version" : "version"
        }, {
          "constraintType" : "<",
          "version" : "version"
        } ]
      } ],
      "requiredMetadata" : "{}",
      "customModelId" : "customModelId",
      "customTaskId" : "customTaskId",
      "warning" : [ "warning", "warning" ],
      "id" : "id",
      "isFrozen" : True,
      "requiredMetadataValues" : [ {
        "fieldName" : "fieldName",
        "value" : "value"
      }, {
        "fieldName" : "fieldName",
        "value" : "value"
      } ],
      "versionMajor" : 1,
      "versionMinor" : 5,
      "items" : [ {
        "fileName" : "fileName",
        "ref" : "ref",
        "repositoryLocation" : "repositoryLocation",
        "created" : "created",
        "filePath" : "filePath",
        "fileSource" : "fileSource",
        "commitSha" : "commitSha",
        "id" : "id",
        "repositoryName" : "repositoryName",
        "repositoryFilePath" : "repositoryFilePath"
      }, {
        "fileName" : "fileName",
        "ref" : "ref",
        "repositoryLocation" : "repositoryLocation",
        "created" : "created",
        "filePath" : "filePath",
        "fileSource" : "fileSource",
        "commitSha" : "commitSha",
        "id" : "id",
        "repositoryName" : "repositoryName",
        "repositoryFilePath" : "repositoryFilePath"
      } ]
    },
    "created" : "created",
    "calibratePredictions" : True,
    "name" : "name",
    "customModelType" : "training",
    "description" : "description",
    "language" : "language",
    "targetType" : "Binary",
    "id" : "id",
    "updated" : "updated"
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0,
  "totalCount" : 5
})
    )
    result = CustomTasksApi.custom_tasks_list(offset=0, limit=1000, )
    assert isinstance(result, CustomTaskListResponse)


@responses.activate
def test_custom_tasks_api_custom_tasks_patch(unittest_endpoint):
    responses.add(
        responses.PATCH,
        '{endpoint}/api/v2/customTasks/{customTaskId}/'.format(endpoint=unittest_endpoint,
        customTaskId="customTaskId_example", ),
        status=201,
        content_type='application/json',
        body=json.dumps({
  "createdBy" : "createdBy",
  "deploymentsCount" : 6,
  "latestVersion" : {
    "baseEnvironmentVersionId" : "baseEnvironmentVersionId",
    "baseEnvironmentId" : "baseEnvironmentId",
    "created" : "created",
    "description" : "description",
    "label" : "label",
    "dependencies" : [ {
      "line" : "line",
      "packageName" : "packageName",
      "lineNumber" : 5,
      "constraints" : [ {
        "constraintType" : "<",
        "version" : "version"
      }, {
        "constraintType" : "<",
        "version" : "version"
      } ]
    }, {
      "line" : "line",
      "packageName" : "packageName",
      "lineNumber" : 5,
      "constraints" : [ {
        "constraintType" : "<",
        "version" : "version"
      }, {
        "constraintType" : "<",
        "version" : "version"
      } ]
    } ],
    "requiredMetadata" : "{}",
    "customModelId" : "customModelId",
    "customTaskId" : "customTaskId",
    "warning" : [ "warning", "warning" ],
    "id" : "id",
    "isFrozen" : True,
    "requiredMetadataValues" : [ {
      "fieldName" : "fieldName",
      "value" : "value"
    }, {
      "fieldName" : "fieldName",
      "value" : "value"
    } ],
    "versionMajor" : 1,
    "versionMinor" : 5,
    "items" : [ {
      "fileName" : "fileName",
      "ref" : "ref",
      "repositoryLocation" : "repositoryLocation",
      "created" : "created",
      "filePath" : "filePath",
      "fileSource" : "fileSource",
      "commitSha" : "commitSha",
      "id" : "id",
      "repositoryName" : "repositoryName",
      "repositoryFilePath" : "repositoryFilePath"
    }, {
      "fileName" : "fileName",
      "ref" : "ref",
      "repositoryLocation" : "repositoryLocation",
      "created" : "created",
      "filePath" : "filePath",
      "fileSource" : "fileSource",
      "commitSha" : "commitSha",
      "id" : "id",
      "repositoryName" : "repositoryName",
      "repositoryFilePath" : "repositoryFilePath"
    } ]
  },
  "created" : "created",
  "calibratePredictions" : True,
  "name" : "name",
  "customModelType" : "training",
  "description" : "description",
  "language" : "language",
  "targetType" : "Binary",
  "id" : "id",
  "updated" : "updated"
})
    )
    result = CustomTasksApi.custom_tasks_patch(custom_task_id="customTaskId_example", )
    assert isinstance(result, CustomTaskResponse)


@responses.activate
def test_custom_tasks_api_custom_tasks_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/customTasks/{customTaskId}/'.format(endpoint=unittest_endpoint,
        customTaskId="customTaskId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "createdBy" : "createdBy",
  "deploymentsCount" : 6,
  "latestVersion" : {
    "baseEnvironmentVersionId" : "baseEnvironmentVersionId",
    "baseEnvironmentId" : "baseEnvironmentId",
    "created" : "created",
    "description" : "description",
    "label" : "label",
    "dependencies" : [ {
      "line" : "line",
      "packageName" : "packageName",
      "lineNumber" : 5,
      "constraints" : [ {
        "constraintType" : "<",
        "version" : "version"
      }, {
        "constraintType" : "<",
        "version" : "version"
      } ]
    }, {
      "line" : "line",
      "packageName" : "packageName",
      "lineNumber" : 5,
      "constraints" : [ {
        "constraintType" : "<",
        "version" : "version"
      }, {
        "constraintType" : "<",
        "version" : "version"
      } ]
    } ],
    "requiredMetadata" : "{}",
    "customModelId" : "customModelId",
    "customTaskId" : "customTaskId",
    "warning" : [ "warning", "warning" ],
    "id" : "id",
    "isFrozen" : True,
    "requiredMetadataValues" : [ {
      "fieldName" : "fieldName",
      "value" : "value"
    }, {
      "fieldName" : "fieldName",
      "value" : "value"
    } ],
    "versionMajor" : 1,
    "versionMinor" : 5,
    "items" : [ {
      "fileName" : "fileName",
      "ref" : "ref",
      "repositoryLocation" : "repositoryLocation",
      "created" : "created",
      "filePath" : "filePath",
      "fileSource" : "fileSource",
      "commitSha" : "commitSha",
      "id" : "id",
      "repositoryName" : "repositoryName",
      "repositoryFilePath" : "repositoryFilePath"
    }, {
      "fileName" : "fileName",
      "ref" : "ref",
      "repositoryLocation" : "repositoryLocation",
      "created" : "created",
      "filePath" : "filePath",
      "fileSource" : "fileSource",
      "commitSha" : "commitSha",
      "id" : "id",
      "repositoryName" : "repositoryName",
      "repositoryFilePath" : "repositoryFilePath"
    } ]
  },
  "created" : "created",
  "calibratePredictions" : True,
  "name" : "name",
  "customModelType" : "training",
  "description" : "description",
  "language" : "language",
  "targetType" : "Binary",
  "id" : "id",
  "updated" : "updated"
})
    )
    result = CustomTasksApi.custom_tasks_retrieve(custom_task_id="customTaskId_example", )
    assert isinstance(result, CustomTaskResponse)


@responses.activate
def test_custom_tasks_api_custom_tasks_versions_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/api/v2/customTasks/{customTaskId}/versions/'.format(endpoint=unittest_endpoint,
        customTaskId="customTaskId_example", isMajorUpdate="True", ),
        status=201,
        content_type='application/json',
        body=json.dumps({
  "baseEnvironmentVersionId" : "baseEnvironmentVersionId",
  "baseEnvironmentId" : "baseEnvironmentId",
  "created" : "created",
  "description" : "description",
  "label" : "label",
  "dependencies" : [ {
    "line" : "line",
    "packageName" : "packageName",
    "lineNumber" : 5,
    "constraints" : [ {
      "constraintType" : "<",
      "version" : "version"
    }, {
      "constraintType" : "<",
      "version" : "version"
    } ]
  }, {
    "line" : "line",
    "packageName" : "packageName",
    "lineNumber" : 5,
    "constraints" : [ {
      "constraintType" : "<",
      "version" : "version"
    }, {
      "constraintType" : "<",
      "version" : "version"
    } ]
  } ],
  "requiredMetadata" : "{}",
  "customModelId" : "customModelId",
  "customTaskId" : "customTaskId",
  "warning" : [ "warning", "warning" ],
  "id" : "id",
  "isFrozen" : True,
  "requiredMetadataValues" : [ {
    "fieldName" : "fieldName",
    "value" : "value"
  }, {
    "fieldName" : "fieldName",
    "value" : "value"
  } ],
  "versionMajor" : 1,
  "versionMinor" : 5,
  "items" : [ {
    "fileName" : "fileName",
    "ref" : "ref",
    "repositoryLocation" : "repositoryLocation",
    "created" : "created",
    "filePath" : "filePath",
    "fileSource" : "fileSource",
    "commitSha" : "commitSha",
    "id" : "id",
    "repositoryName" : "repositoryName",
    "repositoryFilePath" : "repositoryFilePath"
  }, {
    "fileName" : "fileName",
    "ref" : "ref",
    "repositoryLocation" : "repositoryLocation",
    "created" : "created",
    "filePath" : "filePath",
    "fileSource" : "fileSource",
    "commitSha" : "commitSha",
    "id" : "id",
    "repositoryName" : "repositoryName",
    "repositoryFilePath" : "repositoryFilePath"
  } ]
})
    )
    result = CustomTasksApi.custom_tasks_versions_create(custom_task_id="customTaskId_example", is_major_update="True", )
    assert isinstance(result, CustomTaskVersionResponse)


@responses.activate
def test_custom_tasks_api_custom_tasks_versions_download_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/customTasks/{customTaskId}/versions/{customTaskVersionId}/download/'.format(endpoint=unittest_endpoint,
        customTaskId="customTaskId_example", customTaskVersionId="customTaskVersionId_example", ),
        status=200,
        content_type='',
    )
    result = CustomTasksApi.custom_tasks_versions_download_list(custom_task_id="customTaskId_example", custom_task_version_id="customTaskVersionId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_custom_tasks_api_custom_tasks_versions_from_repository_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/api/v2/customTasks/{customTaskId}/versions/fromRepository/'.format(endpoint=unittest_endpoint,
        customTaskId="customTaskId_example", ),
        status=202,
        content_type='',
    )
    result = CustomTasksApi.custom_tasks_versions_from_repository_create(custom_task_id="customTaskId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_custom_tasks_api_custom_tasks_versions_from_repository_patch_many(unittest_endpoint):
    responses.add(
        responses.PATCH,
        '{endpoint}/api/v2/customTasks/{customTaskId}/versions/fromRepository/'.format(endpoint=unittest_endpoint,
        customTaskId="customTaskId_example", ),
        status=202,
        content_type='',
    )
    result = CustomTasksApi.custom_tasks_versions_from_repository_patch_many(custom_task_id="customTaskId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_custom_tasks_api_custom_tasks_versions_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/customTasks/{customTaskId}/versions/'.format(endpoint=unittest_endpoint,
        offset=0, limit=1000, customTaskId="customTaskId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "baseEnvironmentVersionId" : "baseEnvironmentVersionId",
    "baseEnvironmentId" : "baseEnvironmentId",
    "created" : "created",
    "description" : "description",
    "label" : "label",
    "dependencies" : [ {
      "line" : "line",
      "packageName" : "packageName",
      "lineNumber" : 5,
      "constraints" : [ {
        "constraintType" : "<",
        "version" : "version"
      }, {
        "constraintType" : "<",
        "version" : "version"
      } ]
    }, {
      "line" : "line",
      "packageName" : "packageName",
      "lineNumber" : 5,
      "constraints" : [ {
        "constraintType" : "<",
        "version" : "version"
      }, {
        "constraintType" : "<",
        "version" : "version"
      } ]
    } ],
    "requiredMetadata" : "{}",
    "customModelId" : "customModelId",
    "customTaskId" : "customTaskId",
    "warning" : [ "warning", "warning" ],
    "id" : "id",
    "isFrozen" : True,
    "requiredMetadataValues" : [ {
      "fieldName" : "fieldName",
      "value" : "value"
    }, {
      "fieldName" : "fieldName",
      "value" : "value"
    } ],
    "versionMajor" : 1,
    "versionMinor" : 5,
    "items" : [ {
      "fileName" : "fileName",
      "ref" : "ref",
      "repositoryLocation" : "repositoryLocation",
      "created" : "created",
      "filePath" : "filePath",
      "fileSource" : "fileSource",
      "commitSha" : "commitSha",
      "id" : "id",
      "repositoryName" : "repositoryName",
      "repositoryFilePath" : "repositoryFilePath"
    }, {
      "fileName" : "fileName",
      "ref" : "ref",
      "repositoryLocation" : "repositoryLocation",
      "created" : "created",
      "filePath" : "filePath",
      "fileSource" : "fileSource",
      "commitSha" : "commitSha",
      "id" : "id",
      "repositoryName" : "repositoryName",
      "repositoryFilePath" : "repositoryFilePath"
    } ]
  }, {
    "baseEnvironmentVersionId" : "baseEnvironmentVersionId",
    "baseEnvironmentId" : "baseEnvironmentId",
    "created" : "created",
    "description" : "description",
    "label" : "label",
    "dependencies" : [ {
      "line" : "line",
      "packageName" : "packageName",
      "lineNumber" : 5,
      "constraints" : [ {
        "constraintType" : "<",
        "version" : "version"
      }, {
        "constraintType" : "<",
        "version" : "version"
      } ]
    }, {
      "line" : "line",
      "packageName" : "packageName",
      "lineNumber" : 5,
      "constraints" : [ {
        "constraintType" : "<",
        "version" : "version"
      }, {
        "constraintType" : "<",
        "version" : "version"
      } ]
    } ],
    "requiredMetadata" : "{}",
    "customModelId" : "customModelId",
    "customTaskId" : "customTaskId",
    "warning" : [ "warning", "warning" ],
    "id" : "id",
    "isFrozen" : True,
    "requiredMetadataValues" : [ {
      "fieldName" : "fieldName",
      "value" : "value"
    }, {
      "fieldName" : "fieldName",
      "value" : "value"
    } ],
    "versionMajor" : 1,
    "versionMinor" : 5,
    "items" : [ {
      "fileName" : "fileName",
      "ref" : "ref",
      "repositoryLocation" : "repositoryLocation",
      "created" : "created",
      "filePath" : "filePath",
      "fileSource" : "fileSource",
      "commitSha" : "commitSha",
      "id" : "id",
      "repositoryName" : "repositoryName",
      "repositoryFilePath" : "repositoryFilePath"
    }, {
      "fileName" : "fileName",
      "ref" : "ref",
      "repositoryLocation" : "repositoryLocation",
      "created" : "created",
      "filePath" : "filePath",
      "fileSource" : "fileSource",
      "commitSha" : "commitSha",
      "id" : "id",
      "repositoryName" : "repositoryName",
      "repositoryFilePath" : "repositoryFilePath"
    } ]
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0,
  "totalCount" : 6
})
    )
    result = CustomTasksApi.custom_tasks_versions_list(offset=0, limit=1000, custom_task_id="customTaskId_example", )
    assert isinstance(result, CustomTaskVersionListResponse)


@responses.activate
def test_custom_tasks_api_custom_tasks_versions_patch(unittest_endpoint):
    responses.add(
        responses.PATCH,
        '{endpoint}/api/v2/customTasks/{customTaskId}/versions/{customTaskVersionId}/'.format(endpoint=unittest_endpoint,
        customTaskId="customTaskId_example", customTaskVersionId="customTaskVersionId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "baseEnvironmentVersionId" : "baseEnvironmentVersionId",
  "baseEnvironmentId" : "baseEnvironmentId",
  "created" : "created",
  "description" : "description",
  "label" : "label",
  "dependencies" : [ {
    "line" : "line",
    "packageName" : "packageName",
    "lineNumber" : 5,
    "constraints" : [ {
      "constraintType" : "<",
      "version" : "version"
    }, {
      "constraintType" : "<",
      "version" : "version"
    } ]
  }, {
    "line" : "line",
    "packageName" : "packageName",
    "lineNumber" : 5,
    "constraints" : [ {
      "constraintType" : "<",
      "version" : "version"
    }, {
      "constraintType" : "<",
      "version" : "version"
    } ]
  } ],
  "requiredMetadata" : "{}",
  "customModelId" : "customModelId",
  "customTaskId" : "customTaskId",
  "warning" : [ "warning", "warning" ],
  "id" : "id",
  "isFrozen" : True,
  "requiredMetadataValues" : [ {
    "fieldName" : "fieldName",
    "value" : "value"
  }, {
    "fieldName" : "fieldName",
    "value" : "value"
  } ],
  "versionMajor" : 1,
  "versionMinor" : 5,
  "items" : [ {
    "fileName" : "fileName",
    "ref" : "ref",
    "repositoryLocation" : "repositoryLocation",
    "created" : "created",
    "filePath" : "filePath",
    "fileSource" : "fileSource",
    "commitSha" : "commitSha",
    "id" : "id",
    "repositoryName" : "repositoryName",
    "repositoryFilePath" : "repositoryFilePath"
  }, {
    "fileName" : "fileName",
    "ref" : "ref",
    "repositoryLocation" : "repositoryLocation",
    "created" : "created",
    "filePath" : "filePath",
    "fileSource" : "fileSource",
    "commitSha" : "commitSha",
    "id" : "id",
    "repositoryName" : "repositoryName",
    "repositoryFilePath" : "repositoryFilePath"
  } ]
})
    )
    result = CustomTasksApi.custom_tasks_versions_patch(custom_task_id="customTaskId_example", custom_task_version_id="customTaskVersionId_example", )
    assert isinstance(result, CustomTaskVersionResponse)


@responses.activate
def test_custom_tasks_api_custom_tasks_versions_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/customTasks/{customTaskId}/versions/{customTaskVersionId}/'.format(endpoint=unittest_endpoint,
        customTaskId="customTaskId_example", customTaskVersionId="customTaskVersionId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "baseEnvironmentVersionId" : "baseEnvironmentVersionId",
  "baseEnvironmentId" : "baseEnvironmentId",
  "created" : "created",
  "description" : "description",
  "label" : "label",
  "dependencies" : [ {
    "line" : "line",
    "packageName" : "packageName",
    "lineNumber" : 5,
    "constraints" : [ {
      "constraintType" : "<",
      "version" : "version"
    }, {
      "constraintType" : "<",
      "version" : "version"
    } ]
  }, {
    "line" : "line",
    "packageName" : "packageName",
    "lineNumber" : 5,
    "constraints" : [ {
      "constraintType" : "<",
      "version" : "version"
    }, {
      "constraintType" : "<",
      "version" : "version"
    } ]
  } ],
  "requiredMetadata" : "{}",
  "customModelId" : "customModelId",
  "customTaskId" : "customTaskId",
  "warning" : [ "warning", "warning" ],
  "id" : "id",
  "isFrozen" : True,
  "requiredMetadataValues" : [ {
    "fieldName" : "fieldName",
    "value" : "value"
  }, {
    "fieldName" : "fieldName",
    "value" : "value"
  } ],
  "versionMajor" : 1,
  "versionMinor" : 5,
  "items" : [ {
    "fileName" : "fileName",
    "ref" : "ref",
    "repositoryLocation" : "repositoryLocation",
    "created" : "created",
    "filePath" : "filePath",
    "fileSource" : "fileSource",
    "commitSha" : "commitSha",
    "id" : "id",
    "repositoryName" : "repositoryName",
    "repositoryFilePath" : "repositoryFilePath"
  }, {
    "fileName" : "fileName",
    "ref" : "ref",
    "repositoryLocation" : "repositoryLocation",
    "created" : "created",
    "filePath" : "filePath",
    "fileSource" : "fileSource",
    "commitSha" : "commitSha",
    "id" : "id",
    "repositoryName" : "repositoryName",
    "repositoryFilePath" : "repositoryFilePath"
  } ]
})
    )
    result = CustomTasksApi.custom_tasks_versions_retrieve(custom_task_id="customTaskId_example", custom_task_version_id="customTaskVersionId_example", )
    assert isinstance(result, CustomTaskVersionResponse)
