#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import json
import responses
from six.moves.urllib.parse import urljoin
from dateutil import parser
from datarobot.models.full_api.generated.model.basic_dataset_details_response import BasicDatasetDetailsResponse
from datarobot.models.full_api.generated.model.bulk_dataset_action import BulkDatasetAction
from datarobot.models.full_api.generated.model.create_workspace_state import CreateWorkspaceState
from datarobot.models.full_api.generated.model.created_dataset_data_engine_response import CreatedDatasetDataEngineResponse
from datarobot.models.full_api.generated.model.created_dataset_response import CreatedDatasetResponse
from datarobot.models.full_api.generated.model.dataset_access_control_list_response import DatasetAccessControlListResponse
from datarobot.models.full_api.generated.model.dataset_access_set import DatasetAccessSet
from datarobot.models.full_api.generated.model.dataset_create_from_workspace_state import DatasetCreateFromWorkspaceState
from datarobot.models.full_api.generated.model.dataset_describe_permissions_response import DatasetDescribePermissionsResponse
from datarobot.models.full_api.generated.model.dataset_feature_histogram_response import DatasetFeatureHistogramResponse
from datarobot.models.full_api.generated.model.dataset_featurelist_list_response import DatasetFeaturelistListResponse
from datarobot.models.full_api.generated.model.dataset_featurelist_response import DatasetFeaturelistResponse
from datarobot.models.full_api.generated.model.dataset_features_list_response import DatasetFeaturesListResponse
from datarobot.models.full_api.generated.model.dataset_from_file import DatasetFromFile
from datarobot.models.full_api.generated.model.dataset_list_response import DatasetListResponse
from datarobot.models.full_api.generated.model.dataset_project_list_response import DatasetProjectListResponse
from datarobot.models.full_api.generated.model.dataset_refresh_job_create import DatasetRefreshJobCreate
from datarobot.models.full_api.generated.model.dataset_refresh_job_response import DatasetRefreshJobResponse
from datarobot.models.full_api.generated.model.dataset_refresh_job_retrieve_execution_results_response import DatasetRefreshJobRetrieveExecutionResultsResponse
from datarobot.models.full_api.generated.model.dataset_refresh_job_update import DatasetRefreshJobUpdate
from datarobot.models.full_api.generated.model.dataset_refresh_jobs_list_response import DatasetRefreshJobsListResponse
from datarobot.models.full_api.generated.model.dataset_relationship_create import DatasetRelationshipCreate
from datarobot.models.full_api.generated.model.dataset_relationship_list_response import DatasetRelationshipListResponse
from datarobot.models.full_api.generated.model.dataset_relationship_response import DatasetRelationshipResponse
from datarobot.models.full_api.generated.model.dataset_relationship_update import DatasetRelationshipUpdate
from datarobot.models.full_api.generated.model.dataset_shared_roles import DatasetSharedRoles
from datarobot.models.full_api.generated.model.dataset_transform_list_response import DatasetTransformListResponse
from datarobot.models.full_api.generated.model.dataset_transform_response import DatasetTransformResponse
from datarobot.models.full_api.generated.model.datasource import Datasource
from datarobot.models.full_api.generated.model.feature_list_create import FeatureListCreate
from datarobot.models.full_api.generated.model.feature_list_modify import FeatureListModify
from datarobot.models.full_api.generated.model.feature_transform import FeatureTransform
from datarobot.models.full_api.generated.model.from_latest import FromLatest
from datarobot.models.full_api.generated.model.from_specific import FromSpecific
from datarobot.models.full_api.generated.model.full_dataset_details_response import FullDatasetDetailsResponse
from datarobot.models.full_api.generated.model.get_dataset_version_projects_response import GetDatasetVersionProjectsResponse
from datarobot.models.full_api.generated.model.hdfs import Hdfs
from datarobot.models.full_api.generated.model.patch_dataset import PatchDataset
from datarobot.models.full_api.generated.model.shared_roles_list_response import SharedRolesListResponse
from datarobot.models.full_api.generated.model.url import Url
from datarobot.models.full_api.generated.model.workspace_source_created_response import WorkspaceSourceCreatedResponse
from datarobot.models.full_api.generated.model.workspace_state_response import WorkspaceStateResponse
from datarobot.utils import from_api
from datarobot.models.full_api.generated.model import *

from datarobot.models.full_api.generated.api.datasets_api import DatasetsApi




@responses.activate
def test_datasets_api_data_engine_workspace_states_create(unittest_endpoint):
    responses.add(
        responses.POST,
       '{endpoint}/api/v2/dataEngineWorkspaceStates/'.format(endpoint=unittest_endpoint),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "workspaceStateId" : "workspaceStateId"
})
    )
    result = DatasetsApi.data_engine_workspace_states_create()
    assert isinstance(result, WorkspaceSourceCreatedResponse)


@responses.activate
def test_datasets_api_data_engine_workspace_states_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/dataEngineWorkspaceStates/{workspaceStateId}/'.format(endpoint=unittest_endpoint,
        workspaceStateId="workspaceStateId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "queryGeneratorId" : "queryGeneratorId",
  "query" : "query",
  "language" : "language",
  "datasets" : [ {
    "needsCredentials" : True,
    "alias" : "alias",
    "datasetId" : "datasetId",
    "datasetVersionId" : "datasetVersionId"
  }, {
    "needsCredentials" : True,
    "alias" : "alias",
    "datasetId" : "datasetId",
    "datasetVersionId" : "datasetVersionId"
  } ],
  "runTime" : 0.8008281904610115
})
    )
    result = DatasetsApi.data_engine_workspace_states_retrieve(workspace_state_id="workspaceStateId_example", )
    assert isinstance(result, WorkspaceStateResponse)


@responses.activate
def test_datasets_api_datasets_access_control_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/datasets/{datasetId}/accessControl/'.format(endpoint=unittest_endpoint,
        offset=0, limit=100, datasetId="datasetId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "role" : "OWNER",
    "canUseData" : True,
    "canShare" : True,
    "userFullName" : "userFullName",
    "username" : "username"
  }, {
    "role" : "OWNER",
    "canUseData" : True,
    "canShare" : True,
    "userFullName" : "userFullName",
    "username" : "username"
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0,
  "totalCount" : 6
})
    )
    result = DatasetsApi.datasets_access_control_list(offset=0, limit=100, dataset_id="datasetId_example", )
    assert isinstance(result, DatasetAccessControlListResponse)


@responses.activate
def test_datasets_api_datasets_access_control_patch_many(unittest_endpoint):
    responses.add(
        responses.PATCH,
        '{endpoint}/api/v2/datasets/{datasetId}/accessControl/'.format(endpoint=unittest_endpoint,
        datasetId="datasetId_example", ),
        status=204,
        content_type='',
    )
    result = DatasetsApi.datasets_access_control_patch_many(dataset_id="datasetId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_datasets_api_datasets_all_features_details_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/datasets/{datasetId}/allFeaturesDetails/'.format(endpoint=unittest_endpoint,
        limit=100, offset=0, orderBy="name", datasetId="datasetId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "timeStepAggregation" : 2,
    "timeSeriesEligibilityReason" : "timeSeriesEligibilityReason",
    "dateFormat" : "dateFormat",
    "max" : 1.4658129805029452,
    "naCount" : 7,
    "lowInformation" : True,
    "timeUnitAggregation" : "timeUnitAggregation",
    "min" : 2.3021358869347655,
    "timeSeriesEligible" : True,
    "median" : 5.637376656633329,
    "timeStep" : 3,
    "mean" : 5.962133916683182,
    "featureType" : "Interaction",
    "keySummary" : "",
    "name" : "name",
    "datasetId" : "datasetId",
    "timeSeriesEligibilityReasonAggregation" : "timeSeriesEligibilityReasonAggregation",
    "id" : 6,
    "isZeroInflated" : True,
    "timeSeriesEligibleAggregation" : True,
    "stdDev" : 9.301444243932576,
    "datasetVersionId" : "datasetVersionId",
    "timeUnit" : "timeUnit",
    "uniqueCount" : 4
  }, {
    "timeStepAggregation" : 2,
    "timeSeriesEligibilityReason" : "timeSeriesEligibilityReason",
    "dateFormat" : "dateFormat",
    "max" : 1.4658129805029452,
    "naCount" : 7,
    "lowInformation" : True,
    "timeUnitAggregation" : "timeUnitAggregation",
    "min" : 2.3021358869347655,
    "timeSeriesEligible" : True,
    "median" : 5.637376656633329,
    "timeStep" : 3,
    "mean" : 5.962133916683182,
    "featureType" : "Interaction",
    "keySummary" : "",
    "name" : "name",
    "datasetId" : "datasetId",
    "timeSeriesEligibilityReasonAggregation" : "timeSeriesEligibilityReasonAggregation",
    "id" : 6,
    "isZeroInflated" : True,
    "timeSeriesEligibleAggregation" : True,
    "stdDev" : 9.301444243932576,
    "datasetVersionId" : "datasetVersionId",
    "timeUnit" : "timeUnit",
    "uniqueCount" : 4
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0,
  "totalCount" : 7
})
    )
    result = DatasetsApi.datasets_all_features_details_list(limit=100, offset=0, order_by="name", dataset_id="datasetId_example", )
    assert isinstance(result, DatasetFeaturesListResponse)


@responses.activate
def test_datasets_api_datasets_delete(unittest_endpoint):
    responses.add(
        responses.DELETE,
        '{endpoint}/api/v2/datasets/{datasetId}/'.format(endpoint=unittest_endpoint,
        datasetId="datasetId_example", ),
        status=204,
        content_type='',
    )
    result = DatasetsApi.datasets_delete(dataset_id="datasetId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_datasets_api_datasets_deleted_patch_many(unittest_endpoint):
    responses.add(
        responses.PATCH,
        '{endpoint}/api/v2/datasets/{datasetId}/deleted/'.format(endpoint=unittest_endpoint,
        datasetId="datasetId_example", ),
        status=200,
        content_type='',
    )
    result = DatasetsApi.datasets_deleted_patch_many(dataset_id="datasetId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_datasets_api_datasets_feature_histograms_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/datasets/{datasetId}/featureHistograms/{featureName}/'.format(endpoint=unittest_endpoint,
        binLimit=60, datasetId="datasetId_example", featureName="featureName_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "plot" : [ {
    "count" : 0.8008281904610115,
    "label" : "label"
  }, {
    "count" : 0.8008281904610115,
    "label" : "label"
  } ]
})
    )
    result = DatasetsApi.datasets_feature_histograms_retrieve(bin_limit=60, dataset_id="datasetId_example", feature_name="featureName_example", )
    assert isinstance(result, DatasetFeatureHistogramResponse)


@responses.activate
def test_datasets_api_datasets_feature_transforms_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/api/v2/datasets/{datasetId}/featureTransforms/'.format(endpoint=unittest_endpoint,
        datasetId="datasetId_example", ),
        status=202,
        content_type='',
    )
    result = DatasetsApi.datasets_feature_transforms_create(dataset_id="datasetId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_datasets_api_datasets_feature_transforms_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/datasets/{datasetId}/featureTransforms/'.format(endpoint=unittest_endpoint,
        limit=100, offset=0, datasetId="datasetId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "variableType" : "text",
    "parentName" : "parentName",
    "name" : "name",
    "dateExtraction" : "year",
    "replacement" : ""
  }, {
    "variableType" : "text",
    "parentName" : "parentName",
    "name" : "name",
    "dateExtraction" : "year",
    "replacement" : ""
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0,
  "totalCount" : 6
})
    )
    result = DatasetsApi.datasets_feature_transforms_list(limit=100, offset=0, dataset_id="datasetId_example", )
    assert isinstance(result, DatasetTransformListResponse)


@responses.activate
def test_datasets_api_datasets_feature_transforms_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/datasets/{datasetId}/featureTransforms/{featureName}/'.format(endpoint=unittest_endpoint,
        datasetId="datasetId_example", featureName="featureName_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "variableType" : "text",
  "parentName" : "parentName",
  "name" : "name",
  "dateExtraction" : "year",
  "replacement" : ""
})
    )
    result = DatasetsApi.datasets_feature_transforms_retrieve(dataset_id="datasetId_example", feature_name="featureName_example", )
    assert isinstance(result, DatasetTransformResponse)


@responses.activate
def test_datasets_api_datasets_featurelists_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/api/v2/datasets/{datasetId}/featurelists/'.format(endpoint=unittest_endpoint,
        datasetId="datasetId_example", ),
        status=201,
        content_type='application/json',
        body=json.dumps({
  "features" : [ "features", "features" ],
  "createdBy" : "createdBy",
  "name" : "name",
  "datasetId" : "datasetId",
  "id" : "id",
  "creationDate" : "2000-01-23T04:56:07.000+00:00",
  "userCreated" : True,
  "datasetVersionId" : "datasetVersionId"
})
    )
    result = DatasetsApi.datasets_featurelists_create(dataset_id="datasetId_example", )
    assert isinstance(result, DatasetFeaturelistResponse)


@responses.activate
def test_datasets_api_datasets_featurelists_delete(unittest_endpoint):
    responses.add(
        responses.DELETE,
        '{endpoint}/api/v2/datasets/{datasetId}/featurelists/{featurelistId}/'.format(endpoint=unittest_endpoint,
        datasetId="datasetId_example", featurelistId="featurelistId_example", ),
        status=204,
        content_type='',
    )
    result = DatasetsApi.datasets_featurelists_delete(dataset_id="datasetId_example", featurelist_id="featurelistId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_datasets_api_datasets_featurelists_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/datasets/{datasetId}/featurelists/'.format(endpoint=unittest_endpoint,
        limit=100, offset=0, orderBy="name", datasetId="datasetId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "features" : [ "features", "features" ],
    "createdBy" : "createdBy",
    "name" : "name",
    "datasetId" : "datasetId",
    "id" : "id",
    "creationDate" : "2000-01-23T04:56:07.000+00:00",
    "userCreated" : True,
    "datasetVersionId" : "datasetVersionId"
  }, {
    "features" : [ "features", "features" ],
    "createdBy" : "createdBy",
    "name" : "name",
    "datasetId" : "datasetId",
    "id" : "id",
    "creationDate" : "2000-01-23T04:56:07.000+00:00",
    "userCreated" : True,
    "datasetVersionId" : "datasetVersionId"
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0,
  "totalCount" : 6
})
    )
    result = DatasetsApi.datasets_featurelists_list(limit=100, offset=0, order_by="name", dataset_id="datasetId_example", )
    assert isinstance(result, DatasetFeaturelistListResponse)


@responses.activate
def test_datasets_api_datasets_featurelists_patch(unittest_endpoint):
    responses.add(
        responses.PATCH,
        '{endpoint}/api/v2/datasets/{datasetId}/featurelists/{featurelistId}/'.format(endpoint=unittest_endpoint,
        datasetId="datasetId_example", featurelistId="featurelistId_example", ),
        status=200,
        content_type='',
    )
    result = DatasetsApi.datasets_featurelists_patch(dataset_id="datasetId_example", featurelist_id="featurelistId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_datasets_api_datasets_featurelists_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/datasets/{datasetId}/featurelists/{featurelistId}/'.format(endpoint=unittest_endpoint,
        datasetId="datasetId_example", featurelistId="featurelistId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "features" : [ "features", "features" ],
  "createdBy" : "createdBy",
  "name" : "name",
  "datasetId" : "datasetId",
  "id" : "id",
  "creationDate" : "2000-01-23T04:56:07.000+00:00",
  "userCreated" : True,
  "datasetVersionId" : "datasetVersionId"
})
    )
    result = DatasetsApi.datasets_featurelists_retrieve(dataset_id="datasetId_example", featurelist_id="featurelistId_example", )
    assert isinstance(result, DatasetFeaturelistResponse)


@responses.activate
def test_datasets_api_datasets_file_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/datasets/{datasetId}/file/'.format(endpoint=unittest_endpoint,
        datasetId="datasetId_example", ),
        status=200,
        content_type='text/csv',
        body=json.dumps("datasetId_example")
    )
    result = DatasetsApi.datasets_file_list(dataset_id="datasetId_example", )
    assert isinstance(result, str)


@responses.activate
def test_datasets_api_datasets_from_data_engine_workspace_state_create(unittest_endpoint):
    responses.add(
        responses.POST,
       '{endpoint}/api/v2/datasets/fromDataEngineWorkspaceState/'.format(endpoint=unittest_endpoint),
        status=202,
        content_type='application/json',
        body=json.dumps({
  "statusId" : "statusId",
  "datasetId" : "datasetId",
  "datasetVersionId" : "datasetVersionId"
})
    )
    result = DatasetsApi.datasets_from_data_engine_workspace_state_create()
    assert isinstance(result, CreatedDatasetDataEngineResponse)


@responses.activate
def test_datasets_api_datasets_from_data_source_create(unittest_endpoint):
    responses.add(
        responses.POST,
       '{endpoint}/api/v2/datasets/fromDataSource/'.format(endpoint=unittest_endpoint),
        status=202,
        content_type='application/json',
        body=json.dumps({
  "catalogId" : "catalogId",
  "statusId" : "statusId",
  "catalogVersionId" : "catalogVersionId"
})
    )
    result = DatasetsApi.datasets_from_data_source_create()
    assert isinstance(result, CreatedDatasetResponse)


@responses.activate
def test_datasets_api_datasets_from_file_create(unittest_endpoint, temporary_file):
    responses.add(
        responses.POST,
        '{endpoint}/api/v2/datasets/fromFile/'.format(endpoint=unittest_endpoint,
        file=open(temporary_file, 'rb'), ),
        status=202,
        content_type='application/json',
        body=json.dumps({
  "catalogId" : "catalogId",
  "statusId" : "statusId",
  "catalogVersionId" : "catalogVersionId"
})
    )
    result = DatasetsApi.datasets_from_file_create(file=open(temporary_file, 'rb'), )
    assert isinstance(result, CreatedDatasetResponse)


@responses.activate
def test_datasets_api_datasets_from_hdfs_create(unittest_endpoint):
    responses.add(
        responses.POST,
       '{endpoint}/api/v2/datasets/fromHDFS/'.format(endpoint=unittest_endpoint),
        status=202,
        content_type='application/json',
        body=json.dumps({
  "catalogId" : "catalogId",
  "statusId" : "statusId",
  "catalogVersionId" : "catalogVersionId"
})
    )
    result = DatasetsApi.datasets_from_hdfs_create()
    assert isinstance(result, CreatedDatasetResponse)


@responses.activate
def test_datasets_api_datasets_from_url_create(unittest_endpoint):
    responses.add(
        responses.POST,
       '{endpoint}/api/v2/datasets/fromURL/'.format(endpoint=unittest_endpoint),
        status=202,
        content_type='application/json',
        body=json.dumps({
  "catalogId" : "catalogId",
  "statusId" : "statusId",
  "catalogVersionId" : "catalogVersionId"
})
    )
    result = DatasetsApi.datasets_from_url_create()
    assert isinstance(result, CreatedDatasetResponse)


@responses.activate
def test_datasets_api_datasets_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/datasets/'.format(endpoint=unittest_endpoint,
        limit=100, offset=0, ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "isLatestVersion" : True,
    "dataPersisted" : True,
    "isDataEngineEligible" : True,
    "creationDate" : "2000-01-23T04:56:07.000+00:00",
    "processingState" : "COMPLETED",
    "versionId" : "versionId",
    "createdBy" : "createdBy",
    "datasetSize" : 6,
    "name" : "name",
    "datasetId" : "datasetId",
    "categories" : [ "BATCH_PREDICTIONS", "BATCH_PREDICTIONS" ],
    "rowCount" : 1,
    "isSnapshot" : True,
    "timeSeriesProperties" : {
      "isMostlyImputed" : True
    }
  }, {
    "isLatestVersion" : True,
    "dataPersisted" : True,
    "isDataEngineEligible" : True,
    "creationDate" : "2000-01-23T04:56:07.000+00:00",
    "processingState" : "COMPLETED",
    "versionId" : "versionId",
    "createdBy" : "createdBy",
    "datasetSize" : 6,
    "name" : "name",
    "datasetId" : "datasetId",
    "categories" : [ "BATCH_PREDICTIONS", "BATCH_PREDICTIONS" ],
    "rowCount" : 1,
    "isSnapshot" : True,
    "timeSeriesProperties" : {
      "isMostlyImputed" : True
    }
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0,
  "totalCount" : 5
})
    )
    result = DatasetsApi.datasets_list(limit=100, offset=0, )
    assert isinstance(result, DatasetListResponse)


@responses.activate
def test_datasets_api_datasets_patch(unittest_endpoint):
    responses.add(
        responses.PATCH,
        '{endpoint}/api/v2/datasets/{datasetId}/'.format(endpoint=unittest_endpoint,
        datasetId="datasetId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "processingState" : "COMPLETED",
  "versionId" : "versionId",
  "isLatestVersion" : True,
  "dataPersisted" : True,
  "createdBy" : "createdBy",
  "isDataEngineEligible" : True,
  "name" : "name",
  "datasetId" : "datasetId",
  "categories" : [ "BATCH_PREDICTIONS", "BATCH_PREDICTIONS" ],
  "creationDate" : "2000-01-23T04:56:07.000+00:00",
  "isSnapshot" : True,
  "timeSeriesProperties" : {
    "isMostlyImputed" : True
  }
})
    )
    result = DatasetsApi.datasets_patch(dataset_id="datasetId_example", )
    assert isinstance(result, BasicDatasetDetailsResponse)


@responses.activate
def test_datasets_api_datasets_patch_many(unittest_endpoint):
    responses.add(
        responses.PATCH,
       '{endpoint}/api/v2/datasets/'.format(endpoint=unittest_endpoint),
        status=204,
        content_type='',
    )
    result = DatasetsApi.datasets_patch_many()
    assert isinstance(result, type(None))


@responses.activate
def test_datasets_api_datasets_permissions_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/datasets/{datasetId}/permissions/'.format(endpoint=unittest_endpoint,
        datasetId="datasetId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "canCreateFeaturelist" : True,
  "canGetFeatureInfo" : True,
  "canSnapshotDataset" : True,
  "canGetDatasetInfo" : True,
  "canUseFeaturelists" : True,
  "canPatchDatasetInfo" : True,
  "canUndeleteDataset" : True,
  "canGetDatasetPermissions" : True,
  "canPatchDatasetAliases" : True,
  "canUseDatasetData" : True,
  "uid" : "uid",
  "canGetCatalogItemInfo" : True,
  "canReloadDataset" : True,
  "canDeleteDataset" : True,
  "canPatchDatasetPermissions" : True,
  "canDownloadDatasetData" : True,
  "datasetId" : "datasetId",
  "canGetFeaturelists" : True,
  "canShareDataset" : True,
  "canPostDataset" : True,
  "canPatchCatalogInfo" : True,
  "canPatchFeaturelists" : True,
  "username" : "username"
})
    )
    result = DatasetsApi.datasets_permissions_list(dataset_id="datasetId_example", )
    assert isinstance(result, DatasetDescribePermissionsResponse)


@responses.activate
def test_datasets_api_datasets_projects_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/datasets/{datasetId}/projects/'.format(endpoint=unittest_endpoint,
        limit=100, offset=0, datasetId="datasetId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "id" : "id",
    "url" : "url"
  }, {
    "id" : "id",
    "url" : "url"
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0,
  "totalCount" : 6
})
    )
    result = DatasetsApi.datasets_projects_list(limit=100, offset=0, dataset_id="datasetId_example", )
    assert isinstance(result, DatasetProjectListResponse)


@responses.activate
def test_datasets_api_datasets_refresh_jobs_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/api/v2/datasets/{datasetId}/refreshJobs/'.format(endpoint=unittest_endpoint,
        datasetId="datasetId_example", ),
        status=201,
        content_type='application/json',
        body=json.dumps({
  "updatedBy" : "updatedBy",
  "credentials" : "credentials",
  "enabled" : True,
  "scheduleReferenceDate" : "2000-01-23T04:56:07.000+00:00",
  "useKerberos" : True,
  "jobId" : "jobId",
  "schedule" : {
    "dayOfWeek" : [ "*", "*" ],
    "hour" : "",
    "month" : [ "*", "*" ],
    "dayOfMonth" : [ "*", "*" ],
    "minute" : ""
  },
  "createdBy" : "createdBy",
  "name" : "name",
  "credentialId" : "credentialId",
  "datasetId" : "datasetId",
  "categories" : "",
  "updatedAt" : "2000-01-23T04:56:07.000+00:00"
})
    )
    result = DatasetsApi.datasets_refresh_jobs_create(dataset_id="datasetId_example", )
    assert isinstance(result, DatasetRefreshJobResponse)


@responses.activate
def test_datasets_api_datasets_refresh_jobs_delete(unittest_endpoint):
    responses.add(
        responses.DELETE,
        '{endpoint}/api/v2/datasets/{datasetId}/refreshJobs/{jobId}/'.format(endpoint=unittest_endpoint,
        datasetId="datasetId_example", jobId="jobId_example", ),
        status=204,
        content_type='',
    )
    result = DatasetsApi.datasets_refresh_jobs_delete(dataset_id="datasetId_example", job_id="jobId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_datasets_api_datasets_refresh_jobs_execution_results_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/datasets/{datasetId}/refreshJobs/{jobId}/executionResults/'.format(endpoint=unittest_endpoint,
        datasetId="datasetId_example", jobId="jobId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "executionId" : "executionId",
    "jobId" : "jobId",
    "completedAt" : "2000-01-23T04:56:07.000+00:00",
    "datasetId" : "datasetId",
    "startedAt" : "2000-01-23T04:56:07.000+00:00",
    "message" : "message",
    "datasetVersionId" : "datasetVersionId",
    "status" : "INITIALIZING"
  }, {
    "executionId" : "executionId",
    "jobId" : "jobId",
    "completedAt" : "2000-01-23T04:56:07.000+00:00",
    "datasetId" : "datasetId",
    "startedAt" : "2000-01-23T04:56:07.000+00:00",
    "message" : "message",
    "datasetVersionId" : "datasetVersionId",
    "status" : "INITIALIZING"
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0,
  "totalCount" : 6
})
    )
    result = DatasetsApi.datasets_refresh_jobs_execution_results_list(dataset_id="datasetId_example", job_id="jobId_example", )
    assert isinstance(result, DatasetRefreshJobRetrieveExecutionResultsResponse)


@responses.activate
def test_datasets_api_datasets_refresh_jobs_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/datasets/{datasetId}/refreshJobs/'.format(endpoint=unittest_endpoint,
        limit=100, offset=0, datasetId="datasetId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "updatedBy" : "updatedBy",
    "credentials" : "credentials",
    "enabled" : True,
    "scheduleReferenceDate" : "2000-01-23T04:56:07.000+00:00",
    "useKerberos" : True,
    "jobId" : "jobId",
    "schedule" : {
      "dayOfWeek" : [ "*", "*" ],
      "hour" : "",
      "month" : [ "*", "*" ],
      "dayOfMonth" : [ "*", "*" ],
      "minute" : ""
    },
    "createdBy" : "createdBy",
    "name" : "name",
    "credentialId" : "credentialId",
    "datasetId" : "datasetId",
    "categories" : "",
    "updatedAt" : "2000-01-23T04:56:07.000+00:00"
  }, {
    "updatedBy" : "updatedBy",
    "credentials" : "credentials",
    "enabled" : True,
    "scheduleReferenceDate" : "2000-01-23T04:56:07.000+00:00",
    "useKerberos" : True,
    "jobId" : "jobId",
    "schedule" : {
      "dayOfWeek" : [ "*", "*" ],
      "hour" : "",
      "month" : [ "*", "*" ],
      "dayOfMonth" : [ "*", "*" ],
      "minute" : ""
    },
    "createdBy" : "createdBy",
    "name" : "name",
    "credentialId" : "credentialId",
    "datasetId" : "datasetId",
    "categories" : "",
    "updatedAt" : "2000-01-23T04:56:07.000+00:00"
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0,
  "totalCount" : 6
})
    )
    result = DatasetsApi.datasets_refresh_jobs_list(limit=100, offset=0, dataset_id="datasetId_example", )
    assert isinstance(result, DatasetRefreshJobsListResponse)


@responses.activate
def test_datasets_api_datasets_refresh_jobs_patch(unittest_endpoint):
    responses.add(
        responses.PATCH,
        '{endpoint}/api/v2/datasets/{datasetId}/refreshJobs/{jobId}/'.format(endpoint=unittest_endpoint,
        datasetId="datasetId_example", jobId="jobId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "updatedBy" : "updatedBy",
  "credentials" : "credentials",
  "enabled" : True,
  "scheduleReferenceDate" : "2000-01-23T04:56:07.000+00:00",
  "useKerberos" : True,
  "jobId" : "jobId",
  "schedule" : {
    "dayOfWeek" : [ "*", "*" ],
    "hour" : "",
    "month" : [ "*", "*" ],
    "dayOfMonth" : [ "*", "*" ],
    "minute" : ""
  },
  "createdBy" : "createdBy",
  "name" : "name",
  "credentialId" : "credentialId",
  "datasetId" : "datasetId",
  "categories" : "",
  "updatedAt" : "2000-01-23T04:56:07.000+00:00"
})
    )
    result = DatasetsApi.datasets_refresh_jobs_patch(dataset_id="datasetId_example", job_id="jobId_example", )
    assert isinstance(result, DatasetRefreshJobResponse)


@responses.activate
def test_datasets_api_datasets_refresh_jobs_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/datasets/{datasetId}/refreshJobs/{jobId}/'.format(endpoint=unittest_endpoint,
        datasetId="datasetId_example", jobId="jobId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "updatedBy" : "updatedBy",
  "credentials" : "credentials",
  "enabled" : True,
  "scheduleReferenceDate" : "2000-01-23T04:56:07.000+00:00",
  "useKerberos" : True,
  "jobId" : "jobId",
  "schedule" : {
    "dayOfWeek" : [ "*", "*" ],
    "hour" : "",
    "month" : [ "*", "*" ],
    "dayOfMonth" : [ "*", "*" ],
    "minute" : ""
  },
  "createdBy" : "createdBy",
  "name" : "name",
  "credentialId" : "credentialId",
  "datasetId" : "datasetId",
  "categories" : "",
  "updatedAt" : "2000-01-23T04:56:07.000+00:00"
})
    )
    result = DatasetsApi.datasets_refresh_jobs_retrieve(dataset_id="datasetId_example", job_id="jobId_example", )
    assert isinstance(result, DatasetRefreshJobResponse)


@responses.activate
def test_datasets_api_datasets_relationships_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/api/v2/datasets/{datasetId}/relationships/'.format(endpoint=unittest_endpoint,
        datasetId="datasetId_example", ),
        status=201,
        content_type='application/json',
        body=json.dumps({
  "linkedFeatures" : [ "linkedFeatures", "linkedFeatures" ],
  "modificationDate" : "2000-01-23T04:56:07.000+00:00",
  "createdBy" : "createdBy",
  "linkedDatasetId" : "linkedDatasetId",
  "sourceDatasetId" : "sourceDatasetId",
  "modifiedBy" : "modifiedBy",
  "id" : "id",
  "creationDate" : "2000-01-23T04:56:07.000+00:00",
  "sourceFeatures" : [ "sourceFeatures", "sourceFeatures" ]
})
    )
    result = DatasetsApi.datasets_relationships_create(dataset_id="datasetId_example", )
    assert isinstance(result, DatasetRelationshipResponse)


@responses.activate
def test_datasets_api_datasets_relationships_delete(unittest_endpoint):
    responses.add(
        responses.DELETE,
        '{endpoint}/api/v2/datasets/{datasetId}/relationships/{datasetRelationshipId}/'.format(endpoint=unittest_endpoint,
        datasetId="datasetId_example", datasetRelationshipId="datasetRelationshipId_example", ),
        status=204,
        content_type='',
    )
    result = DatasetsApi.datasets_relationships_delete(dataset_id="datasetId_example", dataset_relationship_id="datasetRelationshipId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_datasets_api_datasets_relationships_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/datasets/{datasetId}/relationships/'.format(endpoint=unittest_endpoint,
        limit=100, offset=0, datasetId="datasetId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "linkedFeatures" : [ "linkedFeatures", "linkedFeatures" ],
    "modificationDate" : "2000-01-23T04:56:07.000+00:00",
    "createdBy" : "createdBy",
    "linkedDatasetId" : "linkedDatasetId",
    "sourceDatasetId" : "sourceDatasetId",
    "modifiedBy" : "modifiedBy",
    "id" : "id",
    "creationDate" : "2000-01-23T04:56:07.000+00:00",
    "sourceFeatures" : [ "sourceFeatures", "sourceFeatures" ]
  }, {
    "linkedFeatures" : [ "linkedFeatures", "linkedFeatures" ],
    "modificationDate" : "2000-01-23T04:56:07.000+00:00",
    "createdBy" : "createdBy",
    "linkedDatasetId" : "linkedDatasetId",
    "sourceDatasetId" : "sourceDatasetId",
    "modifiedBy" : "modifiedBy",
    "id" : "id",
    "creationDate" : "2000-01-23T04:56:07.000+00:00",
    "sourceFeatures" : [ "sourceFeatures", "sourceFeatures" ]
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0,
  "totalCount" : 6
})
    )
    result = DatasetsApi.datasets_relationships_list(limit=100, offset=0, dataset_id="datasetId_example", )
    assert isinstance(result, DatasetRelationshipListResponse)


@responses.activate
def test_datasets_api_datasets_relationships_patch(unittest_endpoint):
    responses.add(
        responses.PATCH,
        '{endpoint}/api/v2/datasets/{datasetId}/relationships/{datasetRelationshipId}/'.format(endpoint=unittest_endpoint,
        datasetId="datasetId_example", datasetRelationshipId="datasetRelationshipId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "linkedFeatures" : [ "linkedFeatures", "linkedFeatures" ],
  "modificationDate" : "2000-01-23T04:56:07.000+00:00",
  "createdBy" : "createdBy",
  "linkedDatasetId" : "linkedDatasetId",
  "sourceDatasetId" : "sourceDatasetId",
  "modifiedBy" : "modifiedBy",
  "id" : "id",
  "creationDate" : "2000-01-23T04:56:07.000+00:00",
  "sourceFeatures" : [ "sourceFeatures", "sourceFeatures" ]
})
    )
    result = DatasetsApi.datasets_relationships_patch(dataset_id="datasetId_example", dataset_relationship_id="datasetRelationshipId_example", )
    assert isinstance(result, DatasetRelationshipResponse)


@responses.activate
def test_datasets_api_datasets_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/datasets/{datasetId}/'.format(endpoint=unittest_endpoint,
        datasetId="datasetId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "dataPersisted" : True,
  "isDataEngineEligible" : True,
  "lastModifierFullName" : "lastModifierFullName",
  "description" : "description",
  "error" : "error",
  "dataSourceId" : "dataSourceId",
  "lastModificationDate" : "2000-01-23T04:56:07.000+00:00",
  "datasetSize" : 0,
  "eda1ModificationDate" : "2000-01-23T04:56:07.000+00:00",
  "entityCountByType" : {
    "numPredictionDatasets" : 5,
    "numExternalModelPackages" : 1,
    "numSparkSqlQueries" : 7,
    "numFeatureDiscoveryConfigs" : 5,
    "numProjects" : 2,
    "numCalendars" : 6
  },
  "datasetId" : "datasetId",
  "categories" : [ "BATCH_PREDICTIONS", "BATCH_PREDICTIONS" ],
  "rowCount" : 2,
  "timeSeriesProperties" : {
    "isMostlyImputed" : True
  },
  "isLatestVersion" : True,
  "featureCountByType" : [ {
    "count" : 3,
    "featureType" : "featureType"
  }, {
    "count" : 3,
    "featureType" : "featureType"
  } ],
  "eda1ModifierFullName" : "eda1ModifierFullName",
  "creationDate" : "2000-01-23T04:56:07.000+00:00",
  "uri" : "uri",
  "tags" : [ "tags", "tags" ],
  "processingState" : "COMPLETED",
  "versionId" : "versionId",
  "createdBy" : "createdBy",
  "dataEngineQueryId" : "dataEngineQueryId",
  "name" : "name",
  "isSnapshot" : True,
  "dataSourceType" : "dataSourceType",
  "featureCount" : 9
})
    )
    result = DatasetsApi.datasets_retrieve(dataset_id="datasetId_example", )
    assert isinstance(result, FullDatasetDetailsResponse)


@responses.activate
def test_datasets_api_datasets_shared_roles_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/datasets/{datasetId}/sharedRoles/'.format(endpoint=unittest_endpoint,
        offset=0, limit=100, datasetId="datasetId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "shareRecipientType" : "user",
    "role" : "CONSUMER",
    "canUseData" : True,
    "canShare" : True,
    "name" : "name",
    "userFullName" : "userFullName",
    "id" : "id"
  }, {
    "shareRecipientType" : "user",
    "role" : "CONSUMER",
    "canUseData" : True,
    "canShare" : True,
    "name" : "name",
    "userFullName" : "userFullName",
    "id" : "id"
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0,
  "totalCount" : 6
})
    )
    result = DatasetsApi.datasets_shared_roles_list(offset=0, limit=100, dataset_id="datasetId_example", )
    assert isinstance(result, SharedRolesListResponse)


@responses.activate
def test_datasets_api_datasets_shared_roles_patch_many(unittest_endpoint):
    responses.add(
        responses.PATCH,
        '{endpoint}/api/v2/datasets/{datasetId}/sharedRoles/'.format(endpoint=unittest_endpoint,
        datasetId="datasetId_example", ),
        status=204,
        content_type='',
    )
    result = DatasetsApi.datasets_shared_roles_patch_many(dataset_id="datasetId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_datasets_api_datasets_versions_all_features_details_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/datasets/{datasetId}/versions/{datasetVersionId}/allFeaturesDetails/'.format(endpoint=unittest_endpoint,
        limit=100, offset=0, orderBy="name", datasetId="datasetId_example", datasetVersionId="datasetVersionId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "timeStepAggregation" : 2,
    "timeSeriesEligibilityReason" : "timeSeriesEligibilityReason",
    "dateFormat" : "dateFormat",
    "max" : 1.4658129805029452,
    "naCount" : 7,
    "lowInformation" : True,
    "timeUnitAggregation" : "timeUnitAggregation",
    "min" : 2.3021358869347655,
    "timeSeriesEligible" : True,
    "median" : 5.637376656633329,
    "timeStep" : 3,
    "mean" : 5.962133916683182,
    "featureType" : "Interaction",
    "keySummary" : "",
    "name" : "name",
    "datasetId" : "datasetId",
    "timeSeriesEligibilityReasonAggregation" : "timeSeriesEligibilityReasonAggregation",
    "id" : 6,
    "isZeroInflated" : True,
    "timeSeriesEligibleAggregation" : True,
    "stdDev" : 9.301444243932576,
    "datasetVersionId" : "datasetVersionId",
    "timeUnit" : "timeUnit",
    "uniqueCount" : 4
  }, {
    "timeStepAggregation" : 2,
    "timeSeriesEligibilityReason" : "timeSeriesEligibilityReason",
    "dateFormat" : "dateFormat",
    "max" : 1.4658129805029452,
    "naCount" : 7,
    "lowInformation" : True,
    "timeUnitAggregation" : "timeUnitAggregation",
    "min" : 2.3021358869347655,
    "timeSeriesEligible" : True,
    "median" : 5.637376656633329,
    "timeStep" : 3,
    "mean" : 5.962133916683182,
    "featureType" : "Interaction",
    "keySummary" : "",
    "name" : "name",
    "datasetId" : "datasetId",
    "timeSeriesEligibilityReasonAggregation" : "timeSeriesEligibilityReasonAggregation",
    "id" : 6,
    "isZeroInflated" : True,
    "timeSeriesEligibleAggregation" : True,
    "stdDev" : 9.301444243932576,
    "datasetVersionId" : "datasetVersionId",
    "timeUnit" : "timeUnit",
    "uniqueCount" : 4
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0,
  "totalCount" : 7
})
    )
    result = DatasetsApi.datasets_versions_all_features_details_list(limit=100, offset=0, order_by="name", dataset_id="datasetId_example", dataset_version_id="datasetVersionId_example", )
    assert isinstance(result, DatasetFeaturesListResponse)


@responses.activate
def test_datasets_api_datasets_versions_delete(unittest_endpoint):
    responses.add(
        responses.DELETE,
        '{endpoint}/api/v2/datasets/{datasetId}/versions/{datasetVersionId}/'.format(endpoint=unittest_endpoint,
        datasetId="datasetId_example", datasetVersionId="datasetVersionId_example", ),
        status=204,
        content_type='',
    )
    result = DatasetsApi.datasets_versions_delete(dataset_id="datasetId_example", dataset_version_id="datasetVersionId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_datasets_api_datasets_versions_deleted_patch_many(unittest_endpoint):
    responses.add(
        responses.PATCH,
        '{endpoint}/api/v2/datasets/{datasetId}/versions/{datasetVersionId}/deleted/'.format(endpoint=unittest_endpoint,
        datasetId="datasetId_example", datasetVersionId="datasetVersionId_example", ),
        status=200,
        content_type='',
    )
    result = DatasetsApi.datasets_versions_deleted_patch_many(dataset_id="datasetId_example", dataset_version_id="datasetVersionId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_datasets_api_datasets_versions_feature_histograms_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/datasets/{datasetId}/versions/{datasetVersionId}/featureHistograms/{featureName}/'.format(endpoint=unittest_endpoint,
        binLimit=60, datasetId="datasetId_example", datasetVersionId="datasetVersionId_example", featureName="featureName_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "plot" : [ {
    "count" : 0.8008281904610115,
    "label" : "label"
  }, {
    "count" : 0.8008281904610115,
    "label" : "label"
  } ]
})
    )
    result = DatasetsApi.datasets_versions_feature_histograms_retrieve(bin_limit=60, dataset_id="datasetId_example", dataset_version_id="datasetVersionId_example", feature_name="featureName_example", )
    assert isinstance(result, DatasetFeatureHistogramResponse)


@responses.activate
def test_datasets_api_datasets_versions_featurelists_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/datasets/{datasetId}/versions/{datasetVersionId}/featurelists/'.format(endpoint=unittest_endpoint,
        limit=100, offset=0, orderBy="name", datasetId="datasetId_example", datasetVersionId="datasetVersionId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "features" : [ "features", "features" ],
    "createdBy" : "createdBy",
    "name" : "name",
    "datasetId" : "datasetId",
    "id" : "id",
    "creationDate" : "2000-01-23T04:56:07.000+00:00",
    "userCreated" : True,
    "datasetVersionId" : "datasetVersionId"
  }, {
    "features" : [ "features", "features" ],
    "createdBy" : "createdBy",
    "name" : "name",
    "datasetId" : "datasetId",
    "id" : "id",
    "creationDate" : "2000-01-23T04:56:07.000+00:00",
    "userCreated" : True,
    "datasetVersionId" : "datasetVersionId"
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0,
  "totalCount" : 6
})
    )
    result = DatasetsApi.datasets_versions_featurelists_list(limit=100, offset=0, order_by="name", dataset_id="datasetId_example", dataset_version_id="datasetVersionId_example", )
    assert isinstance(result, DatasetFeaturelistListResponse)


@responses.activate
def test_datasets_api_datasets_versions_featurelists_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/datasets/{datasetId}/versions/{datasetVersionId}/featurelists/{featurelistId}/'.format(endpoint=unittest_endpoint,
        datasetId="datasetId_example", datasetVersionId="datasetVersionId_example", featurelistId="featurelistId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "features" : [ "features", "features" ],
  "createdBy" : "createdBy",
  "name" : "name",
  "datasetId" : "datasetId",
  "id" : "id",
  "creationDate" : "2000-01-23T04:56:07.000+00:00",
  "userCreated" : True,
  "datasetVersionId" : "datasetVersionId"
})
    )
    result = DatasetsApi.datasets_versions_featurelists_retrieve(dataset_id="datasetId_example", dataset_version_id="datasetVersionId_example", featurelist_id="featurelistId_example", )
    assert isinstance(result, DatasetFeaturelistResponse)


@responses.activate
def test_datasets_api_datasets_versions_file_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/datasets/{datasetId}/versions/{datasetVersionId}/file/'.format(endpoint=unittest_endpoint,
        datasetId="datasetId_example", datasetVersionId="datasetVersionId_example", ),
        status=200,
        content_type='text/csv',
        body=json.dumps("datasetId_example")
    )
    result = DatasetsApi.datasets_versions_file_list(dataset_id="datasetId_example", dataset_version_id="datasetVersionId_example", )
    assert isinstance(result, str)


@responses.activate
def test_datasets_api_datasets_versions_from_data_engine_workspace_state_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/api/v2/datasets/{datasetId}/versions/fromDataEngineWorkspaceState/'.format(endpoint=unittest_endpoint,
        datasetId="datasetId_example", ),
        status=202,
        content_type='application/json',
        body=json.dumps({
  "statusId" : "statusId",
  "datasetId" : "datasetId",
  "datasetVersionId" : "datasetVersionId"
})
    )
    result = DatasetsApi.datasets_versions_from_data_engine_workspace_state_create(dataset_id="datasetId_example", )
    assert isinstance(result, CreatedDatasetDataEngineResponse)


@responses.activate
def test_datasets_api_datasets_versions_from_data_source_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/api/v2/datasets/{datasetId}/versions/fromDataSource/'.format(endpoint=unittest_endpoint,
        datasetId="datasetId_example", ),
        status=202,
        content_type='application/json',
        body=json.dumps({
  "catalogId" : "catalogId",
  "statusId" : "statusId",
  "catalogVersionId" : "catalogVersionId"
})
    )
    result = DatasetsApi.datasets_versions_from_data_source_create(dataset_id="datasetId_example", )
    assert isinstance(result, CreatedDatasetResponse)


@responses.activate
def test_datasets_api_datasets_versions_from_file_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/api/v2/datasets/{datasetId}/versions/fromFile/'.format(endpoint=unittest_endpoint,
        datasetId="datasetId_example", ),
        status=202,
        content_type='application/json',
        body=json.dumps({
  "catalogId" : "catalogId",
  "statusId" : "statusId",
  "catalogVersionId" : "catalogVersionId"
})
    )
    result = DatasetsApi.datasets_versions_from_file_create(dataset_id="datasetId_example", )
    assert isinstance(result, CreatedDatasetResponse)


@responses.activate
def test_datasets_api_datasets_versions_from_hdfs_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/api/v2/datasets/{datasetId}/versions/fromHDFS/'.format(endpoint=unittest_endpoint,
        datasetId="datasetId_example", ),
        status=202,
        content_type='application/json',
        body=json.dumps({
  "catalogId" : "catalogId",
  "statusId" : "statusId",
  "catalogVersionId" : "catalogVersionId"
})
    )
    result = DatasetsApi.datasets_versions_from_hdfs_create(dataset_id="datasetId_example", )
    assert isinstance(result, CreatedDatasetResponse)


@responses.activate
def test_datasets_api_datasets_versions_from_latest_version_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/api/v2/datasets/{datasetId}/versions/fromLatestVersion/'.format(endpoint=unittest_endpoint,
        datasetId="datasetId_example", ),
        status=202,
        content_type='application/json',
        body=json.dumps({
  "catalogId" : "catalogId",
  "statusId" : "statusId",
  "catalogVersionId" : "catalogVersionId"
})
    )
    result = DatasetsApi.datasets_versions_from_latest_version_create(dataset_id="datasetId_example", )
    assert isinstance(result, CreatedDatasetResponse)


@responses.activate
def test_datasets_api_datasets_versions_from_url_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/api/v2/datasets/{datasetId}/versions/fromURL/'.format(endpoint=unittest_endpoint,
        datasetId="datasetId_example", ),
        status=202,
        content_type='application/json',
        body=json.dumps({
  "catalogId" : "catalogId",
  "statusId" : "statusId",
  "catalogVersionId" : "catalogVersionId"
})
    )
    result = DatasetsApi.datasets_versions_from_url_create(dataset_id="datasetId_example", )
    assert isinstance(result, CreatedDatasetResponse)


@responses.activate
def test_datasets_api_datasets_versions_from_version_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/api/v2/datasets/{datasetId}/versions/{datasetVersionId}/fromVersion/'.format(endpoint=unittest_endpoint,
        datasetId="datasetId_example", datasetVersionId="datasetVersionId_example", ),
        status=202,
        content_type='application/json',
        body=json.dumps({
  "catalogId" : "catalogId",
  "statusId" : "statusId",
  "catalogVersionId" : "catalogVersionId"
})
    )
    result = DatasetsApi.datasets_versions_from_version_create(dataset_id="datasetId_example", dataset_version_id="datasetVersionId_example", )
    assert isinstance(result, CreatedDatasetResponse)


@responses.activate
def test_datasets_api_datasets_versions_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/datasets/{datasetId}/versions/'.format(endpoint=unittest_endpoint,
        limit=100, offset=0, datasetId="datasetId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "isLatestVersion" : True,
    "dataPersisted" : True,
    "isDataEngineEligible" : True,
    "creationDate" : "2000-01-23T04:56:07.000+00:00",
    "processingState" : "COMPLETED",
    "versionId" : "versionId",
    "createdBy" : "createdBy",
    "datasetSize" : 6,
    "name" : "name",
    "datasetId" : "datasetId",
    "categories" : [ "BATCH_PREDICTIONS", "BATCH_PREDICTIONS" ],
    "rowCount" : 1,
    "isSnapshot" : True,
    "timeSeriesProperties" : {
      "isMostlyImputed" : True
    }
  }, {
    "isLatestVersion" : True,
    "dataPersisted" : True,
    "isDataEngineEligible" : True,
    "creationDate" : "2000-01-23T04:56:07.000+00:00",
    "processingState" : "COMPLETED",
    "versionId" : "versionId",
    "createdBy" : "createdBy",
    "datasetSize" : 6,
    "name" : "name",
    "datasetId" : "datasetId",
    "categories" : [ "BATCH_PREDICTIONS", "BATCH_PREDICTIONS" ],
    "rowCount" : 1,
    "isSnapshot" : True,
    "timeSeriesProperties" : {
      "isMostlyImputed" : True
    }
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0,
  "totalCount" : 5
})
    )
    result = DatasetsApi.datasets_versions_list(limit=100, offset=0, dataset_id="datasetId_example", )
    assert isinstance(result, DatasetListResponse)


@responses.activate
def test_datasets_api_datasets_versions_projects_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/datasets/{datasetId}/versions/{datasetVersionId}/projects/'.format(endpoint=unittest_endpoint,
        limit=100, offset=0, datasetId="datasetId_example", datasetVersionId="datasetVersionId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "id" : "id",
    "url" : "url"
  }, {
    "id" : "id",
    "url" : "url"
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0,
  "totalCount" : 6
})
    )
    result = DatasetsApi.datasets_versions_projects_list(limit=100, offset=0, dataset_id="datasetId_example", dataset_version_id="datasetVersionId_example", )
    assert isinstance(result, GetDatasetVersionProjectsResponse)


@responses.activate
def test_datasets_api_datasets_versions_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/datasets/{datasetId}/versions/{datasetVersionId}/'.format(endpoint=unittest_endpoint,
        datasetId="datasetId_example", datasetVersionId="datasetVersionId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "dataPersisted" : True,
  "isDataEngineEligible" : True,
  "lastModifierFullName" : "lastModifierFullName",
  "description" : "description",
  "error" : "error",
  "dataSourceId" : "dataSourceId",
  "lastModificationDate" : "2000-01-23T04:56:07.000+00:00",
  "datasetSize" : 0,
  "eda1ModificationDate" : "2000-01-23T04:56:07.000+00:00",
  "entityCountByType" : {
    "numPredictionDatasets" : 5,
    "numExternalModelPackages" : 1,
    "numSparkSqlQueries" : 7,
    "numFeatureDiscoveryConfigs" : 5,
    "numProjects" : 2,
    "numCalendars" : 6
  },
  "datasetId" : "datasetId",
  "categories" : [ "BATCH_PREDICTIONS", "BATCH_PREDICTIONS" ],
  "rowCount" : 2,
  "timeSeriesProperties" : {
    "isMostlyImputed" : True
  },
  "isLatestVersion" : True,
  "featureCountByType" : [ {
    "count" : 3,
    "featureType" : "featureType"
  }, {
    "count" : 3,
    "featureType" : "featureType"
  } ],
  "eda1ModifierFullName" : "eda1ModifierFullName",
  "creationDate" : "2000-01-23T04:56:07.000+00:00",
  "uri" : "uri",
  "tags" : [ "tags", "tags" ],
  "processingState" : "COMPLETED",
  "versionId" : "versionId",
  "createdBy" : "createdBy",
  "dataEngineQueryId" : "dataEngineQueryId",
  "name" : "name",
  "isSnapshot" : True,
  "dataSourceType" : "dataSourceType",
  "featureCount" : 9
})
    )
    result = DatasetsApi.datasets_versions_retrieve(dataset_id="datasetId_example", dataset_version_id="datasetVersionId_example", )
    assert isinstance(result, FullDatasetDetailsResponse)
