#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import json
import responses
from six.moves.urllib.parse import urljoin
from dateutil import parser
from datarobot.models.full_api.generated.model.eureqa_distribution_detail_response import EureqaDistributionDetailResponse
from datarobot.models.full_api.generated.model.eureqa_leaderboard_entry_payload import EureqaLeaderboardEntryPayload
from datarobot.models.full_api.generated.model.eureqa_model_detail_response import EureqaModelDetailResponse
from datarobot.models.full_api.generated.model.pareto_front_response import ParetoFrontResponse
from datarobot.utils import from_api
from datarobot.models.full_api.generated.model import *

from datarobot.models.full_api.generated.api.eureqa_api import EureqaApi




@responses.activate
def test_eureqa_api_projects_eureqa_distribution_plot_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/eureqaDistributionPlot/{solutionId}/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", solutionId="solutionId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "complexity" : 5,
  "bins" : [ {
    "binEnd" : 0.8008281904610115,
    "negatives" : 1,
    "binStart" : 6.027456183070403,
    "positives" : 5
  }, {
    "binEnd" : 0.8008281904610115,
    "negatives" : 1,
    "binStart" : 6.027456183070403,
    "positives" : 5
  } ],
  "expression" : "expression",
  "errorMetric" : "errorMetric",
  "threshold" : 7.061401241503109,
  "eureqaSolutionId" : "eureqaSolutionId",
  "error" : 2.3021358869347655,
  "expressionAnnotated" : "expressionAnnotated"
})
    )
    result = EureqaApi.projects_eureqa_distribution_plot_retrieve(project_id="projectId_example", solution_id="solutionId_example", )
    assert isinstance(result, EureqaDistributionDetailResponse)


@responses.activate
def test_eureqa_api_projects_eureqa_model_detail_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/eureqaModelDetail/{solutionId}/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", solutionId="solutionId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "complexity" : 0,
  "expression" : "expression",
  "errorMetric" : "errorMetric",
  "plotData" : [ {
    "actual" : 1.4658129805029452,
    "row" : 5,
    "predicted" : 5.962133916683182
  }, {
    "actual" : 1.4658129805029452,
    "row" : 5,
    "predicted" : 5.962133916683182
  } ],
  "eureqaSolutionId" : "eureqaSolutionId",
  "error" : 6.027456183070403,
  "expressionAnnotated" : "expressionAnnotated"
})
    )
    result = EureqaApi.projects_eureqa_model_detail_retrieve(project_id="projectId_example", solution_id="solutionId_example", )
    assert isinstance(result, EureqaModelDetailResponse)


@responses.activate
def test_eureqa_api_projects_eureqa_models_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/api/v2/projects/{projectId}/eureqaModels/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", ),
        status=200,
        content_type='',
    )
    result = EureqaApi.projects_eureqa_models_create(project_id="projectId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_eureqa_api_projects_eureqa_models_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/eureqaModels/{modelId}/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "errorMetric" : "errorMetric",
  "solutions" : [ {
    "complexity" : 0,
    "expression" : "expression",
    "eureqaSolutionId" : "eureqaSolutionId",
    "bestModel" : True,
    "error" : 6.027456183070403,
    "expressionAnnotated" : "expressionAnnotated"
  }, {
    "complexity" : 0,
    "expression" : "expression",
    "eureqaSolutionId" : "eureqaSolutionId",
    "bestModel" : True,
    "error" : 6.027456183070403,
    "expressionAnnotated" : "expressionAnnotated"
  } ],
  "hyperparameters" : "",
  "targetType" : "Regression",
  "projectId" : "projectId"
})
    )
    result = EureqaApi.projects_eureqa_models_retrieve(project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, ParetoFrontResponse)
