#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import json
import responses
from six.moves.urllib.parse import urljoin
from dateutil import parser
from datarobot.models.full_api.generated.model.driver_configuration_list_response import DriverConfigurationListResponse
from datarobot.models.full_api.generated.model.driver_configuration_retrieve_response import DriverConfigurationRetrieveResponse
from datarobot.utils import from_api
from datarobot.models.full_api.generated.model import *

from datarobot.models.full_api.generated.api.external_drivers_api import ExternalDriversApi




@responses.activate
def test_external_drivers_api_external_driver_configurations_list(unittest_endpoint):
    responses.add(
        responses.GET,
       '{endpoint}/api/v2/externalDriverConfigurations/'.format(endpoint=unittest_endpoint),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "standardizedName" : "standardizedName",
    "creator" : "creator",
    "jdbcUrlPathDelimiter" : "jdbcUrlPathDelimiter",
    "jdbcUrlPrefix" : "jdbcUrlPrefix",
    "jdbcUrlQueryDelimiter" : "jdbcUrlQueryDelimiter",
    "jdbcUrlQueryParamKeyValueDelimiter" : "jdbcUrlQueryParamKeyValueDelimiter",
    "associatedAuthTypes" : [ "associatedAuthTypes", "associatedAuthTypes" ],
    "jdbcFieldSchemas" : {
      "default" : "default",
      "kind" : "QUERY_PARAM",
      "visibleByDefault" : True,
      "name" : "name",
      "description" : "description",
      "index" : 0,
      "choices" : [ "choices", "choices" ],
      "required" : True
    },
    "className" : "className",
    "id" : "id",
    "updated" : "updated",
    "jdbcUrlQueryParamDelimiter" : "jdbcUrlQueryParamDelimiter"
  }, {
    "standardizedName" : "standardizedName",
    "creator" : "creator",
    "jdbcUrlPathDelimiter" : "jdbcUrlPathDelimiter",
    "jdbcUrlPrefix" : "jdbcUrlPrefix",
    "jdbcUrlQueryDelimiter" : "jdbcUrlQueryDelimiter",
    "jdbcUrlQueryParamKeyValueDelimiter" : "jdbcUrlQueryParamKeyValueDelimiter",
    "associatedAuthTypes" : [ "associatedAuthTypes", "associatedAuthTypes" ],
    "jdbcFieldSchemas" : {
      "default" : "default",
      "kind" : "QUERY_PARAM",
      "visibleByDefault" : True,
      "name" : "name",
      "description" : "description",
      "index" : 0,
      "choices" : [ "choices", "choices" ],
      "required" : True
    },
    "className" : "className",
    "id" : "id",
    "updated" : "updated",
    "jdbcUrlQueryParamDelimiter" : "jdbcUrlQueryParamDelimiter"
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0,
  "totalCount" : 6
})
    )
    result = ExternalDriversApi.external_driver_configurations_list()
    assert isinstance(result, DriverConfigurationListResponse)


@responses.activate
def test_external_drivers_api_external_driver_configurations_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/externalDriverConfigurations/{configurationId}/'.format(endpoint=unittest_endpoint,
        configurationId="configurationId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "standardizedName" : "standardizedName",
  "creator" : "creator",
  "jdbcUrlPathDelimiter" : "jdbcUrlPathDelimiter",
  "jdbcUrlPrefix" : "jdbcUrlPrefix",
  "jdbcUrlQueryDelimiter" : "jdbcUrlQueryDelimiter",
  "jdbcUrlQueryParamKeyValueDelimiter" : "jdbcUrlQueryParamKeyValueDelimiter",
  "associatedAuthTypes" : [ "associatedAuthTypes", "associatedAuthTypes" ],
  "jdbcFieldSchemas" : {
    "default" : "default",
    "kind" : "QUERY_PARAM",
    "visibleByDefault" : True,
    "name" : "name",
    "description" : "description",
    "index" : 0,
    "choices" : [ "choices", "choices" ],
    "required" : True
  },
  "className" : "className",
  "id" : "id",
  "updated" : "updated",
  "jdbcUrlQueryParamDelimiter" : "jdbcUrlQueryParamDelimiter"
})
    )
    result = ExternalDriversApi.external_driver_configurations_retrieve(configuration_id="configurationId_example", )
    assert isinstance(result, DriverConfigurationRetrieveResponse)
