#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import json
import responses
from six.moves.urllib.parse import urljoin
from dateutil import parser
from datarobot.models.full_api.generated.model.create_featurelist import CreateFeaturelist
from datarobot.models.full_api.generated.model.featurelist_destroy_response import FeaturelistDestroyResponse
from datarobot.models.full_api.generated.model.featurelist_list_response import FeaturelistListResponse
from datarobot.models.full_api.generated.model.featurelist_response import FeaturelistResponse
from datarobot.models.full_api.generated.model.update_featurelist import UpdateFeaturelist
from datarobot.utils import from_api
from datarobot.models.full_api.generated.model import *

from datarobot.models.full_api.generated.api.featurelists_api import FeaturelistsApi




@responses.activate
def test_featurelists_api_projects_featurelists_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/api/v2/projects/{projectId}/featurelists/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "features" : [ "features", "features" ],
  "created" : "created",
  "isUserCreated" : True,
  "name" : "name",
  "numModels" : 6,
  "description" : "description",
  "id" : "id",
  "projectId" : "projectId"
})
    )
    result = FeaturelistsApi.projects_featurelists_create(project_id="projectId_example", )
    assert isinstance(result, FeaturelistResponse)


@responses.activate
def test_featurelists_api_projects_featurelists_delete(unittest_endpoint):
    responses.add(
        responses.DELETE,
        '{endpoint}/api/v2/projects/{projectId}/featurelists/{featurelistId}/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", featurelistId="featurelistId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "numAffectedJobs" : 0,
  "dryRun" : "False",
  "canDelete" : "False",
  "deletionBlockedReason" : "deletionBlockedReason",
  "numAffectedModels" : 6
})
    )
    result = FeaturelistsApi.projects_featurelists_delete(project_id="projectId_example", featurelist_id="featurelistId_example", )
    assert isinstance(result, FeaturelistDestroyResponse)


@responses.activate
def test_featurelists_api_projects_featurelists_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/featurelists/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "features" : [ "features", "features" ],
    "created" : "created",
    "isUserCreated" : True,
    "name" : "name",
    "numModels" : 6,
    "description" : "description",
    "id" : "id",
    "projectId" : "projectId"
  }, {
    "features" : [ "features", "features" ],
    "created" : "created",
    "isUserCreated" : True,
    "name" : "name",
    "numModels" : 6,
    "description" : "description",
    "id" : "id",
    "projectId" : "projectId"
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0
})
    )
    result = FeaturelistsApi.projects_featurelists_list(project_id="projectId_example", )
    assert isinstance(result, FeaturelistListResponse)


@responses.activate
def test_featurelists_api_projects_featurelists_patch(unittest_endpoint):
    responses.add(
        responses.PATCH,
        '{endpoint}/api/v2/projects/{projectId}/featurelists/{featurelistId}/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", featurelistId="featurelistId_example", ),
        status=204,
        content_type='',
    )
    result = FeaturelistsApi.projects_featurelists_patch(project_id="projectId_example", featurelist_id="featurelistId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_featurelists_api_projects_featurelists_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/featurelists/{featurelistId}/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", featurelistId="featurelistId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "features" : [ "features", "features" ],
  "created" : "created",
  "isUserCreated" : True,
  "name" : "name",
  "numModels" : 6,
  "description" : "description",
  "id" : "id",
  "projectId" : "projectId"
})
    )
    result = FeaturelistsApi.projects_featurelists_retrieve(project_id="projectId_example", featurelist_id="featurelistId_example", )
    assert isinstance(result, FeaturelistResponse)


@responses.activate
def test_featurelists_api_projects_modeling_featurelists_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/api/v2/projects/{projectId}/modelingFeaturelists/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "features" : [ "features", "features" ],
  "created" : "created",
  "isUserCreated" : True,
  "name" : "name",
  "numModels" : 6,
  "description" : "description",
  "id" : "id",
  "projectId" : "projectId"
})
    )
    result = FeaturelistsApi.projects_modeling_featurelists_create(project_id="projectId_example", )
    assert isinstance(result, FeaturelistResponse)


@responses.activate
def test_featurelists_api_projects_modeling_featurelists_delete(unittest_endpoint):
    responses.add(
        responses.DELETE,
        '{endpoint}/api/v2/projects/{projectId}/modelingFeaturelists/{featurelistId}/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", featurelistId="featurelistId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "numAffectedJobs" : 0,
  "dryRun" : "False",
  "canDelete" : "False",
  "deletionBlockedReason" : "deletionBlockedReason",
  "numAffectedModels" : 6
})
    )
    result = FeaturelistsApi.projects_modeling_featurelists_delete(project_id="projectId_example", featurelist_id="featurelistId_example", )
    assert isinstance(result, FeaturelistDestroyResponse)


@responses.activate
def test_featurelists_api_projects_modeling_featurelists_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/modelingFeaturelists/'.format(endpoint=unittest_endpoint,
        offset=0, limit=0, projectId="projectId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "features" : [ "features", "features" ],
    "created" : "created",
    "isUserCreated" : True,
    "name" : "name",
    "numModels" : 6,
    "description" : "description",
    "id" : "id",
    "projectId" : "projectId"
  }, {
    "features" : [ "features", "features" ],
    "created" : "created",
    "isUserCreated" : True,
    "name" : "name",
    "numModels" : 6,
    "description" : "description",
    "id" : "id",
    "projectId" : "projectId"
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0
})
    )
    result = FeaturelistsApi.projects_modeling_featurelists_list(offset=0, limit=0, project_id="projectId_example", )
    assert isinstance(result, FeaturelistListResponse)


@responses.activate
def test_featurelists_api_projects_modeling_featurelists_patch(unittest_endpoint):
    responses.add(
        responses.PATCH,
        '{endpoint}/api/v2/projects/{projectId}/modelingFeaturelists/{featurelistId}/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", featurelistId="featurelistId_example", ),
        status=204,
        content_type='',
    )
    result = FeaturelistsApi.projects_modeling_featurelists_patch(project_id="projectId_example", featurelist_id="featurelistId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_featurelists_api_projects_modeling_featurelists_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/modelingFeaturelists/{featurelistId}/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", featurelistId="featurelistId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "features" : [ "features", "features" ],
  "created" : "created",
  "isUserCreated" : True,
  "name" : "name",
  "numModels" : 6,
  "description" : "description",
  "id" : "id",
  "projectId" : "projectId"
})
    )
    result = FeaturelistsApi.projects_modeling_featurelists_retrieve(project_id="projectId_example", featurelist_id="featurelistId_example", )
    assert isinstance(result, FeaturelistResponse)
