#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import json
import responses
from six.moves.urllib.parse import urljoin
from dateutil import parser
from datarobot.models.full_api.generated.model.cluster_license_retrieve_response import ClusterLicenseRetrieveResponse
from datarobot.models.full_api.generated.model.cluster_license_update import ClusterLicenseUpdate
from datarobot.models.full_api.generated.model.cluster_license_validation_response import ClusterLicenseValidationResponse
from datarobot.models.full_api.generated.model.version_retrieve_response import VersionRetrieveResponse
from datarobot.utils import from_api
from datarobot.models.full_api.generated.model import *

from datarobot.models.full_api.generated.api.infrastructure_api import InfrastructureApi




@responses.activate
def test_infrastructure_api_cluster_license_list(unittest_endpoint):
    responses.add(
        responses.GET,
       '{endpoint}/api/v2/clusterLicense/'.format(endpoint=unittest_endpoint),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "uploadInfo" : {
    "uploaderUsername" : "uploaderUsername",
    "uploaderUserId" : "uploaderUserId",
    "uploadTimestamp" : "uploadTimestamp"
  },
  "licenseInfo" : {
    "concurrentWorkersCount" : 0,
    "expired" : True,
    "maxDeploymentLimit" : 0,
    "expirationTimestamp" : "expirationTimestamp",
    "maximumActiveUsers" : 0,
    "featureFlags" : {
      "key" : {
        "uiLabel" : "uiLabel",
        "uiTooltip" : "uiTooltip",
        "value" : True
      }
    },
    "prepaidDeploymentLimit" : 0
  }
})
    )
    result = InfrastructureApi.cluster_license_list()
    assert isinstance(result, ClusterLicenseRetrieveResponse)


@responses.activate
def test_infrastructure_api_cluster_license_put_many(unittest_endpoint):
    responses.add(
        responses.PUT,
       '{endpoint}/api/v2/clusterLicense/'.format(endpoint=unittest_endpoint),
        status=200,
        content_type='',
    )
    result = InfrastructureApi.cluster_license_put_many()
    assert isinstance(result, type(None))


@responses.activate
def test_infrastructure_api_cluster_license_validation_create(unittest_endpoint):
    responses.add(
        responses.POST,
       '{endpoint}/api/v2/clusterLicenseValidation/'.format(endpoint=unittest_endpoint),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "licenseInfo" : {
    "concurrentWorkersCount" : 0,
    "expired" : True,
    "maxDeploymentLimit" : 0,
    "expirationTimestamp" : "expirationTimestamp",
    "maximumActiveUsers" : 0,
    "featureFlags" : {
      "key" : {
        "uiLabel" : "uiLabel",
        "uiTooltip" : "uiTooltip",
        "value" : True
      }
    },
    "prepaidDeploymentLimit" : 0
  }
})
    )
    result = InfrastructureApi.cluster_license_validation_create()
    assert isinstance(result, ClusterLicenseValidationResponse)


@responses.activate
def test_infrastructure_api_version_list(unittest_endpoint):
    responses.add(
        responses.GET,
       '{endpoint}/api/v2/version/'.format(endpoint=unittest_endpoint),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "major" : 0,
  "minor" : 6,
  "versionString" : "versionString"
})
    )
    result = InfrastructureApi.version_list()
    assert isinstance(result, VersionRetrieveResponse)
