#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import json
import responses
from six.moves.urllib.parse import urljoin
from dateutil import parser
from datarobot.models.full_api.generated.model.batch_prediction_job_create import BatchPredictionJobCreate
from datarobot.models.full_api.generated.model.batch_prediction_job_definition_id import BatchPredictionJobDefinitionId
from datarobot.models.full_api.generated.model.batch_prediction_job_definitions_create import BatchPredictionJobDefinitionsCreate
from datarobot.models.full_api.generated.model.batch_prediction_job_definitions_list_response import BatchPredictionJobDefinitionsListResponse
from datarobot.models.full_api.generated.model.batch_prediction_job_definitions_response import BatchPredictionJobDefinitionsResponse
from datarobot.models.full_api.generated.model.batch_prediction_job_definitions_update import BatchPredictionJobDefinitionsUpdate
from datarobot.models.full_api.generated.model.batch_prediction_job_id import BatchPredictionJobId
from datarobot.models.full_api.generated.model.batch_prediction_job_list_response import BatchPredictionJobListResponse
from datarobot.models.full_api.generated.model.batch_prediction_job_response import BatchPredictionJobResponse
from datarobot.models.full_api.generated.model.batch_prediction_job_update import BatchPredictionJobUpdate
from datarobot.models.full_api.generated.model.create_prediction_dataset_response import CreatePredictionDatasetResponse
from datarobot.models.full_api.generated.model.create_prediction_from_dataset import CreatePredictionFromDataset
from datarobot.models.full_api.generated.model.create_training_prediction import CreateTrainingPrediction
from datarobot.models.full_api.generated.model.imorted_model_update_payload import ImortedModelUpdatePayload
from datarobot.models.full_api.generated.model.imported_model_list_response import ImportedModelListResponse
from datarobot.models.full_api.generated.model.imported_model_retrieve_response import ImportedModelRetrieveResponse
from datarobot.models.full_api.generated.model.predict_job_details_response import PredictJobDetailsResponse
from datarobot.models.full_api.generated.model.prediction_data_source import PredictionDataSource
from datarobot.models.full_api.generated.model.prediction_dataset_list_controller_response import PredictionDatasetListControllerResponse
from datarobot.models.full_api.generated.model.prediction_dataset_retrieve_response import PredictionDatasetRetrieveResponse
from datarobot.models.full_api.generated.model.prediction_explanations_create import PredictionExplanationsCreate
from datarobot.models.full_api.generated.model.prediction_explanations_initialization_create import PredictionExplanationsInitializationCreate
from datarobot.models.full_api.generated.model.prediction_explanations_initialization_retrieve import PredictionExplanationsInitializationRetrieve
from datarobot.models.full_api.generated.model.prediction_explanations_record import PredictionExplanationsRecord
from datarobot.models.full_api.generated.model.prediction_explanations_record_list import PredictionExplanationsRecordList
from datarobot.models.full_api.generated.model.prediction_explanations_retrieve import PredictionExplanationsRetrieve
from datarobot.models.full_api.generated.model.prediction_file_upload import PredictionFileUpload
from datarobot.models.full_api.generated.model.prediction_from_catalog_dataset import PredictionFromCatalogDataset
from datarobot.models.full_api.generated.model.prediction_integration_job_create_payload import PredictionIntegrationJobCreatePayload
from datarobot.models.full_api.generated.model.prediction_integration_job_logs_retrieve_response import PredictionIntegrationJobLogsRetrieveResponse
from datarobot.models.full_api.generated.model.prediction_integration_job_response import PredictionIntegrationJobResponse
from datarobot.models.full_api.generated.model.prediction_integration_job_run_history_response import PredictionIntegrationJobRunHistoryResponse
from datarobot.models.full_api.generated.model.prediction_integration_job_runs_history_response import PredictionIntegrationJobRunsHistoryResponse
from datarobot.models.full_api.generated.model.prediction_integration_job_update import PredictionIntegrationJobUpdate
from datarobot.models.full_api.generated.model.prediction_retrieve_response import PredictionRetrieveResponse
from datarobot.models.full_api.generated.model.prediction_url_upload import PredictionURLUpload
from datarobot.models.full_api.generated.model.retrieve_list_prediction_metadata_objects_response import RetrieveListPredictionMetadataObjectsResponse
from datarobot.models.full_api.generated.model.retrieve_prediction_metadata_object import RetrievePredictionMetadataObject
from datarobot.models.full_api.generated.model.scheduled_job_response import ScheduledJobResponse
from datarobot.models.full_api.generated.model.scheduled_job_run_stop import ScheduledJobRunStop
from datarobot.models.full_api.generated.model.scheduled_jobs_list_response import ScheduledJobsListResponse
from datarobot.models.full_api.generated.model.single_model_file_payload import SingleModelFilePayload
from datarobot.models.full_api.generated.model.training_predictions_list_response import TrainingPredictionsListResponse
from datarobot.models.full_api.generated.model.training_predictions_retrieve_response import TrainingPredictionsRetrieveResponse
from datarobot.utils import from_api
from datarobot.models.full_api.generated.model import *

from datarobot.models.full_api.generated.api.predictions_api import PredictionsApi




@responses.activate
def test_predictions_api_batch_prediction_job_definitions_create(unittest_endpoint):
    responses.add(
        responses.POST,
       '{endpoint}/api/v2/batchPredictionJobDefinitions/'.format(endpoint=unittest_endpoint),
        status=202,
        content_type='application/json',
        body=json.dumps({
  "updatedBy" : {
    "fullName" : "fullName",
    "userId" : "userId",
    "username" : "username"
  },
  "created" : "2000-01-23T04:56:07.000+00:00",
  "enabled" : False,
  "schedule" : {
    "dayOfWeek" : [ "*", "*" ],
    "hour" : [ "*", "*" ],
    "month" : [ "*", "*" ],
    "dayOfMonth" : [ "*", "*" ],
    "minute" : [ "*", "*" ]
  },
  "lastSuccessfulRunTime" : "2000-01-23T04:56:07.000+00:00",
  "createdBy" : {
    "fullName" : "fullName",
    "userId" : "userId",
    "username" : "username"
  },
  "lastStartedJobTime" : "2000-01-23T04:56:07.000+00:00",
  "name" : "name",
  "lastFailedRunTime" : "2000-01-23T04:56:07.000+00:00",
  "nextScheduledRunTime" : "2000-01-23T04:56:07.000+00:00",
  "batchPredictionJob" : {
    "abortOnError" : True,
    "disableRowLevelErrorHandling" : False,
    "columnNamesRemapping" : "",
    "chunkSize" : "",
    "timeseriesSettings" : "",
    "passthroughColumns" : [ "passthroughColumns", "passthroughColumns", "passthroughColumns", "passthroughColumns", "passthroughColumns" ],
    "includeProbabilitiesClasses" : [ "includeProbabilitiesClasses", "includeProbabilitiesClasses", "includeProbabilitiesClasses", "includeProbabilitiesClasses", "includeProbabilitiesClasses" ],
    "outputSettings" : "",
    "maxExplanations" : 60,
    "numConcurrent" : 5,
    "includeProbabilities" : True,
    "predictionWarningEnabled" : True,
    "intakeSettings" : "",
    "explanationAlgorithm" : "shap",
    "passthroughColumnsSet" : "all",
    "deploymentId" : "deploymentId",
    "includePredictionStatus" : False,
    "thresholdHigh" : 5.962133916683182,
    "skipDriftTracking" : False,
    "thresholdLow" : 5.637376656633329,
    "csvSettings" : {
      "quotechar" : "\"",
      "delimiter" : "",
      "encoding" : "utf-8"
    },
    "pinnedModelId" : "pinnedModelId",
    "predictionInstance" : {
      "hostName" : "hostName",
      "apiKey" : "apiKey",
      "datarobotKey" : "datarobotKey",
      "sslEnabled" : True
    }
  },
  "id" : "id",
  "lastStartedJobStatus" : "INITIALIZING",
  "updated" : "2000-01-23T04:56:07.000+00:00",
  "lastScheduledRunTime" : "2000-01-23T04:56:07.000+00:00"
})
    )
    result = PredictionsApi.batch_prediction_job_definitions_create()
    assert isinstance(result, BatchPredictionJobDefinitionsResponse)


@responses.activate
def test_predictions_api_batch_prediction_job_definitions_delete(unittest_endpoint):
    responses.add(
        responses.DELETE,
        '{endpoint}/api/v2/batchPredictionJobDefinitions/{jobDefinitionId}/'.format(endpoint=unittest_endpoint,
        jobDefinitionId="jobDefinitionId_example", ),
        status=204,
        content_type='',
    )
    result = PredictionsApi.batch_prediction_job_definitions_delete(job_definition_id="jobDefinitionId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_predictions_api_batch_prediction_job_definitions_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/batchPredictionJobDefinitions/'.format(endpoint=unittest_endpoint,
        offset=0, limit=100, ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "updatedBy" : {
      "fullName" : "fullName",
      "userId" : "userId",
      "username" : "username"
    },
    "created" : "2000-01-23T04:56:07.000+00:00",
    "enabled" : False,
    "schedule" : {
      "dayOfWeek" : [ "*", "*" ],
      "hour" : [ "*", "*" ],
      "month" : [ "*", "*" ],
      "dayOfMonth" : [ "*", "*" ],
      "minute" : [ "*", "*" ]
    },
    "lastSuccessfulRunTime" : "2000-01-23T04:56:07.000+00:00",
    "createdBy" : {
      "fullName" : "fullName",
      "userId" : "userId",
      "username" : "username"
    },
    "lastStartedJobTime" : "2000-01-23T04:56:07.000+00:00",
    "name" : "name",
    "lastFailedRunTime" : "2000-01-23T04:56:07.000+00:00",
    "nextScheduledRunTime" : "2000-01-23T04:56:07.000+00:00",
    "batchPredictionJob" : {
      "abortOnError" : True,
      "disableRowLevelErrorHandling" : False,
      "columnNamesRemapping" : "",
      "chunkSize" : "",
      "timeseriesSettings" : "",
      "passthroughColumns" : [ "passthroughColumns", "passthroughColumns", "passthroughColumns", "passthroughColumns", "passthroughColumns" ],
      "includeProbabilitiesClasses" : [ "includeProbabilitiesClasses", "includeProbabilitiesClasses", "includeProbabilitiesClasses", "includeProbabilitiesClasses", "includeProbabilitiesClasses" ],
      "outputSettings" : "",
      "maxExplanations" : 60,
      "numConcurrent" : 5,
      "includeProbabilities" : True,
      "predictionWarningEnabled" : True,
      "intakeSettings" : "",
      "explanationAlgorithm" : "shap",
      "passthroughColumnsSet" : "all",
      "deploymentId" : "deploymentId",
      "includePredictionStatus" : False,
      "thresholdHigh" : 5.962133916683182,
      "skipDriftTracking" : False,
      "thresholdLow" : 5.637376656633329,
      "csvSettings" : {
        "quotechar" : "\"",
        "delimiter" : "",
        "encoding" : "utf-8"
      },
      "pinnedModelId" : "pinnedModelId",
      "predictionInstance" : {
        "hostName" : "hostName",
        "apiKey" : "apiKey",
        "datarobotKey" : "datarobotKey",
        "sslEnabled" : True
      }
    },
    "id" : "id",
    "lastStartedJobStatus" : "INITIALIZING",
    "updated" : "2000-01-23T04:56:07.000+00:00",
    "lastScheduledRunTime" : "2000-01-23T04:56:07.000+00:00"
  }, {
    "updatedBy" : {
      "fullName" : "fullName",
      "userId" : "userId",
      "username" : "username"
    },
    "created" : "2000-01-23T04:56:07.000+00:00",
    "enabled" : False,
    "schedule" : {
      "dayOfWeek" : [ "*", "*" ],
      "hour" : [ "*", "*" ],
      "month" : [ "*", "*" ],
      "dayOfMonth" : [ "*", "*" ],
      "minute" : [ "*", "*" ]
    },
    "lastSuccessfulRunTime" : "2000-01-23T04:56:07.000+00:00",
    "createdBy" : {
      "fullName" : "fullName",
      "userId" : "userId",
      "username" : "username"
    },
    "lastStartedJobTime" : "2000-01-23T04:56:07.000+00:00",
    "name" : "name",
    "lastFailedRunTime" : "2000-01-23T04:56:07.000+00:00",
    "nextScheduledRunTime" : "2000-01-23T04:56:07.000+00:00",
    "batchPredictionJob" : {
      "abortOnError" : True,
      "disableRowLevelErrorHandling" : False,
      "columnNamesRemapping" : "",
      "chunkSize" : "",
      "timeseriesSettings" : "",
      "passthroughColumns" : [ "passthroughColumns", "passthroughColumns", "passthroughColumns", "passthroughColumns", "passthroughColumns" ],
      "includeProbabilitiesClasses" : [ "includeProbabilitiesClasses", "includeProbabilitiesClasses", "includeProbabilitiesClasses", "includeProbabilitiesClasses", "includeProbabilitiesClasses" ],
      "outputSettings" : "",
      "maxExplanations" : 60,
      "numConcurrent" : 5,
      "includeProbabilities" : True,
      "predictionWarningEnabled" : True,
      "intakeSettings" : "",
      "explanationAlgorithm" : "shap",
      "passthroughColumnsSet" : "all",
      "deploymentId" : "deploymentId",
      "includePredictionStatus" : False,
      "thresholdHigh" : 5.962133916683182,
      "skipDriftTracking" : False,
      "thresholdLow" : 5.637376656633329,
      "csvSettings" : {
        "quotechar" : "\"",
        "delimiter" : "",
        "encoding" : "utf-8"
      },
      "pinnedModelId" : "pinnedModelId",
      "predictionInstance" : {
        "hostName" : "hostName",
        "apiKey" : "apiKey",
        "datarobotKey" : "datarobotKey",
        "sslEnabled" : True
      }
    },
    "id" : "id",
    "lastStartedJobStatus" : "INITIALIZING",
    "updated" : "2000-01-23T04:56:07.000+00:00",
    "lastScheduledRunTime" : "2000-01-23T04:56:07.000+00:00"
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0,
  "totalCount" : 2
})
    )
    result = PredictionsApi.batch_prediction_job_definitions_list(offset=0, limit=100, )
    assert isinstance(result, BatchPredictionJobDefinitionsListResponse)


@responses.activate
def test_predictions_api_batch_prediction_job_definitions_patch(unittest_endpoint):
    responses.add(
        responses.PATCH,
        '{endpoint}/api/v2/batchPredictionJobDefinitions/{jobDefinitionId}/'.format(endpoint=unittest_endpoint,
        jobDefinitionId="jobDefinitionId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "updatedBy" : {
    "fullName" : "fullName",
    "userId" : "userId",
    "username" : "username"
  },
  "created" : "2000-01-23T04:56:07.000+00:00",
  "enabled" : False,
  "schedule" : {
    "dayOfWeek" : [ "*", "*" ],
    "hour" : [ "*", "*" ],
    "month" : [ "*", "*" ],
    "dayOfMonth" : [ "*", "*" ],
    "minute" : [ "*", "*" ]
  },
  "lastSuccessfulRunTime" : "2000-01-23T04:56:07.000+00:00",
  "createdBy" : {
    "fullName" : "fullName",
    "userId" : "userId",
    "username" : "username"
  },
  "lastStartedJobTime" : "2000-01-23T04:56:07.000+00:00",
  "name" : "name",
  "lastFailedRunTime" : "2000-01-23T04:56:07.000+00:00",
  "nextScheduledRunTime" : "2000-01-23T04:56:07.000+00:00",
  "batchPredictionJob" : {
    "abortOnError" : True,
    "disableRowLevelErrorHandling" : False,
    "columnNamesRemapping" : "",
    "chunkSize" : "",
    "timeseriesSettings" : "",
    "passthroughColumns" : [ "passthroughColumns", "passthroughColumns", "passthroughColumns", "passthroughColumns", "passthroughColumns" ],
    "includeProbabilitiesClasses" : [ "includeProbabilitiesClasses", "includeProbabilitiesClasses", "includeProbabilitiesClasses", "includeProbabilitiesClasses", "includeProbabilitiesClasses" ],
    "outputSettings" : "",
    "maxExplanations" : 60,
    "numConcurrent" : 5,
    "includeProbabilities" : True,
    "predictionWarningEnabled" : True,
    "intakeSettings" : "",
    "explanationAlgorithm" : "shap",
    "passthroughColumnsSet" : "all",
    "deploymentId" : "deploymentId",
    "includePredictionStatus" : False,
    "thresholdHigh" : 5.962133916683182,
    "skipDriftTracking" : False,
    "thresholdLow" : 5.637376656633329,
    "csvSettings" : {
      "quotechar" : "\"",
      "delimiter" : "",
      "encoding" : "utf-8"
    },
    "pinnedModelId" : "pinnedModelId",
    "predictionInstance" : {
      "hostName" : "hostName",
      "apiKey" : "apiKey",
      "datarobotKey" : "datarobotKey",
      "sslEnabled" : True
    }
  },
  "id" : "id",
  "lastStartedJobStatus" : "INITIALIZING",
  "updated" : "2000-01-23T04:56:07.000+00:00",
  "lastScheduledRunTime" : "2000-01-23T04:56:07.000+00:00"
})
    )
    result = PredictionsApi.batch_prediction_job_definitions_patch(job_definition_id="jobDefinitionId_example", )
    assert isinstance(result, BatchPredictionJobDefinitionsResponse)


@responses.activate
def test_predictions_api_batch_prediction_job_definitions_portable_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/batchPredictionJobDefinitions/{jobDefinitionId}/portable/'.format(endpoint=unittest_endpoint,
        jobDefinitionId="jobDefinitionId_example", ),
        status=200,
        content_type='',
    )
    result = PredictionsApi.batch_prediction_job_definitions_portable_list(job_definition_id="jobDefinitionId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_predictions_api_batch_prediction_job_definitions_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/batchPredictionJobDefinitions/{jobDefinitionId}/'.format(endpoint=unittest_endpoint,
        jobDefinitionId="jobDefinitionId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "updatedBy" : {
    "fullName" : "fullName",
    "userId" : "userId",
    "username" : "username"
  },
  "created" : "2000-01-23T04:56:07.000+00:00",
  "enabled" : False,
  "schedule" : {
    "dayOfWeek" : [ "*", "*" ],
    "hour" : [ "*", "*" ],
    "month" : [ "*", "*" ],
    "dayOfMonth" : [ "*", "*" ],
    "minute" : [ "*", "*" ]
  },
  "lastSuccessfulRunTime" : "2000-01-23T04:56:07.000+00:00",
  "createdBy" : {
    "fullName" : "fullName",
    "userId" : "userId",
    "username" : "username"
  },
  "lastStartedJobTime" : "2000-01-23T04:56:07.000+00:00",
  "name" : "name",
  "lastFailedRunTime" : "2000-01-23T04:56:07.000+00:00",
  "nextScheduledRunTime" : "2000-01-23T04:56:07.000+00:00",
  "batchPredictionJob" : {
    "abortOnError" : True,
    "disableRowLevelErrorHandling" : False,
    "columnNamesRemapping" : "",
    "chunkSize" : "",
    "timeseriesSettings" : "",
    "passthroughColumns" : [ "passthroughColumns", "passthroughColumns", "passthroughColumns", "passthroughColumns", "passthroughColumns" ],
    "includeProbabilitiesClasses" : [ "includeProbabilitiesClasses", "includeProbabilitiesClasses", "includeProbabilitiesClasses", "includeProbabilitiesClasses", "includeProbabilitiesClasses" ],
    "outputSettings" : "",
    "maxExplanations" : 60,
    "numConcurrent" : 5,
    "includeProbabilities" : True,
    "predictionWarningEnabled" : True,
    "intakeSettings" : "",
    "explanationAlgorithm" : "shap",
    "passthroughColumnsSet" : "all",
    "deploymentId" : "deploymentId",
    "includePredictionStatus" : False,
    "thresholdHigh" : 5.962133916683182,
    "skipDriftTracking" : False,
    "thresholdLow" : 5.637376656633329,
    "csvSettings" : {
      "quotechar" : "\"",
      "delimiter" : "",
      "encoding" : "utf-8"
    },
    "pinnedModelId" : "pinnedModelId",
    "predictionInstance" : {
      "hostName" : "hostName",
      "apiKey" : "apiKey",
      "datarobotKey" : "datarobotKey",
      "sslEnabled" : True
    }
  },
  "id" : "id",
  "lastStartedJobStatus" : "INITIALIZING",
  "updated" : "2000-01-23T04:56:07.000+00:00",
  "lastScheduledRunTime" : "2000-01-23T04:56:07.000+00:00"
})
    )
    result = PredictionsApi.batch_prediction_job_definitions_retrieve(job_definition_id="jobDefinitionId_example", )
    assert isinstance(result, BatchPredictionJobDefinitionsResponse)


@responses.activate
def test_predictions_api_batch_predictions_create(unittest_endpoint):
    responses.add(
        responses.POST,
       '{endpoint}/api/v2/batchPredictions/'.format(endpoint=unittest_endpoint),
        status=202,
        content_type='application/json',
        body=json.dumps({
  "hidden" : "2000-01-23T04:56:07.000+00:00",
  "queuePosition" : 0,
  "created" : "2000-01-23T04:56:07.000+00:00",
  "queued" : True,
  "jobOutputSize" : 0,
  "source" : "source",
  "jobSpec" : {
    "abortOnError" : True,
    "disableRowLevelErrorHandling" : False,
    "columnNamesRemapping" : "",
    "chunkSize" : "",
    "timeseriesSettings" : "",
    "passthroughColumns" : [ "passthroughColumns", "passthroughColumns", "passthroughColumns", "passthroughColumns", "passthroughColumns" ],
    "includeProbabilitiesClasses" : [ "includeProbabilitiesClasses", "includeProbabilitiesClasses", "includeProbabilitiesClasses", "includeProbabilitiesClasses", "includeProbabilitiesClasses" ],
    "outputSettings" : "",
    "maxExplanations" : 60,
    "numConcurrent" : 5,
    "includeProbabilities" : True,
    "predictionWarningEnabled" : True,
    "intakeSettings" : "",
    "explanationAlgorithm" : "shap",
    "passthroughColumnsSet" : "all",
    "deploymentId" : "deploymentId",
    "includePredictionStatus" : False,
    "thresholdHigh" : 5.962133916683182,
    "skipDriftTracking" : False,
    "thresholdLow" : 5.637376656633329,
    "csvSettings" : {
      "quotechar" : "\"",
      "delimiter" : "",
      "encoding" : "utf-8"
    },
    "pinnedModelId" : "pinnedModelId",
    "predictionInstance" : {
      "hostName" : "hostName",
      "apiKey" : "apiKey",
      "datarobotKey" : "datarobotKey",
      "sslEnabled" : True
    }
  },
  "percentageCompleted" : 23.02135886934765,
  "resultsDeleted" : True,
  "jobIntakeSize" : 0,
  "scoredRows" : 0,
  "createdBy" : {
    "fullName" : "fullName",
    "userId" : "userId",
    "username" : "username"
  },
  "skippedRows" : 0,
  "elapsedTimeSec" : 0,
  "failedRows" : 0,
  "statusDetails" : "statusDetails",
  "links" : {
    "csvUpload" : "http://example.com/aeiou",
    "download" : "download",
    "self" : "http://example.com/aeiou"
  },
  "id" : "id",
  "batchPredictionJobDefinition" : {
    "name" : "name",
    "id" : "id"
  },
  "logs" : [ "logs", "logs" ],
  "intakeDatasetDisplayName" : "intakeDatasetDisplayName",
  "status" : "INITIALIZING"
})
    )
    result = PredictionsApi.batch_predictions_create()
    assert isinstance(result, BatchPredictionJobResponse)


@responses.activate
def test_predictions_api_batch_predictions_csv_upload_put_many(unittest_endpoint):
    responses.add(
        responses.PUT,
        '{endpoint}/api/v2/batchPredictions/{predictionJobId}/csvUpload/'.format(endpoint=unittest_endpoint,
        predictionJobId="predictionJobId_example", ),
        status=202,
        content_type='',
    )
    result = PredictionsApi.batch_predictions_csv_upload_put_many(prediction_job_id="predictionJobId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_predictions_api_batch_predictions_delete(unittest_endpoint):
    responses.add(
        responses.DELETE,
        '{endpoint}/api/v2/batchPredictions/{predictionJobId}/'.format(endpoint=unittest_endpoint,
        predictionJobId="predictionJobId_example", ),
        status=202,
        content_type='',
    )
    result = PredictionsApi.batch_predictions_delete(prediction_job_id="predictionJobId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_predictions_api_batch_predictions_download_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/batchPredictions/{predictionJobId}/download/'.format(endpoint=unittest_endpoint,
        predictionJobId="predictionJobId_example", ),
        status=200,
        content_type='',
    )
    result = PredictionsApi.batch_predictions_download_list(prediction_job_id="predictionJobId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_predictions_api_batch_predictions_from_existing_create(unittest_endpoint):
    responses.add(
        responses.POST,
       '{endpoint}/api/v2/batchPredictions/fromExisting/'.format(endpoint=unittest_endpoint),
        status=202,
        content_type='application/json',
        body=json.dumps({
  "hidden" : "2000-01-23T04:56:07.000+00:00",
  "queuePosition" : 0,
  "created" : "2000-01-23T04:56:07.000+00:00",
  "queued" : True,
  "jobOutputSize" : 0,
  "source" : "source",
  "jobSpec" : {
    "abortOnError" : True,
    "disableRowLevelErrorHandling" : False,
    "columnNamesRemapping" : "",
    "chunkSize" : "",
    "timeseriesSettings" : "",
    "passthroughColumns" : [ "passthroughColumns", "passthroughColumns", "passthroughColumns", "passthroughColumns", "passthroughColumns" ],
    "includeProbabilitiesClasses" : [ "includeProbabilitiesClasses", "includeProbabilitiesClasses", "includeProbabilitiesClasses", "includeProbabilitiesClasses", "includeProbabilitiesClasses" ],
    "outputSettings" : "",
    "maxExplanations" : 60,
    "numConcurrent" : 5,
    "includeProbabilities" : True,
    "predictionWarningEnabled" : True,
    "intakeSettings" : "",
    "explanationAlgorithm" : "shap",
    "passthroughColumnsSet" : "all",
    "deploymentId" : "deploymentId",
    "includePredictionStatus" : False,
    "thresholdHigh" : 5.962133916683182,
    "skipDriftTracking" : False,
    "thresholdLow" : 5.637376656633329,
    "csvSettings" : {
      "quotechar" : "\"",
      "delimiter" : "",
      "encoding" : "utf-8"
    },
    "pinnedModelId" : "pinnedModelId",
    "predictionInstance" : {
      "hostName" : "hostName",
      "apiKey" : "apiKey",
      "datarobotKey" : "datarobotKey",
      "sslEnabled" : True
    }
  },
  "percentageCompleted" : 23.02135886934765,
  "resultsDeleted" : True,
  "jobIntakeSize" : 0,
  "scoredRows" : 0,
  "createdBy" : {
    "fullName" : "fullName",
    "userId" : "userId",
    "username" : "username"
  },
  "skippedRows" : 0,
  "elapsedTimeSec" : 0,
  "failedRows" : 0,
  "statusDetails" : "statusDetails",
  "links" : {
    "csvUpload" : "http://example.com/aeiou",
    "download" : "download",
    "self" : "http://example.com/aeiou"
  },
  "id" : "id",
  "batchPredictionJobDefinition" : {
    "name" : "name",
    "id" : "id"
  },
  "logs" : [ "logs", "logs" ],
  "intakeDatasetDisplayName" : "intakeDatasetDisplayName",
  "status" : "INITIALIZING"
})
    )
    result = PredictionsApi.batch_predictions_from_existing_create()
    assert isinstance(result, BatchPredictionJobResponse)


@responses.activate
def test_predictions_api_batch_predictions_from_job_definition_create(unittest_endpoint):
    responses.add(
        responses.POST,
       '{endpoint}/api/v2/batchPredictions/fromJobDefinition/'.format(endpoint=unittest_endpoint),
        status=202,
        content_type='application/json',
        body=json.dumps({
  "hidden" : "2000-01-23T04:56:07.000+00:00",
  "queuePosition" : 0,
  "created" : "2000-01-23T04:56:07.000+00:00",
  "queued" : True,
  "jobOutputSize" : 0,
  "source" : "source",
  "jobSpec" : {
    "abortOnError" : True,
    "disableRowLevelErrorHandling" : False,
    "columnNamesRemapping" : "",
    "chunkSize" : "",
    "timeseriesSettings" : "",
    "passthroughColumns" : [ "passthroughColumns", "passthroughColumns", "passthroughColumns", "passthroughColumns", "passthroughColumns" ],
    "includeProbabilitiesClasses" : [ "includeProbabilitiesClasses", "includeProbabilitiesClasses", "includeProbabilitiesClasses", "includeProbabilitiesClasses", "includeProbabilitiesClasses" ],
    "outputSettings" : "",
    "maxExplanations" : 60,
    "numConcurrent" : 5,
    "includeProbabilities" : True,
    "predictionWarningEnabled" : True,
    "intakeSettings" : "",
    "explanationAlgorithm" : "shap",
    "passthroughColumnsSet" : "all",
    "deploymentId" : "deploymentId",
    "includePredictionStatus" : False,
    "thresholdHigh" : 5.962133916683182,
    "skipDriftTracking" : False,
    "thresholdLow" : 5.637376656633329,
    "csvSettings" : {
      "quotechar" : "\"",
      "delimiter" : "",
      "encoding" : "utf-8"
    },
    "pinnedModelId" : "pinnedModelId",
    "predictionInstance" : {
      "hostName" : "hostName",
      "apiKey" : "apiKey",
      "datarobotKey" : "datarobotKey",
      "sslEnabled" : True
    }
  },
  "percentageCompleted" : 23.02135886934765,
  "resultsDeleted" : True,
  "jobIntakeSize" : 0,
  "scoredRows" : 0,
  "createdBy" : {
    "fullName" : "fullName",
    "userId" : "userId",
    "username" : "username"
  },
  "skippedRows" : 0,
  "elapsedTimeSec" : 0,
  "failedRows" : 0,
  "statusDetails" : "statusDetails",
  "links" : {
    "csvUpload" : "http://example.com/aeiou",
    "download" : "download",
    "self" : "http://example.com/aeiou"
  },
  "id" : "id",
  "batchPredictionJobDefinition" : {
    "name" : "name",
    "id" : "id"
  },
  "logs" : [ "logs", "logs" ],
  "intakeDatasetDisplayName" : "intakeDatasetDisplayName",
  "status" : "INITIALIZING"
})
    )
    result = PredictionsApi.batch_predictions_from_job_definition_create()
    assert isinstance(result, BatchPredictionJobResponse)


@responses.activate
def test_predictions_api_batch_predictions_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/batchPredictions/'.format(endpoint=unittest_endpoint,
        offset=0, limit=100, allJobs=False, ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "hidden" : "2000-01-23T04:56:07.000+00:00",
    "queuePosition" : 0,
    "created" : "2000-01-23T04:56:07.000+00:00",
    "queued" : True,
    "jobOutputSize" : 0,
    "source" : "source",
    "jobSpec" : {
      "abortOnError" : True,
      "disableRowLevelErrorHandling" : False,
      "columnNamesRemapping" : "",
      "chunkSize" : "",
      "timeseriesSettings" : "",
      "passthroughColumns" : [ "passthroughColumns", "passthroughColumns", "passthroughColumns", "passthroughColumns", "passthroughColumns" ],
      "includeProbabilitiesClasses" : [ "includeProbabilitiesClasses", "includeProbabilitiesClasses", "includeProbabilitiesClasses", "includeProbabilitiesClasses", "includeProbabilitiesClasses" ],
      "outputSettings" : "",
      "maxExplanations" : 60,
      "numConcurrent" : 5,
      "includeProbabilities" : True,
      "predictionWarningEnabled" : True,
      "intakeSettings" : "",
      "explanationAlgorithm" : "shap",
      "passthroughColumnsSet" : "all",
      "deploymentId" : "deploymentId",
      "includePredictionStatus" : False,
      "thresholdHigh" : 5.962133916683182,
      "skipDriftTracking" : False,
      "thresholdLow" : 5.637376656633329,
      "csvSettings" : {
        "quotechar" : "\"",
        "delimiter" : "",
        "encoding" : "utf-8"
      },
      "pinnedModelId" : "pinnedModelId",
      "predictionInstance" : {
        "hostName" : "hostName",
        "apiKey" : "apiKey",
        "datarobotKey" : "datarobotKey",
        "sslEnabled" : True
      }
    },
    "percentageCompleted" : 23.02135886934765,
    "resultsDeleted" : True,
    "jobIntakeSize" : 0,
    "scoredRows" : 0,
    "createdBy" : {
      "fullName" : "fullName",
      "userId" : "userId",
      "username" : "username"
    },
    "skippedRows" : 0,
    "elapsedTimeSec" : 0,
    "failedRows" : 0,
    "statusDetails" : "statusDetails",
    "links" : {
      "csvUpload" : "http://example.com/aeiou",
      "download" : "download",
      "self" : "http://example.com/aeiou"
    },
    "id" : "id",
    "batchPredictionJobDefinition" : {
      "name" : "name",
      "id" : "id"
    },
    "logs" : [ "logs", "logs" ],
    "intakeDatasetDisplayName" : "intakeDatasetDisplayName",
    "status" : "INITIALIZING"
  }, {
    "hidden" : "2000-01-23T04:56:07.000+00:00",
    "queuePosition" : 0,
    "created" : "2000-01-23T04:56:07.000+00:00",
    "queued" : True,
    "jobOutputSize" : 0,
    "source" : "source",
    "jobSpec" : {
      "abortOnError" : True,
      "disableRowLevelErrorHandling" : False,
      "columnNamesRemapping" : "",
      "chunkSize" : "",
      "timeseriesSettings" : "",
      "passthroughColumns" : [ "passthroughColumns", "passthroughColumns", "passthroughColumns", "passthroughColumns", "passthroughColumns" ],
      "includeProbabilitiesClasses" : [ "includeProbabilitiesClasses", "includeProbabilitiesClasses", "includeProbabilitiesClasses", "includeProbabilitiesClasses", "includeProbabilitiesClasses" ],
      "outputSettings" : "",
      "maxExplanations" : 60,
      "numConcurrent" : 5,
      "includeProbabilities" : True,
      "predictionWarningEnabled" : True,
      "intakeSettings" : "",
      "explanationAlgorithm" : "shap",
      "passthroughColumnsSet" : "all",
      "deploymentId" : "deploymentId",
      "includePredictionStatus" : False,
      "thresholdHigh" : 5.962133916683182,
      "skipDriftTracking" : False,
      "thresholdLow" : 5.637376656633329,
      "csvSettings" : {
        "quotechar" : "\"",
        "delimiter" : "",
        "encoding" : "utf-8"
      },
      "pinnedModelId" : "pinnedModelId",
      "predictionInstance" : {
        "hostName" : "hostName",
        "apiKey" : "apiKey",
        "datarobotKey" : "datarobotKey",
        "sslEnabled" : True
      }
    },
    "percentageCompleted" : 23.02135886934765,
    "resultsDeleted" : True,
    "jobIntakeSize" : 0,
    "scoredRows" : 0,
    "createdBy" : {
      "fullName" : "fullName",
      "userId" : "userId",
      "username" : "username"
    },
    "skippedRows" : 0,
    "elapsedTimeSec" : 0,
    "failedRows" : 0,
    "statusDetails" : "statusDetails",
    "links" : {
      "csvUpload" : "http://example.com/aeiou",
      "download" : "download",
      "self" : "http://example.com/aeiou"
    },
    "id" : "id",
    "batchPredictionJobDefinition" : {
      "name" : "name",
      "id" : "id"
    },
    "logs" : [ "logs", "logs" ],
    "intakeDatasetDisplayName" : "intakeDatasetDisplayName",
    "status" : "INITIALIZING"
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0,
  "totalCount" : 2
})
    )
    result = PredictionsApi.batch_predictions_list(offset=0, limit=100, all_jobs=False, )
    assert isinstance(result, BatchPredictionJobListResponse)


@responses.activate
def test_predictions_api_batch_predictions_patch(unittest_endpoint):
    responses.add(
        responses.PATCH,
        '{endpoint}/api/v2/batchPredictions/{predictionJobId}/'.format(endpoint=unittest_endpoint,
        predictionJobId="predictionJobId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "hidden" : "2000-01-23T04:56:07.000+00:00",
  "queuePosition" : 0,
  "created" : "2000-01-23T04:56:07.000+00:00",
  "queued" : True,
  "jobOutputSize" : 0,
  "source" : "source",
  "jobSpec" : {
    "abortOnError" : True,
    "disableRowLevelErrorHandling" : False,
    "columnNamesRemapping" : "",
    "chunkSize" : "",
    "timeseriesSettings" : "",
    "passthroughColumns" : [ "passthroughColumns", "passthroughColumns", "passthroughColumns", "passthroughColumns", "passthroughColumns" ],
    "includeProbabilitiesClasses" : [ "includeProbabilitiesClasses", "includeProbabilitiesClasses", "includeProbabilitiesClasses", "includeProbabilitiesClasses", "includeProbabilitiesClasses" ],
    "outputSettings" : "",
    "maxExplanations" : 60,
    "numConcurrent" : 5,
    "includeProbabilities" : True,
    "predictionWarningEnabled" : True,
    "intakeSettings" : "",
    "explanationAlgorithm" : "shap",
    "passthroughColumnsSet" : "all",
    "deploymentId" : "deploymentId",
    "includePredictionStatus" : False,
    "thresholdHigh" : 5.962133916683182,
    "skipDriftTracking" : False,
    "thresholdLow" : 5.637376656633329,
    "csvSettings" : {
      "quotechar" : "\"",
      "delimiter" : "",
      "encoding" : "utf-8"
    },
    "pinnedModelId" : "pinnedModelId",
    "predictionInstance" : {
      "hostName" : "hostName",
      "apiKey" : "apiKey",
      "datarobotKey" : "datarobotKey",
      "sslEnabled" : True
    }
  },
  "percentageCompleted" : 23.02135886934765,
  "resultsDeleted" : True,
  "jobIntakeSize" : 0,
  "scoredRows" : 0,
  "createdBy" : {
    "fullName" : "fullName",
    "userId" : "userId",
    "username" : "username"
  },
  "skippedRows" : 0,
  "elapsedTimeSec" : 0,
  "failedRows" : 0,
  "statusDetails" : "statusDetails",
  "links" : {
    "csvUpload" : "http://example.com/aeiou",
    "download" : "download",
    "self" : "http://example.com/aeiou"
  },
  "id" : "id",
  "batchPredictionJobDefinition" : {
    "name" : "name",
    "id" : "id"
  },
  "logs" : [ "logs", "logs" ],
  "intakeDatasetDisplayName" : "intakeDatasetDisplayName",
  "status" : "INITIALIZING"
})
    )
    result = PredictionsApi.batch_predictions_patch(prediction_job_id="predictionJobId_example", )
    assert isinstance(result, BatchPredictionJobResponse)


@responses.activate
def test_predictions_api_batch_predictions_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/batchPredictions/{predictionJobId}/'.format(endpoint=unittest_endpoint,
        predictionJobId="predictionJobId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "hidden" : "2000-01-23T04:56:07.000+00:00",
  "queuePosition" : 0,
  "created" : "2000-01-23T04:56:07.000+00:00",
  "queued" : True,
  "jobOutputSize" : 0,
  "source" : "source",
  "jobSpec" : {
    "abortOnError" : True,
    "disableRowLevelErrorHandling" : False,
    "columnNamesRemapping" : "",
    "chunkSize" : "",
    "timeseriesSettings" : "",
    "passthroughColumns" : [ "passthroughColumns", "passthroughColumns", "passthroughColumns", "passthroughColumns", "passthroughColumns" ],
    "includeProbabilitiesClasses" : [ "includeProbabilitiesClasses", "includeProbabilitiesClasses", "includeProbabilitiesClasses", "includeProbabilitiesClasses", "includeProbabilitiesClasses" ],
    "outputSettings" : "",
    "maxExplanations" : 60,
    "numConcurrent" : 5,
    "includeProbabilities" : True,
    "predictionWarningEnabled" : True,
    "intakeSettings" : "",
    "explanationAlgorithm" : "shap",
    "passthroughColumnsSet" : "all",
    "deploymentId" : "deploymentId",
    "includePredictionStatus" : False,
    "thresholdHigh" : 5.962133916683182,
    "skipDriftTracking" : False,
    "thresholdLow" : 5.637376656633329,
    "csvSettings" : {
      "quotechar" : "\"",
      "delimiter" : "",
      "encoding" : "utf-8"
    },
    "pinnedModelId" : "pinnedModelId",
    "predictionInstance" : {
      "hostName" : "hostName",
      "apiKey" : "apiKey",
      "datarobotKey" : "datarobotKey",
      "sslEnabled" : True
    }
  },
  "percentageCompleted" : 23.02135886934765,
  "resultsDeleted" : True,
  "jobIntakeSize" : 0,
  "scoredRows" : 0,
  "createdBy" : {
    "fullName" : "fullName",
    "userId" : "userId",
    "username" : "username"
  },
  "skippedRows" : 0,
  "elapsedTimeSec" : 0,
  "failedRows" : 0,
  "statusDetails" : "statusDetails",
  "links" : {
    "csvUpload" : "http://example.com/aeiou",
    "download" : "download",
    "self" : "http://example.com/aeiou"
  },
  "id" : "id",
  "batchPredictionJobDefinition" : {
    "name" : "name",
    "id" : "id"
  },
  "logs" : [ "logs", "logs" ],
  "intakeDatasetDisplayName" : "intakeDatasetDisplayName",
  "status" : "INITIALIZING"
})
    )
    result = PredictionsApi.batch_predictions_retrieve(prediction_job_id="predictionJobId_example", )
    assert isinstance(result, BatchPredictionJobResponse)


@responses.activate
def test_predictions_api_imported_models_create(unittest_endpoint):
    responses.add(
        responses.POST,
       '{endpoint}/api/v2/importedModels/'.format(endpoint=unittest_endpoint),
        status=202,
        content_type='application/json',
        body=json.dumps(dict())
    )
    result = PredictionsApi.imported_models_create()
    assert isinstance(result, dict)


@responses.activate
def test_predictions_api_imported_models_delete(unittest_endpoint):
    responses.add(
        responses.DELETE,
        '{endpoint}/api/v2/importedModels/{importId}/'.format(endpoint=unittest_endpoint,
        importId="importId_example", ),
        status=204,
        content_type='application/json',
        body=json.dumps(dict(import_id="importId_example", ))
    )
    result = PredictionsApi.imported_models_delete(import_id="importId_example", )
    assert isinstance(result, dict)


@responses.activate
def test_predictions_api_imported_models_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/importedModels/'.format(endpoint=unittest_endpoint,
        offset=0, limit=100, ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "pythonVersion" : "pythonVersion",
    "note" : "note",
    "featurelistName" : "featurelistName",
    "createdByUsername" : "createdByUsername",
    "importedAt" : "2000-01-23T04:56:07.000+00:00",
    "modelId" : "modelId",
    "displayName" : "displayName",
    "importedByUsername" : "importedByUsername",
    "datasetName" : "datasetName",
    "importedById" : "importedById",
    "version" : "version",
    "isTimeSeries" : True,
    "target" : "target",
    "modelName" : "modelName",
    "originUrl" : "originUrl",
    "id" : "id",
    "projectName" : "projectName",
    "projectId" : "projectId",
    "createdById" : "createdById"
  }, {
    "pythonVersion" : "pythonVersion",
    "note" : "note",
    "featurelistName" : "featurelistName",
    "createdByUsername" : "createdByUsername",
    "importedAt" : "2000-01-23T04:56:07.000+00:00",
    "modelId" : "modelId",
    "displayName" : "displayName",
    "importedByUsername" : "importedByUsername",
    "datasetName" : "datasetName",
    "importedById" : "importedById",
    "version" : "version",
    "isTimeSeries" : True,
    "target" : "target",
    "modelName" : "modelName",
    "originUrl" : "originUrl",
    "id" : "id",
    "projectName" : "projectName",
    "projectId" : "projectId",
    "createdById" : "createdById"
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0
})
    )
    result = PredictionsApi.imported_models_list(offset=0, limit=100, )
    assert isinstance(result, ImportedModelListResponse)


@responses.activate
def test_predictions_api_imported_models_patch(unittest_endpoint):
    responses.add(
        responses.PATCH,
        '{endpoint}/api/v2/importedModels/{importId}/'.format(endpoint=unittest_endpoint,
        importId="importId_example", ),
        status=204,
        content_type='application/json',
        body=json.dumps(dict(import_id="importId_example", ))
    )
    result = PredictionsApi.imported_models_patch(import_id="importId_example", )
    assert isinstance(result, dict)


@responses.activate
def test_predictions_api_imported_models_put(unittest_endpoint):
    responses.add(
        responses.PUT,
        '{endpoint}/api/v2/importedModels/{importId}/'.format(endpoint=unittest_endpoint,
        importId="importId_example", ),
        status=202,
        content_type='application/json',
        body=json.dumps(dict(import_id="importId_example", ))
    )
    result = PredictionsApi.imported_models_put(import_id="importId_example", )
    assert isinstance(result, dict)


@responses.activate
def test_predictions_api_imported_models_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/importedModels/{importId}/'.format(endpoint=unittest_endpoint,
        importId="importId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "pythonVersion" : "pythonVersion",
  "note" : "note",
  "featurelistName" : "featurelistName",
  "createdByUsername" : "createdByUsername",
  "importedAt" : "2000-01-23T04:56:07.000+00:00",
  "modelId" : "modelId",
  "displayName" : "displayName",
  "importedByUsername" : "importedByUsername",
  "datasetName" : "datasetName",
  "importedById" : "importedById",
  "version" : "version",
  "isTimeSeries" : True,
  "target" : "target",
  "modelName" : "modelName",
  "originUrl" : "originUrl",
  "id" : "id",
  "projectName" : "projectName",
  "projectId" : "projectId",
  "createdById" : "createdById"
})
    )
    result = PredictionsApi.imported_models_retrieve(import_id="importId_example", )
    assert isinstance(result, ImportedModelRetrieveResponse)


@responses.activate
def test_predictions_api_prediction_integration_jobs_create(unittest_endpoint):
    responses.add(
        responses.POST,
       '{endpoint}/api/v2/predictionIntegrationJobs/'.format(endpoint=unittest_endpoint),
        status=201,
        content_type='application/json',
        body=json.dumps({
  "schedule" : {
    "dayOfWeek" : [ "*", "*" ],
    "hour" : [ "*", "*" ],
    "month" : [ "*", "*" ],
    "dayOfMonth" : [ "*", "*" ],
    "minute" : ""
  },
  "integrationTypeName" : "sql",
  "deploymentId" : "deploymentId",
  "integrationTypeId" : "sql",
  "updatedByName" : "updatedByName",
  "name" : "name",
  "predictionOptions" : {
    "predictionExplanations" : 5,
    "passthroughColumnsSchemas" : [ {
      "dataType" : 0,
      "precision" : 6,
      "name" : "name",
      "scale" : 1
    }, {
      "dataType" : 0,
      "precision" : 6,
      "name" : "name",
      "scale" : 1
    } ],
    "timeseriesSettings" : {
      "predictionEndDate" : "predictionEndDate",
      "relaxKnownInAdvanceFeaturesCheck" : False,
      "predictionStartDate" : "predictionStartDate",
      "forecastPoint" : "forecastPoint",
      "type" : "forecast"
    },
    "passthroughColumns" : [ "passthroughColumns", "passthroughColumns" ],
    "errorLogColumn" : True,
    "overwrite" : True
  },
  "id" : "id",
  "source" : "",
  "updatedById" : "updatedById",
  "target" : "",
  "updatedAt" : "updatedAt"
})
    )
    result = PredictionsApi.prediction_integration_jobs_create()
    assert isinstance(result, PredictionIntegrationJobResponse)


@responses.activate
def test_predictions_api_prediction_integration_jobs_job_runs_history_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/predictionIntegrationJobs/{predictionIntegrationJobId}/jobRunsHistory/'.format(endpoint=unittest_endpoint,
        predictionIntegrationJobId="predictionIntegrationJobId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "duration" : 6,
    "jobStatus" : "failed",
    "scoredRows" : 5,
    "created" : "2000-01-23T04:56:07.000+00:00",
    "failedRows" : 1,
    "completed" : "2000-01-23T04:56:07.000+00:00",
    "failed" : "2000-01-23T04:56:07.000+00:00",
    "totalRows" : 5,
    "jobRunId" : "jobRunId"
  }, {
    "duration" : 6,
    "jobStatus" : "failed",
    "scoredRows" : 5,
    "created" : "2000-01-23T04:56:07.000+00:00",
    "failedRows" : 1,
    "completed" : "2000-01-23T04:56:07.000+00:00",
    "failed" : "2000-01-23T04:56:07.000+00:00",
    "totalRows" : 5,
    "jobRunId" : "jobRunId"
  }, {
    "duration" : 6,
    "jobStatus" : "failed",
    "scoredRows" : 5,
    "created" : "2000-01-23T04:56:07.000+00:00",
    "failedRows" : 1,
    "completed" : "2000-01-23T04:56:07.000+00:00",
    "failed" : "2000-01-23T04:56:07.000+00:00",
    "totalRows" : 5,
    "jobRunId" : "jobRunId"
  }, {
    "duration" : 6,
    "jobStatus" : "failed",
    "scoredRows" : 5,
    "created" : "2000-01-23T04:56:07.000+00:00",
    "failedRows" : 1,
    "completed" : "2000-01-23T04:56:07.000+00:00",
    "failed" : "2000-01-23T04:56:07.000+00:00",
    "totalRows" : 5,
    "jobRunId" : "jobRunId"
  }, {
    "duration" : 6,
    "jobStatus" : "failed",
    "scoredRows" : 5,
    "created" : "2000-01-23T04:56:07.000+00:00",
    "failedRows" : 1,
    "completed" : "2000-01-23T04:56:07.000+00:00",
    "failed" : "2000-01-23T04:56:07.000+00:00",
    "totalRows" : 5,
    "jobRunId" : "jobRunId"
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0,
  "totalCount" : 2
})
    )
    result = PredictionsApi.prediction_integration_jobs_job_runs_history_list(prediction_integration_job_id="predictionIntegrationJobId_example", )
    assert isinstance(result, PredictionIntegrationJobRunsHistoryResponse)


@responses.activate
def test_predictions_api_prediction_integration_jobs_job_runs_history_logs_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/predictionIntegrationJobs/{predictionIntegrationJobId}/jobRunsHistory/{jobRunId}/logs/'.format(endpoint=unittest_endpoint,
        predictionIntegrationJobId="predictionIntegrationJobId_example", jobRunId="jobRunId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "logs" : [ {
    "time" : "2000-01-23T04:56:07.000+00:00",
    "message" : "message"
  }, {
    "time" : "2000-01-23T04:56:07.000+00:00",
    "message" : "message"
  } ]
})
    )
    result = PredictionsApi.prediction_integration_jobs_job_runs_history_logs_list(prediction_integration_job_id="predictionIntegrationJobId_example", job_run_id="jobRunId_example", )
    assert isinstance(result, PredictionIntegrationJobLogsRetrieveResponse)


@responses.activate
def test_predictions_api_prediction_integration_jobs_job_runs_history_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/predictionIntegrationJobs/{predictionIntegrationJobId}/jobRunsHistory/{jobRunId}/'.format(endpoint=unittest_endpoint,
        predictionIntegrationJobId="predictionIntegrationJobId_example", jobRunId="jobRunId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "duration" : 0,
  "jobStatus" : "failed",
  "scoredRows" : 1,
  "created" : "2000-01-23T04:56:07.000+00:00",
  "failedRows" : 6,
  "completed" : "2000-01-23T04:56:07.000+00:00",
  "failed" : "2000-01-23T04:56:07.000+00:00",
  "totalRows" : 5,
  "jobRunId" : "jobRunId"
})
    )
    result = PredictionsApi.prediction_integration_jobs_job_runs_history_retrieve(prediction_integration_job_id="predictionIntegrationJobId_example", job_run_id="jobRunId_example", )
    assert isinstance(result, PredictionIntegrationJobRunHistoryResponse)


@responses.activate
def test_predictions_api_prediction_integration_jobs_patch(unittest_endpoint):
    responses.add(
        responses.PATCH,
        '{endpoint}/api/v2/predictionIntegrationJobs/{predictionIntegrationJobId}/'.format(endpoint=unittest_endpoint,
        predictionIntegrationJobId="predictionIntegrationJobId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "schedule" : {
    "dayOfWeek" : [ "*", "*" ],
    "hour" : [ "*", "*" ],
    "month" : [ "*", "*" ],
    "dayOfMonth" : [ "*", "*" ],
    "minute" : ""
  },
  "integrationTypeName" : "sql",
  "deploymentId" : "deploymentId",
  "integrationTypeId" : "sql",
  "updatedByName" : "updatedByName",
  "name" : "name",
  "predictionOptions" : {
    "predictionExplanations" : 5,
    "passthroughColumnsSchemas" : [ {
      "dataType" : 0,
      "precision" : 6,
      "name" : "name",
      "scale" : 1
    }, {
      "dataType" : 0,
      "precision" : 6,
      "name" : "name",
      "scale" : 1
    } ],
    "timeseriesSettings" : {
      "predictionEndDate" : "predictionEndDate",
      "relaxKnownInAdvanceFeaturesCheck" : False,
      "predictionStartDate" : "predictionStartDate",
      "forecastPoint" : "forecastPoint",
      "type" : "forecast"
    },
    "passthroughColumns" : [ "passthroughColumns", "passthroughColumns" ],
    "errorLogColumn" : True,
    "overwrite" : True
  },
  "id" : "id",
  "source" : "",
  "updatedById" : "updatedById",
  "target" : "",
  "updatedAt" : "updatedAt"
})
    )
    result = PredictionsApi.prediction_integration_jobs_patch(prediction_integration_job_id="predictionIntegrationJobId_example", )
    assert isinstance(result, PredictionIntegrationJobResponse)


@responses.activate
def test_predictions_api_prediction_integration_jobs_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/predictionIntegrationJobs/{predictionIntegrationJobId}/'.format(endpoint=unittest_endpoint,
        predictionIntegrationJobId="predictionIntegrationJobId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "schedule" : {
    "dayOfWeek" : [ "*", "*" ],
    "hour" : [ "*", "*" ],
    "month" : [ "*", "*" ],
    "dayOfMonth" : [ "*", "*" ],
    "minute" : ""
  },
  "integrationTypeName" : "sql",
  "deploymentId" : "deploymentId",
  "integrationTypeId" : "sql",
  "updatedByName" : "updatedByName",
  "name" : "name",
  "predictionOptions" : {
    "predictionExplanations" : 5,
    "passthroughColumnsSchemas" : [ {
      "dataType" : 0,
      "precision" : 6,
      "name" : "name",
      "scale" : 1
    }, {
      "dataType" : 0,
      "precision" : 6,
      "name" : "name",
      "scale" : 1
    } ],
    "timeseriesSettings" : {
      "predictionEndDate" : "predictionEndDate",
      "relaxKnownInAdvanceFeaturesCheck" : False,
      "predictionStartDate" : "predictionStartDate",
      "forecastPoint" : "forecastPoint",
      "type" : "forecast"
    },
    "passthroughColumns" : [ "passthroughColumns", "passthroughColumns" ],
    "errorLogColumn" : True,
    "overwrite" : True
  },
  "id" : "id",
  "source" : "",
  "updatedById" : "updatedById",
  "target" : "",
  "updatedAt" : "updatedAt"
})
    )
    result = PredictionsApi.prediction_integration_jobs_retrieve(prediction_integration_job_id="predictionIntegrationJobId_example", )
    assert isinstance(result, PredictionIntegrationJobResponse)


@responses.activate
def test_predictions_api_projects_models_prediction_explanations_initialization_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/api/v2/projects/{projectId}/models/{modelId}/predictionExplanationsInitialization/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=202,
        content_type='',
    )
    result = PredictionsApi.projects_models_prediction_explanations_initialization_create(project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_predictions_api_projects_models_prediction_explanations_initialization_delete_many(unittest_endpoint):
    responses.add(
        responses.DELETE,
        '{endpoint}/api/v2/projects/{projectId}/models/{modelId}/predictionExplanationsInitialization/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=204,
        content_type='',
    )
    result = PredictionsApi.projects_models_prediction_explanations_initialization_delete_many(project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_predictions_api_projects_models_prediction_explanations_initialization_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/models/{modelId}/predictionExplanationsInitialization/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=200,
        content_type='',
    )
    result = PredictionsApi.projects_models_prediction_explanations_initialization_list(project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_predictions_api_projects_predict_jobs_delete(unittest_endpoint):
    responses.add(
        responses.DELETE,
        '{endpoint}/api/v2/projects/{projectId}/predictJobs/{jobId}/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", jobId="jobId_example", ),
        status=204,
        content_type='',
    )
    result = PredictionsApi.projects_predict_jobs_delete(project_id="projectId_example", job_id="jobId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_predictions_api_projects_predict_jobs_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/predictJobs/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "modelId" : "modelId",
  "isBlocked" : True,
  "id" : "id",
  "message" : "message",
  "projectId" : "projectId",
  "status" : "queue"
})
    )
    result = PredictionsApi.projects_predict_jobs_list(project_id="projectId_example", )
    assert isinstance(result, PredictJobDetailsResponse)


@responses.activate
def test_predictions_api_projects_predict_jobs_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/predictJobs/{jobId}/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", jobId="jobId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "modelId" : "modelId",
  "isBlocked" : True,
  "id" : "id",
  "message" : "message",
  "projectId" : "projectId",
  "status" : "queue"
})
    )
    result = PredictionsApi.projects_predict_jobs_retrieve(project_id="projectId_example", job_id="jobId_example", )
    assert isinstance(result, PredictJobDetailsResponse)


@responses.activate
def test_predictions_api_projects_prediction_datasets_data_source_uploads_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/api/v2/projects/{projectId}/predictionDatasets/dataSourceUploads/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", ),
        status=202,
        content_type='',
    )
    result = PredictionsApi.projects_prediction_datasets_data_source_uploads_create(project_id="projectId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_predictions_api_projects_prediction_datasets_dataset_uploads_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/api/v2/projects/{projectId}/predictionDatasets/datasetUploads/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", ),
        status=202,
        content_type='application/json',
        body=json.dumps({
  "datasetId" : "datasetId"
})
    )
    result = PredictionsApi.projects_prediction_datasets_dataset_uploads_create(project_id="projectId_example", )
    assert isinstance(result, CreatePredictionDatasetResponse)


@responses.activate
def test_predictions_api_projects_prediction_datasets_delete(unittest_endpoint):
    responses.add(
        responses.DELETE,
        '{endpoint}/api/v2/projects/{projectId}/predictionDatasets/{datasetId}/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", datasetId="datasetId_example", ),
        status=204,
        content_type='',
    )
    result = PredictionsApi.projects_prediction_datasets_delete(project_id="projectId_example", dataset_id="datasetId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_predictions_api_projects_prediction_datasets_file_uploads_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/api/v2/projects/{projectId}/predictionDatasets/fileUploads/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", ),
        status=202,
        content_type='',
    )
    result = PredictionsApi.projects_prediction_datasets_file_uploads_create(project_id="projectId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_predictions_api_projects_prediction_datasets_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/predictionDatasets/'.format(endpoint=unittest_endpoint,
        offset=0, limit=0, projectId="projectId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "next",
  "data" : [ {
    "numRows" : 5,
    "created" : "2000-01-23T04:56:07.000+00:00",
    "predictionsStartDate" : "2000-01-23T04:56:07.000+00:00",
    "dataQualityWarnings" : {
      "insufficientRowsForEvaluatingModels" : True,
      "hasKiaMissingValuesInForecastWindow" : True,
      "singleClassActualValueColumn" : True
    },
    "detectedActualValueColumns" : [ {
      "missingCount" : 6,
      "name" : "name"
    }, {
      "missingCount" : 6,
      "name" : "name"
    } ],
    "maxForecastDate" : "2000-01-23T04:56:07.000+00:00",
    "predictionsEndDate" : "2000-01-23T04:56:07.000+00:00",
    "catalogId" : "catalogId",
    "dataStartDate" : "2000-01-23T04:56:07.000+00:00",
    "actualValueColumn" : "actualValueColumn",
    "catalogVersionId" : "catalogVersionId",
    "name" : "name",
    "forecastPointRange" : [ "2000-01-23T04:56:07.000+00:00", "2000-01-23T04:56:07.000+00:00" ],
    "secondaryDatasetsConfigId" : "secondaryDatasetsConfigId",
    "forecastPoint" : "forecastPoint",
    "id" : "id",
    "dataEndDate" : "2000-01-23T04:56:07.000+00:00",
    "projectId" : "projectId",
    "numColumns" : 1,
    "containsTargetValues" : True
  }, {
    "numRows" : 5,
    "created" : "2000-01-23T04:56:07.000+00:00",
    "predictionsStartDate" : "2000-01-23T04:56:07.000+00:00",
    "dataQualityWarnings" : {
      "insufficientRowsForEvaluatingModels" : True,
      "hasKiaMissingValuesInForecastWindow" : True,
      "singleClassActualValueColumn" : True
    },
    "detectedActualValueColumns" : [ {
      "missingCount" : 6,
      "name" : "name"
    }, {
      "missingCount" : 6,
      "name" : "name"
    } ],
    "maxForecastDate" : "2000-01-23T04:56:07.000+00:00",
    "predictionsEndDate" : "2000-01-23T04:56:07.000+00:00",
    "catalogId" : "catalogId",
    "dataStartDate" : "2000-01-23T04:56:07.000+00:00",
    "actualValueColumn" : "actualValueColumn",
    "catalogVersionId" : "catalogVersionId",
    "name" : "name",
    "forecastPointRange" : [ "2000-01-23T04:56:07.000+00:00", "2000-01-23T04:56:07.000+00:00" ],
    "secondaryDatasetsConfigId" : "secondaryDatasetsConfigId",
    "forecastPoint" : "forecastPoint",
    "id" : "id",
    "dataEndDate" : "2000-01-23T04:56:07.000+00:00",
    "projectId" : "projectId",
    "numColumns" : 1,
    "containsTargetValues" : True
  } ],
  "previous" : "previous",
  "count" : 0
})
    )
    result = PredictionsApi.projects_prediction_datasets_list(offset=0, limit=0, project_id="projectId_example", )
    assert isinstance(result, PredictionDatasetListControllerResponse)


@responses.activate
def test_predictions_api_projects_prediction_datasets_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/predictionDatasets/{datasetId}/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", datasetId="datasetId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "numRows" : 5,
  "created" : "2000-01-23T04:56:07.000+00:00",
  "predictionsStartDate" : "2000-01-23T04:56:07.000+00:00",
  "dataQualityWarnings" : {
    "insufficientRowsForEvaluatingModels" : True,
    "hasKiaMissingValuesInForecastWindow" : True,
    "singleClassActualValueColumn" : True
  },
  "detectedActualValueColumns" : [ {
    "missingCount" : 6,
    "name" : "name"
  }, {
    "missingCount" : 6,
    "name" : "name"
  } ],
  "maxForecastDate" : "2000-01-23T04:56:07.000+00:00",
  "predictionsEndDate" : "2000-01-23T04:56:07.000+00:00",
  "catalogId" : "catalogId",
  "dataStartDate" : "2000-01-23T04:56:07.000+00:00",
  "actualValueColumn" : "actualValueColumn",
  "catalogVersionId" : "catalogVersionId",
  "name" : "name",
  "forecastPointRange" : [ "2000-01-23T04:56:07.000+00:00", "2000-01-23T04:56:07.000+00:00" ],
  "secondaryDatasetsConfigId" : "secondaryDatasetsConfigId",
  "forecastPoint" : "forecastPoint",
  "id" : "id",
  "dataEndDate" : "2000-01-23T04:56:07.000+00:00",
  "projectId" : "projectId",
  "numColumns" : 1,
  "containsTargetValues" : True
})
    )
    result = PredictionsApi.projects_prediction_datasets_retrieve(project_id="projectId_example", dataset_id="datasetId_example", )
    assert isinstance(result, PredictionDatasetRetrieveResponse)


@responses.activate
def test_predictions_api_projects_prediction_datasets_url_uploads_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/api/v2/projects/{projectId}/predictionDatasets/urlUploads/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", ),
        status=202,
        content_type='',
    )
    result = PredictionsApi.projects_prediction_datasets_url_uploads_create(project_id="projectId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_predictions_api_projects_prediction_explanations_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/api/v2/projects/{projectId}/predictionExplanations/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", ),
        status=202,
        content_type='',
    )
    result = PredictionsApi.projects_prediction_explanations_create(project_id="projectId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_predictions_api_projects_prediction_explanations_records_delete(unittest_endpoint):
    responses.add(
        responses.DELETE,
        '{endpoint}/api/v2/projects/{projectId}/predictionExplanationsRecords/{predictionExplanationsId}/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", predictionExplanationsId="predictionExplanationsId_example", ),
        status=204,
        content_type='',
    )
    result = PredictionsApi.projects_prediction_explanations_records_delete(project_id="projectId_example", prediction_explanations_id="predictionExplanationsId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_predictions_api_projects_prediction_explanations_records_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/predictionExplanationsRecords/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "next",
  "data" : [ {
    "predictionThreshold" : 5.637376656633329,
    "maxExplanations" : 1,
    "predictionExplanationsLocation" : "predictionExplanationsLocation",
    "finishTime" : 6.027456183070403,
    "modelId" : "modelId",
    "datasetId" : "datasetId",
    "id" : "id",
    "thresholdHigh" : 2.3021358869347655,
    "thresholdLow" : 7.061401241503109,
    "projectId" : "projectId",
    "numColumns" : 5
  }, {
    "predictionThreshold" : 5.637376656633329,
    "maxExplanations" : 1,
    "predictionExplanationsLocation" : "predictionExplanationsLocation",
    "finishTime" : 6.027456183070403,
    "modelId" : "modelId",
    "datasetId" : "datasetId",
    "id" : "id",
    "thresholdHigh" : 2.3021358869347655,
    "thresholdLow" : 7.061401241503109,
    "projectId" : "projectId",
    "numColumns" : 5
  } ],
  "previous" : "previous",
  "count" : 0
})
    )
    result = PredictionsApi.projects_prediction_explanations_records_list(project_id="projectId_example", )
    assert isinstance(result, PredictionExplanationsRecordList)


@responses.activate
def test_predictions_api_projects_prediction_explanations_records_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/predictionExplanationsRecords/{predictionExplanationsId}/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", predictionExplanationsId="predictionExplanationsId_example", ),
        status=200,
        content_type='',
    )
    result = PredictionsApi.projects_prediction_explanations_records_retrieve(project_id="projectId_example", prediction_explanations_id="predictionExplanationsId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_predictions_api_projects_prediction_explanations_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/predictionExplanations/{predictionExplanationsId}/'.format(endpoint=unittest_endpoint,
        limit=300000, projectId="projectId_example", predictionExplanationsId="predictionExplanationsId_example", ),
        status=200,
        content_type='',
    )
    result = PredictionsApi.projects_prediction_explanations_retrieve(limit=300000, project_id="projectId_example", prediction_explanations_id="predictionExplanationsId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_predictions_api_projects_predictions_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/api/v2/projects/{projectId}/predictions/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", contentType="application/json", ),
        status=202,
        content_type='',
    )
    result = PredictionsApi.projects_predictions_create(project_id="projectId_example", content_type="application/json", )
    assert isinstance(result, type(None))


@responses.activate
def test_predictions_api_projects_predictions_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/predictions/'.format(endpoint=unittest_endpoint,
        offset=0, limit=1000, projectId="projectId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "modelId" : "modelId",
    "predictionsStartDate" : "2000-01-23T04:56:07.000+00:00",
    "predictionIntervalsSize" : 5,
    "url" : "url",
    "predictionDatasetId" : "predictionDatasetId",
    "predictionThreshold" : 5.637376656633329,
    "maxExplanations" : 1,
    "predictionsEndDate" : "2000-01-23T04:56:07.000+00:00",
    "includesPredictionIntervals" : True,
    "actualValueColumn" : "actualValueColumn",
    "explanationAlgorithm" : "explanationAlgorithm",
    "featureDerivationWindowCounts" : 6,
    "datasetId" : "datasetId",
    "forecastPoint" : "2000-01-23T04:56:07.000+00:00",
    "id" : "id",
    "projectId" : "projectId",
    "shapWarnings" : {
      "mismatchRowCount" : 7,
      "maxNormalizedMismatch" : 2.3021358869347655
    }
  }, {
    "modelId" : "modelId",
    "predictionsStartDate" : "2000-01-23T04:56:07.000+00:00",
    "predictionIntervalsSize" : 5,
    "url" : "url",
    "predictionDatasetId" : "predictionDatasetId",
    "predictionThreshold" : 5.637376656633329,
    "maxExplanations" : 1,
    "predictionsEndDate" : "2000-01-23T04:56:07.000+00:00",
    "includesPredictionIntervals" : True,
    "actualValueColumn" : "actualValueColumn",
    "explanationAlgorithm" : "explanationAlgorithm",
    "featureDerivationWindowCounts" : 6,
    "datasetId" : "datasetId",
    "forecastPoint" : "2000-01-23T04:56:07.000+00:00",
    "id" : "id",
    "projectId" : "projectId",
    "shapWarnings" : {
      "mismatchRowCount" : 7,
      "maxNormalizedMismatch" : 2.3021358869347655
    }
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0
})
    )
    result = PredictionsApi.projects_predictions_list(offset=0, limit=1000, project_id="projectId_example", )
    assert isinstance(result, RetrieveListPredictionMetadataObjectsResponse)


@responses.activate
def test_predictions_api_projects_predictions_metadata_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/predictionsMetadata/'.format(endpoint=unittest_endpoint,
        offset=0, limit=1000, projectId="projectId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "modelId" : "modelId",
    "predictionsStartDate" : "2000-01-23T04:56:07.000+00:00",
    "predictionIntervalsSize" : 5,
    "url" : "url",
    "predictionDatasetId" : "predictionDatasetId",
    "predictionThreshold" : 5.637376656633329,
    "maxExplanations" : 1,
    "predictionsEndDate" : "2000-01-23T04:56:07.000+00:00",
    "includesPredictionIntervals" : True,
    "actualValueColumn" : "actualValueColumn",
    "explanationAlgorithm" : "explanationAlgorithm",
    "featureDerivationWindowCounts" : 6,
    "datasetId" : "datasetId",
    "forecastPoint" : "2000-01-23T04:56:07.000+00:00",
    "id" : "id",
    "projectId" : "projectId",
    "shapWarnings" : {
      "mismatchRowCount" : 7,
      "maxNormalizedMismatch" : 2.3021358869347655
    }
  }, {
    "modelId" : "modelId",
    "predictionsStartDate" : "2000-01-23T04:56:07.000+00:00",
    "predictionIntervalsSize" : 5,
    "url" : "url",
    "predictionDatasetId" : "predictionDatasetId",
    "predictionThreshold" : 5.637376656633329,
    "maxExplanations" : 1,
    "predictionsEndDate" : "2000-01-23T04:56:07.000+00:00",
    "includesPredictionIntervals" : True,
    "actualValueColumn" : "actualValueColumn",
    "explanationAlgorithm" : "explanationAlgorithm",
    "featureDerivationWindowCounts" : 6,
    "datasetId" : "datasetId",
    "forecastPoint" : "2000-01-23T04:56:07.000+00:00",
    "id" : "id",
    "projectId" : "projectId",
    "shapWarnings" : {
      "mismatchRowCount" : 7,
      "maxNormalizedMismatch" : 2.3021358869347655
    }
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0
})
    )
    result = PredictionsApi.projects_predictions_metadata_list(offset=0, limit=1000, project_id="projectId_example", )
    assert isinstance(result, RetrieveListPredictionMetadataObjectsResponse)


@responses.activate
def test_predictions_api_projects_predictions_metadata_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/predictionsMetadata/{predictionId}/'.format(endpoint=unittest_endpoint,
        predictionId="predictionId_example", projectId="projectId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "modelId" : "modelId",
  "predictionsStartDate" : "2000-01-23T04:56:07.000+00:00",
  "predictionIntervalsSize" : 5,
  "url" : "url",
  "predictionDatasetId" : "predictionDatasetId",
  "predictionThreshold" : 5.637376656633329,
  "maxExplanations" : 1,
  "predictionsEndDate" : "2000-01-23T04:56:07.000+00:00",
  "includesPredictionIntervals" : True,
  "actualValueColumn" : "actualValueColumn",
  "explanationAlgorithm" : "explanationAlgorithm",
  "featureDerivationWindowCounts" : 6,
  "datasetId" : "datasetId",
  "forecastPoint" : "2000-01-23T04:56:07.000+00:00",
  "id" : "id",
  "projectId" : "projectId",
  "shapWarnings" : {
    "mismatchRowCount" : 7,
    "maxNormalizedMismatch" : 2.3021358869347655
  }
})
    )
    result = PredictionsApi.projects_predictions_metadata_retrieve(prediction_id="predictionId_example", project_id="projectId_example", )
    assert isinstance(result, RetrievePredictionMetadataObject)


@responses.activate
def test_predictions_api_projects_predictions_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/predictions/{predictionId}/'.format(endpoint=unittest_endpoint,
        predictionId="predictionId_example", projectId="projectId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "maxExplanations" : 6,
  "positiveClass" : "",
  "includesPredictionIntervals" : True,
  "task" : "Binary",
  "actualValueColumn" : "actualValueColumn",
  "explanationAlgorithm" : "explanationAlgorithm",
  "featureDerivationWindowCounts" : 0,
  "shapBaseValue" : 1.2315135367772556,
  "predictionIntervalsSize" : 1,
  "predictions" : [ {
    "predictionIntervalUpperBound" : 3.616076749251911,
    "predictionExplanations" : [ {
      "featureValue" : "",
      "feature" : "feature",
      "strength" : 7.061401241503109,
      "label" : ""
    }, {
      "featureValue" : "",
      "feature" : "feature",
      "strength" : 7.061401241503109,
      "label" : ""
    } ],
    "predictionValues" : [ {
      "label" : "",
      "value" : 4.145608029883936
    }, {
      "label" : "",
      "value" : 4.145608029883936
    } ],
    "actualValue" : "actualValue",
    "predictionExplanationMetadata" : [ {
      "shapRemainingTotal" : 2
    }, {
      "shapRemainingTotal" : 2
    } ],
    "forecastDistance" : 5,
    "predictionIntervalLowerBound" : 9.301444243932576,
    "seriesId" : "seriesId",
    "rowId" : 0,
    "target" : "target",
    "predictionThreshold" : 0.20271230230023218,
    "positiveProbability" : 0.5637376656633328,
    "prediction" : "",
    "forecastPoint" : "2000-01-23T04:56:07.000+00:00",
    "originalFormatTimestamp" : "originalFormatTimestamp",
    "timestamp" : "2000-01-23T04:56:07.000+00:00"
  }, {
    "predictionIntervalUpperBound" : 3.616076749251911,
    "predictionExplanations" : [ {
      "featureValue" : "",
      "feature" : "feature",
      "strength" : 7.061401241503109,
      "label" : ""
    }, {
      "featureValue" : "",
      "feature" : "feature",
      "strength" : 7.061401241503109,
      "label" : ""
    } ],
    "predictionValues" : [ {
      "label" : "",
      "value" : 4.145608029883936
    }, {
      "label" : "",
      "value" : 4.145608029883936
    } ],
    "actualValue" : "actualValue",
    "predictionExplanationMetadata" : [ {
      "shapRemainingTotal" : 2
    }, {
      "shapRemainingTotal" : 2
    } ],
    "forecastDistance" : 5,
    "predictionIntervalLowerBound" : 9.301444243932576,
    "seriesId" : "seriesId",
    "rowId" : 0,
    "target" : "target",
    "predictionThreshold" : 0.20271230230023218,
    "positiveProbability" : 0.5637376656633328,
    "prediction" : "",
    "forecastPoint" : "2000-01-23T04:56:07.000+00:00",
    "originalFormatTimestamp" : "originalFormatTimestamp",
    "timestamp" : "2000-01-23T04:56:07.000+00:00"
  } ],
  "shapWarnings" : [ {
    "mismatchRowCount" : 1,
    "maxNormalizedMismatch" : 1.0246457001441578
  }, {
    "mismatchRowCount" : 1,
    "maxNormalizedMismatch" : 1.0246457001441578
  } ]
})
    )
    result = PredictionsApi.projects_predictions_retrieve(prediction_id="predictionId_example", project_id="projectId_example", )
    assert isinstance(result, PredictionRetrieveResponse)


@responses.activate
def test_predictions_api_projects_training_predictions_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/api/v2/projects/{projectId}/trainingPredictions/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", ),
        status=200,
        content_type='',
    )
    result = PredictionsApi.projects_training_predictions_create(project_id="projectId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_predictions_api_projects_training_predictions_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/trainingPredictions/'.format(endpoint=unittest_endpoint,
        offset=0, limit=0, projectId="projectId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "maxExplanations" : 60,
    "modelId" : "modelId",
    "explanationAlgorithm" : "shap",
    "dataSubset" : "validationAndHoldout",
    "id" : "id",
    "url" : "https://openapi-generator.tech",
    "shapWarnings" : [ {
      "partitionName" : "partitionName",
      "value" : {
        "mismatchRowCount" : 5,
        "maxNormalizedMismatch" : 1.4658129805029452
      }
    }, {
      "partitionName" : "partitionName",
      "value" : {
        "mismatchRowCount" : 5,
        "maxNormalizedMismatch" : 1.4658129805029452
      }
    } ]
  }, {
    "maxExplanations" : 60,
    "modelId" : "modelId",
    "explanationAlgorithm" : "shap",
    "dataSubset" : "validationAndHoldout",
    "id" : "id",
    "url" : "https://openapi-generator.tech",
    "shapWarnings" : [ {
      "partitionName" : "partitionName",
      "value" : {
        "mismatchRowCount" : 5,
        "maxNormalizedMismatch" : 1.4658129805029452
      }
    }, {
      "partitionName" : "partitionName",
      "value" : {
        "mismatchRowCount" : 5,
        "maxNormalizedMismatch" : 1.4658129805029452
      }
    } ]
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0
})
    )
    result = PredictionsApi.projects_training_predictions_list(offset=0, limit=0, project_id="projectId_example", )
    assert isinstance(result, TrainingPredictionsListResponse)


@responses.activate
def test_predictions_api_projects_training_predictions_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/trainingPredictions/{predictionId}/'.format(endpoint=unittest_endpoint,
        offset=0, limit=0, projectId="projectId_example", predictionId="predictionId_example", ),
        status=200,
        content_type='application/jsontext/csv',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "shapMetadata" : {
      "warnings" : [ {
        "mismatchRowCount" : 5,
        "maxNormalizedMismatch" : 1.4658129805029452
      }, {
        "mismatchRowCount" : 5,
        "maxNormalizedMismatch" : 1.4658129805029452
      } ],
      "shapBaseValue" : 5.637376656633329,
      "shapRemainingTotal" : 2
    },
    "predictionExplanations" : [ {
      "featureValue" : "",
      "feature" : "feature",
      "strings" : 1.4658129805029452,
      "label" : "label"
    }, {
      "featureValue" : "",
      "feature" : "feature",
      "strings" : 1.4658129805029452,
      "label" : "label"
    } ],
    "partitionId" : "partitionId",
    "predictionValues" : [ {
      "label" : "label",
      "value" : 5.962133916683182
    }, {
      "label" : "label",
      "value" : 5.962133916683182
    } ],
    "prediction" : "",
    "forecastPoint" : "forecastPoint",
    "forecastDistance" : 6,
    "seriesId" : "seriesId",
    "rowId" : "rowId",
    "timestamp" : "timestamp"
  }, {
    "shapMetadata" : {
      "warnings" : [ {
        "mismatchRowCount" : 5,
        "maxNormalizedMismatch" : 1.4658129805029452
      }, {
        "mismatchRowCount" : 5,
        "maxNormalizedMismatch" : 1.4658129805029452
      } ],
      "shapBaseValue" : 5.637376656633329,
      "shapRemainingTotal" : 2
    },
    "predictionExplanations" : [ {
      "featureValue" : "",
      "feature" : "feature",
      "strings" : 1.4658129805029452,
      "label" : "label"
    }, {
      "featureValue" : "",
      "feature" : "feature",
      "strings" : 1.4658129805029452,
      "label" : "label"
    } ],
    "partitionId" : "partitionId",
    "predictionValues" : [ {
      "label" : "label",
      "value" : 5.962133916683182
    }, {
      "label" : "label",
      "value" : 5.962133916683182
    } ],
    "prediction" : "",
    "forecastPoint" : "forecastPoint",
    "forecastDistance" : 6,
    "seriesId" : "seriesId",
    "rowId" : "rowId",
    "timestamp" : "timestamp"
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0
})
    )
    result = PredictionsApi.projects_training_predictions_retrieve(offset=0, limit=0, project_id="projectId_example", prediction_id="predictionId_example", )
    assert isinstance(result, TrainingPredictionsRetrieveResponse)


@responses.activate
def test_predictions_api_scheduled_jobs_delete(unittest_endpoint):
    responses.add(
        responses.DELETE,
        '{endpoint}/api/v2/scheduledJobs/{jobId}/'.format(endpoint=unittest_endpoint,
        jobId="jobId_example", ),
        status=204,
        content_type='',
    )
    result = PredictionsApi.scheduled_jobs_delete(job_id="jobId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_predictions_api_scheduled_jobs_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/scheduledJobs/'.format(endpoint=unittest_endpoint,
        offset=0, limit=20, ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "updatedBy" : "updatedBy",
  "data" : [ {
    "schedule" : {
      "dayOfWeek" : [ "*", "*" ],
      "hour" : [ "*", "*" ],
      "month" : [ "*", "*" ],
      "dayOfMonth" : [ "*", "*" ],
      "minute" : [ "*", "*" ]
    },
    "integrationTypeName" : "sql",
    "scheduledJobId" : "scheduledJobId",
    "createdBy" : "createdBy",
    "deploymentId" : "deploymentId",
    "integrationTypeId" : "integrationTypeId",
    "name" : "name",
    "typeId" : "typeId",
    "id" : "id",
    "enabled" : True,
    "status" : {
      "running" : True,
      "lastFailedRun" : "2000-01-23T04:56:07.000+00:00",
      "nextRunTime" : "2000-01-23T04:56:07.000+00:00",
      "queuePosition" : 0,
      "lastSuccessfulRun" : "2000-01-23T04:56:07.000+00:00"
    },
    "updatedAt" : "2000-01-23T04:56:07.000+00:00"
  }, {
    "schedule" : {
      "dayOfWeek" : [ "*", "*" ],
      "hour" : [ "*", "*" ],
      "month" : [ "*", "*" ],
      "dayOfMonth" : [ "*", "*" ],
      "minute" : [ "*", "*" ]
    },
    "integrationTypeName" : "sql",
    "scheduledJobId" : "scheduledJobId",
    "createdBy" : "createdBy",
    "deploymentId" : "deploymentId",
    "integrationTypeId" : "integrationTypeId",
    "name" : "name",
    "typeId" : "typeId",
    "id" : "id",
    "enabled" : True,
    "status" : {
      "running" : True,
      "lastFailedRun" : "2000-01-23T04:56:07.000+00:00",
      "nextRunTime" : "2000-01-23T04:56:07.000+00:00",
      "queuePosition" : 0,
      "lastSuccessfulRun" : "2000-01-23T04:56:07.000+00:00"
    },
    "updatedAt" : "2000-01-23T04:56:07.000+00:00"
  }, {
    "schedule" : {
      "dayOfWeek" : [ "*", "*" ],
      "hour" : [ "*", "*" ],
      "month" : [ "*", "*" ],
      "dayOfMonth" : [ "*", "*" ],
      "minute" : [ "*", "*" ]
    },
    "integrationTypeName" : "sql",
    "scheduledJobId" : "scheduledJobId",
    "createdBy" : "createdBy",
    "deploymentId" : "deploymentId",
    "integrationTypeId" : "integrationTypeId",
    "name" : "name",
    "typeId" : "typeId",
    "id" : "id",
    "enabled" : True,
    "status" : {
      "running" : True,
      "lastFailedRun" : "2000-01-23T04:56:07.000+00:00",
      "nextRunTime" : "2000-01-23T04:56:07.000+00:00",
      "queuePosition" : 0,
      "lastSuccessfulRun" : "2000-01-23T04:56:07.000+00:00"
    },
    "updatedAt" : "2000-01-23T04:56:07.000+00:00"
  }, {
    "schedule" : {
      "dayOfWeek" : [ "*", "*" ],
      "hour" : [ "*", "*" ],
      "month" : [ "*", "*" ],
      "dayOfMonth" : [ "*", "*" ],
      "minute" : [ "*", "*" ]
    },
    "integrationTypeName" : "sql",
    "scheduledJobId" : "scheduledJobId",
    "createdBy" : "createdBy",
    "deploymentId" : "deploymentId",
    "integrationTypeId" : "integrationTypeId",
    "name" : "name",
    "typeId" : "typeId",
    "id" : "id",
    "enabled" : True,
    "status" : {
      "running" : True,
      "lastFailedRun" : "2000-01-23T04:56:07.000+00:00",
      "nextRunTime" : "2000-01-23T04:56:07.000+00:00",
      "queuePosition" : 0,
      "lastSuccessfulRun" : "2000-01-23T04:56:07.000+00:00"
    },
    "updatedAt" : "2000-01-23T04:56:07.000+00:00"
  }, {
    "schedule" : {
      "dayOfWeek" : [ "*", "*" ],
      "hour" : [ "*", "*" ],
      "month" : [ "*", "*" ],
      "dayOfMonth" : [ "*", "*" ],
      "minute" : [ "*", "*" ]
    },
    "integrationTypeName" : "sql",
    "scheduledJobId" : "scheduledJobId",
    "createdBy" : "createdBy",
    "deploymentId" : "deploymentId",
    "integrationTypeId" : "integrationTypeId",
    "name" : "name",
    "typeId" : "typeId",
    "id" : "id",
    "enabled" : True,
    "status" : {
      "running" : True,
      "lastFailedRun" : "2000-01-23T04:56:07.000+00:00",
      "nextRunTime" : "2000-01-23T04:56:07.000+00:00",
      "queuePosition" : 0,
      "lastSuccessfulRun" : "2000-01-23T04:56:07.000+00:00"
    },
    "updatedAt" : "2000-01-23T04:56:07.000+00:00"
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0,
  "totalCount" : 1,
  "updatedAt" : "2000-01-23T04:56:07.000+00:00"
})
    )
    result = PredictionsApi.scheduled_jobs_list(offset=0, limit=20, )
    assert isinstance(result, ScheduledJobsListResponse)


@responses.activate
def test_predictions_api_scheduled_jobs_patch(unittest_endpoint):
    responses.add(
        responses.PATCH,
        '{endpoint}/api/v2/scheduledJobs/{jobId}/'.format(endpoint=unittest_endpoint,
        jobId="jobId_example", ),
        status=204,
        content_type='',
    )
    result = PredictionsApi.scheduled_jobs_patch(job_id="jobId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_predictions_api_scheduled_jobs_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/scheduledJobs/{jobId}/'.format(endpoint=unittest_endpoint,
        jobId="jobId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "schedule" : {
    "dayOfWeek" : [ "*", "*" ],
    "hour" : [ "*", "*" ],
    "month" : [ "*", "*" ],
    "dayOfMonth" : [ "*", "*" ],
    "minute" : [ "*", "*" ]
  },
  "integrationTypeName" : "sql",
  "scheduledJobId" : "scheduledJobId",
  "createdBy" : "createdBy",
  "deploymentId" : "deploymentId",
  "integrationTypeId" : "integrationTypeId",
  "name" : "name",
  "typeId" : "typeId",
  "id" : "id",
  "enabled" : True,
  "status" : {
    "running" : True,
    "lastFailedRun" : "2000-01-23T04:56:07.000+00:00",
    "nextRunTime" : "2000-01-23T04:56:07.000+00:00",
    "queuePosition" : 0,
    "lastSuccessfulRun" : "2000-01-23T04:56:07.000+00:00"
  },
  "updatedAt" : "2000-01-23T04:56:07.000+00:00"
})
    )
    result = PredictionsApi.scheduled_jobs_retrieve(job_id="jobId_example", )
    assert isinstance(result, ScheduledJobResponse)
