#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import json
import responses
from six.moves.urllib.parse import urljoin
from dateutil import parser
from datarobot.models.full_api.generated.model.resource_usage_response import ResourceUsageResponse
from datarobot.utils import from_api
from datarobot.models.full_api.generated.model import *

from datarobot.models.full_api.generated.api.resource_usage_api import ResourceUsageApi




@responses.activate
def test_resource_usage_api_users_rate_limit_usage_delete(unittest_endpoint):
    responses.add(
        responses.DELETE,
        '{endpoint}/api/v2/users/{userId}/rateLimitUsage/{resourceName}/'.format(endpoint=unittest_endpoint,
        userId="userId_example", resourceName="resourceName_example", ),
        status=204,
        content_type='',
    )
    result = ResourceUsageApi.users_rate_limit_usage_delete(user_id="userId_example", resource_name="resourceName_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_resource_usage_api_users_rate_limit_usage_delete_many(unittest_endpoint):
    responses.add(
        responses.DELETE,
        '{endpoint}/api/v2/users/{userId}/rateLimitUsage/'.format(endpoint=unittest_endpoint,
        userId="userId_example", ),
        status=204,
        content_type='',
    )
    result = ResourceUsageApi.users_rate_limit_usage_delete_many(user_id="userId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_resource_usage_api_users_rate_limit_usage_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/users/{userId}/rateLimitUsage/'.format(endpoint=unittest_endpoint,
        userId="userId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "next",
  "previous" : "previous",
  "usage" : [ {
    "timeToExpire" : 5,
    "resource" : "resource",
    "currentUsage" : 6,
    "maxUsage" : 1
  }, {
    "timeToExpire" : 5,
    "resource" : "resource",
    "currentUsage" : 6,
    "maxUsage" : 1
  } ],
  "count" : 0
})
    )
    result = ResourceUsageApi.users_rate_limit_usage_list(user_id="userId_example", )
    assert isinstance(result, ResourceUsageResponse)
