#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import json
import responses
from six.moves.urllib.parse import urljoin
from dateutil import parser
from datarobot.models.full_api.generated.model.create_sso_configuration import CreateSsoConfiguration
from datarobot.models.full_api.generated.model.list_sso_configuration_response import ListSsoConfigurationResponse
from datarobot.models.full_api.generated.model.sso_configuration_response import SsoConfigurationResponse
from datarobot.models.full_api.generated.model.update_sso_configuration import UpdateSsoConfiguration
from datarobot.utils import from_api
from datarobot.models.full_api.generated.model import *

from datarobot.models.full_api.generated.api.sso_configuration_api import SsoConfigurationApi




@responses.activate
def test_sso_configuration_api_sso_configurations_create(unittest_endpoint):
    responses.add(
        responses.POST,
       '{endpoint}/api/v2/ssoConfigurations/'.format(endpoint=unittest_endpoint),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "autoGenerateUsers" : True,
  "certificate" : {
    "fileName" : "fileName",
    "value" : "value"
  },
  "entityId" : "entityId",
  "securityParameters" : {
    "wantAssertionsSigned" : True,
    "logoutRequestsSigned" : True,
    "authnRequestsSigned" : True,
    "allowUnsolicited" : True,
    "wantResponseSigned" : True
  },
  "issuer" : "issuer",
  "signOnUrl" : "https://openapi-generator.tech",
  "idpMetadataUrl" : "https://openapi-generator.tech",
  "organizationId" : "organizationId",
  "idpMetadata" : {
    "fileName" : "fileName",
    "value" : "value"
  },
  "idpMetadataHttpsVerify" : True,
  "roleMapping" : [ {
    "datarobotRoleId" : "datarobotRoleId",
    "idpRoleId" : "idpRoleId"
  }, {
    "datarobotRoleId" : "datarobotRoleId",
    "idpRoleId" : "idpRoleId"
  } ],
  "attributeMapping" : {
    "firstName" : "firstName",
    "lastName" : "lastName",
    "role" : "role",
    "displayName" : "displayName",
    "email" : "email",
    "impersonationUser" : "impersonationUser",
    "group" : "group",
    "username" : "username"
  },
  "idpResponseMethod" : "POST",
  "enableSso" : True,
  "sessionLengthSeconds" : 0,
  "signOutUrl" : "https://openapi-generator.tech",
  "groupMapping" : [ {
    "idpGroupId" : "idpGroupId",
    "datarobotGroupId" : "datarobotGroupId",
    "datarobotGroupName" : "datarobotGroupName"
  }, {
    "idpGroupId" : "idpGroupId",
    "datarobotGroupId" : "datarobotGroupId",
    "datarobotGroupName" : "datarobotGroupName"
  } ],
  "name" : "name",
  "enforceSso" : True,
  "id" : "id",
  "configurationType" : "MANUAL",
  "spRequestMethod" : "REDIRECT"
})
    )
    result = SsoConfigurationApi.sso_configurations_create()
    assert isinstance(result, SsoConfigurationResponse)


@responses.activate
def test_sso_configuration_api_sso_configurations_list(unittest_endpoint):
    responses.add(
        responses.GET,
       '{endpoint}/api/v2/ssoConfigurations/'.format(endpoint=unittest_endpoint),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "next",
  "data" : [ {
    "autoGenerateUsers" : True,
    "certificate" : {
      "fileName" : "fileName",
      "value" : "value"
    },
    "entityId" : "entityId",
    "securityParameters" : {
      "wantAssertionsSigned" : True,
      "logoutRequestsSigned" : True,
      "authnRequestsSigned" : True,
      "allowUnsolicited" : True,
      "wantResponseSigned" : True
    },
    "issuer" : "issuer",
    "signOnUrl" : "https://openapi-generator.tech",
    "idpMetadataUrl" : "https://openapi-generator.tech",
    "organizationId" : "organizationId",
    "idpMetadata" : {
      "fileName" : "fileName",
      "value" : "value"
    },
    "idpMetadataHttpsVerify" : True,
    "roleMapping" : [ {
      "datarobotRoleId" : "datarobotRoleId",
      "idpRoleId" : "idpRoleId"
    }, {
      "datarobotRoleId" : "datarobotRoleId",
      "idpRoleId" : "idpRoleId"
    } ],
    "attributeMapping" : {
      "firstName" : "firstName",
      "lastName" : "lastName",
      "role" : "role",
      "displayName" : "displayName",
      "email" : "email",
      "impersonationUser" : "impersonationUser",
      "group" : "group",
      "username" : "username"
    },
    "idpResponseMethod" : "POST",
    "enableSso" : True,
    "sessionLengthSeconds" : 0,
    "signOutUrl" : "https://openapi-generator.tech",
    "groupMapping" : [ {
      "idpGroupId" : "idpGroupId",
      "datarobotGroupId" : "datarobotGroupId",
      "datarobotGroupName" : "datarobotGroupName"
    }, {
      "idpGroupId" : "idpGroupId",
      "datarobotGroupId" : "datarobotGroupId",
      "datarobotGroupName" : "datarobotGroupName"
    } ],
    "name" : "name",
    "enforceSso" : True,
    "id" : "id",
    "configurationType" : "MANUAL",
    "spRequestMethod" : "REDIRECT"
  }, {
    "autoGenerateUsers" : True,
    "certificate" : {
      "fileName" : "fileName",
      "value" : "value"
    },
    "entityId" : "entityId",
    "securityParameters" : {
      "wantAssertionsSigned" : True,
      "logoutRequestsSigned" : True,
      "authnRequestsSigned" : True,
      "allowUnsolicited" : True,
      "wantResponseSigned" : True
    },
    "issuer" : "issuer",
    "signOnUrl" : "https://openapi-generator.tech",
    "idpMetadataUrl" : "https://openapi-generator.tech",
    "organizationId" : "organizationId",
    "idpMetadata" : {
      "fileName" : "fileName",
      "value" : "value"
    },
    "idpMetadataHttpsVerify" : True,
    "roleMapping" : [ {
      "datarobotRoleId" : "datarobotRoleId",
      "idpRoleId" : "idpRoleId"
    }, {
      "datarobotRoleId" : "datarobotRoleId",
      "idpRoleId" : "idpRoleId"
    } ],
    "attributeMapping" : {
      "firstName" : "firstName",
      "lastName" : "lastName",
      "role" : "role",
      "displayName" : "displayName",
      "email" : "email",
      "impersonationUser" : "impersonationUser",
      "group" : "group",
      "username" : "username"
    },
    "idpResponseMethod" : "POST",
    "enableSso" : True,
    "sessionLengthSeconds" : 0,
    "signOutUrl" : "https://openapi-generator.tech",
    "groupMapping" : [ {
      "idpGroupId" : "idpGroupId",
      "datarobotGroupId" : "datarobotGroupId",
      "datarobotGroupName" : "datarobotGroupName"
    }, {
      "idpGroupId" : "idpGroupId",
      "datarobotGroupId" : "datarobotGroupId",
      "datarobotGroupName" : "datarobotGroupName"
    } ],
    "name" : "name",
    "enforceSso" : True,
    "id" : "id",
    "configurationType" : "MANUAL",
    "spRequestMethod" : "REDIRECT"
  } ],
  "previous" : "previous",
  "count" : 0,
  "totalCount" : 0
})
    )
    result = SsoConfigurationApi.sso_configurations_list()
    assert isinstance(result, ListSsoConfigurationResponse)


@responses.activate
def test_sso_configuration_api_sso_configurations_patch(unittest_endpoint):
    responses.add(
        responses.PATCH,
        '{endpoint}/api/v2/ssoConfigurations/{configurationId}/'.format(endpoint=unittest_endpoint,
        configurationId="configurationId_example", ),
        status=200,
        content_type='',
    )
    result = SsoConfigurationApi.sso_configurations_patch(configuration_id="configurationId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_sso_configuration_api_sso_configurations_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/ssoConfigurations/{configurationId}/'.format(endpoint=unittest_endpoint,
        configurationId="configurationId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "autoGenerateUsers" : True,
  "certificate" : {
    "fileName" : "fileName",
    "value" : "value"
  },
  "entityId" : "entityId",
  "securityParameters" : {
    "wantAssertionsSigned" : True,
    "logoutRequestsSigned" : True,
    "authnRequestsSigned" : True,
    "allowUnsolicited" : True,
    "wantResponseSigned" : True
  },
  "issuer" : "issuer",
  "signOnUrl" : "https://openapi-generator.tech",
  "idpMetadataUrl" : "https://openapi-generator.tech",
  "organizationId" : "organizationId",
  "idpMetadata" : {
    "fileName" : "fileName",
    "value" : "value"
  },
  "idpMetadataHttpsVerify" : True,
  "roleMapping" : [ {
    "datarobotRoleId" : "datarobotRoleId",
    "idpRoleId" : "idpRoleId"
  }, {
    "datarobotRoleId" : "datarobotRoleId",
    "idpRoleId" : "idpRoleId"
  } ],
  "attributeMapping" : {
    "firstName" : "firstName",
    "lastName" : "lastName",
    "role" : "role",
    "displayName" : "displayName",
    "email" : "email",
    "impersonationUser" : "impersonationUser",
    "group" : "group",
    "username" : "username"
  },
  "idpResponseMethod" : "POST",
  "enableSso" : True,
  "sessionLengthSeconds" : 0,
  "signOutUrl" : "https://openapi-generator.tech",
  "groupMapping" : [ {
    "idpGroupId" : "idpGroupId",
    "datarobotGroupId" : "datarobotGroupId",
    "datarobotGroupName" : "datarobotGroupName"
  }, {
    "idpGroupId" : "idpGroupId",
    "datarobotGroupId" : "datarobotGroupId",
    "datarobotGroupName" : "datarobotGroupName"
  } ],
  "name" : "name",
  "enforceSso" : True,
  "id" : "id",
  "configurationType" : "MANUAL",
  "spRequestMethod" : "REDIRECT"
})
    )
    result = SsoConfigurationApi.sso_configurations_retrieve(configuration_id="configurationId_example", )
    assert isinstance(result, SsoConfigurationResponse)
