#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import json
import responses
from six.moves.urllib.parse import urljoin
from dateutil import parser
from datarobot.models.full_api.generated.model.organization_user import OrganizationUser
from datarobot.models.full_api.generated.model.organization_user_created_response import OrganizationUserCreatedResponse
from datarobot.models.full_api.generated.model.organization_user_list_response import OrganizationUserListResponse
from datarobot.models.full_api.generated.model.organization_user_patch import OrganizationUserPatch
from datarobot.models.full_api.generated.model.organization_user_response import OrganizationUserResponse
from datarobot.models.full_api.generated.model.user_create import UserCreate
from datarobot.models.full_api.generated.model.user_create_response import UserCreateResponse
from datarobot.models.full_api.generated.model.user_limits_patch_body import UserLimitsPatchBody
from datarobot.models.full_api.generated.model.user_limits_response import UserLimitsResponse
from datarobot.utils import from_api
from datarobot.models.full_api.generated.model import *

from datarobot.models.full_api.generated.api.user_management_api import UserManagementApi




@responses.activate
def test_user_management_api_organizations_users_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/api/v2/organizations/{organizationId}/users/'.format(endpoint=unittest_endpoint,
        organizationId="organizationId_example", ),
        status=201,
        content_type='application/json',
        body=json.dumps({
  "userId" : "userId"
})
    )
    result = UserManagementApi.organizations_users_create(organization_id="organizationId_example", )
    assert isinstance(result, OrganizationUserCreatedResponse)


@responses.activate
def test_user_management_api_organizations_users_delete(unittest_endpoint):
    responses.add(
        responses.DELETE,
        '{endpoint}/api/v2/organizations/{organizationId}/users/{userId}/'.format(endpoint=unittest_endpoint,
        organizationId="organizationId_example", userId="userId_example", ),
        status=204,
        content_type='',
    )
    result = UserManagementApi.organizations_users_delete(organization_id="organizationId_example", user_id="userId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_user_management_api_organizations_users_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/organizations/{organizationId}/users/'.format(endpoint=unittest_endpoint,
        offset=0, limit=0, organizationId="organizationId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "organizationId" : "organizationId",
    "firstName" : "firstName",
    "lastName" : "lastName",
    "maxWorkers" : 6,
    "scheduledForDeletion" : True,
    "orgAdmin" : True,
    "id" : "id",
    "accessRoleIds" : [ "accessRoleIds", "accessRoleIds" ],
    "activated" : True,
    "username" : "username"
  }, {
    "organizationId" : "organizationId",
    "firstName" : "firstName",
    "lastName" : "lastName",
    "maxWorkers" : 6,
    "scheduledForDeletion" : True,
    "orgAdmin" : True,
    "id" : "id",
    "accessRoleIds" : [ "accessRoleIds", "accessRoleIds" ],
    "activated" : True,
    "username" : "username"
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0
})
    )
    result = UserManagementApi.organizations_users_list(offset=0, limit=0, organization_id="organizationId_example", )
    assert isinstance(result, OrganizationUserListResponse)


@responses.activate
def test_user_management_api_organizations_users_patch(unittest_endpoint):
    responses.add(
        responses.PATCH,
        '{endpoint}/api/v2/organizations/{organizationId}/users/{userId}/'.format(endpoint=unittest_endpoint,
        organizationId="organizationId_example", userId="userId_example", ),
        status=204,
        content_type='application/json',
        body=json.dumps(dict(organization_id="organizationId_example", user_id="userId_example", ))
    )
    result = UserManagementApi.organizations_users_patch(organization_id="organizationId_example", user_id="userId_example", )
    assert isinstance(result, dict)


@responses.activate
def test_user_management_api_organizations_users_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/organizations/{organizationId}/users/{userId}/'.format(endpoint=unittest_endpoint,
        organizationId="organizationId_example", userId="userId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "organizationId" : "organizationId",
  "firstName" : "firstName",
  "lastName" : "lastName",
  "maxWorkers" : 6,
  "scheduledForDeletion" : True,
  "orgAdmin" : True,
  "id" : "id",
  "accessRoleIds" : [ "accessRoleIds", "accessRoleIds" ],
  "activated" : True,
  "username" : "username"
})
    )
    result = UserManagementApi.organizations_users_retrieve(organization_id="organizationId_example", user_id="userId_example", )
    assert isinstance(result, OrganizationUserResponse)


@responses.activate
def test_user_management_api_users_create(unittest_endpoint):
    responses.add(
        responses.POST,
       '{endpoint}/api/v2/users/'.format(endpoint=unittest_endpoint),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "notifyStatus" : {
    "inviteLink" : "https://openapi-generator.tech",
    "sentStatus" : True
  },
  "userId" : "userId",
  "username" : "username"
})
    )
    result = UserManagementApi.users_create()
    assert isinstance(result, UserCreateResponse)


@responses.activate
def test_user_management_api_users_limits_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/users/{userId}/limits/'.format(endpoint=unittest_endpoint,
        userId="userId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "accountLimits" : {
    "maxUploadSizeCatalog" : 6,
    "maxUploadSize" : 0
  },
  "rateLimits" : [ {
    "usageTracked" : True,
    "resource" : "api",
    "limit" : 1,
    "window" : 5,
    "windowType" : "seconds"
  }, {
    "usageTracked" : True,
    "resource" : "api",
    "limit" : 1,
    "window" : 5,
    "windowType" : "seconds"
  } ]
})
    )
    result = UserManagementApi.users_limits_list(user_id="userId_example", )
    assert isinstance(result, UserLimitsResponse)


@responses.activate
def test_user_management_api_users_limits_patch_many(unittest_endpoint):
    responses.add(
        responses.PATCH,
        '{endpoint}/api/v2/users/{userId}/limits/'.format(endpoint=unittest_endpoint,
        userId="userId_example", ),
        status=200,
        content_type='',
    )
    result = UserManagementApi.users_limits_patch_many(user_id="userId_example", )
    assert isinstance(result, type(None))
