#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import json
import responses
from six.moves.urllib.parse import urljoin
from dateutil import parser
from datarobot.models.full_api.generated.model.users_permadelete import UsersPermadelete
from datarobot.models.full_api.generated.model.users_permadelete_delete_report_params_response import UsersPermadeleteDeleteReportParamsResponse
from datarobot.models.full_api.generated.model.users_permadelete_job_response import UsersPermadeleteJobResponse
from datarobot.models.full_api.generated.model.users_permadelete_job_status_response import UsersPermadeleteJobStatusResponse
from datarobot.models.full_api.generated.model.users_permadelete_preview_job_response import UsersPermadeletePreviewJobResponse
from datarobot.models.full_api.generated.model.users_permadelete_preview_job_status_response import UsersPermadeletePreviewJobStatusResponse
from datarobot.models.full_api.generated.model.users_permadelete_preview_statistics_response import UsersPermadeletePreviewStatisticsResponse
from datarobot.models.full_api.generated.model.users_permadelete_summary_report_statistics_response import UsersPermadeleteSummaryReportStatisticsResponse
from datarobot.utils import from_api
from datarobot.models.full_api.generated.model import *

from datarobot.models.full_api.generated.api.users_permadelete_api import UsersPermadeleteApi




@responses.activate
def test_users_permadelete_api_user_cleanup_jobs_create(unittest_endpoint):
    responses.add(
        responses.POST,
       '{endpoint}/api/v2/userCleanupJobs/'.format(endpoint=unittest_endpoint),
        status=202,
        content_type='application/json',
        body=json.dumps({
  "message" : "message"
})
    )
    result = UsersPermadeleteApi.user_cleanup_jobs_create()
    assert isinstance(result, UsersPermadeleteJobResponse)


@responses.activate
def test_users_permadelete_api_user_cleanup_jobs_delete(unittest_endpoint):
    responses.add(
        responses.DELETE,
        '{endpoint}/api/v2/userCleanupJobs/{statusId}/'.format(endpoint=unittest_endpoint,
        statusId="statusId_example", ),
        status=204,
        content_type='',
    )
    result = UsersPermadeleteApi.user_cleanup_jobs_delete(status_id="statusId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_users_permadelete_api_user_cleanup_jobs_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/userCleanupJobs/{statusId}/'.format(endpoint=unittest_endpoint,
        statusId="statusId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "data" : {
    "reportId" : "reportId",
    "message" : "message",
    "status" : "ABORTED"
  },
  "statusId" : "statusId",
  "created" : "2000-01-23T04:56:07.000+00:00",
  "message" : "message",
  "status" : "COMPLETED"
})
    )
    result = UsersPermadeleteApi.user_cleanup_jobs_retrieve(status_id="statusId_example", )
    assert isinstance(result, UsersPermadeleteJobStatusResponse)


@responses.activate
def test_users_permadelete_api_user_cleanup_preview_jobs_create(unittest_endpoint):
    responses.add(
        responses.POST,
       '{endpoint}/api/v2/userCleanupPreviewJobs/'.format(endpoint=unittest_endpoint),
        status=202,
        content_type='application/json',
        body=json.dumps({
  "message" : "message"
})
    )
    result = UsersPermadeleteApi.user_cleanup_preview_jobs_create()
    assert isinstance(result, UsersPermadeletePreviewJobResponse)


@responses.activate
def test_users_permadelete_api_user_cleanup_preview_jobs_delete(unittest_endpoint):
    responses.add(
        responses.DELETE,
        '{endpoint}/api/v2/userCleanupPreviewJobs/{statusId}/'.format(endpoint=unittest_endpoint,
        statusId="statusId_example", ),
        status=204,
        content_type='',
    )
    result = UsersPermadeleteApi.user_cleanup_preview_jobs_delete(status_id="statusId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_users_permadelete_api_user_cleanup_preview_jobs_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/userCleanupPreviewJobs/{statusId}/'.format(endpoint=unittest_endpoint,
        statusId="statusId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "data" : {
    "reportId" : "reportId",
    "message" : "message",
    "status" : "ABORTED"
  },
  "statusId" : "statusId",
  "created" : "2000-01-23T04:56:07.000+00:00",
  "message" : "message",
  "status" : "COMPLETED"
})
    )
    result = UsersPermadeleteApi.user_cleanup_preview_jobs_retrieve(status_id="statusId_example", )
    assert isinstance(result, UsersPermadeletePreviewJobStatusResponse)


@responses.activate
def test_users_permadelete_api_user_cleanup_previews_content_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/userCleanupPreviews/{reportId}/content/'.format(endpoint=unittest_endpoint,
        reportId="reportId_example", ),
        status=200,
        content_type='',
    )
    result = UsersPermadeleteApi.user_cleanup_previews_content_list(report_id="reportId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_users_permadelete_api_user_cleanup_previews_delete(unittest_endpoint):
    responses.add(
        responses.DELETE,
        '{endpoint}/api/v2/userCleanupPreviews/{reportId}/'.format(endpoint=unittest_endpoint,
        reportId="reportId_example", ),
        status=202,
        content_type='',
    )
    result = UsersPermadeleteApi.user_cleanup_previews_delete(report_id="reportId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_users_permadelete_api_user_cleanup_previews_delete_params_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/userCleanupPreviews/{reportId}/deleteParams/'.format(endpoint=unittest_endpoint,
        reportId="reportId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "data" : {
    "forceProjectDelete" : False,
    "orphansOwner" : "null",
    "forceDeploymentDelete" : False,
    "orphansOwnerName" : "orphansOwnerName",
    "userIds" : [ "userIds", "userIds", "userIds", "userIds", "userIds" ],
    "orgId" : "null"
  },
  "message" : "message"
})
    )
    result = UsersPermadeleteApi.user_cleanup_previews_delete_params_list(report_id="reportId_example", )
    assert isinstance(result, UsersPermadeleteDeleteReportParamsResponse)


@responses.activate
def test_users_permadelete_api_user_cleanup_previews_statistics_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/userCleanupPreviews/{reportId}/statistics/'.format(endpoint=unittest_endpoint,
        reportId="reportId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "data" : {
    "deploymentsWillBeAssignedNewOwner" : 0,
    "projectsWillBeAssignedNewOwner" : 5,
    "projectsWillBeDeleted" : 2,
    "deploymentsWillBeDeleted" : 6,
    "deploymentsWillNotBeDeleted" : 1,
    "projectsWillNotBeDeleted" : 7,
    "usersWillBeDeleted" : 9,
    "usersWillNotBeDeleted" : 3,
    "errors" : 5
  },
  "message" : "message"
})
    )
    result = UsersPermadeleteApi.user_cleanup_previews_statistics_list(report_id="reportId_example", )
    assert isinstance(result, UsersPermadeletePreviewStatisticsResponse)


@responses.activate
def test_users_permadelete_api_user_cleanup_summaries_content_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/userCleanupSummaries/{reportId}/content/'.format(endpoint=unittest_endpoint,
        reportId="reportId_example", ),
        status=200,
        content_type='',
    )
    result = UsersPermadeleteApi.user_cleanup_summaries_content_list(report_id="reportId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_users_permadelete_api_user_cleanup_summaries_delete(unittest_endpoint):
    responses.add(
        responses.DELETE,
        '{endpoint}/api/v2/userCleanupSummaries/{reportId}/'.format(endpoint=unittest_endpoint,
        reportId="reportId_example", ),
        status=202,
        content_type='',
    )
    result = UsersPermadeleteApi.user_cleanup_summaries_delete(report_id="reportId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_users_permadelete_api_user_cleanup_summaries_delete_params_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/userCleanupSummaries/{reportId}/deleteParams/'.format(endpoint=unittest_endpoint,
        reportId="reportId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "data" : {
    "forceProjectDelete" : False,
    "orphansOwner" : "null",
    "forceDeploymentDelete" : False,
    "orphansOwnerName" : "orphansOwnerName",
    "userIds" : [ "userIds", "userIds", "userIds", "userIds", "userIds" ],
    "orgId" : "null"
  },
  "message" : "message"
})
    )
    result = UsersPermadeleteApi.user_cleanup_summaries_delete_params_list(report_id="reportId_example", )
    assert isinstance(result, UsersPermadeleteDeleteReportParamsResponse)


@responses.activate
def test_users_permadelete_api_user_cleanup_summaries_statistics_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/userCleanupSummaries/{reportId}/statistics/'.format(endpoint=unittest_endpoint,
        reportId="reportId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "data" : {
    "deploymentsNotDeleted" : 1,
    "projectsDeleted" : 2,
    "usersNotDeleted" : 3,
    "projectsAssignedNewOwner" : 5,
    "usersDeleted" : 9,
    "deploymentsAssignedNewOwner" : 0,
    "errors" : 5,
    "deploymentsDeleted" : 6,
    "projectsNotDeleted" : 7
  },
  "message" : "message"
})
    )
    result = UsersPermadeleteApi.user_cleanup_summaries_statistics_list(report_id="reportId_example", )
    assert isinstance(result, UsersPermadeleteSummaryReportStatisticsResponse)
