#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import json
import responses
from six.moves.urllib.parse import urljoin
from dateutil import parser
from datarobot.models.testing.generated.model.add_deployment_to_application import AddDeploymentToApplication
from datarobot.models.testing.generated.model.application_access_control_list import ApplicationAccessControlList
from datarobot.models.testing.generated.model.application_access_control_update_request import ApplicationAccessControlUpdateRequest
from datarobot.models.testing.generated.model.application_create import ApplicationCreate
from datarobot.models.testing.generated.model.application_create_response import ApplicationCreateResponse
from datarobot.models.testing.generated.model.application_deployment_state_update import ApplicationDeploymentStateUpdate
from datarobot.models.testing.generated.model.application_deployment_update import ApplicationDeploymentUpdate
from datarobot.models.testing.generated.model.application_list import ApplicationList
from datarobot.models.testing.generated.model.application_model_deployment_param import ApplicationModelDeploymentParam
from datarobot.models.testing.generated.model.application_param import ApplicationParam
from datarobot.models.testing.generated.model.application_retrieve import ApplicationRetrieve
from datarobot.models.testing.generated.model.application_shared_roles_entry_update import ApplicationSharedRolesEntryUpdate
from datarobot.models.testing.generated.model.application_shared_roles_list import ApplicationSharedRolesList
from datarobot.models.testing.generated.model.application_sharing_update_or_remove import ApplicationSharingUpdateOrRemove
from datarobot.models.testing.generated.model.application_type_list_response import ApplicationTypeListResponse
from datarobot.models.testing.generated.model.application_type_retrieve_response import ApplicationTypeRetrieveResponse
from datarobot.models.testing.generated.model.application_type_usecases_list_response import ApplicationTypeUsecasesListResponse
from datarobot.models.testing.generated.model.application_upgrade_deployment_version import ApplicationUpgradeDeploymentVersion
from datarobot.models.testing.generated.model.application_user_role_response import ApplicationUserRoleResponse
from datarobot.utils import from_api
from datarobot.models.testing.generated.model import *

from datarobot.models.testing.generated.api.applications_api import ApplicationsApi




@responses.activate
def test_applications_api_application_types_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/applicationTypes/'.format(endpoint=unittest_endpoint,
        offset=0, limit=0, ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "demoDatasetLink" : "https://openapi-generator.tech",
    "logoImage" : "logoImage",
    "configuration" : {
      "deployments" : [ {
        "internalName" : "internalName",
        "name" : "name",
        "description" : "description",
        "targetTypes" : [ "targetTypes", "targetTypes" ]
      }, {
        "internalName" : "internalName",
        "name" : "name",
        "description" : "description",
        "targetTypes" : [ "targetTypes", "targetTypes" ]
      } ]
    },
    "isLaunchable" : True,
    "maturity" : "maturity",
    "demoAvailable" : True,
    "name" : "name",
    "description" : "description",
    "id" : "id",
    "version" : "version"
  }, {
    "demoDatasetLink" : "https://openapi-generator.tech",
    "logoImage" : "logoImage",
    "configuration" : {
      "deployments" : [ {
        "internalName" : "internalName",
        "name" : "name",
        "description" : "description",
        "targetTypes" : [ "targetTypes", "targetTypes" ]
      }, {
        "internalName" : "internalName",
        "name" : "name",
        "description" : "description",
        "targetTypes" : [ "targetTypes", "targetTypes" ]
      } ]
    },
    "isLaunchable" : True,
    "maturity" : "maturity",
    "demoAvailable" : True,
    "name" : "name",
    "description" : "description",
    "id" : "id",
    "version" : "version"
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0
})
    )
    result = ApplicationsApi.application_types_list(offset=0, limit=0, )
    assert isinstance(result, ApplicationTypeListResponse)


@responses.activate
def test_applications_api_application_types_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/applicationTypes/{applicationTypeId}/'.format(endpoint=unittest_endpoint,
        applicationTypeId="applicationTypeId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "demoDatasetLink" : "https://openapi-generator.tech",
  "logoImage" : "logoImage",
  "configuration" : {
    "deployments" : [ {
      "internalName" : "internalName",
      "name" : "name",
      "description" : "description",
      "targetTypes" : [ "targetTypes", "targetTypes" ]
    }, {
      "internalName" : "internalName",
      "name" : "name",
      "description" : "description",
      "targetTypes" : [ "targetTypes", "targetTypes" ]
    } ]
  },
  "isLaunchable" : True,
  "maturity" : "maturity",
  "demoAvailable" : True,
  "name" : "name",
  "description" : "description",
  "id" : "id",
  "version" : "version"
})
    )
    result = ApplicationsApi.application_types_retrieve(application_type_id="applicationTypeId_example", )
    assert isinstance(result, ApplicationTypeRetrieveResponse)


@responses.activate
def test_applications_api_application_types_usecases_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/applicationTypes/{applicationTypeId}/usecases/'.format(endpoint=unittest_endpoint,
        offset=0, limit=100, applicationTypeId="applicationTypeId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "sources" : [ {
      "dataset" : {
        "name" : "name",
        "url" : "https://openapi-generator.tech",
        "target" : "target"
      }
    }, {
      "dataset" : {
        "name" : "name",
        "url" : "https://openapi-generator.tech",
        "target" : "target"
      }
    } ],
    "applicationTypeId" : "applicationTypeId",
    "demoAvailable" : True,
    "description" : "description",
    "id" : "id",
    "title" : "title"
  }, {
    "sources" : [ {
      "dataset" : {
        "name" : "name",
        "url" : "https://openapi-generator.tech",
        "target" : "target"
      }
    }, {
      "dataset" : {
        "name" : "name",
        "url" : "https://openapi-generator.tech",
        "target" : "target"
      }
    } ],
    "applicationTypeId" : "applicationTypeId",
    "demoAvailable" : True,
    "description" : "description",
    "id" : "id",
    "title" : "title"
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0
})
    )
    result = ApplicationsApi.application_types_usecases_list(offset=0, limit=100, application_type_id="applicationTypeId_example", )
    assert isinstance(result, ApplicationTypeUsecasesListResponse)


@responses.activate
def test_applications_api_applications_access_control_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/applications/{applicationId}/accessControl/'.format(endpoint=unittest_endpoint,
        offset=0, limit=0, applicationId="applicationId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "role" : "role",
    "canShare" : True,
    "userId" : "userId",
    "username" : "username"
  }, {
    "role" : "role",
    "canShare" : True,
    "userId" : "userId",
    "username" : "username"
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0
})
    )
    result = ApplicationsApi.applications_access_control_list(offset=0, limit=0, application_id="applicationId_example", )
    assert isinstance(result, ApplicationAccessControlList)


@responses.activate
def test_applications_api_applications_access_control_patch_many(unittest_endpoint):
    responses.add(
        responses.PATCH,
        '{endpoint}/api/v2/applications/{applicationId}/accessControl/'.format(endpoint=unittest_endpoint,
        applicationId="applicationId_example", ),
        status=200,
        content_type='',
    )
    result = ApplicationsApi.applications_access_control_patch_many(application_id="applicationId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_applications_api_applications_auth_token_patch_many(unittest_endpoint):
    responses.add(
        responses.PATCH,
        '{endpoint}/api/v2/applications/{applicationId}/authToken/'.format(endpoint=unittest_endpoint,
        applicationId="applicationId_example", ),
        status=200,
        content_type='',
    )
    result = ApplicationsApi.applications_auth_token_patch_many(application_id="applicationId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_applications_api_applications_build_jobs_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/api/v2/applications/{applicationId}/buildJobs/'.format(endpoint=unittest_endpoint,
        applicationId="applicationId_example", ),
        status=200,
        content_type='',
    )
    result = ApplicationsApi.applications_build_jobs_create(application_id="applicationId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_applications_api_applications_create(unittest_endpoint):
    responses.add(
        responses.POST,
       '{endpoint}/api/v2/applications/'.format(endpoint=unittest_endpoint),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "recentEvents" : [ "recentEvents", "recentEvents" ],
  "deploymentStatusId" : "deploymentStatusId",
  "userId" : "userId",
  "createdAt" : "createdAt",
  "createdBy" : "createdBy",
  "applicationTypeId" : "applicationTypeId",
  "permissions" : "CAN_UPDATE",
  "name" : "name",
  "deactivationStatusId" : "deactivationStatusId",
  "id" : "id",
  "modelDeploymentId" : "modelDeploymentId",
  "deploymentIds" : [ "deploymentIds", "deploymentIds" ],
  "updatedAt" : "updatedAt"
})
    )
    result = ApplicationsApi.applications_create()
    assert isinstance(result, ApplicationCreateResponse)


@responses.activate
def test_applications_api_applications_delete(unittest_endpoint):
    responses.add(
        responses.DELETE,
        '{endpoint}/api/v2/applications/{applicationId}/'.format(endpoint=unittest_endpoint,
        applicationId="applicationId_example", ),
        status=200,
        content_type='',
    )
    result = ApplicationsApi.applications_delete(application_id="applicationId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_applications_api_applications_deployment_state_patch_many(unittest_endpoint):
    responses.add(
        responses.PATCH,
        '{endpoint}/api/v2/applications/{applicationId}/deploymentState/'.format(endpoint=unittest_endpoint,
        applicationId="applicationId_example", ),
        status=200,
        content_type='',
    )
    result = ApplicationsApi.applications_deployment_state_patch_many(application_id="applicationId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_applications_api_applications_deployments_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/api/v2/applications/{applicationId}/deployments/'.format(endpoint=unittest_endpoint,
        applicationId="applicationId_example", ),
        status=200,
        content_type='',
    )
    result = ApplicationsApi.applications_deployments_create(application_id="applicationId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_applications_api_applications_deployments_delete(unittest_endpoint):
    responses.add(
        responses.DELETE,
        '{endpoint}/api/v2/applications/{applicationId}/deployments/{modelDeploymentId}/'.format(endpoint=unittest_endpoint,
        applicationId="applicationId_example", modelDeploymentId="modelDeploymentId_example", ),
        status=200,
        content_type='',
    )
    result = ApplicationsApi.applications_deployments_delete(application_id="applicationId_example", model_deployment_id="modelDeploymentId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_applications_api_applications_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/applications/'.format(endpoint=unittest_endpoint,
        offset=0, limit=0, ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "description" : "description",
    "datasets" : [ "datasets", "datasets" ],
    "deploymentStatusId" : "deploymentStatusId",
    "applicationTemplateType" : "applicationTemplateType",
    "createdAt" : "createdAt",
    "applicationTypeId" : "applicationTypeId",
    "permissions" : [ "CAN_DELETE", "CAN_DELETE" ],
    "cloudProvider" : "cloudProvider",
    "deploymentName" : "deploymentName",
    "id" : "id",
    "updatedAt" : "updatedAt",
    "creatorLastName" : "creatorLastName",
    "poolUsed" : True,
    "recentEvents" : [ "recentEvents", "recentEvents" ],
    "userId" : "userId",
    "url" : "https://openapi-generator.tech",
    "deploymentState" : "deploymentState",
    "creatorFirstName" : "creatorFirstName",
    "deployments" : [ {
      "deploymentId" : "deploymentId",
      "referenceName" : "referenceName"
    }, {
      "deploymentId" : "deploymentId",
      "referenceName" : "referenceName"
    } ],
    "createdBy" : "createdBy",
    "creatorUserhash" : "creatorUserhash",
    "name" : "name",
    "deactivationStatusId" : "deactivationStatusId",
    "modelDeploymentId" : "modelDeploymentId",
    "deploymentIds" : [ "deploymentIds", "deploymentIds" ]
  }, {
    "description" : "description",
    "datasets" : [ "datasets", "datasets" ],
    "deploymentStatusId" : "deploymentStatusId",
    "applicationTemplateType" : "applicationTemplateType",
    "createdAt" : "createdAt",
    "applicationTypeId" : "applicationTypeId",
    "permissions" : [ "CAN_DELETE", "CAN_DELETE" ],
    "cloudProvider" : "cloudProvider",
    "deploymentName" : "deploymentName",
    "id" : "id",
    "updatedAt" : "updatedAt",
    "creatorLastName" : "creatorLastName",
    "poolUsed" : True,
    "recentEvents" : [ "recentEvents", "recentEvents" ],
    "userId" : "userId",
    "url" : "https://openapi-generator.tech",
    "deploymentState" : "deploymentState",
    "creatorFirstName" : "creatorFirstName",
    "deployments" : [ {
      "deploymentId" : "deploymentId",
      "referenceName" : "referenceName"
    }, {
      "deploymentId" : "deploymentId",
      "referenceName" : "referenceName"
    } ],
    "createdBy" : "createdBy",
    "creatorUserhash" : "creatorUserhash",
    "name" : "name",
    "deactivationStatusId" : "deactivationStatusId",
    "modelDeploymentId" : "modelDeploymentId",
    "deploymentIds" : [ "deploymentIds", "deploymentIds" ]
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0
})
    )
    result = ApplicationsApi.applications_list(offset=0, limit=0, )
    assert isinstance(result, ApplicationList)


@responses.activate
def test_applications_api_applications_patch(unittest_endpoint):
    responses.add(
        responses.PATCH,
        '{endpoint}/api/v2/applications/{applicationId}/'.format(endpoint=unittest_endpoint,
        applicationId="applicationId_example", ),
        status=200,
        content_type='',
    )
    result = ApplicationsApi.applications_patch(application_id="applicationId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_applications_api_applications_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/applications/{applicationId}/'.format(endpoint=unittest_endpoint,
        applicationId="applicationId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "description" : "description",
  "datasets" : [ "datasets", "datasets" ],
  "deploymentStatusId" : "deploymentStatusId",
  "applicationTemplateType" : "applicationTemplateType",
  "createdAt" : "createdAt",
  "applicationTypeId" : "applicationTypeId",
  "permissions" : [ "CAN_DELETE", "CAN_DELETE" ],
  "cloudProvider" : "cloudProvider",
  "deploymentName" : "deploymentName",
  "id" : "id",
  "updatedAt" : "updatedAt",
  "creatorLastName" : "creatorLastName",
  "poolUsed" : True,
  "recentEvents" : [ {
    "metadata" : {
      "success" : True,
      "url" : "https://openapi-generator.tech"
    },
    "eventType" : "eventType",
    "timestamp" : "2000-01-23T04:56:07.000+00:00"
  }, {
    "metadata" : {
      "success" : True,
      "url" : "https://openapi-generator.tech"
    },
    "eventType" : "eventType",
    "timestamp" : "2000-01-23T04:56:07.000+00:00"
  } ],
  "userId" : "userId",
  "url" : "https://openapi-generator.tech",
  "deploymentState" : "deploymentState",
  "creatorFirstName" : "creatorFirstName",
  "deployments" : [ {
    "deploymentId" : "deploymentId",
    "referenceName" : "referenceName"
  }, {
    "deploymentId" : "deploymentId",
    "referenceName" : "referenceName"
  } ],
  "createdBy" : "createdBy",
  "creatorUserhash" : "creatorUserhash",
  "name" : "name",
  "deactivationStatusId" : "deactivationStatusId",
  "modelDeploymentId" : "modelDeploymentId",
  "deploymentIds" : [ "deploymentIds", "deploymentIds" ]
})
    )
    result = ApplicationsApi.applications_retrieve(application_id="applicationId_example", )
    assert isinstance(result, ApplicationRetrieve)


@responses.activate
def test_applications_api_applications_shared_roles_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/applications/{applicationId}/sharedRoles/'.format(endpoint=unittest_endpoint,
        applicationId="applicationId_example", ),
        status=200,
        content_type='',
    )
    result = ApplicationsApi.applications_shared_roles_list(application_id="applicationId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_applications_api_applications_shared_roles_patch_many(unittest_endpoint):
    responses.add(
        responses.PATCH,
        '{endpoint}/api/v2/applications/{applicationId}/sharedRoles/'.format(endpoint=unittest_endpoint,
        sendNotification=False, note="note_example", operation="operation_example", roles=[
        ApplicationSharedRolesEntryUpdate(
            id="id_example",
            role="OWNER",
            share_recipient_type="user",
        ),
    ], applicationId="applicationId_example", ),
        status=200,
        content_type='',
    )
    result = ApplicationsApi.applications_shared_roles_patch_many(send_notification=False, note="note_example", operation="operation_example", roles=[
        ApplicationSharedRolesEntryUpdate(
            id="id_example",
            role="OWNER",
            share_recipient_type="user",
        ),
    ], application_id="applicationId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_applications_api_applications_user_role_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/applications/{applicationId}/userRole/'.format(endpoint=unittest_endpoint,
        applicationId="applicationId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "role" : "role"
})
    )
    result = ApplicationsApi.applications_user_role_list(application_id="applicationId_example", )
    assert isinstance(result, ApplicationUserRoleResponse)


@responses.activate
def test_applications_api_applications_version_patch_many(unittest_endpoint):
    responses.add(
        responses.PATCH,
        '{endpoint}/api/v2/applications/{applicationId}/version/'.format(endpoint=unittest_endpoint,
        applicationId="applicationId_example", ),
        status=200,
        content_type='',
    )
    result = ApplicationsApi.applications_version_patch_many(application_id="applicationId_example", )
    assert isinstance(result, type(None))
