#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import json
import responses
from six.moves.urllib.parse import urljoin
from dateutil import parser
from datarobot.models.testing.generated.model.bias_vs_accuracy_insight_retrieve import BiasVsAccuracyInsightRetrieve
from datarobot.models.testing.generated.model.cross_class_accuracy_create_response import CrossClassAccuracyCreateResponse
from datarobot.models.testing.generated.model.cross_class_accuracy_list import CrossClassAccuracyList
from datarobot.models.testing.generated.model.data_disparity_create_payload import DataDisparityCreatePayload
from datarobot.models.testing.generated.model.data_disparity_create_response import DataDisparityCreateResponse
from datarobot.models.testing.generated.model.data_disparity_retrieve_response import DataDisparityRetrieveResponse
from datarobot.models.testing.generated.model.fairness_insights_list_response import FairnessInsightsListResponse
from datarobot.models.testing.generated.model.fairness_insights_start_calculation_payload import FairnessInsightsStartCalculationPayload
from datarobot.models.testing.generated.model.fairness_insights_start_calculation_response import FairnessInsightsStartCalculationResponse
from datarobot.utils import from_api
from datarobot.models.testing.generated.model import *

from datarobot.models.testing.generated.api.bias_and_fairness_api import BiasAndFairnessApi




@responses.activate
def test_bias_and_fairness_api_projects_bias_vs_accuracy_insights_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/biasVsAccuracyInsights/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "data" : [ {
    "models" : [ {
      "prime" : True,
      "samplepct" : 23.02135886934765,
      "fairnessValue" : 0.5962133916683182,
      "dsName" : "dsName",
      "modelId" : "modelId",
      "accuracyValue" : 0.6027456183070403,
      "modelNumber" : 0,
      "modelType" : "modelType",
      "bp" : 0
    }, {
      "prime" : True,
      "samplepct" : 23.02135886934765,
      "fairnessValue" : 0.5962133916683182,
      "dsName" : "dsName",
      "modelId" : "modelId",
      "accuracyValue" : 0.6027456183070403,
      "modelNumber" : 0,
      "modelType" : "modelType",
      "bp" : 0
    } ],
    "protectedFeature" : "",
    "fairnessThreshold" : 0.08008281904610115,
    "accuracyMetric" : "AUC",
    "fairnessMetric" : ""
  }, {
    "models" : [ {
      "prime" : True,
      "samplepct" : 23.02135886934765,
      "fairnessValue" : 0.5962133916683182,
      "dsName" : "dsName",
      "modelId" : "modelId",
      "accuracyValue" : 0.6027456183070403,
      "modelNumber" : 0,
      "modelType" : "modelType",
      "bp" : 0
    }, {
      "prime" : True,
      "samplepct" : 23.02135886934765,
      "fairnessValue" : 0.5962133916683182,
      "dsName" : "dsName",
      "modelId" : "modelId",
      "accuracyValue" : 0.6027456183070403,
      "modelNumber" : 0,
      "modelType" : "modelType",
      "bp" : 0
    } ],
    "protectedFeature" : "",
    "fairnessThreshold" : 0.08008281904610115,
    "accuracyMetric" : "AUC",
    "fairnessMetric" : ""
  } ]
})
    )
    result = BiasAndFairnessApi.projects_bias_vs_accuracy_insights_list(project_id="projectId_example", )
    assert isinstance(result, BiasVsAccuracyInsightRetrieve)


@responses.activate
def test_bias_and_fairness_api_projects_models_cross_class_accuracy_scores_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/api/v2/projects/{projectId}/models/{modelId}/crossClassAccuracyScores/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=202,
        content_type='application/json',
        body=json.dumps({
  "statusId" : "statusId"
})
    )
    result = BiasAndFairnessApi.projects_models_cross_class_accuracy_scores_create(project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, CrossClassAccuracyCreateResponse)


@responses.activate
def test_bias_and_fairness_api_projects_models_cross_class_accuracy_scores_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/models/{modelId}/crossClassAccuracyScores/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "predictionThreshold" : 0.14658129805029452,
    "feature" : "feature",
    "modelId" : "modelId",
    "perClassAccuracyScores" : [ {
      "className" : "className",
      "metrics" : [ {
        "metric" : "AUC",
        "value" : 0.6027456183070403
      }, {
        "metric" : "AUC",
        "value" : 0.6027456183070403
      } ]
    }, {
      "className" : "className",
      "metrics" : [ {
        "metric" : "AUC",
        "value" : 0.6027456183070403
      }, {
        "metric" : "AUC",
        "value" : 0.6027456183070403
      } ]
    } ]
  }, {
    "predictionThreshold" : 0.14658129805029452,
    "feature" : "feature",
    "modelId" : "modelId",
    "perClassAccuracyScores" : [ {
      "className" : "className",
      "metrics" : [ {
        "metric" : "AUC",
        "value" : 0.6027456183070403
      }, {
        "metric" : "AUC",
        "value" : 0.6027456183070403
      } ]
    }, {
      "className" : "className",
      "metrics" : [ {
        "metric" : "AUC",
        "value" : 0.6027456183070403
      }, {
        "metric" : "AUC",
        "value" : 0.6027456183070403
      } ]
    } ]
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0,
  "totalCount" : 5
})
    )
    result = BiasAndFairnessApi.projects_models_cross_class_accuracy_scores_list(project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, CrossClassAccuracyList)


@responses.activate
def test_bias_and_fairness_api_projects_models_data_disparity_insights_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/api/v2/projects/{projectId}/models/{modelId}/dataDisparityInsights/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=202,
        content_type='application/json',
        body=json.dumps({
  "statusId" : "statusId"
})
    )
    result = BiasAndFairnessApi.projects_models_data_disparity_insights_create(project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, DataDisparityCreateResponse)


@responses.activate
def test_bias_and_fairness_api_projects_models_data_disparity_insights_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/models/{modelId}/dataDisparityInsights/'.format(endpoint=unittest_endpoint,
        feature="feature_example", className1="className1_example", className2="className2_example", projectId="projectId_example", modelId="modelId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : {
    "features" : [ {
      "disparityScore" : 1.4658129805029452,
      "name" : "name",
      "detailsHistogram" : [ {
        "bin" : "bin",
        "bars" : [ {
          "label" : "label",
          "value" : 6.027456183070403
        }, {
          "label" : "label",
          "value" : 6.027456183070403
        } ]
      }, {
        "bin" : "bin",
        "bars" : [ {
          "label" : "label",
          "value" : 6.027456183070403
        }, {
          "label" : "label",
          "value" : 6.027456183070403
        } ]
      } ],
      "featureImpact" : 5.962133916683182,
      "status" : "Healthy"
    }, {
      "disparityScore" : 1.4658129805029452,
      "name" : "name",
      "detailsHistogram" : [ {
        "bin" : "bin",
        "bars" : [ {
          "label" : "label",
          "value" : 6.027456183070403
        }, {
          "label" : "label",
          "value" : 6.027456183070403
        } ]
      }, {
        "bin" : "bin",
        "bars" : [ {
          "label" : "label",
          "value" : 6.027456183070403
        }, {
          "label" : "label",
          "value" : 6.027456183070403
        } ]
      } ],
      "featureImpact" : 5.962133916683182,
      "status" : "Healthy"
    } ],
    "metric" : "metric",
    "protectedFeature" : "protectedFeature",
    "values" : [ {
      "count" : 5,
      "label" : "label"
    }, {
      "count" : 5,
      "label" : "label"
    } ]
  },
  "previous" : "https://openapi-generator.tech",
  "count" : 0,
  "totalCount" : 2
})
    )
    result = BiasAndFairnessApi.projects_models_data_disparity_insights_list(feature="feature_example", class_name1="className1_example", class_name2="className2_example", project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, DataDisparityRetrieveResponse)


@responses.activate
def test_bias_and_fairness_api_projects_models_fairness_insights_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/api/v2/projects/{projectId}/models/{modelId}/fairnessInsights/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=202,
        content_type='application/json',
        body=json.dumps({
  "statusId" : "statusId"
})
    )
    result = BiasAndFairnessApi.projects_models_fairness_insights_create(project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, FairnessInsightsStartCalculationResponse)


@responses.activate
def test_bias_and_fairness_api_projects_models_fairness_insights_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/models/{modelId}/fairnessInsights/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "predictionThreshold" : 0.23021358869347652,
    "modelId" : "modelId",
    "protectedFeature" : "protectedFeature",
    "fairnessThreshold" : 0.6027456183070403,
    "perClassFairness" : [ {
      "entriesCount" : 0,
      "absoluteValue" : 0.14658129805029452,
      "className" : "className",
      "isStatisticallySignificant" : True,
      "value" : 0.5637376656633328
    }, {
      "entriesCount" : 0,
      "absoluteValue" : 0.14658129805029452,
      "className" : "className",
      "isStatisticallySignificant" : True,
      "value" : 0.5637376656633328
    } ],
    "fairnessMetric" : "proportionalParity"
  }, {
    "predictionThreshold" : 0.23021358869347652,
    "modelId" : "modelId",
    "protectedFeature" : "protectedFeature",
    "fairnessThreshold" : 0.6027456183070403,
    "perClassFairness" : [ {
      "entriesCount" : 0,
      "absoluteValue" : 0.14658129805029452,
      "className" : "className",
      "isStatisticallySignificant" : True,
      "value" : 0.5637376656633328
    }, {
      "entriesCount" : 0,
      "absoluteValue" : 0.14658129805029452,
      "className" : "className",
      "isStatisticallySignificant" : True,
      "value" : 0.5637376656633328
    } ],
    "fairnessMetric" : "proportionalParity"
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0,
  "totalCount" : 7
})
    )
    result = BiasAndFairnessApi.projects_models_fairness_insights_list(project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, FairnessInsightsListResponse)
