#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import json
import responses
from six.moves.urllib.parse import urljoin
from dateutil import parser
from datarobot.models.testing.generated.model.blueprint_chart_retrieve_response import BlueprintChartRetrieveResponse
from datarobot.models.testing.generated.model.blueprint_list_documents_response import BlueprintListDocumentsResponse
from datarobot.models.testing.generated.model.blueprint_response import BlueprintResponse
from datarobot.models.testing.generated.model.custom_model_artifacts_response import CustomModelArtifactsResponse
from datarobot.models.testing.generated.model.persistent_model_logs_retrieve_response import PersistentModelLogsRetrieveResponse
from datarobot.utils import from_api
from datarobot.models.testing.generated.model import *

from datarobot.models.testing.generated.api.blueprints_api import BlueprintsApi




@responses.activate
def test_blueprints_api_projects_blueprints_blueprint_chart_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/blueprints/{blueprintId}/blueprintChart/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", blueprintId="blueprintId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "nodes" : [ {
    "id" : "id",
    "label" : "label"
  }, {
    "id" : "id",
    "label" : "label"
  } ],
  "edges" : [ [ "edges", "edges" ], [ "edges", "edges" ] ]
})
    )
    result = BlueprintsApi.projects_blueprints_blueprint_chart_list(project_id="projectId_example", blueprint_id="blueprintId_example", )
    assert isinstance(result, BlueprintChartRetrieveResponse)


@responses.activate
def test_blueprints_api_projects_blueprints_blueprint_docs_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/blueprints/{blueprintId}/blueprintDocs/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", blueprintId="blueprintId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "task" : "task",
  "references" : [ {
    "name" : "name",
    "url" : "url"
  }, {
    "name" : "name",
    "url" : "url"
  } ],
  "description" : "description",
  "links" : [ {
    "name" : "name",
    "url" : "url"
  }, {
    "name" : "name",
    "url" : "url"
  } ],
  "title" : "title",
  "parameters" : [ {
    "name" : "name",
    "description" : "description",
    "type" : "type"
  }, {
    "name" : "name",
    "description" : "description",
    "type" : "type"
  } ]
})
    )
    result = BlueprintsApi.projects_blueprints_blueprint_docs_list(project_id="projectId_example", blueprint_id="blueprintId_example", )
    assert isinstance(result, BlueprintListDocumentsResponse)


@responses.activate
def test_blueprints_api_projects_blueprints_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/blueprints/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "monotonicDecreasingFeaturelistId" : "monotonicDecreasingFeaturelistId",
  "monotonicIncreasingFeaturelistId" : "monotonicIncreasingFeaturelistId",
  "supportsComposableMl" : True,
  "processes" : [ "processes", "processes" ],
  "blueprintCategory" : "blueprintCategory",
  "recommendedFeaturelistId" : "recommendedFeaturelistId",
  "id" : "id",
  "modelType" : "modelType",
  "projectId" : "projectId",
  "supportsMonotonicConstraints" : True
})
    )
    result = BlueprintsApi.projects_blueprints_list(project_id="projectId_example", )
    assert isinstance(result, BlueprintResponse)


@responses.activate
def test_blueprints_api_projects_blueprints_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/blueprints/{blueprintId}/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", blueprintId="blueprintId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "monotonicDecreasingFeaturelistId" : "monotonicDecreasingFeaturelistId",
  "monotonicIncreasingFeaturelistId" : "monotonicIncreasingFeaturelistId",
  "supportsComposableMl" : True,
  "processes" : [ "processes", "processes" ],
  "blueprintCategory" : "blueprintCategory",
  "recommendedFeaturelistId" : "recommendedFeaturelistId",
  "id" : "id",
  "modelType" : "modelType",
  "projectId" : "projectId",
  "supportsMonotonicConstraints" : True
})
    )
    result = BlueprintsApi.projects_blueprints_retrieve(project_id="projectId_example", blueprint_id="blueprintId_example", )
    assert isinstance(result, BlueprintResponse)


@responses.activate
def test_blueprints_api_projects_models_blueprint_chart_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/models/{modelId}/blueprintChart/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "nodes" : [ {
    "id" : "id",
    "label" : "label"
  }, {
    "id" : "id",
    "label" : "label"
  } ],
  "edges" : [ [ "edges", "edges" ], [ "edges", "edges" ] ]
})
    )
    result = BlueprintsApi.projects_models_blueprint_chart_list(project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, BlueprintChartRetrieveResponse)


@responses.activate
def test_blueprints_api_projects_models_blueprint_docs_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/models/{modelId}/blueprintDocs/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "task" : "task",
  "references" : [ {
    "name" : "name",
    "url" : "url"
  }, {
    "name" : "name",
    "url" : "url"
  } ],
  "description" : "description",
  "links" : [ {
    "name" : "name",
    "url" : "url"
  }, {
    "name" : "name",
    "url" : "url"
  } ],
  "title" : "title",
  "parameters" : [ {
    "name" : "name",
    "description" : "description",
    "type" : "type"
  }, {
    "name" : "name",
    "description" : "description",
    "type" : "type"
  } ]
})
    )
    result = BlueprintsApi.projects_models_blueprint_docs_list(project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, BlueprintListDocumentsResponse)


@responses.activate
def test_blueprints_api_projects_models_logs_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/models/{modelId}/logs/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "data" : ""
})
    )
    result = BlueprintsApi.projects_models_logs_list(project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, PersistentModelLogsRetrieveResponse)


@responses.activate
def test_blueprints_api_projects_models_training_artifact_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/models/{modelId}/trainingArtifact/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "data" : ""
})
    )
    result = BlueprintsApi.projects_models_training_artifact_list(project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, CustomModelArtifactsResponse)
