#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import json
import responses
from six.moves.urllib.parse import urljoin
from dateutil import parser
from datarobot.models.testing.generated.model.catalog_details_retrieve_response import CatalogDetailsRetrieveResponse
from datarobot.models.testing.generated.model.catalog_extended_details_response import CatalogExtendedDetailsResponse
from datarobot.models.testing.generated.model.catalog_list_search_response import CatalogListSearchResponse
from datarobot.models.testing.generated.model.update_catalog_metadata import UpdateCatalogMetadata
from datarobot.utils import from_api
from datarobot.models.testing.generated.model import *

from datarobot.models.testing.generated.api.catalog_items_api import CatalogItemsApi




@responses.activate
def test_catalog_items_api_catalog_items_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/catalogItems/'.format(endpoint=unittest_endpoint,
        offset=0, limit=0, initialCacheSize=500, ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "next",
  "data" : [ {
    "projectsUsedInCount" : 1,
    "userBlueprintId" : "userBlueprintId",
    "infoModificationDate" : "infoModificationDate",
    "catalogType" : "unknown_dataset_type",
    "isDataEngineEligible" : True,
    "dataMeshWorkspaceId" : "dataMeshWorkspaceId",
    "infoCreatorFullName" : "infoCreatorFullName",
    "infoModifierFullName" : "infoModifierFullName",
    "lastModifierFullName" : "lastModifierFullName",
    "description" : "description",
    "error" : "error",
    "infoCreationDate" : "infoCreationDate",
    "uri" : "uri",
    "isFirstVersion" : True,
    "relevance" : 5.962133916683182,
    "canUseDatasetData" : True,
    "tags" : [ "tags", "tags" ],
    "catalogName" : "catalogName",
    "originalName" : "originalName",
    "processingState" : 6,
    "dataSourceId" : "dataSourceId",
    "lastModificationDate" : "lastModificationDate",
    "dataEngineQueryId" : "dataEngineQueryId",
    "id" : "id"
  }, {
    "projectsUsedInCount" : 1,
    "userBlueprintId" : "userBlueprintId",
    "infoModificationDate" : "infoModificationDate",
    "catalogType" : "unknown_dataset_type",
    "isDataEngineEligible" : True,
    "dataMeshWorkspaceId" : "dataMeshWorkspaceId",
    "infoCreatorFullName" : "infoCreatorFullName",
    "infoModifierFullName" : "infoModifierFullName",
    "lastModifierFullName" : "lastModifierFullName",
    "description" : "description",
    "error" : "error",
    "infoCreationDate" : "infoCreationDate",
    "uri" : "uri",
    "isFirstVersion" : True,
    "relevance" : 5.962133916683182,
    "canUseDatasetData" : True,
    "tags" : [ "tags", "tags" ],
    "catalogName" : "catalogName",
    "originalName" : "originalName",
    "processingState" : 6,
    "dataSourceId" : "dataSourceId",
    "lastModificationDate" : "lastModificationDate",
    "dataEngineQueryId" : "dataEngineQueryId",
    "id" : "id"
  } ],
  "previous" : "previous",
  "cacheHit" : True,
  "count" : 0,
  "totalCount" : 5
})
    )
    result = CatalogItemsApi.catalog_items_list(offset=0, limit=0, initial_cache_size=500, )
    assert isinstance(result, CatalogListSearchResponse)


@responses.activate
def test_catalog_items_api_catalog_items_patch(unittest_endpoint):
    responses.add(
        responses.PATCH,
        '{endpoint}/api/v2/catalogItems/{catalogId}/'.format(endpoint=unittest_endpoint,
        catalogId="catalogId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "projectsUsedInCount" : 1,
  "userBlueprintId" : "userBlueprintId",
  "infoModificationDate" : "infoModificationDate",
  "catalogType" : "unknown_dataset_type",
  "isDataEngineEligible" : True,
  "dataMeshWorkspaceId" : "dataMeshWorkspaceId",
  "infoCreatorFullName" : "infoCreatorFullName",
  "infoModifierFullName" : "infoModifierFullName",
  "lastModifierFullName" : "lastModifierFullName",
  "description" : "description",
  "error" : "error",
  "infoCreationDate" : "infoCreationDate",
  "uri" : "uri",
  "isFirstVersion" : True,
  "relevance" : 5.962133916683182,
  "canUseDatasetData" : True,
  "tags" : [ "tags", "tags" ],
  "catalogName" : "catalogName",
  "originalName" : "originalName",
  "processingState" : 6,
  "dataSourceId" : "dataSourceId",
  "lastModificationDate" : "lastModificationDate",
  "dataEngineQueryId" : "dataEngineQueryId",
  "id" : "id"
})
    )
    result = CatalogItemsApi.catalog_items_patch(catalog_id="catalogId_example", )
    assert isinstance(result, CatalogExtendedDetailsResponse)


@responses.activate
def test_catalog_items_api_catalog_items_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/catalogItems/{catalogId}/'.format(endpoint=unittest_endpoint,
        catalogId="catalogId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "createdAt" : "2000-01-23T04:56:07.000+00:00",
  "createdBy" : "createdBy",
  "modifiedAt" : "2000-01-23T04:56:07.000+00:00",
  "name" : "name",
  "description" : "description",
  "modifiedBy" : "modifiedBy",
  "id" : "id",
  "message" : "message",
  "type" : "unknown_dataset_type",
  "status" : "COMPLETED",
  "tags" : [ "tags", "tags" ]
})
    )
    result = CatalogItemsApi.catalog_items_retrieve(catalog_id="catalogId_example", )
    assert isinstance(result, CatalogDetailsRetrieveResponse)
