#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import json
import responses
from six.moves.urllib.parse import urljoin
from dateutil import parser
from datarobot.models.testing.generated.model.comment import Comment
from datarobot.models.testing.generated.model.comment_retrieve import CommentRetrieve
from datarobot.models.testing.generated.model.comment_update import CommentUpdate
from datarobot.utils import from_api
from datarobot.models.testing.generated.model import *

from datarobot.models.testing.generated.api.comments_api import CommentsApi




@responses.activate
def test_comments_api_comments_create(unittest_endpoint):
    responses.add(
        responses.POST,
       '{endpoint}/api/v2/comments/'.format(endpoint=unittest_endpoint),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "createdAt" : "createdAt",
  "createdBy" : {
    "firstName" : "firstName",
    "lastName" : "lastName",
    "id" : "id",
    "username" : "username"
  },
  "entityType" : "useCase",
  "mentions" : [ {
    "firstName" : "firstName",
    "lastName" : "lastName",
    "id" : "id",
    "username" : "username"
  }, {
    "firstName" : "firstName",
    "lastName" : "lastName",
    "id" : "id",
    "username" : "username"
  } ],
  "entityId" : "entityId",
  "id" : "id",
  "content" : "content",
  "updatedAt" : "updatedAt"
})
    )
    result = CommentsApi.comments_create()
    assert isinstance(result, CommentRetrieve)


@responses.activate
def test_comments_api_comments_delete(unittest_endpoint):
    responses.add(
        responses.DELETE,
        '{endpoint}/api/v2/comments/{commentId}/'.format(endpoint=unittest_endpoint,
        commentId="commentId_example", ),
        status=200,
        content_type='',
    )
    result = CommentsApi.comments_delete(comment_id="commentId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_comments_api_comments_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/comments/{entityType}/{entityId}/'.format(endpoint=unittest_endpoint,
        entityId="entityId_example", entityType="useCase", ),
        status=200,
        content_type='',
    )
    result = CommentsApi.comments_list(entity_id="entityId_example", entity_type="useCase", )
    assert isinstance(result, type(None))


@responses.activate
def test_comments_api_comments_patch(unittest_endpoint):
    responses.add(
        responses.PATCH,
        '{endpoint}/api/v2/comments/{commentId}/'.format(endpoint=unittest_endpoint,
        commentId="commentId_example", ),
        status=200,
        content_type='',
    )
    result = CommentsApi.comments_patch(comment_id="commentId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_comments_api_comments_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/comments/{commentId}/'.format(endpoint=unittest_endpoint,
        commentId="commentId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "createdAt" : "createdAt",
  "createdBy" : {
    "firstName" : "firstName",
    "lastName" : "lastName",
    "id" : "id",
    "username" : "username"
  },
  "entityType" : "useCase",
  "mentions" : [ {
    "firstName" : "firstName",
    "lastName" : "lastName",
    "id" : "id",
    "username" : "username"
  }, {
    "firstName" : "firstName",
    "lastName" : "lastName",
    "id" : "id",
    "username" : "username"
  } ],
  "entityId" : "entityId",
  "id" : "id",
  "content" : "content",
  "updatedAt" : "updatedAt"
})
    )
    result = CommentsApi.comments_retrieve(comment_id="commentId_example", )
    assert isinstance(result, CommentRetrieve)
