#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import json
import responses
from six.moves.urllib.parse import urljoin
from dateutil import parser
from datarobot.models.testing.generated.model.create_credentials_response import CreateCredentialsResponse
from datarobot.models.testing.generated.model.credentials_association_update import CredentialsAssociationUpdate
from datarobot.models.testing.generated.model.credentials_body import CredentialsBody
from datarobot.models.testing.generated.model.credentials_list_associations_response import CredentialsListAssociationsResponse
from datarobot.models.testing.generated.model.credentials_list_response import CredentialsListResponse
from datarobot.models.testing.generated.model.credentials_update import CredentialsUpdate
from datarobot.utils import from_api
from datarobot.models.testing.generated.model import *

from datarobot.models.testing.generated.api.credentials_api import CredentialsApi




@responses.activate
def test_credentials_api_credentials_associations_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/credentials/{credentialId}/associations/'.format(endpoint=unittest_endpoint,
        credentialId="credentialId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "link" : "https://openapi-generator.tech",
    "objectId" : "objectId",
    "objectType" : "objectType"
  }, {
    "link" : "https://openapi-generator.tech",
    "objectId" : "objectId",
    "objectType" : "objectType"
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0,
  "totalCount" : 6
})
    )
    result = CredentialsApi.credentials_associations_list(credential_id="credentialId_example", )
    assert isinstance(result, CredentialsListAssociationsResponse)


@responses.activate
def test_credentials_api_credentials_associations_patch_many(unittest_endpoint):
    responses.add(
        responses.PATCH,
        '{endpoint}/api/v2/credentials/{credentialId}/associations/'.format(endpoint=unittest_endpoint,
        credentialId="credentialId_example", ),
        status=200,
        content_type='',
    )
    result = CredentialsApi.credentials_associations_patch_many(credential_id="credentialId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_credentials_api_credentials_create(unittest_endpoint):
    responses.add(
        responses.POST,
       '{endpoint}/api/v2/credentials/'.format(endpoint=unittest_endpoint),
        status=201,
        content_type='application/json',
        body=json.dumps({
  "credentialType" : "basic",
  "name" : "name",
  "credentialId" : "credentialId",
  "description" : "description",
  "creationDate" : "2000-01-23T04:56:07.000+00:00"
})
    )
    result = CredentialsApi.credentials_create()
    assert isinstance(result, CreateCredentialsResponse)


@responses.activate
def test_credentials_api_credentials_delete(unittest_endpoint):
    responses.add(
        responses.DELETE,
        '{endpoint}/api/v2/credentials/{credentialId}/'.format(endpoint=unittest_endpoint,
        credentialId="credentialId_example", ),
        status=204,
        content_type='',
    )
    result = CredentialsApi.credentials_delete(credential_id="credentialId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_credentials_api_credentials_list(unittest_endpoint):
    responses.add(
        responses.GET,
       '{endpoint}/api/v2/credentials/'.format(endpoint=unittest_endpoint),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "credentialType" : "basic",
    "name" : "name",
    "credentialId" : "credentialId",
    "description" : "description",
    "creationDate" : "2000-01-23T04:56:07.000+00:00"
  }, {
    "credentialType" : "basic",
    "name" : "name",
    "credentialId" : "credentialId",
    "description" : "description",
    "creationDate" : "2000-01-23T04:56:07.000+00:00"
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0,
  "totalCount" : 6
})
    )
    result = CredentialsApi.credentials_list()
    assert isinstance(result, CredentialsListResponse)


@responses.activate
def test_credentials_api_credentials_patch(unittest_endpoint):
    responses.add(
        responses.PATCH,
        '{endpoint}/api/v2/credentials/{credentialId}/'.format(endpoint=unittest_endpoint,
        credentialId="credentialId_example", ),
        status=200,
        content_type='',
    )
    result = CredentialsApi.credentials_patch(credential_id="credentialId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_credentials_api_credentials_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/credentials/{credentialId}/'.format(endpoint=unittest_endpoint,
        credentialId="credentialId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "credentialType" : "basic",
  "name" : "name",
  "credentialId" : "credentialId",
  "description" : "description",
  "creationDate" : "2000-01-23T04:56:07.000+00:00"
})
    )
    result = CredentialsApi.credentials_retrieve(credential_id="credentialId_example", )
    assert isinstance(result, CreateCredentialsResponse)
