#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import json
import responses
from six.moves.urllib.parse import urljoin
from dateutil import parser
from datarobot.models.testing.generated.model.base_dependency_build_metadata_response import BaseDependencyBuildMetadataResponse
from datarobot.models.testing.generated.model.custom_model_access_control_list_response import CustomModelAccessControlListResponse
from datarobot.models.testing.generated.model.custom_model_access_control_update_response import CustomModelAccessControlUpdateResponse
from datarobot.models.testing.generated.model.custom_model_async_operation_response import CustomModelAsyncOperationResponse
from datarobot.models.testing.generated.model.custom_model_copy import CustomModelCopy
from datarobot.models.testing.generated.model.custom_model_create import CustomModelCreate
from datarobot.models.testing.generated.model.custom_model_deployment_list_response import CustomModelDeploymentListResponse
from datarobot.models.testing.generated.model.custom_model_list_response import CustomModelListResponse
from datarobot.models.testing.generated.model.custom_model_prediction_explanations import CustomModelPredictionExplanations
from datarobot.models.testing.generated.model.custom_model_resource_limits import CustomModelResourceLimits
from datarobot.models.testing.generated.model.custom_model_response import CustomModelResponse
from datarobot.models.testing.generated.model.custom_model_tests import CustomModelTests
from datarobot.models.testing.generated.model.custom_model_tests_list_response import CustomModelTestsListResponse
from datarobot.models.testing.generated.model.custom_model_tests_log_tail_response import CustomModelTestsLogTailResponse
from datarobot.models.testing.generated.model.custom_model_tests_response import CustomModelTestsResponse
from datarobot.models.testing.generated.model.custom_model_update import CustomModelUpdate
from datarobot.models.testing.generated.model.custom_model_version_create_from_repository import CustomModelVersionCreateFromRepository
from datarobot.models.testing.generated.model.custom_model_version_list_response import CustomModelVersionListResponse
from datarobot.models.testing.generated.model.custom_model_version_metadata_update import CustomModelVersionMetadataUpdate
from datarobot.models.testing.generated.model.custom_model_version_response import CustomModelVersionResponse
from datarobot.models.testing.generated.model.custom_training_blueprint_create import CustomTrainingBlueprintCreate
from datarobot.models.testing.generated.model.custom_training_blueprint_list_response import CustomTrainingBlueprintListResponse
from datarobot.models.testing.generated.model.custom_training_blueprint_response import CustomTrainingBlueprintResponse
from datarobot.models.testing.generated.model.dependency_build_log_response import DependencyBuildLogResponse
from datarobot.models.testing.generated.model.feature_impact_create_payload import FeatureImpactCreatePayload
from datarobot.models.testing.generated.model.feature_impact_create_response import FeatureImpactCreateResponse
from datarobot.models.testing.generated.model.feature_impact_response import FeatureImpactResponse
from datarobot.models.testing.generated.model.sharing_update_or_remove_with_grant import SharingUpdateOrRemoveWithGrant
from datarobot.models.testing.generated.model.training_data_assignment import TrainingDataAssignment
from datarobot.utils import from_api
from datarobot.models.testing.generated.model import *

from datarobot.models.testing.generated.api.custom_models_api import CustomModelsApi




@responses.activate
def test_custom_models_api_custom_inference_images_feature_impact_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/api/v2/customInferenceImages/{imageId}/featureImpact/'.format(endpoint=unittest_endpoint,
        imageId="imageId_example", ),
        status=202,
        content_type='application/json',
        body=json.dumps({
  "statusId" : "statusId"
})
    )
    result = CustomModelsApi.custom_inference_images_feature_impact_create(image_id="imageId_example", )
    assert isinstance(result, FeatureImpactCreateResponse)


@responses.activate
def test_custom_models_api_custom_inference_images_feature_impact_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/customInferenceImages/{imageId}/featureImpact/'.format(endpoint=unittest_endpoint,
        imageId="imageId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "ranRedundancyDetection" : True,
  "previous" : "https://openapi-generator.tech",
  "featureImpacts" : [ {
    "redundantWith" : "redundantWith",
    "featureName" : "featureName",
    "impactUnnormalized" : 1.4658129805029452,
    "impactNormalized" : 0.6027456183070403
  }, {
    "redundantWith" : "redundantWith",
    "featureName" : "featureName",
    "impactUnnormalized" : 1.4658129805029452,
    "impactNormalized" : 0.6027456183070403
  }, {
    "redundantWith" : "redundantWith",
    "featureName" : "featureName",
    "impactUnnormalized" : 1.4658129805029452,
    "impactNormalized" : 0.6027456183070403
  }, {
    "redundantWith" : "redundantWith",
    "featureName" : "featureName",
    "impactUnnormalized" : 1.4658129805029452,
    "impactNormalized" : 0.6027456183070403
  }, {
    "redundantWith" : "redundantWith",
    "featureName" : "featureName",
    "impactUnnormalized" : 1.4658129805029452,
    "impactNormalized" : 0.6027456183070403
  } ],
  "count" : 0,
  "rowCount" : 5,
  "shapBased" : True
})
    )
    result = CustomModelsApi.custom_inference_images_feature_impact_list(image_id="imageId_example", )
    assert isinstance(result, FeatureImpactResponse)


@responses.activate
def test_custom_models_api_custom_model_deployments_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/customModelDeployments/'.format(endpoint=unittest_endpoint,
        offset=0, limit=100, ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "executionEnvironmentVersion" : {
      "id" : "id",
      "label" : "label"
    },
    "testingStatus" : "not_tested",
    "customModel" : {
      "name" : "name",
      "id" : "id"
    },
    "customModelImageId" : "customModelImageId",
    "customModelVersion" : {
      "id" : "id",
      "label" : "label"
    },
    "deployed" : "deployed",
    "deployedBy" : "deployedBy",
    "id" : "id",
    "label" : "label",
    "imageType" : "customModelImage",
    "executionEnvironment" : {
      "name" : "name",
      "id" : "id"
    },
    "status" : "inactive"
  }, {
    "executionEnvironmentVersion" : {
      "id" : "id",
      "label" : "label"
    },
    "testingStatus" : "not_tested",
    "customModel" : {
      "name" : "name",
      "id" : "id"
    },
    "customModelImageId" : "customModelImageId",
    "customModelVersion" : {
      "id" : "id",
      "label" : "label"
    },
    "deployed" : "deployed",
    "deployedBy" : "deployedBy",
    "id" : "id",
    "label" : "label",
    "imageType" : "customModelImage",
    "executionEnvironment" : {
      "name" : "name",
      "id" : "id"
    },
    "status" : "inactive"
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0,
  "totalCount" : 6
})
    )
    result = CustomModelsApi.custom_model_deployments_list(offset=0, limit=100, )
    assert isinstance(result, CustomModelDeploymentListResponse)


@responses.activate
def test_custom_models_api_custom_model_limits_list(unittest_endpoint):
    responses.add(
        responses.GET,
       '{endpoint}/api/v2/customModelLimits/'.format(endpoint=unittest_endpoint),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "maxCustomModelContainerSize" : 2147483647,
  "desiredCustomModelContainerSize" : 1327305004,
  "maxCustomModelTestingParallelUsers" : 3,
  "maxCustomModelReplicasPerDeployment" : 1
})
    )
    result = CustomModelsApi.custom_model_limits_list()
    assert isinstance(result, CustomModelResourceLimits)


@responses.activate
def test_custom_models_api_custom_model_tests_create(unittest_endpoint):
    responses.add(
        responses.POST,
       '{endpoint}/api/v2/customModelTests/'.format(endpoint=unittest_endpoint),
        status=202,
        content_type='application/json',
        body=json.dumps({
  "statusId" : "statusId"
})
    )
    result = CustomModelsApi.custom_model_tests_create()
    assert isinstance(result, CustomModelAsyncOperationResponse)


@responses.activate
def test_custom_models_api_custom_model_tests_delete(unittest_endpoint):
    responses.add(
        responses.DELETE,
        '{endpoint}/api/v2/customModelTests/{customModelTestId}/'.format(endpoint=unittest_endpoint,
        customModelTestId="customModelTestId_example", ),
        status=204,
        content_type='',
    )
    result = CustomModelsApi.custom_model_tests_delete(custom_model_test_id="customModelTestId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_custom_models_api_custom_model_tests_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/customModelTests/'.format(endpoint=unittest_endpoint,
        offset=0, limit=1000, customModelId="customModelId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "networkEgressPolicy" : "NONE",
    "completedAt" : "completedAt",
    "testingStatus" : {
      "nullValueImputation" : {
        "message" : "message",
        "status" : "not_tested"
      },
      "errorCheck" : {
        "message" : "message",
        "status" : "not_tested"
      },
      "longRunningService" : {
        "message" : "message",
        "status" : "not_tested"
      },
      "sideEffects" : {
        "message" : "message",
        "status" : "not_tested"
      }
    },
    "created" : "created",
    "replicas" : 4,
    "customModelVersion" : {
      "id" : "id",
      "label" : "label"
    },
    "maximumMemory" : 2147483647,
    "executionEnvironment" : {
      "name" : "name",
      "id" : "id"
    },
    "executionEnvironmentVersion" : {
      "id" : "id",
      "label" : "label"
    },
    "requiresHa" : True,
    "customModel" : {
      "name" : "name",
      "id" : "id"
    },
    "createdBy" : "createdBy",
    "customModelImageId" : "customModelImageId",
    "datasetId" : "datasetId",
    "id" : "id",
    "desiredMemory" : 2147483647,
    "imageType" : "customModelImage",
    "datasetVersionId" : "datasetVersionId",
    "overallStatus" : "not_tested"
  }, {
    "networkEgressPolicy" : "NONE",
    "completedAt" : "completedAt",
    "testingStatus" : {
      "nullValueImputation" : {
        "message" : "message",
        "status" : "not_tested"
      },
      "errorCheck" : {
        "message" : "message",
        "status" : "not_tested"
      },
      "longRunningService" : {
        "message" : "message",
        "status" : "not_tested"
      },
      "sideEffects" : {
        "message" : "message",
        "status" : "not_tested"
      }
    },
    "created" : "created",
    "replicas" : 4,
    "customModelVersion" : {
      "id" : "id",
      "label" : "label"
    },
    "maximumMemory" : 2147483647,
    "executionEnvironment" : {
      "name" : "name",
      "id" : "id"
    },
    "executionEnvironmentVersion" : {
      "id" : "id",
      "label" : "label"
    },
    "requiresHa" : True,
    "customModel" : {
      "name" : "name",
      "id" : "id"
    },
    "createdBy" : "createdBy",
    "customModelImageId" : "customModelImageId",
    "datasetId" : "datasetId",
    "id" : "id",
    "desiredMemory" : 2147483647,
    "imageType" : "customModelImage",
    "datasetVersionId" : "datasetVersionId",
    "overallStatus" : "not_tested"
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0,
  "totalCount" : 5
})
    )
    result = CustomModelsApi.custom_model_tests_list(offset=0, limit=1000, custom_model_id="customModelId_example", )
    assert isinstance(result, CustomModelTestsListResponse)


@responses.activate
def test_custom_models_api_custom_model_tests_log_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/customModelTests/{customModelTestId}/log/'.format(endpoint=unittest_endpoint,
        customModelTestId="customModelTestId_example", ),
        status=200,
        content_type='',
    )
    result = CustomModelsApi.custom_model_tests_log_list(custom_model_test_id="customModelTestId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_custom_models_api_custom_model_tests_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/customModelTests/{customModelTestId}/'.format(endpoint=unittest_endpoint,
        customModelTestId="customModelTestId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "networkEgressPolicy" : "NONE",
  "completedAt" : "completedAt",
  "testingStatus" : {
    "nullValueImputation" : {
      "message" : "message",
      "status" : "not_tested"
    },
    "errorCheck" : {
      "message" : "message",
      "status" : "not_tested"
    },
    "longRunningService" : {
      "message" : "message",
      "status" : "not_tested"
    },
    "sideEffects" : {
      "message" : "message",
      "status" : "not_tested"
    }
  },
  "created" : "created",
  "replicas" : 4,
  "customModelVersion" : {
    "id" : "id",
    "label" : "label"
  },
  "maximumMemory" : 2147483647,
  "executionEnvironment" : {
    "name" : "name",
    "id" : "id"
  },
  "executionEnvironmentVersion" : {
    "id" : "id",
    "label" : "label"
  },
  "requiresHa" : True,
  "customModel" : {
    "name" : "name",
    "id" : "id"
  },
  "createdBy" : "createdBy",
  "customModelImageId" : "customModelImageId",
  "datasetId" : "datasetId",
  "id" : "id",
  "desiredMemory" : 2147483647,
  "imageType" : "customModelImage",
  "datasetVersionId" : "datasetVersionId",
  "overallStatus" : "not_tested"
})
    )
    result = CustomModelsApi.custom_model_tests_retrieve(custom_model_test_id="customModelTestId_example", )
    assert isinstance(result, CustomModelTestsResponse)


@responses.activate
def test_custom_models_api_custom_model_tests_tail_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/customModelTests/{customModelTestId}/tail/'.format(endpoint=unittest_endpoint,
        lines=100, customModelTestId="customModelTestId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "log" : "log"
})
    )
    result = CustomModelsApi.custom_model_tests_tail_list(lines=100, custom_model_test_id="customModelTestId_example", )
    assert isinstance(result, CustomModelTestsLogTailResponse)


@responses.activate
def test_custom_models_api_custom_models_access_control_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/customModels/{customModelId}/accessControl/'.format(endpoint=unittest_endpoint,
        offset=0, limit=1000, customModelId="customModelId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "role" : "role",
    "canShare" : True,
    "userId" : "userId",
    "username" : "username"
  }, {
    "role" : "role",
    "canShare" : True,
    "userId" : "userId",
    "username" : "username"
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0
})
    )
    result = CustomModelsApi.custom_models_access_control_list(offset=0, limit=1000, custom_model_id="customModelId_example", )
    assert isinstance(result, CustomModelAccessControlListResponse)


@responses.activate
def test_custom_models_api_custom_models_access_control_patch_many(unittest_endpoint):
    responses.add(
        responses.PATCH,
        '{endpoint}/api/v2/customModels/{customModelId}/accessControl/'.format(endpoint=unittest_endpoint,
        customModelId="customModelId_example", ),
        status=204,
        content_type='application/json',
        body=json.dumps({
  "data" : [ {
    "role" : "role",
    "canShare" : True,
    "userId" : "userId",
    "username" : "username"
  }, {
    "role" : "role",
    "canShare" : True,
    "userId" : "userId",
    "username" : "username"
  } ]
})
    )
    result = CustomModelsApi.custom_models_access_control_patch_many(custom_model_id="customModelId_example", )
    assert isinstance(result, CustomModelAccessControlUpdateResponse)


@responses.activate
def test_custom_models_api_custom_models_create(unittest_endpoint):
    responses.add(
        responses.POST,
       '{endpoint}/api/v2/customModels/'.format(endpoint=unittest_endpoint),
        status=201,
        content_type='application/json',
        body=json.dumps({
  "targetName" : "targetName",
  "supportsAnomalyDetection" : True,
  "calibratePredictions" : True,
  "customModelType" : "training",
  "description" : "description",
  "language" : "language",
  "trainingDataFileName" : "trainingDataFileName",
  "predictionThreshold" : 4.145608029883936,
  "deploymentsCount" : 6,
  "trainingDataPartitionColumn" : "trainingDataPartitionColumn",
  "id" : "id",
  "networkEgressPolicy" : "NONE",
  "negativeClassLabel" : "negativeClassLabel",
  "trainingDatasetVersionId" : "trainingDatasetVersionId",
  "created" : "created",
  "replicas" : 5,
  "trainingDatasetId" : "trainingDatasetId",
  "supportsRegression" : True,
  "maximumMemory" : 2147483647,
  "targetType" : "Binary",
  "trainingDataAssignmentInProgress" : True,
  "requiresHa" : True,
  "classLabels" : [ "classLabels", "classLabels" ],
  "createdBy" : "createdBy",
  "latestVersion" : {
    "networkEgressPolicy" : "NONE",
    "baseEnvironmentVersionId" : "baseEnvironmentVersionId",
    "baseEnvironmentId" : "baseEnvironmentId",
    "created" : "created",
    "replicas" : 5,
    "description" : "description",
    "maximumMemory" : 2147483647,
    "label" : "label",
    "dependencies" : [ {
      "line" : "line",
      "packageName" : "packageName",
      "lineNumber" : 5,
      "constraints" : [ {
        "constraintType" : "<",
        "version" : "version"
      }, {
        "constraintType" : "<",
        "version" : "version"
      } ]
    }, {
      "line" : "line",
      "packageName" : "packageName",
      "lineNumber" : 5,
      "constraints" : [ {
        "constraintType" : "<",
        "version" : "version"
      }, {
        "constraintType" : "<",
        "version" : "version"
      } ]
    } ],
    "requiredMetadata" : "{}",
    "requiresHa" : True,
    "customModelId" : "customModelId",
    "id" : "id",
    "desiredMemory" : 2147483647,
    "isFrozen" : True,
    "requiredMetadataValues" : [ {
      "fieldName" : "fieldName",
      "value" : "value"
    }, {
      "fieldName" : "fieldName",
      "value" : "value"
    } ],
    "versionMajor" : 9,
    "versionMinor" : 3,
    "items" : [ {
      "fileName" : "fileName",
      "ref" : "ref",
      "repositoryLocation" : "repositoryLocation",
      "created" : "created",
      "filePath" : "filePath",
      "fileSource" : "fileSource",
      "storagePath" : "storagePath",
      "commitSha" : "commitSha",
      "id" : "id",
      "repositoryName" : "repositoryName",
      "repositoryFilePath" : "repositoryFilePath",
      "workspaceId" : "workspaceId"
    }, {
      "fileName" : "fileName",
      "ref" : "ref",
      "repositoryLocation" : "repositoryLocation",
      "created" : "created",
      "filePath" : "filePath",
      "fileSource" : "fileSource",
      "storagePath" : "storagePath",
      "commitSha" : "commitSha",
      "id" : "id",
      "repositoryName" : "repositoryName",
      "repositoryFilePath" : "repositoryFilePath",
      "workspaceId" : "workspaceId"
    } ]
  },
  "supportsBinaryClassification" : True,
  "name" : "name",
  "desiredMemory" : 2147483647,
  "positiveClassLabel" : "positiveClassLabel",
  "updated" : "updated"
})
    )
    result = CustomModelsApi.custom_models_create()
    assert isinstance(result, CustomModelResponse)


@responses.activate
def test_custom_models_api_custom_models_delete(unittest_endpoint):
    responses.add(
        responses.DELETE,
        '{endpoint}/api/v2/customModels/{customModelId}/'.format(endpoint=unittest_endpoint,
        customModelId="customModelId_example", ),
        status=204,
        content_type='',
    )
    result = CustomModelsApi.custom_models_delete(custom_model_id="customModelId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_custom_models_api_custom_models_download_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/customModels/{customModelId}/download/'.format(endpoint=unittest_endpoint,
        customModelId="customModelId_example", ),
        status=200,
        content_type='',
    )
    result = CustomModelsApi.custom_models_download_list(custom_model_id="customModelId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_custom_models_api_custom_models_from_custom_model_create(unittest_endpoint):
    responses.add(
        responses.POST,
       '{endpoint}/api/v2/customModels/fromCustomModel/'.format(endpoint=unittest_endpoint),
        status=201,
        content_type='application/json',
        body=json.dumps({
  "targetName" : "targetName",
  "supportsAnomalyDetection" : True,
  "calibratePredictions" : True,
  "customModelType" : "training",
  "description" : "description",
  "language" : "language",
  "trainingDataFileName" : "trainingDataFileName",
  "predictionThreshold" : 4.145608029883936,
  "deploymentsCount" : 6,
  "trainingDataPartitionColumn" : "trainingDataPartitionColumn",
  "id" : "id",
  "networkEgressPolicy" : "NONE",
  "negativeClassLabel" : "negativeClassLabel",
  "trainingDatasetVersionId" : "trainingDatasetVersionId",
  "created" : "created",
  "replicas" : 5,
  "trainingDatasetId" : "trainingDatasetId",
  "supportsRegression" : True,
  "maximumMemory" : 2147483647,
  "targetType" : "Binary",
  "trainingDataAssignmentInProgress" : True,
  "requiresHa" : True,
  "classLabels" : [ "classLabels", "classLabels" ],
  "createdBy" : "createdBy",
  "latestVersion" : {
    "networkEgressPolicy" : "NONE",
    "baseEnvironmentVersionId" : "baseEnvironmentVersionId",
    "baseEnvironmentId" : "baseEnvironmentId",
    "created" : "created",
    "replicas" : 5,
    "description" : "description",
    "maximumMemory" : 2147483647,
    "label" : "label",
    "dependencies" : [ {
      "line" : "line",
      "packageName" : "packageName",
      "lineNumber" : 5,
      "constraints" : [ {
        "constraintType" : "<",
        "version" : "version"
      }, {
        "constraintType" : "<",
        "version" : "version"
      } ]
    }, {
      "line" : "line",
      "packageName" : "packageName",
      "lineNumber" : 5,
      "constraints" : [ {
        "constraintType" : "<",
        "version" : "version"
      }, {
        "constraintType" : "<",
        "version" : "version"
      } ]
    } ],
    "requiredMetadata" : "{}",
    "requiresHa" : True,
    "customModelId" : "customModelId",
    "id" : "id",
    "desiredMemory" : 2147483647,
    "isFrozen" : True,
    "requiredMetadataValues" : [ {
      "fieldName" : "fieldName",
      "value" : "value"
    }, {
      "fieldName" : "fieldName",
      "value" : "value"
    } ],
    "versionMajor" : 9,
    "versionMinor" : 3,
    "items" : [ {
      "fileName" : "fileName",
      "ref" : "ref",
      "repositoryLocation" : "repositoryLocation",
      "created" : "created",
      "filePath" : "filePath",
      "fileSource" : "fileSource",
      "storagePath" : "storagePath",
      "commitSha" : "commitSha",
      "id" : "id",
      "repositoryName" : "repositoryName",
      "repositoryFilePath" : "repositoryFilePath",
      "workspaceId" : "workspaceId"
    }, {
      "fileName" : "fileName",
      "ref" : "ref",
      "repositoryLocation" : "repositoryLocation",
      "created" : "created",
      "filePath" : "filePath",
      "fileSource" : "fileSource",
      "storagePath" : "storagePath",
      "commitSha" : "commitSha",
      "id" : "id",
      "repositoryName" : "repositoryName",
      "repositoryFilePath" : "repositoryFilePath",
      "workspaceId" : "workspaceId"
    } ]
  },
  "supportsBinaryClassification" : True,
  "name" : "name",
  "desiredMemory" : 2147483647,
  "positiveClassLabel" : "positiveClassLabel",
  "updated" : "updated"
})
    )
    result = CustomModelsApi.custom_models_from_custom_model_create()
    assert isinstance(result, CustomModelResponse)


@responses.activate
def test_custom_models_api_custom_models_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/customModels/'.format(endpoint=unittest_endpoint,
        offset=0, limit=1000, ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "targetName" : "targetName",
    "supportsAnomalyDetection" : True,
    "calibratePredictions" : True,
    "customModelType" : "training",
    "description" : "description",
    "language" : "language",
    "trainingDataFileName" : "trainingDataFileName",
    "predictionThreshold" : 4.145608029883936,
    "deploymentsCount" : 6,
    "trainingDataPartitionColumn" : "trainingDataPartitionColumn",
    "id" : "id",
    "networkEgressPolicy" : "NONE",
    "negativeClassLabel" : "negativeClassLabel",
    "trainingDatasetVersionId" : "trainingDatasetVersionId",
    "created" : "created",
    "replicas" : 5,
    "trainingDatasetId" : "trainingDatasetId",
    "supportsRegression" : True,
    "maximumMemory" : 2147483647,
    "targetType" : "Binary",
    "trainingDataAssignmentInProgress" : True,
    "requiresHa" : True,
    "classLabels" : [ "classLabels", "classLabels" ],
    "createdBy" : "createdBy",
    "latestVersion" : {
      "networkEgressPolicy" : "NONE",
      "baseEnvironmentVersionId" : "baseEnvironmentVersionId",
      "baseEnvironmentId" : "baseEnvironmentId",
      "created" : "created",
      "replicas" : 5,
      "description" : "description",
      "maximumMemory" : 2147483647,
      "label" : "label",
      "dependencies" : [ {
        "line" : "line",
        "packageName" : "packageName",
        "lineNumber" : 5,
        "constraints" : [ {
          "constraintType" : "<",
          "version" : "version"
        }, {
          "constraintType" : "<",
          "version" : "version"
        } ]
      }, {
        "line" : "line",
        "packageName" : "packageName",
        "lineNumber" : 5,
        "constraints" : [ {
          "constraintType" : "<",
          "version" : "version"
        }, {
          "constraintType" : "<",
          "version" : "version"
        } ]
      } ],
      "requiredMetadata" : "{}",
      "requiresHa" : True,
      "customModelId" : "customModelId",
      "id" : "id",
      "desiredMemory" : 2147483647,
      "isFrozen" : True,
      "requiredMetadataValues" : [ {
        "fieldName" : "fieldName",
        "value" : "value"
      }, {
        "fieldName" : "fieldName",
        "value" : "value"
      } ],
      "versionMajor" : 9,
      "versionMinor" : 3,
      "items" : [ {
        "fileName" : "fileName",
        "ref" : "ref",
        "repositoryLocation" : "repositoryLocation",
        "created" : "created",
        "filePath" : "filePath",
        "fileSource" : "fileSource",
        "storagePath" : "storagePath",
        "commitSha" : "commitSha",
        "id" : "id",
        "repositoryName" : "repositoryName",
        "repositoryFilePath" : "repositoryFilePath",
        "workspaceId" : "workspaceId"
      }, {
        "fileName" : "fileName",
        "ref" : "ref",
        "repositoryLocation" : "repositoryLocation",
        "created" : "created",
        "filePath" : "filePath",
        "fileSource" : "fileSource",
        "storagePath" : "storagePath",
        "commitSha" : "commitSha",
        "id" : "id",
        "repositoryName" : "repositoryName",
        "repositoryFilePath" : "repositoryFilePath",
        "workspaceId" : "workspaceId"
      } ]
    },
    "supportsBinaryClassification" : True,
    "name" : "name",
    "desiredMemory" : 2147483647,
    "positiveClassLabel" : "positiveClassLabel",
    "updated" : "updated"
  }, {
    "targetName" : "targetName",
    "supportsAnomalyDetection" : True,
    "calibratePredictions" : True,
    "customModelType" : "training",
    "description" : "description",
    "language" : "language",
    "trainingDataFileName" : "trainingDataFileName",
    "predictionThreshold" : 4.145608029883936,
    "deploymentsCount" : 6,
    "trainingDataPartitionColumn" : "trainingDataPartitionColumn",
    "id" : "id",
    "networkEgressPolicy" : "NONE",
    "negativeClassLabel" : "negativeClassLabel",
    "trainingDatasetVersionId" : "trainingDatasetVersionId",
    "created" : "created",
    "replicas" : 5,
    "trainingDatasetId" : "trainingDatasetId",
    "supportsRegression" : True,
    "maximumMemory" : 2147483647,
    "targetType" : "Binary",
    "trainingDataAssignmentInProgress" : True,
    "requiresHa" : True,
    "classLabels" : [ "classLabels", "classLabels" ],
    "createdBy" : "createdBy",
    "latestVersion" : {
      "networkEgressPolicy" : "NONE",
      "baseEnvironmentVersionId" : "baseEnvironmentVersionId",
      "baseEnvironmentId" : "baseEnvironmentId",
      "created" : "created",
      "replicas" : 5,
      "description" : "description",
      "maximumMemory" : 2147483647,
      "label" : "label",
      "dependencies" : [ {
        "line" : "line",
        "packageName" : "packageName",
        "lineNumber" : 5,
        "constraints" : [ {
          "constraintType" : "<",
          "version" : "version"
        }, {
          "constraintType" : "<",
          "version" : "version"
        } ]
      }, {
        "line" : "line",
        "packageName" : "packageName",
        "lineNumber" : 5,
        "constraints" : [ {
          "constraintType" : "<",
          "version" : "version"
        }, {
          "constraintType" : "<",
          "version" : "version"
        } ]
      } ],
      "requiredMetadata" : "{}",
      "requiresHa" : True,
      "customModelId" : "customModelId",
      "id" : "id",
      "desiredMemory" : 2147483647,
      "isFrozen" : True,
      "requiredMetadataValues" : [ {
        "fieldName" : "fieldName",
        "value" : "value"
      }, {
        "fieldName" : "fieldName",
        "value" : "value"
      } ],
      "versionMajor" : 9,
      "versionMinor" : 3,
      "items" : [ {
        "fileName" : "fileName",
        "ref" : "ref",
        "repositoryLocation" : "repositoryLocation",
        "created" : "created",
        "filePath" : "filePath",
        "fileSource" : "fileSource",
        "storagePath" : "storagePath",
        "commitSha" : "commitSha",
        "id" : "id",
        "repositoryName" : "repositoryName",
        "repositoryFilePath" : "repositoryFilePath",
        "workspaceId" : "workspaceId"
      }, {
        "fileName" : "fileName",
        "ref" : "ref",
        "repositoryLocation" : "repositoryLocation",
        "created" : "created",
        "filePath" : "filePath",
        "fileSource" : "fileSource",
        "storagePath" : "storagePath",
        "commitSha" : "commitSha",
        "id" : "id",
        "repositoryName" : "repositoryName",
        "repositoryFilePath" : "repositoryFilePath",
        "workspaceId" : "workspaceId"
      } ]
    },
    "supportsBinaryClassification" : True,
    "name" : "name",
    "desiredMemory" : 2147483647,
    "positiveClassLabel" : "positiveClassLabel",
    "updated" : "updated"
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0,
  "totalCount" : 1
})
    )
    result = CustomModelsApi.custom_models_list(offset=0, limit=1000, )
    assert isinstance(result, CustomModelListResponse)


@responses.activate
def test_custom_models_api_custom_models_patch(unittest_endpoint):
    responses.add(
        responses.PATCH,
        '{endpoint}/api/v2/customModels/{customModelId}/'.format(endpoint=unittest_endpoint,
        customModelId="customModelId_example", ),
        status=201,
        content_type='application/json',
        body=json.dumps({
  "targetName" : "targetName",
  "supportsAnomalyDetection" : True,
  "calibratePredictions" : True,
  "customModelType" : "training",
  "description" : "description",
  "language" : "language",
  "trainingDataFileName" : "trainingDataFileName",
  "predictionThreshold" : 4.145608029883936,
  "deploymentsCount" : 6,
  "trainingDataPartitionColumn" : "trainingDataPartitionColumn",
  "id" : "id",
  "networkEgressPolicy" : "NONE",
  "negativeClassLabel" : "negativeClassLabel",
  "trainingDatasetVersionId" : "trainingDatasetVersionId",
  "created" : "created",
  "replicas" : 5,
  "trainingDatasetId" : "trainingDatasetId",
  "supportsRegression" : True,
  "maximumMemory" : 2147483647,
  "targetType" : "Binary",
  "trainingDataAssignmentInProgress" : True,
  "requiresHa" : True,
  "classLabels" : [ "classLabels", "classLabels" ],
  "createdBy" : "createdBy",
  "latestVersion" : {
    "networkEgressPolicy" : "NONE",
    "baseEnvironmentVersionId" : "baseEnvironmentVersionId",
    "baseEnvironmentId" : "baseEnvironmentId",
    "created" : "created",
    "replicas" : 5,
    "description" : "description",
    "maximumMemory" : 2147483647,
    "label" : "label",
    "dependencies" : [ {
      "line" : "line",
      "packageName" : "packageName",
      "lineNumber" : 5,
      "constraints" : [ {
        "constraintType" : "<",
        "version" : "version"
      }, {
        "constraintType" : "<",
        "version" : "version"
      } ]
    }, {
      "line" : "line",
      "packageName" : "packageName",
      "lineNumber" : 5,
      "constraints" : [ {
        "constraintType" : "<",
        "version" : "version"
      }, {
        "constraintType" : "<",
        "version" : "version"
      } ]
    } ],
    "requiredMetadata" : "{}",
    "requiresHa" : True,
    "customModelId" : "customModelId",
    "id" : "id",
    "desiredMemory" : 2147483647,
    "isFrozen" : True,
    "requiredMetadataValues" : [ {
      "fieldName" : "fieldName",
      "value" : "value"
    }, {
      "fieldName" : "fieldName",
      "value" : "value"
    } ],
    "versionMajor" : 9,
    "versionMinor" : 3,
    "items" : [ {
      "fileName" : "fileName",
      "ref" : "ref",
      "repositoryLocation" : "repositoryLocation",
      "created" : "created",
      "filePath" : "filePath",
      "fileSource" : "fileSource",
      "storagePath" : "storagePath",
      "commitSha" : "commitSha",
      "id" : "id",
      "repositoryName" : "repositoryName",
      "repositoryFilePath" : "repositoryFilePath",
      "workspaceId" : "workspaceId"
    }, {
      "fileName" : "fileName",
      "ref" : "ref",
      "repositoryLocation" : "repositoryLocation",
      "created" : "created",
      "filePath" : "filePath",
      "fileSource" : "fileSource",
      "storagePath" : "storagePath",
      "commitSha" : "commitSha",
      "id" : "id",
      "repositoryName" : "repositoryName",
      "repositoryFilePath" : "repositoryFilePath",
      "workspaceId" : "workspaceId"
    } ]
  },
  "supportsBinaryClassification" : True,
  "name" : "name",
  "desiredMemory" : 2147483647,
  "positiveClassLabel" : "positiveClassLabel",
  "updated" : "updated"
})
    )
    result = CustomModelsApi.custom_models_patch(custom_model_id="customModelId_example", )
    assert isinstance(result, CustomModelResponse)


@responses.activate
def test_custom_models_api_custom_models_prediction_explanations_initialization_create(unittest_endpoint):
    responses.add(
        responses.POST,
       '{endpoint}/api/v2/customModels/predictionExplanationsInitialization/'.format(endpoint=unittest_endpoint),
        status=202,
        content_type='',
    )
    result = CustomModelsApi.custom_models_prediction_explanations_initialization_create()
    assert isinstance(result, type(None))


@responses.activate
def test_custom_models_api_custom_models_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/customModels/{customModelId}/'.format(endpoint=unittest_endpoint,
        customModelId="customModelId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "targetName" : "targetName",
  "supportsAnomalyDetection" : True,
  "calibratePredictions" : True,
  "customModelType" : "training",
  "description" : "description",
  "language" : "language",
  "trainingDataFileName" : "trainingDataFileName",
  "predictionThreshold" : 4.145608029883936,
  "deploymentsCount" : 6,
  "trainingDataPartitionColumn" : "trainingDataPartitionColumn",
  "id" : "id",
  "networkEgressPolicy" : "NONE",
  "negativeClassLabel" : "negativeClassLabel",
  "trainingDatasetVersionId" : "trainingDatasetVersionId",
  "created" : "created",
  "replicas" : 5,
  "trainingDatasetId" : "trainingDatasetId",
  "supportsRegression" : True,
  "maximumMemory" : 2147483647,
  "targetType" : "Binary",
  "trainingDataAssignmentInProgress" : True,
  "requiresHa" : True,
  "classLabels" : [ "classLabels", "classLabels" ],
  "createdBy" : "createdBy",
  "latestVersion" : {
    "networkEgressPolicy" : "NONE",
    "baseEnvironmentVersionId" : "baseEnvironmentVersionId",
    "baseEnvironmentId" : "baseEnvironmentId",
    "created" : "created",
    "replicas" : 5,
    "description" : "description",
    "maximumMemory" : 2147483647,
    "label" : "label",
    "dependencies" : [ {
      "line" : "line",
      "packageName" : "packageName",
      "lineNumber" : 5,
      "constraints" : [ {
        "constraintType" : "<",
        "version" : "version"
      }, {
        "constraintType" : "<",
        "version" : "version"
      } ]
    }, {
      "line" : "line",
      "packageName" : "packageName",
      "lineNumber" : 5,
      "constraints" : [ {
        "constraintType" : "<",
        "version" : "version"
      }, {
        "constraintType" : "<",
        "version" : "version"
      } ]
    } ],
    "requiredMetadata" : "{}",
    "requiresHa" : True,
    "customModelId" : "customModelId",
    "id" : "id",
    "desiredMemory" : 2147483647,
    "isFrozen" : True,
    "requiredMetadataValues" : [ {
      "fieldName" : "fieldName",
      "value" : "value"
    }, {
      "fieldName" : "fieldName",
      "value" : "value"
    } ],
    "versionMajor" : 9,
    "versionMinor" : 3,
    "items" : [ {
      "fileName" : "fileName",
      "ref" : "ref",
      "repositoryLocation" : "repositoryLocation",
      "created" : "created",
      "filePath" : "filePath",
      "fileSource" : "fileSource",
      "storagePath" : "storagePath",
      "commitSha" : "commitSha",
      "id" : "id",
      "repositoryName" : "repositoryName",
      "repositoryFilePath" : "repositoryFilePath",
      "workspaceId" : "workspaceId"
    }, {
      "fileName" : "fileName",
      "ref" : "ref",
      "repositoryLocation" : "repositoryLocation",
      "created" : "created",
      "filePath" : "filePath",
      "fileSource" : "fileSource",
      "storagePath" : "storagePath",
      "commitSha" : "commitSha",
      "id" : "id",
      "repositoryName" : "repositoryName",
      "repositoryFilePath" : "repositoryFilePath",
      "workspaceId" : "workspaceId"
    } ]
  },
  "supportsBinaryClassification" : True,
  "name" : "name",
  "desiredMemory" : 2147483647,
  "positiveClassLabel" : "positiveClassLabel",
  "updated" : "updated"
})
    )
    result = CustomModelsApi.custom_models_retrieve(custom_model_id="customModelId_example", )
    assert isinstance(result, CustomModelResponse)


@responses.activate
def test_custom_models_api_custom_models_training_data_patch_many(unittest_endpoint):
    responses.add(
        responses.PATCH,
        '{endpoint}/api/v2/customModels/{customModelId}/trainingData/'.format(endpoint=unittest_endpoint,
        customModelId="customModelId_example", ),
        status=202,
        content_type='',
    )
    result = CustomModelsApi.custom_models_training_data_patch_many(custom_model_id="customModelId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_custom_models_api_custom_models_version_create_from_latest(unittest_endpoint):
    responses.add(
        responses.PATCH,
        '{endpoint}/api/v2/customModels/{customModelId}/versions/'.format(endpoint=unittest_endpoint,
        customModelId="customModelId_example", isMajorUpdate="True", ),
        status=201,
        content_type='application/json',
        body=json.dumps({
  "networkEgressPolicy" : "NONE",
  "baseEnvironmentVersionId" : "baseEnvironmentVersionId",
  "baseEnvironmentId" : "baseEnvironmentId",
  "created" : "created",
  "replicas" : 5,
  "description" : "description",
  "maximumMemory" : 2147483647,
  "label" : "label",
  "dependencies" : [ {
    "line" : "line",
    "packageName" : "packageName",
    "lineNumber" : 5,
    "constraints" : [ {
      "constraintType" : "<",
      "version" : "version"
    }, {
      "constraintType" : "<",
      "version" : "version"
    } ]
  }, {
    "line" : "line",
    "packageName" : "packageName",
    "lineNumber" : 5,
    "constraints" : [ {
      "constraintType" : "<",
      "version" : "version"
    }, {
      "constraintType" : "<",
      "version" : "version"
    } ]
  } ],
  "requiredMetadata" : "{}",
  "requiresHa" : True,
  "customModelId" : "customModelId",
  "id" : "id",
  "desiredMemory" : 2147483647,
  "isFrozen" : True,
  "requiredMetadataValues" : [ {
    "fieldName" : "fieldName",
    "value" : "value"
  }, {
    "fieldName" : "fieldName",
    "value" : "value"
  } ],
  "versionMajor" : 9,
  "versionMinor" : 3,
  "items" : [ {
    "fileName" : "fileName",
    "ref" : "ref",
    "repositoryLocation" : "repositoryLocation",
    "created" : "created",
    "filePath" : "filePath",
    "fileSource" : "fileSource",
    "storagePath" : "storagePath",
    "commitSha" : "commitSha",
    "id" : "id",
    "repositoryName" : "repositoryName",
    "repositoryFilePath" : "repositoryFilePath",
    "workspaceId" : "workspaceId"
  }, {
    "fileName" : "fileName",
    "ref" : "ref",
    "repositoryLocation" : "repositoryLocation",
    "created" : "created",
    "filePath" : "filePath",
    "fileSource" : "fileSource",
    "storagePath" : "storagePath",
    "commitSha" : "commitSha",
    "id" : "id",
    "repositoryName" : "repositoryName",
    "repositoryFilePath" : "repositoryFilePath",
    "workspaceId" : "workspaceId"
  } ]
})
    )
    result = CustomModelsApi.custom_models_version_create_from_latest(custom_model_id="customModelId_example", is_major_update="True", )
    assert isinstance(result, CustomModelVersionResponse)


@responses.activate
def test_custom_models_api_custom_models_versions_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/api/v2/customModels/{customModelId}/versions/'.format(endpoint=unittest_endpoint,
        customModelId="customModelId_example", isMajorUpdate="True", ),
        status=201,
        content_type='application/json',
        body=json.dumps({
  "networkEgressPolicy" : "NONE",
  "baseEnvironmentVersionId" : "baseEnvironmentVersionId",
  "baseEnvironmentId" : "baseEnvironmentId",
  "created" : "created",
  "replicas" : 5,
  "description" : "description",
  "maximumMemory" : 2147483647,
  "label" : "label",
  "dependencies" : [ {
    "line" : "line",
    "packageName" : "packageName",
    "lineNumber" : 5,
    "constraints" : [ {
      "constraintType" : "<",
      "version" : "version"
    }, {
      "constraintType" : "<",
      "version" : "version"
    } ]
  }, {
    "line" : "line",
    "packageName" : "packageName",
    "lineNumber" : 5,
    "constraints" : [ {
      "constraintType" : "<",
      "version" : "version"
    }, {
      "constraintType" : "<",
      "version" : "version"
    } ]
  } ],
  "requiredMetadata" : "{}",
  "requiresHa" : True,
  "customModelId" : "customModelId",
  "id" : "id",
  "desiredMemory" : 2147483647,
  "isFrozen" : True,
  "requiredMetadataValues" : [ {
    "fieldName" : "fieldName",
    "value" : "value"
  }, {
    "fieldName" : "fieldName",
    "value" : "value"
  } ],
  "versionMajor" : 9,
  "versionMinor" : 3,
  "items" : [ {
    "fileName" : "fileName",
    "ref" : "ref",
    "repositoryLocation" : "repositoryLocation",
    "created" : "created",
    "filePath" : "filePath",
    "fileSource" : "fileSource",
    "storagePath" : "storagePath",
    "commitSha" : "commitSha",
    "id" : "id",
    "repositoryName" : "repositoryName",
    "repositoryFilePath" : "repositoryFilePath",
    "workspaceId" : "workspaceId"
  }, {
    "fileName" : "fileName",
    "ref" : "ref",
    "repositoryLocation" : "repositoryLocation",
    "created" : "created",
    "filePath" : "filePath",
    "fileSource" : "fileSource",
    "storagePath" : "storagePath",
    "commitSha" : "commitSha",
    "id" : "id",
    "repositoryName" : "repositoryName",
    "repositoryFilePath" : "repositoryFilePath",
    "workspaceId" : "workspaceId"
  } ]
})
    )
    result = CustomModelsApi.custom_models_versions_create(custom_model_id="customModelId_example", is_major_update="True", )
    assert isinstance(result, CustomModelVersionResponse)


@responses.activate
def test_custom_models_api_custom_models_versions_dependency_build_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/api/v2/customModels/{customModelId}/versions/{customModelVersionId}/dependencyBuild/'.format(endpoint=unittest_endpoint,
        customModelId="customModelId_example", customModelVersionId="customModelVersionId_example", ),
        status=202,
        content_type='application/json',
        body=json.dumps({
  "buildEnd" : "buildEnd",
  "buildStart" : "buildStart",
  "buildLogLocation" : "https://openapi-generator.tech",
  "buildStatus" : "submitted"
})
    )
    result = CustomModelsApi.custom_models_versions_dependency_build_create(custom_model_id="customModelId_example", custom_model_version_id="customModelVersionId_example", )
    assert isinstance(result, BaseDependencyBuildMetadataResponse)


@responses.activate
def test_custom_models_api_custom_models_versions_dependency_build_delete_many(unittest_endpoint):
    responses.add(
        responses.DELETE,
        '{endpoint}/api/v2/customModels/{customModelId}/versions/{customModelVersionId}/dependencyBuild/'.format(endpoint=unittest_endpoint,
        customModelId="customModelId_example", customModelVersionId="customModelVersionId_example", ),
        status=204,
        content_type='',
    )
    result = CustomModelsApi.custom_models_versions_dependency_build_delete_many(custom_model_id="customModelId_example", custom_model_version_id="customModelVersionId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_custom_models_api_custom_models_versions_dependency_build_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/customModels/{customModelId}/versions/{customModelVersionId}/dependencyBuild/'.format(endpoint=unittest_endpoint,
        customModelId="customModelId_example", customModelVersionId="customModelVersionId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "buildEnd" : "buildEnd",
  "buildStart" : "buildStart",
  "buildLogLocation" : "https://openapi-generator.tech",
  "buildStatus" : "submitted"
})
    )
    result = CustomModelsApi.custom_models_versions_dependency_build_list(custom_model_id="customModelId_example", custom_model_version_id="customModelVersionId_example", )
    assert isinstance(result, BaseDependencyBuildMetadataResponse)


@responses.activate
def test_custom_models_api_custom_models_versions_dependency_build_log_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/customModels/{customModelId}/versions/{customModelVersionId}/dependencyBuildLog/'.format(endpoint=unittest_endpoint,
        customModelId="customModelId_example", customModelVersionId="customModelVersionId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "data" : ""
})
    )
    result = CustomModelsApi.custom_models_versions_dependency_build_log_list(custom_model_id="customModelId_example", custom_model_version_id="customModelVersionId_example", )
    assert isinstance(result, DependencyBuildLogResponse)


@responses.activate
def test_custom_models_api_custom_models_versions_download_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/customModels/{customModelId}/versions/{customModelVersionId}/download/'.format(endpoint=unittest_endpoint,
        customModelId="customModelId_example", customModelVersionId="customModelVersionId_example", ),
        status=200,
        content_type='',
    )
    result = CustomModelsApi.custom_models_versions_download_list(custom_model_id="customModelId_example", custom_model_version_id="customModelVersionId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_custom_models_api_custom_models_versions_feature_impact_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/api/v2/customModels/{customModelId}/versions/{customModelVersionId}/featureImpact/'.format(endpoint=unittest_endpoint,
        customModelId="customModelId_example", customModelVersionId="customModelVersionId_example", ),
        status=202,
        content_type='application/json',
        body=json.dumps({
  "statusId" : "statusId"
})
    )
    result = CustomModelsApi.custom_models_versions_feature_impact_create(custom_model_id="customModelId_example", custom_model_version_id="customModelVersionId_example", )
    assert isinstance(result, FeatureImpactCreateResponse)


@responses.activate
def test_custom_models_api_custom_models_versions_feature_impact_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/customModels/{customModelId}/versions/{customModelVersionId}/featureImpact/'.format(endpoint=unittest_endpoint,
        customModelId="customModelId_example", customModelVersionId="customModelVersionId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "ranRedundancyDetection" : True,
  "previous" : "https://openapi-generator.tech",
  "featureImpacts" : [ {
    "redundantWith" : "redundantWith",
    "featureName" : "featureName",
    "impactUnnormalized" : 1.4658129805029452,
    "impactNormalized" : 0.6027456183070403
  }, {
    "redundantWith" : "redundantWith",
    "featureName" : "featureName",
    "impactUnnormalized" : 1.4658129805029452,
    "impactNormalized" : 0.6027456183070403
  }, {
    "redundantWith" : "redundantWith",
    "featureName" : "featureName",
    "impactUnnormalized" : 1.4658129805029452,
    "impactNormalized" : 0.6027456183070403
  }, {
    "redundantWith" : "redundantWith",
    "featureName" : "featureName",
    "impactUnnormalized" : 1.4658129805029452,
    "impactNormalized" : 0.6027456183070403
  }, {
    "redundantWith" : "redundantWith",
    "featureName" : "featureName",
    "impactUnnormalized" : 1.4658129805029452,
    "impactNormalized" : 0.6027456183070403
  } ],
  "count" : 0,
  "rowCount" : 5,
  "shapBased" : True
})
    )
    result = CustomModelsApi.custom_models_versions_feature_impact_list(custom_model_id="customModelId_example", custom_model_version_id="customModelVersionId_example", )
    assert isinstance(result, FeatureImpactResponse)


@responses.activate
def test_custom_models_api_custom_models_versions_from_repository_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/api/v2/customModels/{customModelId}/versions/fromRepository/'.format(endpoint=unittest_endpoint,
        customModelId="customModelId_example", ),
        status=202,
        content_type='',
    )
    result = CustomModelsApi.custom_models_versions_from_repository_create(custom_model_id="customModelId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_custom_models_api_custom_models_versions_from_repository_patch_many(unittest_endpoint):
    responses.add(
        responses.PATCH,
        '{endpoint}/api/v2/customModels/{customModelId}/versions/fromRepository/'.format(endpoint=unittest_endpoint,
        customModelId="customModelId_example", ),
        status=202,
        content_type='',
    )
    result = CustomModelsApi.custom_models_versions_from_repository_patch_many(custom_model_id="customModelId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_custom_models_api_custom_models_versions_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/customModels/{customModelId}/versions/'.format(endpoint=unittest_endpoint,
        offset=0, limit=1000, customModelId="customModelId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "networkEgressPolicy" : "NONE",
    "baseEnvironmentVersionId" : "baseEnvironmentVersionId",
    "baseEnvironmentId" : "baseEnvironmentId",
    "created" : "created",
    "replicas" : 5,
    "description" : "description",
    "maximumMemory" : 2147483647,
    "label" : "label",
    "dependencies" : [ {
      "line" : "line",
      "packageName" : "packageName",
      "lineNumber" : 5,
      "constraints" : [ {
        "constraintType" : "<",
        "version" : "version"
      }, {
        "constraintType" : "<",
        "version" : "version"
      } ]
    }, {
      "line" : "line",
      "packageName" : "packageName",
      "lineNumber" : 5,
      "constraints" : [ {
        "constraintType" : "<",
        "version" : "version"
      }, {
        "constraintType" : "<",
        "version" : "version"
      } ]
    } ],
    "requiredMetadata" : "{}",
    "requiresHa" : True,
    "customModelId" : "customModelId",
    "id" : "id",
    "desiredMemory" : 2147483647,
    "isFrozen" : True,
    "requiredMetadataValues" : [ {
      "fieldName" : "fieldName",
      "value" : "value"
    }, {
      "fieldName" : "fieldName",
      "value" : "value"
    } ],
    "versionMajor" : 9,
    "versionMinor" : 3,
    "items" : [ {
      "fileName" : "fileName",
      "ref" : "ref",
      "repositoryLocation" : "repositoryLocation",
      "created" : "created",
      "filePath" : "filePath",
      "fileSource" : "fileSource",
      "storagePath" : "storagePath",
      "commitSha" : "commitSha",
      "id" : "id",
      "repositoryName" : "repositoryName",
      "repositoryFilePath" : "repositoryFilePath",
      "workspaceId" : "workspaceId"
    }, {
      "fileName" : "fileName",
      "ref" : "ref",
      "repositoryLocation" : "repositoryLocation",
      "created" : "created",
      "filePath" : "filePath",
      "fileSource" : "fileSource",
      "storagePath" : "storagePath",
      "commitSha" : "commitSha",
      "id" : "id",
      "repositoryName" : "repositoryName",
      "repositoryFilePath" : "repositoryFilePath",
      "workspaceId" : "workspaceId"
    } ]
  }, {
    "networkEgressPolicy" : "NONE",
    "baseEnvironmentVersionId" : "baseEnvironmentVersionId",
    "baseEnvironmentId" : "baseEnvironmentId",
    "created" : "created",
    "replicas" : 5,
    "description" : "description",
    "maximumMemory" : 2147483647,
    "label" : "label",
    "dependencies" : [ {
      "line" : "line",
      "packageName" : "packageName",
      "lineNumber" : 5,
      "constraints" : [ {
        "constraintType" : "<",
        "version" : "version"
      }, {
        "constraintType" : "<",
        "version" : "version"
      } ]
    }, {
      "line" : "line",
      "packageName" : "packageName",
      "lineNumber" : 5,
      "constraints" : [ {
        "constraintType" : "<",
        "version" : "version"
      }, {
        "constraintType" : "<",
        "version" : "version"
      } ]
    } ],
    "requiredMetadata" : "{}",
    "requiresHa" : True,
    "customModelId" : "customModelId",
    "id" : "id",
    "desiredMemory" : 2147483647,
    "isFrozen" : True,
    "requiredMetadataValues" : [ {
      "fieldName" : "fieldName",
      "value" : "value"
    }, {
      "fieldName" : "fieldName",
      "value" : "value"
    } ],
    "versionMajor" : 9,
    "versionMinor" : 3,
    "items" : [ {
      "fileName" : "fileName",
      "ref" : "ref",
      "repositoryLocation" : "repositoryLocation",
      "created" : "created",
      "filePath" : "filePath",
      "fileSource" : "fileSource",
      "storagePath" : "storagePath",
      "commitSha" : "commitSha",
      "id" : "id",
      "repositoryName" : "repositoryName",
      "repositoryFilePath" : "repositoryFilePath",
      "workspaceId" : "workspaceId"
    }, {
      "fileName" : "fileName",
      "ref" : "ref",
      "repositoryLocation" : "repositoryLocation",
      "created" : "created",
      "filePath" : "filePath",
      "fileSource" : "fileSource",
      "storagePath" : "storagePath",
      "commitSha" : "commitSha",
      "id" : "id",
      "repositoryName" : "repositoryName",
      "repositoryFilePath" : "repositoryFilePath",
      "workspaceId" : "workspaceId"
    } ]
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0,
  "totalCount" : 6
})
    )
    result = CustomModelsApi.custom_models_versions_list(offset=0, limit=1000, custom_model_id="customModelId_example", )
    assert isinstance(result, CustomModelVersionListResponse)


@responses.activate
def test_custom_models_api_custom_models_versions_patch(unittest_endpoint):
    responses.add(
        responses.PATCH,
        '{endpoint}/api/v2/customModels/{customModelId}/versions/{customModelVersionId}/'.format(endpoint=unittest_endpoint,
        customModelId="customModelId_example", customModelVersionId="customModelVersionId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "networkEgressPolicy" : "NONE",
  "baseEnvironmentVersionId" : "baseEnvironmentVersionId",
  "baseEnvironmentId" : "baseEnvironmentId",
  "created" : "created",
  "replicas" : 5,
  "description" : "description",
  "maximumMemory" : 2147483647,
  "label" : "label",
  "dependencies" : [ {
    "line" : "line",
    "packageName" : "packageName",
    "lineNumber" : 5,
    "constraints" : [ {
      "constraintType" : "<",
      "version" : "version"
    }, {
      "constraintType" : "<",
      "version" : "version"
    } ]
  }, {
    "line" : "line",
    "packageName" : "packageName",
    "lineNumber" : 5,
    "constraints" : [ {
      "constraintType" : "<",
      "version" : "version"
    }, {
      "constraintType" : "<",
      "version" : "version"
    } ]
  } ],
  "requiredMetadata" : "{}",
  "requiresHa" : True,
  "customModelId" : "customModelId",
  "id" : "id",
  "desiredMemory" : 2147483647,
  "isFrozen" : True,
  "requiredMetadataValues" : [ {
    "fieldName" : "fieldName",
    "value" : "value"
  }, {
    "fieldName" : "fieldName",
    "value" : "value"
  } ],
  "versionMajor" : 9,
  "versionMinor" : 3,
  "items" : [ {
    "fileName" : "fileName",
    "ref" : "ref",
    "repositoryLocation" : "repositoryLocation",
    "created" : "created",
    "filePath" : "filePath",
    "fileSource" : "fileSource",
    "storagePath" : "storagePath",
    "commitSha" : "commitSha",
    "id" : "id",
    "repositoryName" : "repositoryName",
    "repositoryFilePath" : "repositoryFilePath",
    "workspaceId" : "workspaceId"
  }, {
    "fileName" : "fileName",
    "ref" : "ref",
    "repositoryLocation" : "repositoryLocation",
    "created" : "created",
    "filePath" : "filePath",
    "fileSource" : "fileSource",
    "storagePath" : "storagePath",
    "commitSha" : "commitSha",
    "id" : "id",
    "repositoryName" : "repositoryName",
    "repositoryFilePath" : "repositoryFilePath",
    "workspaceId" : "workspaceId"
  } ]
})
    )
    result = CustomModelsApi.custom_models_versions_patch(custom_model_id="customModelId_example", custom_model_version_id="customModelVersionId_example", )
    assert isinstance(result, CustomModelVersionResponse)


@responses.activate
def test_custom_models_api_custom_models_versions_prediction_explanations_initialization_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/api/v2/customModels/{customModelId}/versions/{customModelVersionId}/predictionExplanationsInitialization/'.format(endpoint=unittest_endpoint,
        customModelId="customModelId_example", customModelVersionId="customModelVersionId_example", ),
        status=202,
        content_type='',
    )
    result = CustomModelsApi.custom_models_versions_prediction_explanations_initialization_create(custom_model_id="customModelId_example", custom_model_version_id="customModelVersionId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_custom_models_api_custom_models_versions_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/customModels/{customModelId}/versions/{customModelVersionId}/'.format(endpoint=unittest_endpoint,
        customModelId="customModelId_example", customModelVersionId="customModelVersionId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "networkEgressPolicy" : "NONE",
  "baseEnvironmentVersionId" : "baseEnvironmentVersionId",
  "baseEnvironmentId" : "baseEnvironmentId",
  "created" : "created",
  "replicas" : 5,
  "description" : "description",
  "maximumMemory" : 2147483647,
  "label" : "label",
  "dependencies" : [ {
    "line" : "line",
    "packageName" : "packageName",
    "lineNumber" : 5,
    "constraints" : [ {
      "constraintType" : "<",
      "version" : "version"
    }, {
      "constraintType" : "<",
      "version" : "version"
    } ]
  }, {
    "line" : "line",
    "packageName" : "packageName",
    "lineNumber" : 5,
    "constraints" : [ {
      "constraintType" : "<",
      "version" : "version"
    }, {
      "constraintType" : "<",
      "version" : "version"
    } ]
  } ],
  "requiredMetadata" : "{}",
  "requiresHa" : True,
  "customModelId" : "customModelId",
  "id" : "id",
  "desiredMemory" : 2147483647,
  "isFrozen" : True,
  "requiredMetadataValues" : [ {
    "fieldName" : "fieldName",
    "value" : "value"
  }, {
    "fieldName" : "fieldName",
    "value" : "value"
  } ],
  "versionMajor" : 9,
  "versionMinor" : 3,
  "items" : [ {
    "fileName" : "fileName",
    "ref" : "ref",
    "repositoryLocation" : "repositoryLocation",
    "created" : "created",
    "filePath" : "filePath",
    "fileSource" : "fileSource",
    "storagePath" : "storagePath",
    "commitSha" : "commitSha",
    "id" : "id",
    "repositoryName" : "repositoryName",
    "repositoryFilePath" : "repositoryFilePath",
    "workspaceId" : "workspaceId"
  }, {
    "fileName" : "fileName",
    "ref" : "ref",
    "repositoryLocation" : "repositoryLocation",
    "created" : "created",
    "filePath" : "filePath",
    "fileSource" : "fileSource",
    "storagePath" : "storagePath",
    "commitSha" : "commitSha",
    "id" : "id",
    "repositoryName" : "repositoryName",
    "repositoryFilePath" : "repositoryFilePath",
    "workspaceId" : "workspaceId"
  } ]
})
    )
    result = CustomModelsApi.custom_models_versions_retrieve(custom_model_id="customModelId_example", custom_model_version_id="customModelVersionId_example", )
    assert isinstance(result, CustomModelVersionResponse)


@responses.activate
def test_custom_models_api_custom_training_blueprints_create(unittest_endpoint):
    responses.add(
        responses.POST,
       '{endpoint}/api/v2/customTrainingBlueprints/'.format(endpoint=unittest_endpoint),
        status=201,
        content_type='application/json',
        body=json.dumps({
  "userBlueprintId" : "userBlueprintId",
  "createdAt" : "createdAt",
  "executionEnvironmentVersion" : {
    "id" : "id",
    "label" : "label"
  },
  "customModel" : {
    "name" : "name",
    "id" : "id"
  },
  "trainingHistory" : [ {
    "targetName" : "targetName",
    "lid" : "lid",
    "pid" : "pid",
    "creationDate" : "creationDate",
    "projectName" : "projectName",
    "projectModelsCount" : 6
  }, {
    "targetName" : "targetName",
    "lid" : "lid",
    "pid" : "pid",
    "creationDate" : "creationDate",
    "projectName" : "projectName",
    "projectModelsCount" : 6
  } ],
  "customModelVersion" : {
    "id" : "id",
    "label" : "label"
  },
  "targetType" : "Binary",
  "executionEnvironment" : {
    "name" : "name",
    "id" : "id"
  }
})
    )
    result = CustomModelsApi.custom_training_blueprints_create()
    assert isinstance(result, CustomTrainingBlueprintResponse)


@responses.activate
def test_custom_models_api_custom_training_blueprints_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/customTrainingBlueprints/'.format(endpoint=unittest_endpoint,
        offset=0, limit=1000, ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "userBlueprintId" : "userBlueprintId",
    "createdAt" : "createdAt",
    "executionEnvironmentVersion" : {
      "id" : "id",
      "label" : "label"
    },
    "customModel" : {
      "name" : "name",
      "id" : "id"
    },
    "trainingHistory" : [ {
      "targetName" : "targetName",
      "lid" : "lid",
      "pid" : "pid",
      "creationDate" : "creationDate",
      "projectName" : "projectName",
      "projectModelsCount" : 6
    }, {
      "targetName" : "targetName",
      "lid" : "lid",
      "pid" : "pid",
      "creationDate" : "creationDate",
      "projectName" : "projectName",
      "projectModelsCount" : 6
    } ],
    "customModelVersion" : {
      "id" : "id",
      "label" : "label"
    },
    "targetType" : "Binary",
    "executionEnvironment" : {
      "name" : "name",
      "id" : "id"
    }
  }, {
    "userBlueprintId" : "userBlueprintId",
    "createdAt" : "createdAt",
    "executionEnvironmentVersion" : {
      "id" : "id",
      "label" : "label"
    },
    "customModel" : {
      "name" : "name",
      "id" : "id"
    },
    "trainingHistory" : [ {
      "targetName" : "targetName",
      "lid" : "lid",
      "pid" : "pid",
      "creationDate" : "creationDate",
      "projectName" : "projectName",
      "projectModelsCount" : 6
    }, {
      "targetName" : "targetName",
      "lid" : "lid",
      "pid" : "pid",
      "creationDate" : "creationDate",
      "projectName" : "projectName",
      "projectModelsCount" : 6
    } ],
    "customModelVersion" : {
      "id" : "id",
      "label" : "label"
    },
    "targetType" : "Binary",
    "executionEnvironment" : {
      "name" : "name",
      "id" : "id"
    }
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0,
  "totalCount" : 1
})
    )
    result = CustomModelsApi.custom_training_blueprints_list(offset=0, limit=1000, )
    assert isinstance(result, CustomTrainingBlueprintListResponse)
