#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import json
import responses
from six.moves.urllib.parse import urljoin
from dateutil import parser
from datarobot.models.testing.generated.model.data_source_create import DataSourceCreate
from datarobot.models.testing.generated.model.data_source_describe_permissions_response import DataSourceDescribePermissionsResponse
from datarobot.models.testing.generated.model.data_source_list_response import DataSourceListResponse
from datarobot.models.testing.generated.model.data_source_retrieve_response import DataSourceRetrieveResponse
from datarobot.models.testing.generated.model.data_source_update import DataSourceUpdate
from datarobot.models.testing.generated.model.shared_roles_update_with_grant import SharedRolesUpdateWithGrant
from datarobot.models.testing.generated.model.shared_roles_with_grant_list_response import SharedRolesWithGrantListResponse
from datarobot.models.testing.generated.model.sharing_list_response import SharingListResponse
from datarobot.models.testing.generated.model.sharing_update_or_remove_with_grant import SharingUpdateOrRemoveWithGrant
from datarobot.utils import from_api
from datarobot.models.testing.generated.model import *

from datarobot.models.testing.generated.api.data_sources_api import DataSourcesApi




@responses.activate
def test_data_sources_api_external_data_sources_access_control_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/externalDataSources/{dataSourceId}/accessControl/'.format(endpoint=unittest_endpoint,
        offset=0, limit=0, dataSourceId="dataSourceId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "next",
  "data" : [ {
    "role" : "role",
    "canShare" : True,
    "userId" : "userId",
    "username" : "username"
  }, {
    "role" : "role",
    "canShare" : True,
    "userId" : "userId",
    "username" : "username"
  } ],
  "previous" : "previous",
  "count" : 0
})
    )
    result = DataSourcesApi.external_data_sources_access_control_list(offset=0, limit=0, data_source_id="dataSourceId_example", )
    assert isinstance(result, SharingListResponse)


@responses.activate
def test_data_sources_api_external_data_sources_access_control_patch_many(unittest_endpoint):
    responses.add(
        responses.PATCH,
        '{endpoint}/api/v2/externalDataSources/{dataSourceId}/accessControl/'.format(endpoint=unittest_endpoint,
        dataSourceId="dataSourceId_example", ),
        status=204,
        content_type='',
    )
    result = DataSourcesApi.external_data_sources_access_control_patch_many(data_source_id="dataSourceId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_data_sources_api_external_data_sources_create(unittest_endpoint):
    responses.add(
        responses.POST,
       '{endpoint}/api/v2/externalDataSources/'.format(endpoint=unittest_endpoint),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "creator" : "creator",
  "role" : "OWNER",
  "id" : "id",
  "params" : "",
  "type" : "jdbc",
  "updated" : "updated",
  "canonicalName" : "canonicalName"
})
    )
    result = DataSourcesApi.external_data_sources_create()
    assert isinstance(result, DataSourceRetrieveResponse)


@responses.activate
def test_data_sources_api_external_data_sources_delete(unittest_endpoint):
    responses.add(
        responses.DELETE,
        '{endpoint}/api/v2/externalDataSources/{dataSourceId}/'.format(endpoint=unittest_endpoint,
        dataSourceId="dataSourceId_example", ),
        status=204,
        content_type='',
    )
    result = DataSourcesApi.external_data_sources_delete(data_source_id="dataSourceId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_data_sources_api_external_data_sources_list(unittest_endpoint):
    responses.add(
        responses.GET,
       '{endpoint}/api/v2/externalDataSources/'.format(endpoint=unittest_endpoint),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "data" : [ {
    "creator" : "creator",
    "role" : "OWNER",
    "canShare" : True,
    "canDelete" : True,
    "id" : "id",
    "params" : "",
    "type" : "jdbc",
    "updated" : "updated",
    "canonicalName" : "canonicalName"
  }, {
    "creator" : "creator",
    "role" : "OWNER",
    "canShare" : True,
    "canDelete" : True,
    "id" : "id",
    "params" : "",
    "type" : "jdbc",
    "updated" : "updated",
    "canonicalName" : "canonicalName"
  } ]
})
    )
    result = DataSourcesApi.external_data_sources_list()
    assert isinstance(result, DataSourceListResponse)


@responses.activate
def test_data_sources_api_external_data_sources_patch(unittest_endpoint):
    responses.add(
        responses.PATCH,
        '{endpoint}/api/v2/externalDataSources/{dataSourceId}/'.format(endpoint=unittest_endpoint,
        dataSourceId="dataSourceId_example", ),
        status=204,
        content_type='',
    )
    result = DataSourcesApi.external_data_sources_patch(data_source_id="dataSourceId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_data_sources_api_external_data_sources_permissions_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/externalDataSources/{dataSourceId}/permissions/'.format(endpoint=unittest_endpoint,
        dataSourceId="dataSourceId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "canView" : True,
  "canCreateProject" : True,
  "dataSourceId" : "dataSourceId",
  "canSetRoles" : [ "OWNER", "OWNER" ],
  "canEdit" : True,
  "canShare" : True,
  "canCreatePredictions" : True,
  "canDelete" : True,
  "userId" : "userId",
  "username" : "username"
})
    )
    result = DataSourcesApi.external_data_sources_permissions_list(data_source_id="dataSourceId_example", )
    assert isinstance(result, DataSourceDescribePermissionsResponse)


@responses.activate
def test_data_sources_api_external_data_sources_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/externalDataSources/{dataSourceId}/'.format(endpoint=unittest_endpoint,
        dataSourceId="dataSourceId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "creator" : "creator",
  "role" : "OWNER",
  "id" : "id",
  "params" : "",
  "type" : "jdbc",
  "updated" : "updated",
  "canonicalName" : "canonicalName"
})
    )
    result = DataSourcesApi.external_data_sources_retrieve(data_source_id="dataSourceId_example", )
    assert isinstance(result, DataSourceRetrieveResponse)


@responses.activate
def test_data_sources_api_external_data_sources_shared_roles_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/externalDataSources/{dataSourceId}/sharedRoles/'.format(endpoint=unittest_endpoint,
        offset=0, limit=10, dataSourceId="dataSourceId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "next",
  "data" : [ {
    "shareRecipientType" : "user",
    "role" : "ADMIN",
    "canShare" : True,
    "name" : "name",
    "userFullName" : "userFullName",
    "id" : "id"
  }, {
    "shareRecipientType" : "user",
    "role" : "ADMIN",
    "canShare" : True,
    "name" : "name",
    "userFullName" : "userFullName",
    "id" : "id"
  } ],
  "previous" : "previous",
  "count" : 0,
  "totalCount" : 6
})
    )
    result = DataSourcesApi.external_data_sources_shared_roles_list(offset=0, limit=10, data_source_id="dataSourceId_example", )
    assert isinstance(result, SharedRolesWithGrantListResponse)


@responses.activate
def test_data_sources_api_external_data_sources_shared_roles_patch_many(unittest_endpoint):
    responses.add(
        responses.PATCH,
        '{endpoint}/api/v2/externalDataSources/{dataSourceId}/sharedRoles/'.format(endpoint=unittest_endpoint,
        dataSourceId="dataSourceId_example", ),
        status=204,
        content_type='',
    )
    result = DataSourcesApi.external_data_sources_shared_roles_patch_many(data_source_id="dataSourceId_example", )
    assert isinstance(result, type(None))
