#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import json
import responses
from six.moves.urllib.parse import urljoin
from dateutil import parser
from datarobot.models.testing.generated.model.credentials_list_response import CredentialsListResponse
from datarobot.models.testing.generated.model.data_store_create import DataStoreCreate
from datarobot.models.testing.generated.model.data_store_credentials import DataStoreCredentials
from datarobot.models.testing.generated.model.data_store_credentials_with_credentials_type_support import DataStoreCredentialsWithCredentialsTypeSupport
from datarobot.models.testing.generated.model.data_store_describe_permissions_response import DataStoreDescribePermissionsResponse
from datarobot.models.testing.generated.model.data_store_list_response import DataStoreListResponse
from datarobot.models.testing.generated.model.data_store_retrieve_response import DataStoreRetrieveResponse
from datarobot.models.testing.generated.model.data_store_sql_verify import DataStoreSQLVerify
from datarobot.models.testing.generated.model.data_store_sql_verify_response import DataStoreSQLVerifyResponse
from datarobot.models.testing.generated.model.data_store_schemas_list import DataStoreSchemasList
from datarobot.models.testing.generated.model.data_store_tables import DataStoreTables
from datarobot.models.testing.generated.model.data_store_tables_list import DataStoreTablesList
from datarobot.models.testing.generated.model.data_store_test_response import DataStoreTestResponse
from datarobot.models.testing.generated.model.data_store_update import DataStoreUpdate
from datarobot.models.testing.generated.model.shared_roles_update_with_grant import SharedRolesUpdateWithGrant
from datarobot.models.testing.generated.model.shared_roles_with_grant_list_response import SharedRolesWithGrantListResponse
from datarobot.models.testing.generated.model.sharing_update_or_remove_with_grant import SharingUpdateOrRemoveWithGrant
from datarobot.utils import from_api
from datarobot.models.testing.generated.model import *

from datarobot.models.testing.generated.api.data_stores_api import DataStoresApi




@responses.activate
def test_data_stores_api_external_data_stores_access_control_patch_many(unittest_endpoint):
    responses.add(
        responses.PATCH,
        '{endpoint}/api/v2/externalDataStores/{dataStoreId}/accessControl/'.format(endpoint=unittest_endpoint,
        dataStoreId="dataStoreId_example", ),
        status=204,
        content_type='',
    )
    result = DataStoresApi.external_data_stores_access_control_patch_many(data_store_id="dataStoreId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_data_stores_api_external_data_stores_create(unittest_endpoint):
    responses.add(
        responses.POST,
       '{endpoint}/api/v2/externalDataStores/'.format(endpoint=unittest_endpoint),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "creator" : "creator",
  "role" : "OWNER",
  "associatedAuthTypes" : [ "oauth", "oauth" ],
  "id" : "id",
  "params" : "",
  "type" : "jdbc",
  "updated" : "updated",
  "canonicalName" : "canonicalName"
})
    )
    result = DataStoresApi.external_data_stores_create()
    assert isinstance(result, DataStoreRetrieveResponse)


@responses.activate
def test_data_stores_api_external_data_stores_credentials_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/externalDataStores/{dataStoreId}/credentials/'.format(endpoint=unittest_endpoint,
        dataStoreId="dataStoreId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "credentialType" : "basic",
    "name" : "name",
    "credentialId" : "credentialId",
    "description" : "description",
    "creationDate" : "2000-01-23T04:56:07.000+00:00"
  }, {
    "credentialType" : "basic",
    "name" : "name",
    "credentialId" : "credentialId",
    "description" : "description",
    "creationDate" : "2000-01-23T04:56:07.000+00:00"
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0,
  "totalCount" : 6
})
    )
    result = DataStoresApi.external_data_stores_credentials_list(data_store_id="dataStoreId_example", )
    assert isinstance(result, CredentialsListResponse)


@responses.activate
def test_data_stores_api_external_data_stores_delete(unittest_endpoint):
    responses.add(
        responses.DELETE,
        '{endpoint}/api/v2/externalDataStores/{dataStoreId}/'.format(endpoint=unittest_endpoint,
        dataStoreId="dataStoreId_example", ),
        status=204,
        content_type='',
    )
    result = DataStoresApi.external_data_stores_delete(data_store_id="dataStoreId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_data_stores_api_external_data_stores_list(unittest_endpoint):
    responses.add(
        responses.GET,
       '{endpoint}/api/v2/externalDataStores/'.format(endpoint=unittest_endpoint),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "data" : [ {
    "creator" : "creator",
    "role" : "OWNER",
    "associatedAuthTypes" : [ "oauth", "oauth" ],
    "id" : "id",
    "params" : "",
    "type" : "jdbc",
    "updated" : "updated",
    "canonicalName" : "canonicalName"
  }, {
    "creator" : "creator",
    "role" : "OWNER",
    "associatedAuthTypes" : [ "oauth", "oauth" ],
    "id" : "id",
    "params" : "",
    "type" : "jdbc",
    "updated" : "updated",
    "canonicalName" : "canonicalName"
  } ]
})
    )
    result = DataStoresApi.external_data_stores_list()
    assert isinstance(result, DataStoreListResponse)


@responses.activate
def test_data_stores_api_external_data_stores_patch(unittest_endpoint):
    responses.add(
        responses.PATCH,
        '{endpoint}/api/v2/externalDataStores/{dataStoreId}/'.format(endpoint=unittest_endpoint,
        dataStoreId="dataStoreId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "creator" : "creator",
  "role" : "OWNER",
  "associatedAuthTypes" : [ "oauth", "oauth" ],
  "id" : "id",
  "params" : "",
  "type" : "jdbc",
  "updated" : "updated",
  "canonicalName" : "canonicalName"
})
    )
    result = DataStoresApi.external_data_stores_patch(data_store_id="dataStoreId_example", )
    assert isinstance(result, DataStoreRetrieveResponse)


@responses.activate
def test_data_stores_api_external_data_stores_permissions_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/externalDataStores/{dataStoreId}/permissions/'.format(endpoint=unittest_endpoint,
        dataStoreId="dataStoreId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "canView" : True,
  "canScanDatabase" : True,
  "canCreateDataSource" : True,
  "dataStoreId" : "dataStoreId",
  "canSetRoles" : [ "OWNER", "OWNER" ],
  "canEdit" : True,
  "canShare" : True,
  "canTestConnection" : True,
  "canDelete" : True,
  "userId" : "userId",
  "username" : "username"
})
    )
    result = DataStoresApi.external_data_stores_permissions_list(data_store_id="dataStoreId_example", )
    assert isinstance(result, DataStoreDescribePermissionsResponse)


@responses.activate
def test_data_stores_api_external_data_stores_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/externalDataStores/{dataStoreId}/'.format(endpoint=unittest_endpoint,
        dataStoreId="dataStoreId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "creator" : "creator",
  "role" : "OWNER",
  "associatedAuthTypes" : [ "oauth", "oauth" ],
  "id" : "id",
  "params" : "",
  "type" : "jdbc",
  "updated" : "updated",
  "canonicalName" : "canonicalName"
})
    )
    result = DataStoresApi.external_data_stores_retrieve(data_store_id="dataStoreId_example", )
    assert isinstance(result, DataStoreRetrieveResponse)


@responses.activate
def test_data_stores_api_external_data_stores_schemas_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/api/v2/externalDataStores/{dataStoreId}/schemas/'.format(endpoint=unittest_endpoint,
        dataStoreId="dataStoreId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "catalog" : "catalog",
  "catalogs" : [ "catalogs", "catalogs" ],
  "schemas" : [ "schemas", "schemas" ]
})
    )
    result = DataStoresApi.external_data_stores_schemas_create(data_store_id="dataStoreId_example", )
    assert isinstance(result, DataStoreSchemasList)


@responses.activate
def test_data_stores_api_external_data_stores_shared_roles_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/externalDataStores/{dataStoreId}/sharedRoles/'.format(endpoint=unittest_endpoint,
        offset=0, limit=10, dataStoreId="dataStoreId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "next",
  "data" : [ {
    "shareRecipientType" : "user",
    "role" : "ADMIN",
    "canShare" : True,
    "name" : "name",
    "userFullName" : "userFullName",
    "id" : "id"
  }, {
    "shareRecipientType" : "user",
    "role" : "ADMIN",
    "canShare" : True,
    "name" : "name",
    "userFullName" : "userFullName",
    "id" : "id"
  } ],
  "previous" : "previous",
  "count" : 0,
  "totalCount" : 6
})
    )
    result = DataStoresApi.external_data_stores_shared_roles_list(offset=0, limit=10, data_store_id="dataStoreId_example", )
    assert isinstance(result, SharedRolesWithGrantListResponse)


@responses.activate
def test_data_stores_api_external_data_stores_shared_roles_patch_many(unittest_endpoint):
    responses.add(
        responses.PATCH,
        '{endpoint}/api/v2/externalDataStores/{dataStoreId}/sharedRoles/'.format(endpoint=unittest_endpoint,
        dataStoreId="dataStoreId_example", ),
        status=204,
        content_type='',
    )
    result = DataStoresApi.external_data_stores_shared_roles_patch_many(data_store_id="dataStoreId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_data_stores_api_external_data_stores_tables_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/api/v2/externalDataStores/{dataStoreId}/tables/'.format(endpoint=unittest_endpoint,
        dataStoreId="dataStoreId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "tables" : [ {
    "schema" : "schema",
    "catalog" : "catalog",
    "name" : "name",
    "type" : "TABLE"
  }, {
    "schema" : "schema",
    "catalog" : "catalog",
    "name" : "name",
    "type" : "TABLE"
  } ],
  "catalog" : "catalog"
})
    )
    result = DataStoresApi.external_data_stores_tables_create(data_store_id="dataStoreId_example", )
    assert isinstance(result, DataStoreTablesList)


@responses.activate
def test_data_stores_api_external_data_stores_test_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/api/v2/externalDataStores/{dataStoreId}/test/'.format(endpoint=unittest_endpoint,
        dataStoreId="dataStoreId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "message" : "message"
})
    )
    result = DataStoresApi.external_data_stores_test_create(data_store_id="dataStoreId_example", )
    assert isinstance(result, DataStoreTestResponse)


@responses.activate
def test_data_stores_api_external_data_stores_verify_sql_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/api/v2/externalDataStores/{dataStoreId}/verifySQL/'.format(endpoint=unittest_endpoint,
        dataStoreId="dataStoreId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "records" : [ [ "records", "records" ], [ "records", "records" ] ],
  "columns" : [ "columns", "columns" ]
})
    )
    result = DataStoresApi.external_data_stores_verify_sql_create(data_store_id="dataStoreId_example", )
    assert isinstance(result, DataStoreSQLVerifyResponse)
