#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import json
import responses
from six.moves.urllib.parse import urljoin
from dateutil import parser
from datarobot.models.testing.generated.model.automated_doc_create import AutomatedDocCreate
from datarobot.models.testing.generated.model.automated_doc_list_response import AutomatedDocListResponse
from datarobot.models.testing.generated.model.automated_doc_options_response import AutomatedDocOptionsResponse
from datarobot.models.testing.generated.model.compliance_doc_template_create import ComplianceDocTemplateCreate
from datarobot.models.testing.generated.model.compliance_doc_template_create_response import ComplianceDocTemplateCreateResponse
from datarobot.models.testing.generated.model.compliance_doc_template_default_retrieve_response import ComplianceDocTemplateDefaultRetrieveResponse
from datarobot.models.testing.generated.model.compliance_doc_template_list_response import ComplianceDocTemplateListResponse
from datarobot.models.testing.generated.model.compliance_doc_template_update import ComplianceDocTemplateUpdate
from datarobot.models.testing.generated.model.shared_roles_update import SharedRolesUpdate
from datarobot.models.testing.generated.model.sharing_list_v2_response import SharingListV2Response
from datarobot.models.testing.generated.model.template_response import TemplateResponse
from datarobot.utils import from_api
from datarobot.models.testing.generated.model import *

from datarobot.models.testing.generated.api.documentation_api import DocumentationApi




@responses.activate
def test_documentation_api_automated_document_options_list(unittest_endpoint):
    responses.add(
        responses.GET,
       '{endpoint}/api/v2/automatedDocumentOptions/'.format(endpoint=unittest_endpoint),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "data" : [ {
    "documentType" : "MODEL_COMPLIANCE",
    "locale" : "EN_US"
  }, {
    "documentType" : "MODEL_COMPLIANCE",
    "locale" : "EN_US"
  } ]
})
    )
    result = DocumentationApi.automated_document_options_list()
    assert isinstance(result, AutomatedDocOptionsResponse)


@responses.activate
def test_documentation_api_automated_documents_create(unittest_endpoint):
    responses.add(
        responses.POST,
       '{endpoint}/api/v2/automatedDocuments/'.format(endpoint=unittest_endpoint),
        status=202,
        content_type='',
    )
    result = DocumentationApi.automated_documents_create()
    assert isinstance(result, type(None))


@responses.activate
def test_documentation_api_automated_documents_delete(unittest_endpoint):
    responses.add(
        responses.DELETE,
        '{endpoint}/api/v2/automatedDocuments/{documentId}/'.format(endpoint=unittest_endpoint,
        documentId="documentId_example", ),
        status=204,
        content_type='',
    )
    result = DocumentationApi.automated_documents_delete(document_id="documentId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_documentation_api_automated_documents_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/automatedDocuments/'.format(endpoint=unittest_endpoint,
        offset=0, limit=100, ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "createdAt" : "2000-01-23T04:56:07.000+00:00",
    "documentType" : "MODEL_COMPLIANCE",
    "entityId" : "entityId",
    "id" : "id",
    "locale" : "EN_US",
    "templateId" : "templateId",
    "outputFormat" : "docx",
    "docTypeSpecificInfo" : {
      "modelName" : "modelName",
      "endDate" : "2000-01-23T04:56:07.000+00:00",
      "startDate" : "2000-01-23T04:56:07.000+00:00"
    }
  }, {
    "createdAt" : "2000-01-23T04:56:07.000+00:00",
    "documentType" : "MODEL_COMPLIANCE",
    "entityId" : "entityId",
    "id" : "id",
    "locale" : "EN_US",
    "templateId" : "templateId",
    "outputFormat" : "docx",
    "docTypeSpecificInfo" : {
      "modelName" : "modelName",
      "endDate" : "2000-01-23T04:56:07.000+00:00",
      "startDate" : "2000-01-23T04:56:07.000+00:00"
    }
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0,
  "totalCount" : 6
})
    )
    result = DocumentationApi.automated_documents_list(offset=0, limit=100, )
    assert isinstance(result, AutomatedDocListResponse)


@responses.activate
def test_documentation_api_automated_documents_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/automatedDocuments/{documentId}/'.format(endpoint=unittest_endpoint,
        documentId="documentId_example", ),
        status=200,
        content_type='',
    )
    result = DocumentationApi.automated_documents_retrieve(document_id="documentId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_documentation_api_compliance_doc_templates_create(unittest_endpoint):
    responses.add(
        responses.POST,
       '{endpoint}/api/v2/complianceDocTemplates/'.format(endpoint=unittest_endpoint),
        status=201,
        content_type='application/json',
        body=json.dumps({
  "dateModified" : "2000-01-23T04:56:07.000+00:00",
  "id" : "id"
})
    )
    result = DocumentationApi.compliance_doc_templates_create()
    assert isinstance(result, ComplianceDocTemplateCreateResponse)


@responses.activate
def test_documentation_api_compliance_doc_templates_default_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/complianceDocTemplates/default/'.format(endpoint=unittest_endpoint,
        type="normal", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "sections" : [ "", "" ]
})
    )
    result = DocumentationApi.compliance_doc_templates_default_list(type="normal", )
    assert isinstance(result, ComplianceDocTemplateDefaultRetrieveResponse)


@responses.activate
def test_documentation_api_compliance_doc_templates_delete(unittest_endpoint):
    responses.add(
        responses.DELETE,
        '{endpoint}/api/v2/complianceDocTemplates/{templateId}/'.format(endpoint=unittest_endpoint,
        templateId="templateId_example", ),
        status=204,
        content_type='',
    )
    result = DocumentationApi.compliance_doc_templates_delete(template_id="templateId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_documentation_api_compliance_doc_templates_list(unittest_endpoint):
    responses.add(
        responses.GET,
       '{endpoint}/api/v2/complianceDocTemplates/'.format(endpoint=unittest_endpoint),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "instructions" : "instructions",
    "permissions" : {
      "CAN_VIEW" : True,
      "CAN_DELETE_TEMPLATE" : True,
      "CAN_USE_TEMPLATE" : True,
      "CAN_SHARE" : True,
      "CAN_EDIT_TEMPLATE" : True
    },
    "creatorUsername" : "creatorUsername",
    "creatorId" : "creatorId",
    "name" : "name",
    "projectType" : "timeSeries",
    "description" : "description",
    "dateModified" : "2000-01-23T04:56:07.000+00:00",
    "id" : "id",
    "orgId" : "orgId",
    "sections" : [ "", "" ],
    "labels" : [ "labels", "labels" ]
  }, {
    "instructions" : "instructions",
    "permissions" : {
      "CAN_VIEW" : True,
      "CAN_DELETE_TEMPLATE" : True,
      "CAN_USE_TEMPLATE" : True,
      "CAN_SHARE" : True,
      "CAN_EDIT_TEMPLATE" : True
    },
    "creatorUsername" : "creatorUsername",
    "creatorId" : "creatorId",
    "name" : "name",
    "projectType" : "timeSeries",
    "description" : "description",
    "dateModified" : "2000-01-23T04:56:07.000+00:00",
    "id" : "id",
    "orgId" : "orgId",
    "sections" : [ "", "" ],
    "labels" : [ "labels", "labels" ]
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0,
  "totalCount" : 6
})
    )
    result = DocumentationApi.compliance_doc_templates_list()
    assert isinstance(result, ComplianceDocTemplateListResponse)


@responses.activate
def test_documentation_api_compliance_doc_templates_patch(unittest_endpoint):
    responses.add(
        responses.PATCH,
        '{endpoint}/api/v2/complianceDocTemplates/{templateId}/'.format(endpoint=unittest_endpoint,
        templateId="templateId_example", ),
        status=204,
        content_type='',
    )
    result = DocumentationApi.compliance_doc_templates_patch(template_id="templateId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_documentation_api_compliance_doc_templates_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/complianceDocTemplates/{templateId}/'.format(endpoint=unittest_endpoint,
        templateId="templateId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "instructions" : "instructions",
  "permissions" : {
    "CAN_VIEW" : True,
    "CAN_DELETE_TEMPLATE" : True,
    "CAN_USE_TEMPLATE" : True,
    "CAN_SHARE" : True,
    "CAN_EDIT_TEMPLATE" : True
  },
  "creatorUsername" : "creatorUsername",
  "creatorId" : "creatorId",
  "name" : "name",
  "projectType" : "timeSeries",
  "description" : "description",
  "dateModified" : "2000-01-23T04:56:07.000+00:00",
  "id" : "id",
  "orgId" : "orgId",
  "sections" : [ "", "" ],
  "labels" : [ "labels", "labels" ]
})
    )
    result = DocumentationApi.compliance_doc_templates_retrieve(template_id="templateId_example", )
    assert isinstance(result, TemplateResponse)


@responses.activate
def test_documentation_api_compliance_doc_templates_shared_roles_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/complianceDocTemplates/{templateId}/sharedRoles/'.format(endpoint=unittest_endpoint,
        offset=0, limit=10, templateId="templateId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "next",
  "data" : [ {
    "shareRecipientType" : "user",
    "role" : "ADMIN",
    "name" : "name",
    "id" : "id"
  }, {
    "shareRecipientType" : "user",
    "role" : "ADMIN",
    "name" : "name",
    "id" : "id"
  } ],
  "previous" : "previous",
  "count" : 0,
  "totalCount" : 6
})
    )
    result = DocumentationApi.compliance_doc_templates_shared_roles_list(offset=0, limit=10, template_id="templateId_example", )
    assert isinstance(result, SharingListV2Response)


@responses.activate
def test_documentation_api_compliance_doc_templates_shared_roles_patch_many(unittest_endpoint):
    responses.add(
        responses.PATCH,
        '{endpoint}/api/v2/complianceDocTemplates/{templateId}/sharedRoles/'.format(endpoint=unittest_endpoint,
        templateId="templateId_example", ),
        status=204,
        content_type='',
    )
    result = DocumentationApi.compliance_doc_templates_shared_roles_patch_many(template_id="templateId_example", )
    assert isinstance(result, type(None))
