#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import json
import responses
from six.moves.urllib.parse import urljoin
from dateutil import parser
from datarobot.models.testing.generated.model.feature_discovery_log_list_response import FeatureDiscoveryLogListResponse
from datarobot.models.testing.generated.model.feature_discovery_recipe_sqls_export import FeatureDiscoveryRecipeSQLsExport
from datarobot.models.testing.generated.model.relationships_config_create import RelationshipsConfigCreate
from datarobot.models.testing.generated.model.relationships_config_response import RelationshipsConfigResponse
from datarobot.utils import from_api
from datarobot.models.testing.generated.model import *

from datarobot.models.testing.generated.api.feature_discovery_api import FeatureDiscoveryApi




@responses.activate
def test_feature_discovery_api_projects_feature_discovery_dataset_download_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/featureDiscoveryDatasetDownload/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", ),
        status=200,
        content_type='',
    )
    result = FeatureDiscoveryApi.projects_feature_discovery_dataset_download_list(project_id="projectId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_feature_discovery_api_projects_feature_discovery_logs_download_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/featureDiscoveryLogs/download/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", ),
        status=200,
        content_type='',
    )
    result = FeatureDiscoveryApi.projects_feature_discovery_logs_download_list(project_id="projectId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_feature_discovery_api_projects_feature_discovery_logs_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/featureDiscoveryLogs/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "previous" : "https://openapi-generator.tech",
  "featureDiscoveryLog" : [ "featureDiscoveryLog", "featureDiscoveryLog" ],
  "totalLogLines" : 6,
  "count" : 0
})
    )
    result = FeatureDiscoveryApi.projects_feature_discovery_logs_list(project_id="projectId_example", )
    assert isinstance(result, FeatureDiscoveryLogListResponse)


@responses.activate
def test_feature_discovery_api_projects_feature_discovery_recipe_sql_exports_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/api/v2/projects/{projectId}/featureDiscoveryRecipeSqlExports/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", ),
        status=202,
        content_type='',
    )
    result = FeatureDiscoveryApi.projects_feature_discovery_recipe_sql_exports_create(project_id="projectId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_feature_discovery_api_projects_feature_discovery_recipe_sqls_download_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/featureDiscoveryRecipeSQLs/download/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", ),
        status=200,
        content_type='',
    )
    result = FeatureDiscoveryApi.projects_feature_discovery_recipe_sqls_download_list(project_id="projectId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_feature_discovery_api_relationships_configurations_create(unittest_endpoint):
    responses.add(
        responses.POST,
       '{endpoint}/api/v2/relationshipsConfigurations/'.format(endpoint=unittest_endpoint),
        status=201,
        content_type='application/json',
        body=json.dumps({
  "relationships" : [ {
    "featureDerivationWindowEnd" : 0,
    "dataset1Identifier" : "dataset1Identifier",
    "dataset2Keys" : [ "dataset2Keys", "dataset2Keys", "dataset2Keys", "dataset2Keys", "dataset2Keys" ],
    "dataset1Keys" : [ "dataset1Keys", "dataset1Keys", "dataset1Keys", "dataset1Keys", "dataset1Keys" ],
    "predictionPointRounding" : 4,
    "predictionPointRoundingTimeUnit" : "MILLISECOND",
    "dataset2Identifier" : "dataset2Identifier",
    "featureDerivationWindowStart" : 0,
    "featureDerivationWindowTimeUnit" : "MILLISECOND"
  }, {
    "featureDerivationWindowEnd" : 0,
    "dataset1Identifier" : "dataset1Identifier",
    "dataset2Keys" : [ "dataset2Keys", "dataset2Keys", "dataset2Keys", "dataset2Keys", "dataset2Keys" ],
    "dataset1Keys" : [ "dataset1Keys", "dataset1Keys", "dataset1Keys", "dataset1Keys", "dataset1Keys" ],
    "predictionPointRounding" : 4,
    "predictionPointRoundingTimeUnit" : "MILLISECOND",
    "dataset2Identifier" : "dataset2Identifier",
    "featureDerivationWindowStart" : 0,
    "featureDerivationWindowTimeUnit" : "MILLISECOND"
  } ],
  "featureDiscoverySettings" : [ {
    "name" : "name",
    "verboseName" : "verboseName",
    "description" : "description",
    "family" : "family",
    "settingType" : "settingType",
    "value" : True
  }, {
    "name" : "name",
    "verboseName" : "verboseName",
    "description" : "description",
    "family" : "family",
    "settingType" : "settingType",
    "value" : True
  } ],
  "datasetDefinitions" : [ {
    "identifier" : "identifier",
    "originalIdentifier" : "originalIdentifier",
    "catalogId" : "catalogId",
    "isDeleted" : True,
    "catalogVersionId" : "catalogVersionId",
    "featureListId" : "featureListId",
    "snapshotPolicy" : "specified",
    "primaryTemporalKey" : "primaryTemporalKey",
    "dataSource" : {
      "schema" : "schema",
      "dataSourceId" : "dataSourceId",
      "dataStoreId" : "dataStoreId",
      "catalog" : "catalog",
      "dataStoreName" : "dataStoreName",
      "dbtable" : "dbtable",
      "url" : "url"
    },
    "dataSources" : [ {
      "schema" : "schema",
      "dataSourceId" : "dataSourceId",
      "dataStoreId" : "dataStoreId",
      "catalog" : "catalog",
      "dataStoreName" : "dataStoreName",
      "dbtable" : "dbtable",
      "url" : "url"
    }, {
      "schema" : "schema",
      "dataSourceId" : "dataSourceId",
      "dataStoreId" : "dataStoreId",
      "catalog" : "catalog",
      "dataStoreName" : "dataStoreName",
      "dbtable" : "dbtable",
      "url" : "url"
    } ],
    "featureLists" : [ "featureLists", "featureLists" ]
  }, {
    "identifier" : "identifier",
    "originalIdentifier" : "originalIdentifier",
    "catalogId" : "catalogId",
    "isDeleted" : True,
    "catalogVersionId" : "catalogVersionId",
    "featureListId" : "featureListId",
    "snapshotPolicy" : "specified",
    "primaryTemporalKey" : "primaryTemporalKey",
    "dataSource" : {
      "schema" : "schema",
      "dataSourceId" : "dataSourceId",
      "dataStoreId" : "dataStoreId",
      "catalog" : "catalog",
      "dataStoreName" : "dataStoreName",
      "dbtable" : "dbtable",
      "url" : "url"
    },
    "dataSources" : [ {
      "schema" : "schema",
      "dataSourceId" : "dataSourceId",
      "dataStoreId" : "dataStoreId",
      "catalog" : "catalog",
      "dataStoreName" : "dataStoreName",
      "dbtable" : "dbtable",
      "url" : "url"
    }, {
      "schema" : "schema",
      "dataSourceId" : "dataSourceId",
      "dataStoreId" : "dataStoreId",
      "catalog" : "catalog",
      "dataStoreName" : "dataStoreName",
      "dbtable" : "dbtable",
      "url" : "url"
    } ],
    "featureLists" : [ "featureLists", "featureLists" ]
  } ],
  "snowflakePushDownCompatible" : True,
  "id" : "id",
  "featureDiscoveryMode" : "default"
})
    )
    result = FeatureDiscoveryApi.relationships_configurations_create()
    assert isinstance(result, RelationshipsConfigResponse)


@responses.activate
def test_feature_discovery_api_relationships_configurations_delete(unittest_endpoint):
    responses.add(
        responses.DELETE,
        '{endpoint}/api/v2/relationshipsConfigurations/{relationshipsConfigurationId}/'.format(endpoint=unittest_endpoint,
        relationshipsConfigurationId="relationshipsConfigurationId_example", ),
        status=204,
        content_type='',
    )
    result = FeatureDiscoveryApi.relationships_configurations_delete(relationships_configuration_id="relationshipsConfigurationId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_feature_discovery_api_relationships_configurations_put(unittest_endpoint):
    responses.add(
        responses.PUT,
        '{endpoint}/api/v2/relationshipsConfigurations/{relationshipsConfigurationId}/'.format(endpoint=unittest_endpoint,
        relationshipsConfigurationId="relationshipsConfigurationId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "relationships" : [ {
    "featureDerivationWindowEnd" : 0,
    "dataset1Identifier" : "dataset1Identifier",
    "dataset2Keys" : [ "dataset2Keys", "dataset2Keys", "dataset2Keys", "dataset2Keys", "dataset2Keys" ],
    "dataset1Keys" : [ "dataset1Keys", "dataset1Keys", "dataset1Keys", "dataset1Keys", "dataset1Keys" ],
    "predictionPointRounding" : 4,
    "predictionPointRoundingTimeUnit" : "MILLISECOND",
    "dataset2Identifier" : "dataset2Identifier",
    "featureDerivationWindowStart" : 0,
    "featureDerivationWindowTimeUnit" : "MILLISECOND"
  }, {
    "featureDerivationWindowEnd" : 0,
    "dataset1Identifier" : "dataset1Identifier",
    "dataset2Keys" : [ "dataset2Keys", "dataset2Keys", "dataset2Keys", "dataset2Keys", "dataset2Keys" ],
    "dataset1Keys" : [ "dataset1Keys", "dataset1Keys", "dataset1Keys", "dataset1Keys", "dataset1Keys" ],
    "predictionPointRounding" : 4,
    "predictionPointRoundingTimeUnit" : "MILLISECOND",
    "dataset2Identifier" : "dataset2Identifier",
    "featureDerivationWindowStart" : 0,
    "featureDerivationWindowTimeUnit" : "MILLISECOND"
  } ],
  "featureDiscoverySettings" : [ {
    "name" : "name",
    "verboseName" : "verboseName",
    "description" : "description",
    "family" : "family",
    "settingType" : "settingType",
    "value" : True
  }, {
    "name" : "name",
    "verboseName" : "verboseName",
    "description" : "description",
    "family" : "family",
    "settingType" : "settingType",
    "value" : True
  } ],
  "datasetDefinitions" : [ {
    "identifier" : "identifier",
    "originalIdentifier" : "originalIdentifier",
    "catalogId" : "catalogId",
    "isDeleted" : True,
    "catalogVersionId" : "catalogVersionId",
    "featureListId" : "featureListId",
    "snapshotPolicy" : "specified",
    "primaryTemporalKey" : "primaryTemporalKey",
    "dataSource" : {
      "schema" : "schema",
      "dataSourceId" : "dataSourceId",
      "dataStoreId" : "dataStoreId",
      "catalog" : "catalog",
      "dataStoreName" : "dataStoreName",
      "dbtable" : "dbtable",
      "url" : "url"
    },
    "dataSources" : [ {
      "schema" : "schema",
      "dataSourceId" : "dataSourceId",
      "dataStoreId" : "dataStoreId",
      "catalog" : "catalog",
      "dataStoreName" : "dataStoreName",
      "dbtable" : "dbtable",
      "url" : "url"
    }, {
      "schema" : "schema",
      "dataSourceId" : "dataSourceId",
      "dataStoreId" : "dataStoreId",
      "catalog" : "catalog",
      "dataStoreName" : "dataStoreName",
      "dbtable" : "dbtable",
      "url" : "url"
    } ],
    "featureLists" : [ "featureLists", "featureLists" ]
  }, {
    "identifier" : "identifier",
    "originalIdentifier" : "originalIdentifier",
    "catalogId" : "catalogId",
    "isDeleted" : True,
    "catalogVersionId" : "catalogVersionId",
    "featureListId" : "featureListId",
    "snapshotPolicy" : "specified",
    "primaryTemporalKey" : "primaryTemporalKey",
    "dataSource" : {
      "schema" : "schema",
      "dataSourceId" : "dataSourceId",
      "dataStoreId" : "dataStoreId",
      "catalog" : "catalog",
      "dataStoreName" : "dataStoreName",
      "dbtable" : "dbtable",
      "url" : "url"
    },
    "dataSources" : [ {
      "schema" : "schema",
      "dataSourceId" : "dataSourceId",
      "dataStoreId" : "dataStoreId",
      "catalog" : "catalog",
      "dataStoreName" : "dataStoreName",
      "dbtable" : "dbtable",
      "url" : "url"
    }, {
      "schema" : "schema",
      "dataSourceId" : "dataSourceId",
      "dataStoreId" : "dataStoreId",
      "catalog" : "catalog",
      "dataStoreName" : "dataStoreName",
      "dbtable" : "dbtable",
      "url" : "url"
    } ],
    "featureLists" : [ "featureLists", "featureLists" ]
  } ],
  "snowflakePushDownCompatible" : True,
  "id" : "id",
  "featureDiscoveryMode" : "default"
})
    )
    result = FeatureDiscoveryApi.relationships_configurations_put(relationships_configuration_id="relationshipsConfigurationId_example", )
    assert isinstance(result, RelationshipsConfigResponse)


@responses.activate
def test_feature_discovery_api_relationships_configurations_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/relationshipsConfigurations/{relationshipsConfigurationId}/'.format(endpoint=unittest_endpoint,
        relationshipsConfigurationId="relationshipsConfigurationId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "relationships" : [ {
    "featureDerivationWindowEnd" : 0,
    "dataset1Identifier" : "dataset1Identifier",
    "dataset2Keys" : [ "dataset2Keys", "dataset2Keys", "dataset2Keys", "dataset2Keys", "dataset2Keys" ],
    "dataset1Keys" : [ "dataset1Keys", "dataset1Keys", "dataset1Keys", "dataset1Keys", "dataset1Keys" ],
    "predictionPointRounding" : 4,
    "predictionPointRoundingTimeUnit" : "MILLISECOND",
    "dataset2Identifier" : "dataset2Identifier",
    "featureDerivationWindowStart" : 0,
    "featureDerivationWindowTimeUnit" : "MILLISECOND"
  }, {
    "featureDerivationWindowEnd" : 0,
    "dataset1Identifier" : "dataset1Identifier",
    "dataset2Keys" : [ "dataset2Keys", "dataset2Keys", "dataset2Keys", "dataset2Keys", "dataset2Keys" ],
    "dataset1Keys" : [ "dataset1Keys", "dataset1Keys", "dataset1Keys", "dataset1Keys", "dataset1Keys" ],
    "predictionPointRounding" : 4,
    "predictionPointRoundingTimeUnit" : "MILLISECOND",
    "dataset2Identifier" : "dataset2Identifier",
    "featureDerivationWindowStart" : 0,
    "featureDerivationWindowTimeUnit" : "MILLISECOND"
  } ],
  "featureDiscoverySettings" : [ {
    "name" : "name",
    "verboseName" : "verboseName",
    "description" : "description",
    "family" : "family",
    "settingType" : "settingType",
    "value" : True
  }, {
    "name" : "name",
    "verboseName" : "verboseName",
    "description" : "description",
    "family" : "family",
    "settingType" : "settingType",
    "value" : True
  } ],
  "datasetDefinitions" : [ {
    "identifier" : "identifier",
    "originalIdentifier" : "originalIdentifier",
    "catalogId" : "catalogId",
    "isDeleted" : True,
    "catalogVersionId" : "catalogVersionId",
    "featureListId" : "featureListId",
    "snapshotPolicy" : "specified",
    "primaryTemporalKey" : "primaryTemporalKey",
    "dataSource" : {
      "schema" : "schema",
      "dataSourceId" : "dataSourceId",
      "dataStoreId" : "dataStoreId",
      "catalog" : "catalog",
      "dataStoreName" : "dataStoreName",
      "dbtable" : "dbtable",
      "url" : "url"
    },
    "dataSources" : [ {
      "schema" : "schema",
      "dataSourceId" : "dataSourceId",
      "dataStoreId" : "dataStoreId",
      "catalog" : "catalog",
      "dataStoreName" : "dataStoreName",
      "dbtable" : "dbtable",
      "url" : "url"
    }, {
      "schema" : "schema",
      "dataSourceId" : "dataSourceId",
      "dataStoreId" : "dataStoreId",
      "catalog" : "catalog",
      "dataStoreName" : "dataStoreName",
      "dbtable" : "dbtable",
      "url" : "url"
    } ],
    "featureLists" : [ "featureLists", "featureLists" ]
  }, {
    "identifier" : "identifier",
    "originalIdentifier" : "originalIdentifier",
    "catalogId" : "catalogId",
    "isDeleted" : True,
    "catalogVersionId" : "catalogVersionId",
    "featureListId" : "featureListId",
    "snapshotPolicy" : "specified",
    "primaryTemporalKey" : "primaryTemporalKey",
    "dataSource" : {
      "schema" : "schema",
      "dataSourceId" : "dataSourceId",
      "dataStoreId" : "dataStoreId",
      "catalog" : "catalog",
      "dataStoreName" : "dataStoreName",
      "dbtable" : "dbtable",
      "url" : "url"
    },
    "dataSources" : [ {
      "schema" : "schema",
      "dataSourceId" : "dataSourceId",
      "dataStoreId" : "dataStoreId",
      "catalog" : "catalog",
      "dataStoreName" : "dataStoreName",
      "dbtable" : "dbtable",
      "url" : "url"
    }, {
      "schema" : "schema",
      "dataSourceId" : "dataSourceId",
      "dataStoreId" : "dataStoreId",
      "catalog" : "catalog",
      "dataStoreName" : "dataStoreName",
      "dbtable" : "dbtable",
      "url" : "url"
    } ],
    "featureLists" : [ "featureLists", "featureLists" ]
  } ],
  "snowflakePushDownCompatible" : True,
  "id" : "id",
  "featureDiscoveryMode" : "default"
})
    )
    result = FeatureDiscoveryApi.relationships_configurations_retrieve(relationships_configuration_id="relationshipsConfigurationId_example", )
    assert isinstance(result, RelationshipsConfigResponse)
