#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import json
import responses
from six.moves.urllib.parse import urljoin
from dateutil import parser
from datarobot.models.testing.generated.model.approval_policy import ApprovalPolicy
from datarobot.models.testing.generated.model.approval_policy_list_response import ApprovalPolicyListResponse
from datarobot.models.testing.generated.model.approval_policy_match_response import ApprovalPolicyMatchResponse
from datarobot.models.testing.generated.model.approval_policy_response import ApprovalPolicyResponse
from datarobot.models.testing.generated.model.approval_workflow_list_trigger_response import ApprovalWorkflowListTriggerResponse
from datarobot.models.testing.generated.model.change_request_info_list_response import ChangeRequestInfoListResponse
from datarobot.utils import from_api
from datarobot.models.testing.generated.model import *

from datarobot.models.testing.generated.api.governance_api import GovernanceApi




@responses.activate
def test_governance_api_approval_policies_create(unittest_endpoint):
    responses.add(
        responses.POST,
       '{endpoint}/api/v2/approvalPolicies/'.format(endpoint=unittest_endpoint),
        status=201,
        content_type='application/json',
        body=json.dumps({
  "automaticAction" : {
    "period" : "period",
    "action" : "cancel"
  },
  "review" : {
    "reminderPeriod" : "reminderPeriod",
    "groups" : [ {
      "name" : "name",
      "id" : "id"
    }, {
      "name" : "name",
      "id" : "id"
    }, {
      "name" : "name",
      "id" : "id"
    }, {
      "name" : "name",
      "id" : "id"
    }, {
      "name" : "name",
      "id" : "id"
    } ]
  },
  "name" : "name",
  "active" : True,
  "id" : "id",
  "trigger" : {
    "intendedAction" : {
      "condition" : {
        "condition" : "equals",
        "fieldName" : "fieldName",
        "values" : [ "values", "values", "values", "values", "values" ]
      },
      "action" : "create"
    },
    "entityType" : "deployment",
    "filterGroups" : [ {
      "name" : "name",
      "id" : "id"
    }, {
      "name" : "name",
      "id" : "id"
    }, {
      "name" : "name",
      "id" : "id"
    }, {
      "name" : "name",
      "id" : "id"
    }, {
      "name" : "name",
      "id" : "id"
    } ],
    "labels" : {
      "groupLabel" : "groupLabel",
      "label" : "label"
    }
  },
  "openRequests" : 0
})
    )
    result = GovernanceApi.approval_policies_create()
    assert isinstance(result, ApprovalPolicyResponse)


@responses.activate
def test_governance_api_approval_policies_delete(unittest_endpoint):
    responses.add(
        responses.DELETE,
        '{endpoint}/api/v2/approvalPolicies/{approvalPolicyId}/'.format(endpoint=unittest_endpoint,
        approvalPolicyId="approvalPolicyId_example", ),
        status=204,
        content_type='',
    )
    result = GovernanceApi.approval_policies_delete(approval_policy_id="approvalPolicyId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_governance_api_approval_policies_list(unittest_endpoint):
    responses.add(
        responses.GET,
       '{endpoint}/api/v2/approvalPolicies/'.format(endpoint=unittest_endpoint),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "automaticAction" : {
      "period" : "period",
      "action" : "cancel"
    },
    "review" : {
      "reminderPeriod" : "reminderPeriod",
      "groups" : [ {
        "name" : "name",
        "id" : "id"
      }, {
        "name" : "name",
        "id" : "id"
      }, {
        "name" : "name",
        "id" : "id"
      }, {
        "name" : "name",
        "id" : "id"
      }, {
        "name" : "name",
        "id" : "id"
      } ]
    },
    "name" : "name",
    "active" : True,
    "id" : "id",
    "trigger" : {
      "intendedAction" : {
        "condition" : {
          "condition" : "equals",
          "fieldName" : "fieldName",
          "values" : [ "values", "values", "values", "values", "values" ]
        },
        "action" : "create"
      },
      "entityType" : "deployment",
      "filterGroups" : [ {
        "name" : "name",
        "id" : "id"
      }, {
        "name" : "name",
        "id" : "id"
      }, {
        "name" : "name",
        "id" : "id"
      }, {
        "name" : "name",
        "id" : "id"
      }, {
        "name" : "name",
        "id" : "id"
      } ],
      "labels" : {
        "groupLabel" : "groupLabel",
        "label" : "label"
      }
    },
    "openRequests" : 0
  }, {
    "automaticAction" : {
      "period" : "period",
      "action" : "cancel"
    },
    "review" : {
      "reminderPeriod" : "reminderPeriod",
      "groups" : [ {
        "name" : "name",
        "id" : "id"
      }, {
        "name" : "name",
        "id" : "id"
      }, {
        "name" : "name",
        "id" : "id"
      }, {
        "name" : "name",
        "id" : "id"
      }, {
        "name" : "name",
        "id" : "id"
      } ]
    },
    "name" : "name",
    "active" : True,
    "id" : "id",
    "trigger" : {
      "intendedAction" : {
        "condition" : {
          "condition" : "equals",
          "fieldName" : "fieldName",
          "values" : [ "values", "values", "values", "values", "values" ]
        },
        "action" : "create"
      },
      "entityType" : "deployment",
      "filterGroups" : [ {
        "name" : "name",
        "id" : "id"
      }, {
        "name" : "name",
        "id" : "id"
      }, {
        "name" : "name",
        "id" : "id"
      }, {
        "name" : "name",
        "id" : "id"
      }, {
        "name" : "name",
        "id" : "id"
      } ],
      "labels" : {
        "groupLabel" : "groupLabel",
        "label" : "label"
      }
    },
    "openRequests" : 0
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0,
  "totalCount" : 1
})
    )
    result = GovernanceApi.approval_policies_list()
    assert isinstance(result, ApprovalPolicyListResponse)


@responses.activate
def test_governance_api_approval_policies_put(unittest_endpoint):
    responses.add(
        responses.PUT,
        '{endpoint}/api/v2/approvalPolicies/{approvalPolicyId}/'.format(endpoint=unittest_endpoint,
        approvalPolicyId="approvalPolicyId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "automaticAction" : {
    "period" : "period",
    "action" : "cancel"
  },
  "review" : {
    "reminderPeriod" : "reminderPeriod",
    "groups" : [ {
      "name" : "name",
      "id" : "id"
    }, {
      "name" : "name",
      "id" : "id"
    }, {
      "name" : "name",
      "id" : "id"
    }, {
      "name" : "name",
      "id" : "id"
    }, {
      "name" : "name",
      "id" : "id"
    } ]
  },
  "name" : "name",
  "active" : True,
  "id" : "id",
  "trigger" : {
    "intendedAction" : {
      "condition" : {
        "condition" : "equals",
        "fieldName" : "fieldName",
        "values" : [ "values", "values", "values", "values", "values" ]
      },
      "action" : "create"
    },
    "entityType" : "deployment",
    "filterGroups" : [ {
      "name" : "name",
      "id" : "id"
    }, {
      "name" : "name",
      "id" : "id"
    }, {
      "name" : "name",
      "id" : "id"
    }, {
      "name" : "name",
      "id" : "id"
    }, {
      "name" : "name",
      "id" : "id"
    } ],
    "labels" : {
      "groupLabel" : "groupLabel",
      "label" : "label"
    }
  },
  "openRequests" : 0
})
    )
    result = GovernanceApi.approval_policies_put(approval_policy_id="approvalPolicyId_example", )
    assert isinstance(result, ApprovalPolicyResponse)


@responses.activate
def test_governance_api_approval_policies_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/approvalPolicies/{approvalPolicyId}/'.format(endpoint=unittest_endpoint,
        approvalPolicyId="approvalPolicyId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "automaticAction" : {
    "period" : "period",
    "action" : "cancel"
  },
  "review" : {
    "reminderPeriod" : "reminderPeriod",
    "groups" : [ {
      "name" : "name",
      "id" : "id"
    }, {
      "name" : "name",
      "id" : "id"
    }, {
      "name" : "name",
      "id" : "id"
    }, {
      "name" : "name",
      "id" : "id"
    }, {
      "name" : "name",
      "id" : "id"
    } ]
  },
  "name" : "name",
  "active" : True,
  "id" : "id",
  "trigger" : {
    "intendedAction" : {
      "condition" : {
        "condition" : "equals",
        "fieldName" : "fieldName",
        "values" : [ "values", "values", "values", "values", "values" ]
      },
      "action" : "create"
    },
    "entityType" : "deployment",
    "filterGroups" : [ {
      "name" : "name",
      "id" : "id"
    }, {
      "name" : "name",
      "id" : "id"
    }, {
      "name" : "name",
      "id" : "id"
    }, {
      "name" : "name",
      "id" : "id"
    }, {
      "name" : "name",
      "id" : "id"
    } ],
    "labels" : {
      "groupLabel" : "groupLabel",
      "label" : "label"
    }
  },
  "openRequests" : 0
})
    )
    result = GovernanceApi.approval_policies_retrieve(approval_policy_id="approvalPolicyId_example", )
    assert isinstance(result, ApprovalPolicyResponse)


@responses.activate
def test_governance_api_approval_policies_shareable_change_requests_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/approvalPolicies/{approvalPolicyId}/shareableChangeRequests/'.format(endpoint=unittest_endpoint,
        approvalPolicyId="approvalPolicyId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "changeRequestId" : "changeRequestId",
    "requester" : "requester",
    "updateDate" : "2000-01-23T04:56:07.000+00:00",
    "updatedBy" : "updatedBy",
    "entityName" : "entityName",
    "entityId" : "entityId",
    "state" : "OPENED",
    "createDate" : "2000-01-23T04:56:07.000+00:00"
  }, {
    "changeRequestId" : "changeRequestId",
    "requester" : "requester",
    "updateDate" : "2000-01-23T04:56:07.000+00:00",
    "updatedBy" : "updatedBy",
    "entityName" : "entityName",
    "entityId" : "entityId",
    "state" : "OPENED",
    "createDate" : "2000-01-23T04:56:07.000+00:00"
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0,
  "totalCount" : 6
})
    )
    result = GovernanceApi.approval_policies_shareable_change_requests_list(approval_policy_id="approvalPolicyId_example", )
    assert isinstance(result, ChangeRequestInfoListResponse)


@responses.activate
def test_governance_api_approval_policy_match_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/approvalPolicyMatch/'.format(endpoint=unittest_endpoint,
        entityType="deployment", action="create", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "fieldName" : "fieldName",
  "policyId" : "policyId",
  "entityType" : "deployment",
  "action" : "create",
  "fieldValue" : "fieldValue"
})
    )
    result = GovernanceApi.approval_policy_match_list(entity_type="deployment", action="create", )
    assert isinstance(result, ApprovalPolicyMatchResponse)


@responses.activate
def test_governance_api_approval_policy_triggers_list(unittest_endpoint):
    responses.add(
        responses.GET,
       '{endpoint}/api/v2/approvalPolicyTriggers/'.format(endpoint=unittest_endpoint),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "data" : [ {
    "intendedAction" : {
      "condition" : {
        "condition" : "equals",
        "fieldName" : "fieldName",
        "values" : [ "values", "values", "values", "values", "values" ]
      },
      "action" : "create"
    },
    "entityType" : "deployment",
    "filterGroups" : [ {
      "name" : "name",
      "id" : "id"
    }, {
      "name" : "name",
      "id" : "id"
    }, {
      "name" : "name",
      "id" : "id"
    }, {
      "name" : "name",
      "id" : "id"
    }, {
      "name" : "name",
      "id" : "id"
    } ],
    "labels" : {
      "groupLabel" : "groupLabel",
      "label" : "label"
    }
  }, {
    "intendedAction" : {
      "condition" : {
        "condition" : "equals",
        "fieldName" : "fieldName",
        "values" : [ "values", "values", "values", "values", "values" ]
      },
      "action" : "create"
    },
    "entityType" : "deployment",
    "filterGroups" : [ {
      "name" : "name",
      "id" : "id"
    }, {
      "name" : "name",
      "id" : "id"
    }, {
      "name" : "name",
      "id" : "id"
    }, {
      "name" : "name",
      "id" : "id"
    }, {
      "name" : "name",
      "id" : "id"
    } ],
    "labels" : {
      "groupLabel" : "groupLabel",
      "label" : "label"
    }
  } ]
})
    )
    result = GovernanceApi.approval_policy_triggers_list()
    assert isinstance(result, ApprovalWorkflowListTriggerResponse)
