#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import json
import responses
from six.moves.urllib.parse import urljoin
from dateutil import parser
from datarobot.models.testing.generated.model.add_users_to_group_response import AddUsersToGroupResponse
from datarobot.models.testing.generated.model.list_users_in_group_response import ListUsersInGroupResponse
from datarobot.models.testing.generated.model.modify_users_in_group import ModifyUsersInGroup
from datarobot.models.testing.generated.model.user_group_bulk_delete import UserGroupBulkDelete
from datarobot.models.testing.generated.model.user_group_create import UserGroupCreate
from datarobot.models.testing.generated.model.user_group_response import UserGroupResponse
from datarobot.models.testing.generated.model.user_group_update import UserGroupUpdate
from datarobot.utils import from_api
from datarobot.models.testing.generated.model import *

from datarobot.models.testing.generated.api.groups_api import GroupsApi




@responses.activate
def test_groups_api_groups_create(unittest_endpoint):
    responses.add(
        responses.POST,
       '{endpoint}/api/v2/groups/'.format(endpoint=unittest_endpoint),
        status=201,
        content_type='application/json',
        body=json.dumps({
  "accessRoleId" : "accessRoleId",
  "maxCustomDeploymentsLimit" : 6,
  "membersCount" : 9,
  "orgName" : "orgName",
  "maxAppCountLimit" : 0,
  "description" : "description",
  "maxUploadSizeLimit" : 2,
  "orgId" : "orgId",
  "maxEdaWorkers" : 1,
  "maxWorkers" : 7,
  "accessRoleName" : "accessRoleName",
  "maxRam" : 5,
  "createdBy" : "createdBy",
  "name" : "name",
  "maxUploadCatalogSizeLimit" : 5,
  "id" : "id",
  "email" : "email",
  "accountPermissions" : {
    "key" : True
  }
})
    )
    result = GroupsApi.groups_create()
    assert isinstance(result, UserGroupResponse)


@responses.activate
def test_groups_api_groups_delete(unittest_endpoint):
    responses.add(
        responses.DELETE,
        '{endpoint}/api/v2/groups/{groupId}/'.format(endpoint=unittest_endpoint,
        groupId="groupId_example", ),
        status=204,
        content_type='',
    )
    result = GroupsApi.groups_delete(group_id="groupId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_groups_api_groups_delete_many(unittest_endpoint):
    responses.add(
        responses.DELETE,
       '{endpoint}/api/v2/groups/'.format(endpoint=unittest_endpoint),
        status=204,
        content_type='',
    )
    result = GroupsApi.groups_delete_many()
    assert isinstance(result, type(None))


@responses.activate
def test_groups_api_groups_patch(unittest_endpoint):
    responses.add(
        responses.PATCH,
        '{endpoint}/api/v2/groups/{groupId}/'.format(endpoint=unittest_endpoint,
        groupId="groupId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "accessRoleId" : "accessRoleId",
  "maxCustomDeploymentsLimit" : 6,
  "membersCount" : 9,
  "orgName" : "orgName",
  "maxAppCountLimit" : 0,
  "description" : "description",
  "maxUploadSizeLimit" : 2,
  "orgId" : "orgId",
  "maxEdaWorkers" : 1,
  "maxWorkers" : 7,
  "accessRoleName" : "accessRoleName",
  "maxRam" : 5,
  "createdBy" : "createdBy",
  "name" : "name",
  "maxUploadCatalogSizeLimit" : 5,
  "id" : "id",
  "email" : "email",
  "accountPermissions" : {
    "key" : True
  }
})
    )
    result = GroupsApi.groups_patch(group_id="groupId_example", )
    assert isinstance(result, UserGroupResponse)


@responses.activate
def test_groups_api_groups_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/groups/{groupId}/'.format(endpoint=unittest_endpoint,
        groupId="groupId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "accessRoleId" : "accessRoleId",
  "maxCustomDeploymentsLimit" : 6,
  "membersCount" : 9,
  "orgName" : "orgName",
  "maxAppCountLimit" : 0,
  "description" : "description",
  "maxUploadSizeLimit" : 2,
  "orgId" : "orgId",
  "maxEdaWorkers" : 1,
  "maxWorkers" : 7,
  "accessRoleName" : "accessRoleName",
  "maxRam" : 5,
  "createdBy" : "createdBy",
  "name" : "name",
  "maxUploadCatalogSizeLimit" : 5,
  "id" : "id",
  "email" : "email",
  "accountPermissions" : {
    "key" : True
  }
})
    )
    result = GroupsApi.groups_retrieve(group_id="groupId_example", )
    assert isinstance(result, UserGroupResponse)


@responses.activate
def test_groups_api_groups_users_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/api/v2/groups/{groupId}/users/'.format(endpoint=unittest_endpoint,
        groupId="groupId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "data" : [ {
    "firstName" : "firstName",
    "lastName" : "lastName",
    "scheduledForDeletion" : True,
    "organization" : "organization",
    "userId" : "userId",
    "status" : "active",
    "username" : "username"
  }, {
    "firstName" : "firstName",
    "lastName" : "lastName",
    "scheduledForDeletion" : True,
    "organization" : "organization",
    "userId" : "userId",
    "status" : "active",
    "username" : "username"
  } ],
  "count" : 0
})
    )
    result = GroupsApi.groups_users_create(group_id="groupId_example", )
    assert isinstance(result, AddUsersToGroupResponse)


@responses.activate
def test_groups_api_groups_users_delete_many(unittest_endpoint):
    responses.add(
        responses.DELETE,
        '{endpoint}/api/v2/groups/{groupId}/users/'.format(endpoint=unittest_endpoint,
        groupId="groupId_example", ),
        status=204,
        content_type='',
    )
    result = GroupsApi.groups_users_delete_many(group_id="groupId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_groups_api_groups_users_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/groups/{groupId}/users/'.format(endpoint=unittest_endpoint,
        offset=0, limit=50, groupId="groupId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "firstName" : "firstName",
    "lastName" : "lastName",
    "scheduledForDeletion" : True,
    "organization" : "organization",
    "userId" : "userId",
    "status" : "active",
    "username" : "username"
  }, {
    "firstName" : "firstName",
    "lastName" : "lastName",
    "scheduledForDeletion" : True,
    "organization" : "organization",
    "userId" : "userId",
    "status" : "active",
    "username" : "username"
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0,
  "totalCount" : 6
})
    )
    result = GroupsApi.groups_users_list(offset=0, limit=50, group_id="groupId_example", )
    assert isinstance(result, ListUsersInGroupResponse)
