#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import json
import responses
from six.moves.urllib.parse import urljoin
from dateutil import parser
from datarobot.models.testing.generated.model.image_augmentation_create_list import ImageAugmentationCreateList
from datarobot.models.testing.generated.model.image_augmentation_list_create_response import ImageAugmentationListCreateResponse
from datarobot.models.testing.generated.model.image_augmentation_list_patch_param import ImageAugmentationListPatchParam
from datarobot.models.testing.generated.model.image_augmentation_lists_response import ImageAugmentationListsResponse
from datarobot.models.testing.generated.model.image_augmentation_options_response import ImageAugmentationOptionsResponse
from datarobot.models.testing.generated.model.image_augmentation_retrieve_list import ImageAugmentationRetrieveList
from datarobot.models.testing.generated.model.image_augmentation_retrieve_samples_response import ImageAugmentationRetrieveSamplesResponse
from datarobot.models.testing.generated.model.image_augmentation_samples_request import ImageAugmentationSamplesRequest
from datarobot.models.testing.generated.model.image_augmentation_samples_response import ImageAugmentationSamplesResponse
from datarobot.utils import from_api
from datarobot.models.testing.generated.model import *

from datarobot.models.testing.generated.api.image_augmentation_api import ImageAugmentationApi




@responses.activate
def test_image_augmentation_api_image_augmentation_lists_create(unittest_endpoint):
    responses.add(
        responses.POST,
       '{endpoint}/api/v2/imageAugmentationLists/'.format(endpoint=unittest_endpoint),
        status=201,
        content_type='application/json',
        body=json.dumps({
  "augmentationListId" : "augmentationListId"
})
    )
    result = ImageAugmentationApi.image_augmentation_lists_create()
    assert isinstance(result, ImageAugmentationListCreateResponse)


@responses.activate
def test_image_augmentation_api_image_augmentation_lists_delete(unittest_endpoint):
    responses.add(
        responses.DELETE,
        '{endpoint}/api/v2/imageAugmentationLists/{augmentationId}/'.format(endpoint=unittest_endpoint,
        augmentationId="augmentationId_example", ),
        status=204,
        content_type='',
    )
    result = ImageAugmentationApi.image_augmentation_lists_delete(augmentation_id="augmentationId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_image_augmentation_api_image_augmentation_lists_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/imageAugmentationLists/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", offset=0, limit=100, ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "transformationProbability" : 0.14658129805029452,
    "initialList" : False,
    "featureName" : "featureName",
    "transformations" : [ {
      "name" : "name",
      "params" : [ {
        "minValue" : "",
        "maxValue" : "",
        "name" : "name",
        "currentValue" : ""
      }, {
        "minValue" : "",
        "maxValue" : "",
        "name" : "name",
        "currentValue" : ""
      } ],
      "enabled" : False
    }, {
      "name" : "name",
      "params" : [ {
        "minValue" : "",
        "maxValue" : "",
        "name" : "name",
        "currentValue" : ""
      }, {
        "minValue" : "",
        "maxValue" : "",
        "name" : "name",
        "currentValue" : ""
      } ],
      "enabled" : False
    } ],
    "inUse" : False,
    "name" : "name",
    "id" : "id",
    "numberOfNewImages" : 1,
    "projectId" : "projectId"
  }, {
    "transformationProbability" : 0.14658129805029452,
    "initialList" : False,
    "featureName" : "featureName",
    "transformations" : [ {
      "name" : "name",
      "params" : [ {
        "minValue" : "",
        "maxValue" : "",
        "name" : "name",
        "currentValue" : ""
      }, {
        "minValue" : "",
        "maxValue" : "",
        "name" : "name",
        "currentValue" : ""
      } ],
      "enabled" : False
    }, {
      "name" : "name",
      "params" : [ {
        "minValue" : "",
        "maxValue" : "",
        "name" : "name",
        "currentValue" : ""
      }, {
        "minValue" : "",
        "maxValue" : "",
        "name" : "name",
        "currentValue" : ""
      } ],
      "enabled" : False
    } ],
    "inUse" : False,
    "name" : "name",
    "id" : "id",
    "numberOfNewImages" : 1,
    "projectId" : "projectId"
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0,
  "totalCount" : 5
})
    )
    result = ImageAugmentationApi.image_augmentation_lists_list(project_id="projectId_example", offset=0, limit=100, )
    assert isinstance(result, ImageAugmentationListsResponse)


@responses.activate
def test_image_augmentation_api_image_augmentation_lists_patch(unittest_endpoint):
    responses.add(
        responses.PATCH,
        '{endpoint}/api/v2/imageAugmentationLists/{augmentationId}/'.format(endpoint=unittest_endpoint,
        augmentationId="augmentationId_example", ),
        status=204,
        content_type='',
    )
    result = ImageAugmentationApi.image_augmentation_lists_patch(augmentation_id="augmentationId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_image_augmentation_api_image_augmentation_lists_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/imageAugmentationLists/{augmentationId}/'.format(endpoint=unittest_endpoint,
        augmentationId="augmentationId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "transformationProbability" : 0.14658129805029452,
  "initialList" : False,
  "featureName" : "featureName",
  "transformations" : [ {
    "name" : "name",
    "params" : [ {
      "minValue" : "",
      "maxValue" : "",
      "name" : "name",
      "currentValue" : ""
    }, {
      "minValue" : "",
      "maxValue" : "",
      "name" : "name",
      "currentValue" : ""
    } ],
    "enabled" : False
  }, {
    "name" : "name",
    "params" : [ {
      "minValue" : "",
      "maxValue" : "",
      "name" : "name",
      "currentValue" : ""
    }, {
      "minValue" : "",
      "maxValue" : "",
      "name" : "name",
      "currentValue" : ""
    } ],
    "enabled" : False
  } ],
  "inUse" : False,
  "name" : "name",
  "id" : "id",
  "numberOfNewImages" : 1,
  "projectId" : "projectId"
})
    )
    result = ImageAugmentationApi.image_augmentation_lists_retrieve(augmentation_id="augmentationId_example", )
    assert isinstance(result, ImageAugmentationRetrieveList)


@responses.activate
def test_image_augmentation_api_image_augmentation_options_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/imageAugmentationOptions/{projectId}/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "maxTransformationProbability" : 0.5962133916683182,
  "featureName" : "featureName",
  "maxNumberOfNewImages" : 1,
  "minNumberOfNewImages" : 5,
  "transformations" : [ {
    "enabledByDefault" : True,
    "name" : "name",
    "affectedByTransformationProbability" : True,
    "params" : [ {
      "minValue" : "",
      "maxValue" : "",
      "name" : "name",
      "translatedName" : "translatedName",
      "type" : "type",
      "currentValue" : ""
    }, {
      "minValue" : "",
      "maxValue" : "",
      "name" : "name",
      "translatedName" : "translatedName",
      "type" : "type",
      "currentValue" : ""
    } ],
    "translatedName" : "translatedName"
  }, {
    "enabledByDefault" : True,
    "name" : "name",
    "affectedByTransformationProbability" : True,
    "params" : [ {
      "minValue" : "",
      "maxValue" : "",
      "name" : "name",
      "translatedName" : "translatedName",
      "type" : "type",
      "currentValue" : ""
    }, {
      "minValue" : "",
      "maxValue" : "",
      "name" : "name",
      "translatedName" : "translatedName",
      "type" : "type",
      "currentValue" : ""
    } ],
    "translatedName" : "translatedName"
  } ],
  "name" : "name",
  "id" : "id",
  "currentNumberOfNewImages" : 0,
  "currentTransformationProbability" : 6.027456183070403,
  "projectId" : "projectId",
  "minTransformationProbability" : 0.23021358869347652
})
    )
    result = ImageAugmentationApi.image_augmentation_options_retrieve(project_id="projectId_example", )
    assert isinstance(result, ImageAugmentationOptionsResponse)


@responses.activate
def test_image_augmentation_api_image_augmentation_samples_create(unittest_endpoint):
    responses.add(
        responses.POST,
       '{endpoint}/api/v2/imageAugmentationSamples/'.format(endpoint=unittest_endpoint),
        status=202,
        content_type='application/json',
        body=json.dumps({
  "statusId" : "statusId"
})
    )
    result = ImageAugmentationApi.image_augmentation_samples_create()
    assert isinstance(result, ImageAugmentationSamplesResponse)


@responses.activate
def test_image_augmentation_api_image_augmentation_samples_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/imageAugmentationSamples/{samplesId}/'.format(endpoint=unittest_endpoint,
        samplesId="samplesId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "originalImageId" : "originalImageId",
    "imageId" : "imageId",
    "width" : 1,
    "height" : 6
  }, {
    "originalImageId" : "originalImageId",
    "imageId" : "imageId",
    "width" : 1,
    "height" : 6
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0,
  "totalCount" : 5
})
    )
    result = ImageAugmentationApi.image_augmentation_samples_retrieve(samples_id="samplesId_example", )
    assert isinstance(result, ImageAugmentationRetrieveSamplesResponse)
