#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import json
import responses
from six.moves.urllib.parse import urljoin
from dateutil import parser
from datarobot.models.testing.generated.model.activation_maps_compute_response import ActivationMapsComputeResponse
from datarobot.models.testing.generated.model.activation_maps_list_response import ActivationMapsListResponse
from datarobot.models.testing.generated.model.activation_maps_retrieve_response import ActivationMapsRetrieveResponse
from datarobot.models.testing.generated.model.embeddings_list_response import EmbeddingsListResponse
from datarobot.models.testing.generated.model.embeddings_retrieve_response import EmbeddingsRetrieveResponse
from datarobot.models.testing.generated.model.image_embeddings_compute_response import ImageEmbeddingsComputeResponse
from datarobot.utils import from_api
from datarobot.models.testing.generated.model import *

from datarobot.models.testing.generated.api.image_insights_api import ImageInsightsApi




@responses.activate
def test_image_insights_api_projects_image_activation_maps_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/imageActivationMaps/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "featureName" : "featureName",
    "modelId" : "modelId"
  }, {
    "featureName" : "featureName",
    "modelId" : "modelId"
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0,
  "totalCount" : 6
})
    )
    result = ImageInsightsApi.projects_image_activation_maps_list(project_id="projectId_example", )
    assert isinstance(result, ActivationMapsListResponse)


@responses.activate
def test_image_insights_api_projects_image_embeddings_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/imageEmbeddings/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "featureName" : "featureName",
    "modelId" : "modelId"
  }, {
    "featureName" : "featureName",
    "modelId" : "modelId"
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0,
  "totalCount" : 6
})
    )
    result = ImageInsightsApi.projects_image_embeddings_list(project_id="projectId_example", )
    assert isinstance(result, EmbeddingsListResponse)


@responses.activate
def test_image_insights_api_projects_models_image_activation_maps_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/api/v2/projects/{projectId}/models/{modelId}/imageActivationMaps/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=202,
        content_type='application/json',
        body=json.dumps({
  "modelId" : "modelId",
  "isBlocked" : True,
  "id" : "id",
  "jobType" : "compute_image_activation_maps",
  "projectId" : "projectId",
  "url" : "url",
  "status" : "queue"
})
    )
    result = ImageInsightsApi.projects_models_image_activation_maps_create(project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, ActivationMapsComputeResponse)


@responses.activate
def test_image_insights_api_projects_models_image_activation_maps_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/models/{modelId}/imageActivationMaps/'.format(endpoint=unittest_endpoint,
        featureName="featureName_example", projectId="projectId_example", modelId="modelId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "activationMaps" : [ {
    "imageWidth" : 5,
    "activationValues" : [ [ 37, 37 ], [ 37, 37 ] ],
    "imageId" : "imageId",
    "predictedTargetValue" : "",
    "featureName" : "featureName",
    "overlayImageId" : "overlayImageId",
    "actualTargetValue" : "",
    "links" : {
      "downloadOverlayImage" : "https://openapi-generator.tech",
      "downloadOriginalImage" : "https://openapi-generator.tech"
    },
    "imageHeight" : 5
  }, {
    "imageWidth" : 5,
    "activationValues" : [ [ 37, 37 ], [ 37, 37 ] ],
    "imageId" : "imageId",
    "predictedTargetValue" : "",
    "featureName" : "featureName",
    "overlayImageId" : "overlayImageId",
    "actualTargetValue" : "",
    "links" : {
      "downloadOverlayImage" : "https://openapi-generator.tech",
      "downloadOriginalImage" : "https://openapi-generator.tech"
    },
    "imageHeight" : 5
  } ],
  "targetValues" : [ "targetValues", "targetValues" ],
  "targetBins" : [ {
    "targetBinEnd" : 2.3021358869347655,
    "targetBinStart" : 7.061401241503109
  }, {
    "targetBinEnd" : 2.3021358869347655,
    "targetBinStart" : 7.061401241503109
  } ],
  "activationMapHeight" : 0,
  "activationMapWidth" : 6
})
    )
    result = ImageInsightsApi.projects_models_image_activation_maps_list(feature_name="featureName_example", project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, ActivationMapsRetrieveResponse)


@responses.activate
def test_image_insights_api_projects_models_image_embeddings_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/api/v2/projects/{projectId}/models/{modelId}/imageEmbeddings/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=202,
        content_type='application/json',
        body=json.dumps({
  "modelId" : "modelId",
  "isBlocked" : True,
  "id" : "id",
  "jobType" : "compute_image_embeddings",
  "projectId" : "projectId",
  "url" : "url",
  "status" : "queue"
})
    )
    result = ImageInsightsApi.projects_models_image_embeddings_create(project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, ImageEmbeddingsComputeResponse)


@responses.activate
def test_image_insights_api_projects_models_image_embeddings_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/models/{modelId}/imageEmbeddings/'.format(endpoint=unittest_endpoint,
        featureName="featureName_example", projectId="projectId_example", modelId="modelId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "embeddings" : [ {
    "positionY" : 6.027456183070403,
    "imageId" : "imageId",
    "prediction" : {
      "values" : [ "", "" ],
      "labels" : [ "labels", "labels" ]
    },
    "actualTargetValue" : "",
    "positionX" : 0.8008281904610115
  }, {
    "positionY" : 6.027456183070403,
    "imageId" : "imageId",
    "prediction" : {
      "values" : [ "", "" ],
      "labels" : [ "labels", "labels" ]
    },
    "actualTargetValue" : "",
    "positionX" : 0.8008281904610115
  } ],
  "targetValues" : [ "targetValues", "targetValues" ],
  "targetBins" : [ {
    "targetBinEnd" : 2.3021358869347655,
    "targetBinStart" : 7.061401241503109
  }, {
    "targetBinEnd" : 2.3021358869347655,
    "targetBinStart" : 7.061401241503109
  } ]
})
    )
    result = ImageInsightsApi.projects_models_image_embeddings_list(feature_name="featureName_example", project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, EmbeddingsRetrieveResponse)
