#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import json
import responses
from six.moves.urllib.parse import urljoin
from dateutil import parser
from datarobot.models.testing.generated.model.duplicate_image_table_response import DuplicateImageTableResponse
from datarobot.models.testing.generated.model.image_bins_list_response import ImageBinsListResponse
from datarobot.models.testing.generated.model.image_metadata_list_response import ImageMetadataListResponse
from datarobot.models.testing.generated.model.image_metadata_response import ImageMetadataResponse
from datarobot.models.testing.generated.model.images_data_quality_log_lines_response import ImagesDataQualityLogLinesResponse
from datarobot.utils import from_api
from datarobot.models.testing.generated.model import *

from datarobot.models.testing.generated.api.images_api import ImagesApi




@responses.activate
def test_images_api_datasets_images_data_quality_log_file_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/datasets/{datasetId}/imagesDataQualityLog/file/'.format(endpoint=unittest_endpoint,
        datasetId="datasetId_example", ),
        status=200,
        content_type='',
    )
    result = ImagesApi.datasets_images_data_quality_log_file_list(dataset_id="datasetId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_images_api_datasets_images_data_quality_log_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/datasets/{datasetId}/imagesDataQualityLog/'.format(endpoint=unittest_endpoint,
        datasetId="datasetId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ "data", "data" ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0,
  "totalCount" : 6
})
    )
    result = ImagesApi.datasets_images_data_quality_log_list(dataset_id="datasetId_example", )
    assert isinstance(result, ImagesDataQualityLogLinesResponse)


@responses.activate
def test_images_api_projects_duplicate_images_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/duplicateImages/{column}/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", column="column_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "imageId" : "imageId",
    "rowCount" : 6
  }, {
    "imageId" : "imageId",
    "rowCount" : 6
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0,
  "totalCount" : 1
})
    )
    result = ImagesApi.projects_duplicate_images_retrieve(project_id="projectId_example", column="column_example", )
    assert isinstance(result, DuplicateImageTableResponse)


@responses.activate
def test_images_api_projects_image_bins_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/imageBins/'.format(endpoint=unittest_endpoint,
        featureName="featureName_example", projectId="projectId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "targetBinEnd" : 1,
    "imageId" : "imageId",
    "targetBinStart" : 5,
    "targetValue" : 2.3021358869347655,
    "width" : 7,
    "targetBinRowCount" : 5,
    "height" : 6
  }, {
    "targetBinEnd" : 1,
    "imageId" : "imageId",
    "targetBinStart" : 5,
    "targetValue" : 2.3021358869347655,
    "width" : 7,
    "targetBinRowCount" : 5,
    "height" : 6
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0,
  "totalCount" : 9
})
    )
    result = ImagesApi.projects_image_bins_list(feature_name="featureName_example", project_id="projectId_example", )
    assert isinstance(result, ImageBinsListResponse)


@responses.activate
def test_images_api_projects_image_samples_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/imageSamples/'.format(endpoint=unittest_endpoint,
        featureName="featureName_example", projectId="projectId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "imageId" : "imageId",
    "targetValue" : 1.4658129805029452,
    "width" : 5,
    "height" : 6
  }, {
    "imageId" : "imageId",
    "targetValue" : 1.4658129805029452,
    "width" : 5,
    "height" : 6
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0,
  "totalCount" : 5
})
    )
    result = ImagesApi.projects_image_samples_list(feature_name="featureName_example", project_id="projectId_example", )
    assert isinstance(result, ImageMetadataListResponse)


@responses.activate
def test_images_api_projects_images_data_quality_log_file_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/imagesDataQualityLog/file/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", ),
        status=200,
        content_type='',
    )
    result = ImagesApi.projects_images_data_quality_log_file_list(project_id="projectId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_images_api_projects_images_data_quality_log_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/imagesDataQualityLog/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ "data", "data" ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0,
  "totalCount" : 6
})
    )
    result = ImagesApi.projects_images_data_quality_log_list(project_id="projectId_example", )
    assert isinstance(result, ImagesDataQualityLogLinesResponse)


@responses.activate
def test_images_api_projects_images_file_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/images/{imageId}/file/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", imageId="imageId_example", ),
        status=200,
        content_type='',
    )
    result = ImagesApi.projects_images_file_list(project_id="projectId_example", image_id="imageId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_images_api_projects_images_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/images/'.format(endpoint=unittest_endpoint,
        offset=0, limit=100, projectId="projectId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "imageId" : "imageId",
    "targetValue" : 1.4658129805029452,
    "width" : 5,
    "height" : 6
  }, {
    "imageId" : "imageId",
    "targetValue" : 1.4658129805029452,
    "width" : 5,
    "height" : 6
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0,
  "totalCount" : 5
})
    )
    result = ImagesApi.projects_images_list(offset=0, limit=100, project_id="projectId_example", )
    assert isinstance(result, ImageMetadataListResponse)


@responses.activate
def test_images_api_projects_images_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/images/{imageId}/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", imageId="imageId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "imageId" : "imageId",
  "targetValue" : 1.4658129805029452,
  "width" : 5,
  "height" : 6
})
    )
    result = ImagesApi.projects_images_retrieve(project_id="projectId_example", image_id="imageId_example", )
    assert isinstance(result, ImageMetadataResponse)
