#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import json
import responses
from six.moves.urllib.parse import urljoin
from dateutil import parser
from datarobot.models.testing.generated.model.aot_chart_metadata_response import AOTChartMetadataResponse
from datarobot.models.testing.generated.model.aot_chart_preview_response import AOTChartPreviewResponse
from datarobot.models.testing.generated.model.aot_chart_retrieve_response import AOTChartRetrieveResponse
from datarobot.models.testing.generated.model.anomaly_assessment_explanations_response import AnomalyAssessmentExplanationsResponse
from datarobot.models.testing.generated.model.anomaly_assessment_initialize import AnomalyAssessmentInitialize
from datarobot.models.testing.generated.model.anomaly_assessment_preview_response import AnomalyAssessmentPreviewResponse
from datarobot.models.testing.generated.model.anomaly_assessment_records_response import AnomalyAssessmentRecordsResponse
from datarobot.models.testing.generated.model.bias_vs_accuracy_insight_retrieve import BiasVsAccuracyInsightRetrieve
from datarobot.models.testing.generated.model.confusion_chart_for_datasets_list_response import ConfusionChartForDatasetsListResponse
from datarobot.models.testing.generated.model.confusion_chart_retrieve_for_datasets import ConfusionChartRetrieveForDatasets
from datarobot.models.testing.generated.model.confusion_chart_retrieve_metadata_for_datasets import ConfusionChartRetrieveMetadataForDatasets
from datarobot.models.testing.generated.model.cross_class_accuracy_create_response import CrossClassAccuracyCreateResponse
from datarobot.models.testing.generated.model.cross_class_accuracy_list import CrossClassAccuracyList
from datarobot.models.testing.generated.model.data_disparity_create_payload import DataDisparityCreatePayload
from datarobot.models.testing.generated.model.data_disparity_create_response import DataDisparityCreateResponse
from datarobot.models.testing.generated.model.data_disparity_retrieve_response import DataDisparityRetrieveResponse
from datarobot.models.testing.generated.model.external_scores_create import ExternalScoresCreate
from datarobot.models.testing.generated.model.external_scores_list_response import ExternalScoresListResponse
from datarobot.models.testing.generated.model.fairness_insights_list_response import FairnessInsightsListResponse
from datarobot.models.testing.generated.model.fairness_insights_start_calculation_payload import FairnessInsightsStartCalculationPayload
from datarobot.models.testing.generated.model.fairness_insights_start_calculation_response import FairnessInsightsStartCalculationResponse
from datarobot.models.testing.generated.model.feature_association_create_payload import FeatureAssociationCreatePayload
from datarobot.models.testing.generated.model.feature_association_details_retrieve_controller_response import FeatureAssociationDetailsRetrieveControllerResponse
from datarobot.models.testing.generated.model.feature_association_list_controller_response import FeatureAssociationListControllerResponse
from datarobot.models.testing.generated.model.feature_association_retrieve_controller_response import FeatureAssociationRetrieveControllerResponse
from datarobot.models.testing.generated.model.feature_effect_create import FeatureEffectCreate
from datarobot.models.testing.generated.model.feature_effects_create_datetime import FeatureEffectsCreateDatetime
from datarobot.models.testing.generated.model.feature_effects_datetime_response import FeatureEffectsDatetimeResponse
from datarobot.models.testing.generated.model.feature_effects_response import FeatureEffectsResponse
from datarobot.models.testing.generated.model.feature_fit_datetime_response import FeatureFitDatetimeResponse
from datarobot.models.testing.generated.model.feature_fit_response import FeatureFitResponse
from datarobot.models.testing.generated.model.feature_impact_create_payload import FeatureImpactCreatePayload
from datarobot.models.testing.generated.model.feature_impact_response import FeatureImpactResponse
from datarobot.models.testing.generated.model.frequent_values_response import FrequentValuesResponse
from datarobot.models.testing.generated.model.lift_chart_for_datasets_list import LiftChartForDatasetsList
from datarobot.models.testing.generated.model.model_confusion_chart_class_details_for_dataset_retrieve import ModelConfusionChartClassDetailsForDatasetRetrieve
from datarobot.models.testing.generated.model.model_xray_create_datetime import ModelXrayCreateDatetime
from datarobot.models.testing.generated.model.model_xray_metadata_datetime_response import ModelXrayMetadataDatetimeResponse
from datarobot.models.testing.generated.model.model_xray_metadata_response import ModelXrayMetadataResponse
from datarobot.models.testing.generated.model.multiclass_feature_impact_response import MulticlassFeatureImpactResponse
from datarobot.models.testing.generated.model.multiclass_lift_chart_for_datasets_list import MulticlassLiftChartForDatasetsList
from datarobot.models.testing.generated.model.payoff_matrices_create import PayoffMatricesCreate
from datarobot.models.testing.generated.model.payoff_matrices_list_response import PayoffMatricesListResponse
from datarobot.models.testing.generated.model.payoff_matrices_response import PayoffMatricesResponse
from datarobot.models.testing.generated.model.prediction_explanations_create import PredictionExplanationsCreate
from datarobot.models.testing.generated.model.prediction_explanations_initialization_create import PredictionExplanationsInitializationCreate
from datarobot.models.testing.generated.model.prediction_explanations_initialization_retrieve import PredictionExplanationsInitializationRetrieve
from datarobot.models.testing.generated.model.prediction_explanations_record import PredictionExplanationsRecord
from datarobot.models.testing.generated.model.prediction_explanations_record_list import PredictionExplanationsRecordList
from datarobot.models.testing.generated.model.prediction_explanations_retrieve import PredictionExplanationsRetrieve
from datarobot.models.testing.generated.model.residuals_chart_for_datasets_list import ResidualsChartForDatasetsList
from datarobot.models.testing.generated.model.roc_curve_for_datasets_list import RocCurveForDatasetsList
from datarobot.models.testing.generated.model.shap_impact_retrieve_response import ShapImpactRetrieveResponse
from datarobot.utils import from_api
from datarobot.models.testing.generated.model import *

from datarobot.models.testing.generated.api.insights_api import InsightsApi




@responses.activate
def test_insights_api_projects_anomaly_assessment_records_delete(unittest_endpoint):
    responses.add(
        responses.DELETE,
        '{endpoint}/api/v2/projects/{projectId}/anomalyAssessmentRecords/{recordId}/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", recordId="recordId_example", ),
        status=204,
        content_type='',
    )
    result = InsightsApi.projects_anomaly_assessment_records_delete(project_id="projectId_example", record_id="recordId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_insights_api_projects_anomaly_assessment_records_explanations_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/anomalyAssessmentRecords/{recordId}/explanations/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", recordId="recordId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "backtest" : "",
  "recordId" : "recordId",
  "data" : [ {
    "shapExplanation" : [ {
      "featureValue" : "featureValue",
      "feature" : "feature",
      "strength" : 1.4658129805029452
    }, {
      "featureValue" : "featureValue",
      "feature" : "feature",
      "strength" : 1.4658129805029452
    } ],
    "prediction" : 6.027456183070403,
    "timestamp" : "2000-01-23T04:56:07.000+00:00"
  }, {
    "shapExplanation" : [ {
      "featureValue" : "featureValue",
      "feature" : "feature",
      "strength" : 1.4658129805029452
    }, {
      "featureValue" : "featureValue",
      "feature" : "feature",
      "strength" : 1.4658129805029452
    } ],
    "prediction" : 6.027456183070403,
    "timestamp" : "2000-01-23T04:56:07.000+00:00"
  } ],
  "endDate" : "2000-01-23T04:56:07.000+00:00",
  "modelId" : "modelId",
  "count" : 0,
  "shapBaseValue" : 5.962133916683182,
  "source" : "training",
  "projectId" : "projectId",
  "seriesId" : "seriesId",
  "startDate" : "2000-01-23T04:56:07.000+00:00"
})
    )
    result = InsightsApi.projects_anomaly_assessment_records_explanations_list(project_id="projectId_example", record_id="recordId_example", )
    assert isinstance(result, AnomalyAssessmentExplanationsResponse)


@responses.activate
def test_insights_api_projects_anomaly_assessment_records_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/anomalyAssessmentRecords/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "backtest" : "",
    "endDate" : "2000-01-23T04:56:07.000+00:00",
    "modelId" : "modelId",
    "previewLocation" : "https://openapi-generator.tech",
    "source" : "training",
    "seriesId" : "seriesId",
    "predictionThreshold" : 6.027456183070403,
    "recordId" : "recordId",
    "deleteLocation" : "https://openapi-generator.tech",
    "latestExplanationsLocation" : "https://openapi-generator.tech",
    "statusDetails" : "statusDetails",
    "projectId" : "projectId",
    "startDate" : "2000-01-23T04:56:07.000+00:00",
    "status" : "noData"
  }, {
    "backtest" : "",
    "endDate" : "2000-01-23T04:56:07.000+00:00",
    "modelId" : "modelId",
    "previewLocation" : "https://openapi-generator.tech",
    "source" : "training",
    "seriesId" : "seriesId",
    "predictionThreshold" : 6.027456183070403,
    "recordId" : "recordId",
    "deleteLocation" : "https://openapi-generator.tech",
    "latestExplanationsLocation" : "https://openapi-generator.tech",
    "statusDetails" : "statusDetails",
    "projectId" : "projectId",
    "startDate" : "2000-01-23T04:56:07.000+00:00",
    "status" : "noData"
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0
})
    )
    result = InsightsApi.projects_anomaly_assessment_records_list(project_id="projectId_example", )
    assert isinstance(result, AnomalyAssessmentRecordsResponse)


@responses.activate
def test_insights_api_projects_anomaly_assessment_records_predictions_preview_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/anomalyAssessmentRecords/{recordId}/predictionsPreview/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", recordId="recordId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "backtest" : "",
  "recordId" : "recordId",
  "endDate" : "2000-01-23T04:56:07.000+00:00",
  "modelId" : "modelId",
  "previewBins" : [ {
    "endDate" : "2000-01-23T04:56:07.000+00:00",
    "maxPredicted" : 1.4658129805029452,
    "avgPredicted" : 0.8008281904610115,
    "startDate" : "2000-01-23T04:56:07.000+00:00",
    "frequency" : 6
  }, {
    "endDate" : "2000-01-23T04:56:07.000+00:00",
    "maxPredicted" : 1.4658129805029452,
    "avgPredicted" : 0.8008281904610115,
    "startDate" : "2000-01-23T04:56:07.000+00:00",
    "frequency" : 6
  } ],
  "source" : "training",
  "projectId" : "projectId",
  "seriesId" : "seriesId",
  "startDate" : "2000-01-23T04:56:07.000+00:00"
})
    )
    result = InsightsApi.projects_anomaly_assessment_records_predictions_preview_list(project_id="projectId_example", record_id="recordId_example", )
    assert isinstance(result, AnomalyAssessmentPreviewResponse)


@responses.activate
def test_insights_api_projects_bias_vs_accuracy_insights_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/biasVsAccuracyInsights/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "data" : [ {
    "models" : [ {
      "prime" : True,
      "samplepct" : 23.02135886934765,
      "fairnessValue" : 0.5962133916683182,
      "dsName" : "dsName",
      "modelId" : "modelId",
      "accuracyValue" : 0.6027456183070403,
      "modelNumber" : 0,
      "modelType" : "modelType",
      "bp" : 0
    }, {
      "prime" : True,
      "samplepct" : 23.02135886934765,
      "fairnessValue" : 0.5962133916683182,
      "dsName" : "dsName",
      "modelId" : "modelId",
      "accuracyValue" : 0.6027456183070403,
      "modelNumber" : 0,
      "modelType" : "modelType",
      "bp" : 0
    } ],
    "protectedFeature" : "",
    "fairnessThreshold" : 0.08008281904610115,
    "accuracyMetric" : "AUC",
    "fairnessMetric" : ""
  }, {
    "models" : [ {
      "prime" : True,
      "samplepct" : 23.02135886934765,
      "fairnessValue" : 0.5962133916683182,
      "dsName" : "dsName",
      "modelId" : "modelId",
      "accuracyValue" : 0.6027456183070403,
      "modelNumber" : 0,
      "modelType" : "modelType",
      "bp" : 0
    }, {
      "prime" : True,
      "samplepct" : 23.02135886934765,
      "fairnessValue" : 0.5962133916683182,
      "dsName" : "dsName",
      "modelId" : "modelId",
      "accuracyValue" : 0.6027456183070403,
      "modelNumber" : 0,
      "modelType" : "modelType",
      "bp" : 0
    } ],
    "protectedFeature" : "",
    "fairnessThreshold" : 0.08008281904610115,
    "accuracyMetric" : "AUC",
    "fairnessMetric" : ""
  } ]
})
    )
    result = InsightsApi.projects_bias_vs_accuracy_insights_list(project_id="projectId_example", )
    assert isinstance(result, BiasVsAccuracyInsightRetrieve)


@responses.activate
def test_insights_api_projects_datetime_models_dataset_accuracy_over_time_plots_metadata_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/datetimeModels/{modelId}/datasetAccuracyOverTimePlots/{datasetId}/metadata/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", datasetId="datasetId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "metricName" : "metricName",
  "modelId" : "modelId",
  "frequencyType" : "rowCount",
  "datasetId" : "datasetId",
  "datasetMetadata" : {
    "endDate" : "2000-01-23T04:56:07.000+00:00",
    "startDate" : "2000-01-23T04:56:07.000+00:00"
  },
  "resolutions" : [ "microseconds", "microseconds" ],
  "projectId" : "projectId"
})
    )
    result = InsightsApi.projects_datetime_models_dataset_accuracy_over_time_plots_metadata_list(project_id="projectId_example", model_id="modelId_example", dataset_id="datasetId_example", )
    assert isinstance(result, AOTChartMetadataResponse)


@responses.activate
def test_insights_api_projects_datetime_models_dataset_accuracy_over_time_plots_preview_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/datetimeModels/{modelId}/datasetAccuracyOverTimePlots/{datasetId}/preview/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", datasetId="datasetId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "bins" : [ {
    "actual" : 0.8008281904610115,
    "endDate" : "2000-01-23T04:56:07.000+00:00",
    "predicted" : 1.4658129805029452,
    "startDate" : "2000-01-23T04:56:07.000+00:00",
    "frequency" : 6.027456183070403
  }, {
    "actual" : 0.8008281904610115,
    "endDate" : "2000-01-23T04:56:07.000+00:00",
    "predicted" : 1.4658129805029452,
    "startDate" : "2000-01-23T04:56:07.000+00:00",
    "frequency" : 6.027456183070403
  } ],
  "modelId" : "modelId",
  "datasetId" : "datasetId",
  "projectId" : "projectId"
})
    )
    result = InsightsApi.projects_datetime_models_dataset_accuracy_over_time_plots_preview_list(project_id="projectId_example", model_id="modelId_example", dataset_id="datasetId_example", )
    assert isinstance(result, AOTChartPreviewResponse)


@responses.activate
def test_insights_api_projects_datetime_models_dataset_accuracy_over_time_plots_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/datetimeModels/{modelId}/datasetAccuracyOverTimePlots/{datasetId}/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", datasetId="datasetId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "bins" : [ {
    "actual" : 0.8008281904610115,
    "endDate" : "2000-01-23T04:56:07.000+00:00",
    "predicted" : 1.4658129805029452,
    "startDate" : "2000-01-23T04:56:07.000+00:00",
    "frequency" : 6.027456183070403
  }, {
    "actual" : 0.8008281904610115,
    "endDate" : "2000-01-23T04:56:07.000+00:00",
    "predicted" : 1.4658129805029452,
    "startDate" : "2000-01-23T04:56:07.000+00:00",
    "frequency" : 6.027456183070403
  } ],
  "endDate" : "2000-01-23T04:56:07.000+00:00",
  "modelId" : "modelId",
  "datasetId" : "datasetId",
  "projectId" : "projectId",
  "resolution" : "microseconds",
  "startDate" : "2000-01-23T04:56:07.000+00:00",
  "statistics" : {
    "durbinWatson" : 5.962133916683182
  }
})
    )
    result = InsightsApi.projects_datetime_models_dataset_accuracy_over_time_plots_retrieve(project_id="projectId_example", model_id="modelId_example", dataset_id="datasetId_example", )
    assert isinstance(result, AOTChartRetrieveResponse)


@responses.activate
def test_insights_api_projects_datetime_models_feature_effects_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/api/v2/projects/{projectId}/datetimeModels/{modelId}/featureEffects/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=202,
        content_type='',
    )
    result = InsightsApi.projects_datetime_models_feature_effects_create(project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_insights_api_projects_datetime_models_feature_effects_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/datetimeModels/{modelId}/featureEffects/'.format(endpoint=unittest_endpoint,
        backtestIndex="backtestIndex_example", projectId="projectId_example", modelId="modelId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "backtestIndex" : "backtestIndex",
  "modelId" : "modelId",
  "featureEffects" : [ {
    "isScalable" : True,
    "featureName" : "featureName",
    "predictedVsActual" : {
      "data" : [ {
        "actual" : 1.4658129805029452,
        "bin" : [ "bin", "bin" ],
        "label" : "label",
        "rowCount" : 5,
        "predicted" : 5.962133916683182
      }, {
        "actual" : 1.4658129805029452,
        "bin" : [ "bin", "bin" ],
        "label" : "label",
        "rowCount" : 5,
        "predicted" : 5.962133916683182
      } ],
      "isCapped" : True
    },
    "weightLabel" : "weightLabel",
    "featureType" : "featureType",
    "featureImpactScore" : 0.8008281904610115,
    "partialDependence" : {
      "data" : [ {
        "dependence" : 6.027456183070403,
        "label" : "label"
      }, {
        "dependence" : 6.027456183070403,
        "label" : "label"
      } ],
      "isCapped" : True
    }
  }, {
    "isScalable" : True,
    "featureName" : "featureName",
    "predictedVsActual" : {
      "data" : [ {
        "actual" : 1.4658129805029452,
        "bin" : [ "bin", "bin" ],
        "label" : "label",
        "rowCount" : 5,
        "predicted" : 5.962133916683182
      }, {
        "actual" : 1.4658129805029452,
        "bin" : [ "bin", "bin" ],
        "label" : "label",
        "rowCount" : 5,
        "predicted" : 5.962133916683182
      } ],
      "isCapped" : True
    },
    "weightLabel" : "weightLabel",
    "featureType" : "featureType",
    "featureImpactScore" : 0.8008281904610115,
    "partialDependence" : {
      "data" : [ {
        "dependence" : 6.027456183070403,
        "label" : "label"
      }, {
        "dependence" : 6.027456183070403,
        "label" : "label"
      } ],
      "isCapped" : True
    }
  } ],
  "source" : "source",
  "projectId" : "projectId"
})
    )
    result = InsightsApi.projects_datetime_models_feature_effects_list(backtest_index="backtestIndex_example", project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, FeatureEffectsDatetimeResponse)


@responses.activate
def test_insights_api_projects_datetime_models_feature_effects_metadata_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/datetimeModels/{modelId}/featureEffectsMetadata/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "data" : [ {
    "backtestIndex" : "backtestIndex",
    "sources" : [ "training", "training" ],
    "status" : "INPROGRESS"
  }, {
    "backtestIndex" : "backtestIndex",
    "sources" : [ "training", "training" ],
    "status" : "INPROGRESS"
  } ]
})
    )
    result = InsightsApi.projects_datetime_models_feature_effects_metadata_list(project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, ModelXrayMetadataDatetimeResponse)


@responses.activate
def test_insights_api_projects_datetime_models_feature_fit_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/api/v2/projects/{projectId}/datetimeModels/{modelId}/featureFit/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=202,
        content_type='',
    )
    result = InsightsApi.projects_datetime_models_feature_fit_create(project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_insights_api_projects_datetime_models_feature_fit_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/datetimeModels/{modelId}/featureFit/'.format(endpoint=unittest_endpoint,
        backtestIndex="backtestIndex_example", projectId="projectId_example", modelId="modelId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "backtestIndex" : "backtestIndex",
  "modelId" : "modelId",
  "source" : "source",
  "projectId" : "projectId",
  "featureFit" : [ {
    "isScalable" : True,
    "featureName" : "featureName",
    "predictedVsActual" : {
      "data" : [ {
        "actual" : 1.4658129805029452,
        "bin" : [ "bin", "bin" ],
        "label" : "label",
        "rowCount" : 5,
        "predicted" : 5.962133916683182
      }, {
        "actual" : 1.4658129805029452,
        "bin" : [ "bin", "bin" ],
        "label" : "label",
        "rowCount" : 5,
        "predicted" : 5.962133916683182
      } ],
      "isCapped" : True
    },
    "weightLabel" : "weightLabel",
    "featureImportanceScore" : 0.8008281904610115,
    "featureType" : "featureType",
    "partialDependence" : {
      "data" : [ {
        "dependence" : 6.027456183070403,
        "label" : "label"
      }, {
        "dependence" : 6.027456183070403,
        "label" : "label"
      } ],
      "isCapped" : True
    }
  }, {
    "isScalable" : True,
    "featureName" : "featureName",
    "predictedVsActual" : {
      "data" : [ {
        "actual" : 1.4658129805029452,
        "bin" : [ "bin", "bin" ],
        "label" : "label",
        "rowCount" : 5,
        "predicted" : 5.962133916683182
      }, {
        "actual" : 1.4658129805029452,
        "bin" : [ "bin", "bin" ],
        "label" : "label",
        "rowCount" : 5,
        "predicted" : 5.962133916683182
      } ],
      "isCapped" : True
    },
    "weightLabel" : "weightLabel",
    "featureImportanceScore" : 0.8008281904610115,
    "featureType" : "featureType",
    "partialDependence" : {
      "data" : [ {
        "dependence" : 6.027456183070403,
        "label" : "label"
      }, {
        "dependence" : 6.027456183070403,
        "label" : "label"
      } ],
      "isCapped" : True
    }
  } ]
})
    )
    result = InsightsApi.projects_datetime_models_feature_fit_list(backtest_index="backtestIndex_example", project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, FeatureFitDatetimeResponse)


@responses.activate
def test_insights_api_projects_datetime_models_feature_fit_metadata_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/datetimeModels/{modelId}/featureFitMetadata/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "data" : [ {
    "backtestIndex" : "backtestIndex",
    "sources" : [ "training", "training" ],
    "status" : "INPROGRESS"
  }, {
    "backtestIndex" : "backtestIndex",
    "sources" : [ "training", "training" ],
    "status" : "INPROGRESS"
  } ]
})
    )
    result = InsightsApi.projects_datetime_models_feature_fit_metadata_list(project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, ModelXrayMetadataDatetimeResponse)


@responses.activate
def test_insights_api_projects_external_scores_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/api/v2/projects/{projectId}/externalScores/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", ),
        status=202,
        content_type='',
    )
    result = InsightsApi.projects_external_scores_create(project_id="projectId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_insights_api_projects_external_scores_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/externalScores/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "next",
  "data" : [ {
    "modelId" : "modelId",
    "scores" : [ {
      "label" : "label",
      "value" : 6.027456183070403
    }, {
      "label" : "label",
      "value" : 6.027456183070403
    } ],
    "actualValueColumn" : "actualValueColumn",
    "datasetId" : "datasetId",
    "projectId" : "projectId"
  }, {
    "modelId" : "modelId",
    "scores" : [ {
      "label" : "label",
      "value" : 6.027456183070403
    }, {
      "label" : "label",
      "value" : 6.027456183070403
    } ],
    "actualValueColumn" : "actualValueColumn",
    "datasetId" : "datasetId",
    "projectId" : "projectId"
  } ],
  "previous" : "previous",
  "count" : 0
})
    )
    result = InsightsApi.projects_external_scores_list(project_id="projectId_example", )
    assert isinstance(result, ExternalScoresListResponse)


@responses.activate
def test_insights_api_projects_feature_association_featurelists_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/featureAssociationFeaturelists/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "featurelists" : [ {
    "featurelistId" : "featurelistId",
    "hasFam" : True,
    "title" : "title"
  }, {
    "featurelistId" : "featurelistId",
    "hasFam" : True,
    "title" : "title"
  } ]
})
    )
    result = InsightsApi.projects_feature_association_featurelists_list(project_id="projectId_example", )
    assert isinstance(result, FeatureAssociationListControllerResponse)


@responses.activate
def test_insights_api_projects_feature_association_matrix_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/api/v2/projects/{projectId}/featureAssociationMatrix/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", ),
        status=202,
        content_type='',
    )
    result = InsightsApi.projects_feature_association_matrix_create(project_id="projectId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_insights_api_projects_feature_association_matrix_details_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/featureAssociationMatrixDetails/'.format(endpoint=unittest_endpoint,
        feature1="feature1_example", feature2="feature2_example", projectId="projectId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "features" : [ "features", "features" ],
  "types" : [ "CATEGORICAL", "CATEGORICAL" ],
  "values" : [ [ "", "" ], [ "", "" ] ],
  "chartType" : "chartType"
})
    )
    result = InsightsApi.projects_feature_association_matrix_details_list(feature1="feature1_example", feature2="feature2_example", project_id="projectId_example", )
    assert isinstance(result, FeatureAssociationDetailsRetrieveControllerResponse)


@responses.activate
def test_insights_api_projects_feature_association_matrix_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/featureAssociationMatrix/'.format(endpoint=unittest_endpoint,
        type="association", metric="mutualInfo", projectId="projectId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "features" : [ {
    "feature" : "feature",
    "clusterName" : "clusterName",
    "alphabeticSortIndex" : 0,
    "clusterSortIndex" : 1,
    "clusterId" : 6,
    "importanceSortIndex" : 5,
    "strengthSortIndex" : 5
  }, {
    "feature" : "feature",
    "clusterName" : "clusterName",
    "alphabeticSortIndex" : 0,
    "clusterSortIndex" : 1,
    "clusterId" : 6,
    "importanceSortIndex" : 5,
    "strengthSortIndex" : 5
  } ],
  "strengths" : [ {
    "feature2" : "feature2",
    "statistic" : 2.3021358869347655,
    "feature1" : "feature1"
  }, {
    "feature2" : "feature2",
    "statistic" : 2.3021358869347655,
    "feature1" : "feature1"
  } ]
})
    )
    result = InsightsApi.projects_feature_association_matrix_list(type="association", metric="mutualInfo", project_id="projectId_example", )
    assert isinstance(result, FeatureAssociationRetrieveControllerResponse)


@responses.activate
def test_insights_api_projects_features_frequent_values_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/features/{featureName}/frequentValues/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", featureName="featureName_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "numRows" : 1,
  "name" : "name",
  "projectId" : "projectId",
  "frequentValues" : [ {
    "dataQuality" : "dataQuality",
    "count" : 0,
    "value" : "",
    "target" : 6.027456183070403
  }, {
    "dataQuality" : "dataQuality",
    "count" : 0,
    "value" : "",
    "target" : 6.027456183070403
  } ]
})
    )
    result = InsightsApi.projects_features_frequent_values_list(project_id="projectId_example", feature_name="featureName_example", )
    assert isinstance(result, FrequentValuesResponse)


@responses.activate
def test_insights_api_projects_models_anomaly_assessment_initialization_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/api/v2/projects/{projectId}/models/{modelId}/anomalyAssessmentInitialization/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=202,
        content_type='',
    )
    result = InsightsApi.projects_models_anomaly_assessment_initialization_create(project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_insights_api_projects_models_cross_class_accuracy_scores_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/api/v2/projects/{projectId}/models/{modelId}/crossClassAccuracyScores/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=202,
        content_type='application/json',
        body=json.dumps({
  "statusId" : "statusId"
})
    )
    result = InsightsApi.projects_models_cross_class_accuracy_scores_create(project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, CrossClassAccuracyCreateResponse)


@responses.activate
def test_insights_api_projects_models_cross_class_accuracy_scores_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/models/{modelId}/crossClassAccuracyScores/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "predictionThreshold" : 0.14658129805029452,
    "feature" : "feature",
    "modelId" : "modelId",
    "perClassAccuracyScores" : [ {
      "className" : "className",
      "metrics" : [ {
        "metric" : "AUC",
        "value" : 0.6027456183070403
      }, {
        "metric" : "AUC",
        "value" : 0.6027456183070403
      } ]
    }, {
      "className" : "className",
      "metrics" : [ {
        "metric" : "AUC",
        "value" : 0.6027456183070403
      }, {
        "metric" : "AUC",
        "value" : 0.6027456183070403
      } ]
    } ]
  }, {
    "predictionThreshold" : 0.14658129805029452,
    "feature" : "feature",
    "modelId" : "modelId",
    "perClassAccuracyScores" : [ {
      "className" : "className",
      "metrics" : [ {
        "metric" : "AUC",
        "value" : 0.6027456183070403
      }, {
        "metric" : "AUC",
        "value" : 0.6027456183070403
      } ]
    }, {
      "className" : "className",
      "metrics" : [ {
        "metric" : "AUC",
        "value" : 0.6027456183070403
      }, {
        "metric" : "AUC",
        "value" : 0.6027456183070403
      } ]
    } ]
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0,
  "totalCount" : 5
})
    )
    result = InsightsApi.projects_models_cross_class_accuracy_scores_list(project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, CrossClassAccuracyList)


@responses.activate
def test_insights_api_projects_models_data_disparity_insights_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/api/v2/projects/{projectId}/models/{modelId}/dataDisparityInsights/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=202,
        content_type='application/json',
        body=json.dumps({
  "statusId" : "statusId"
})
    )
    result = InsightsApi.projects_models_data_disparity_insights_create(project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, DataDisparityCreateResponse)


@responses.activate
def test_insights_api_projects_models_data_disparity_insights_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/models/{modelId}/dataDisparityInsights/'.format(endpoint=unittest_endpoint,
        feature="feature_example", className1="className1_example", className2="className2_example", projectId="projectId_example", modelId="modelId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : {
    "features" : [ {
      "disparityScore" : 1.4658129805029452,
      "name" : "name",
      "detailsHistogram" : [ {
        "bin" : "bin",
        "bars" : [ {
          "label" : "label",
          "value" : 6.027456183070403
        }, {
          "label" : "label",
          "value" : 6.027456183070403
        } ]
      }, {
        "bin" : "bin",
        "bars" : [ {
          "label" : "label",
          "value" : 6.027456183070403
        }, {
          "label" : "label",
          "value" : 6.027456183070403
        } ]
      } ],
      "featureImpact" : 5.962133916683182,
      "status" : "Healthy"
    }, {
      "disparityScore" : 1.4658129805029452,
      "name" : "name",
      "detailsHistogram" : [ {
        "bin" : "bin",
        "bars" : [ {
          "label" : "label",
          "value" : 6.027456183070403
        }, {
          "label" : "label",
          "value" : 6.027456183070403
        } ]
      }, {
        "bin" : "bin",
        "bars" : [ {
          "label" : "label",
          "value" : 6.027456183070403
        }, {
          "label" : "label",
          "value" : 6.027456183070403
        } ]
      } ],
      "featureImpact" : 5.962133916683182,
      "status" : "Healthy"
    } ],
    "metric" : "metric",
    "protectedFeature" : "protectedFeature",
    "values" : [ {
      "count" : 5,
      "label" : "label"
    }, {
      "count" : 5,
      "label" : "label"
    } ]
  },
  "previous" : "https://openapi-generator.tech",
  "count" : 0,
  "totalCount" : 2
})
    )
    result = InsightsApi.projects_models_data_disparity_insights_list(feature="feature_example", class_name1="className1_example", class_name2="className2_example", project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, DataDisparityRetrieveResponse)


@responses.activate
def test_insights_api_projects_models_dataset_confusion_charts_class_details_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/models/{modelId}/datasetConfusionCharts/{datasetId}/classDetails/'.format(endpoint=unittest_endpoint,
        className="className_example", projectId="projectId_example", modelId="modelId_example", datasetId="datasetId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "modelId" : "modelId",
  "predictedFrequency" : [ {
    "percentage" : 14.658129805029452,
    "otherClassName" : "otherClassName",
    "value" : 0
  }, {
    "percentage" : 14.658129805029452,
    "otherClassName" : "otherClassName",
    "value" : 0
  } ],
  "datasetId" : "datasetId",
  "className" : "className",
  "projectId" : "projectId",
  "actualFrequency" : [ {
    "percentage" : 8.008281904610115,
    "otherClassName" : "otherClassName",
    "value" : 0
  }, {
    "percentage" : 8.008281904610115,
    "otherClassName" : "otherClassName",
    "value" : 0
  } ]
})
    )
    result = InsightsApi.projects_models_dataset_confusion_charts_class_details_list(class_name="className_example", project_id="projectId_example", model_id="modelId_example", dataset_id="datasetId_example", )
    assert isinstance(result, ModelConfusionChartClassDetailsForDatasetRetrieve)


@responses.activate
def test_insights_api_projects_models_dataset_confusion_charts_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/models/{modelId}/datasetConfusionCharts/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "data" : {
      "classMetrics" : [ {
        "wasPredictedPercentages" : [ {
          "percentage" : 3.616076749251911,
          "otherClassName" : "otherClassName"
        }, {
          "percentage" : 3.616076749251911,
          "otherClassName" : "otherClassName"
        } ],
        "wasActualPercentages" : [ {
          "percentage" : 9.301444243932576,
          "otherClassName" : "otherClassName"
        }, {
          "percentage" : 9.301444243932576,
          "otherClassName" : "otherClassName"
        } ],
        "confusionMatrixOneVsAll" : [ [ 1, 1 ], [ 1, 1 ] ],
        "actualCount" : 6,
        "precision" : 5.637376656633329,
        "recall" : 7.061401241503109,
        "className" : "className",
        "f1" : 5.962133916683182,
        "predictedCount" : 2
      }, {
        "wasPredictedPercentages" : [ {
          "percentage" : 3.616076749251911,
          "otherClassName" : "otherClassName"
        }, {
          "percentage" : 3.616076749251911,
          "otherClassName" : "otherClassName"
        } ],
        "wasActualPercentages" : [ {
          "percentage" : 9.301444243932576,
          "otherClassName" : "otherClassName"
        }, {
          "percentage" : 9.301444243932576,
          "otherClassName" : "otherClassName"
        } ],
        "confusionMatrixOneVsAll" : [ [ 1, 1 ], [ 1, 1 ] ],
        "actualCount" : 6,
        "precision" : 5.637376656633329,
        "recall" : 7.061401241503109,
        "className" : "className",
        "f1" : 5.962133916683182,
        "predictedCount" : 2
      } ],
      "classes" : [ "classes", "classes" ],
      "confusionMatrix" : [ [ 2, 2 ], [ 2, 2 ] ],
      "rowClasses" : [ "rowClasses", "rowClasses" ],
      "colClasses" : [ "colClasses", "colClasses" ]
    },
    "totalMatrixSum" : 1,
    "columns" : [ 0, 0 ],
    "numberOfClasses" : 4,
    "source" : "validation",
    "rows" : [ 7, 7 ]
  }, {
    "data" : {
      "classMetrics" : [ {
        "wasPredictedPercentages" : [ {
          "percentage" : 3.616076749251911,
          "otherClassName" : "otherClassName"
        }, {
          "percentage" : 3.616076749251911,
          "otherClassName" : "otherClassName"
        } ],
        "wasActualPercentages" : [ {
          "percentage" : 9.301444243932576,
          "otherClassName" : "otherClassName"
        }, {
          "percentage" : 9.301444243932576,
          "otherClassName" : "otherClassName"
        } ],
        "confusionMatrixOneVsAll" : [ [ 1, 1 ], [ 1, 1 ] ],
        "actualCount" : 6,
        "precision" : 5.637376656633329,
        "recall" : 7.061401241503109,
        "className" : "className",
        "f1" : 5.962133916683182,
        "predictedCount" : 2
      }, {
        "wasPredictedPercentages" : [ {
          "percentage" : 3.616076749251911,
          "otherClassName" : "otherClassName"
        }, {
          "percentage" : 3.616076749251911,
          "otherClassName" : "otherClassName"
        } ],
        "wasActualPercentages" : [ {
          "percentage" : 9.301444243932576,
          "otherClassName" : "otherClassName"
        }, {
          "percentage" : 9.301444243932576,
          "otherClassName" : "otherClassName"
        } ],
        "confusionMatrixOneVsAll" : [ [ 1, 1 ], [ 1, 1 ] ],
        "actualCount" : 6,
        "precision" : 5.637376656633329,
        "recall" : 7.061401241503109,
        "className" : "className",
        "f1" : 5.962133916683182,
        "predictedCount" : 2
      } ],
      "classes" : [ "classes", "classes" ],
      "confusionMatrix" : [ [ 2, 2 ], [ 2, 2 ] ],
      "rowClasses" : [ "rowClasses", "rowClasses" ],
      "colClasses" : [ "colClasses", "colClasses" ]
    },
    "totalMatrixSum" : 1,
    "columns" : [ 0, 0 ],
    "numberOfClasses" : 4,
    "source" : "validation",
    "rows" : [ 7, 7 ]
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0,
  "totalCount" : 6
})
    )
    result = InsightsApi.projects_models_dataset_confusion_charts_list(project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, ConfusionChartForDatasetsListResponse)


@responses.activate
def test_insights_api_projects_models_dataset_confusion_charts_metadata_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/models/{modelId}/datasetConfusionCharts/{datasetId}/metadata/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", datasetId="datasetId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "relevantClassesPositions" : [ [ 0, 0 ], [ 0, 0 ] ],
  "modelId" : "modelId",
  "totalMatrixSum" : 6,
  "datasetId" : "datasetId",
  "classNames" : [ "classNames", "classNames" ],
  "projectId" : "projectId"
})
    )
    result = InsightsApi.projects_models_dataset_confusion_charts_metadata_list(project_id="projectId_example", model_id="modelId_example", dataset_id="datasetId_example", )
    assert isinstance(result, ConfusionChartRetrieveMetadataForDatasets)


@responses.activate
def test_insights_api_projects_models_dataset_confusion_charts_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/models/{modelId}/datasetConfusionCharts/{datasetId}/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", datasetId="datasetId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "data" : {
    "classMetrics" : [ {
      "wasPredictedPercentages" : [ {
        "percentage" : 3.616076749251911,
        "otherClassName" : "otherClassName"
      }, {
        "percentage" : 3.616076749251911,
        "otherClassName" : "otherClassName"
      } ],
      "wasActualPercentages" : [ {
        "percentage" : 9.301444243932576,
        "otherClassName" : "otherClassName"
      }, {
        "percentage" : 9.301444243932576,
        "otherClassName" : "otherClassName"
      } ],
      "confusionMatrixOneVsAll" : [ [ 1, 1 ], [ 1, 1 ] ],
      "actualCount" : 6,
      "precision" : 5.637376656633329,
      "recall" : 7.061401241503109,
      "className" : "className",
      "f1" : 5.962133916683182,
      "predictedCount" : 2
    }, {
      "wasPredictedPercentages" : [ {
        "percentage" : 3.616076749251911,
        "otherClassName" : "otherClassName"
      }, {
        "percentage" : 3.616076749251911,
        "otherClassName" : "otherClassName"
      } ],
      "wasActualPercentages" : [ {
        "percentage" : 9.301444243932576,
        "otherClassName" : "otherClassName"
      }, {
        "percentage" : 9.301444243932576,
        "otherClassName" : "otherClassName"
      } ],
      "confusionMatrixOneVsAll" : [ [ 1, 1 ], [ 1, 1 ] ],
      "actualCount" : 6,
      "precision" : 5.637376656633329,
      "recall" : 7.061401241503109,
      "className" : "className",
      "f1" : 5.962133916683182,
      "predictedCount" : 2
    } ],
    "classes" : [ "classes", "classes" ],
    "confusionMatrix" : [ [ 2, 2 ], [ 2, 2 ] ],
    "rowClasses" : [ "rowClasses", "rowClasses" ],
    "colClasses" : [ "colClasses", "colClasses" ]
  },
  "totalMatrixSum" : 5,
  "columns" : [ 0, 0 ],
  "numberOfClasses" : 6,
  "datasetId" : "datasetId",
  "rows" : [ 1, 1 ]
})
    )
    result = InsightsApi.projects_models_dataset_confusion_charts_retrieve(project_id="projectId_example", model_id="modelId_example", dataset_id="datasetId_example", )
    assert isinstance(result, ConfusionChartRetrieveForDatasets)


@responses.activate
def test_insights_api_projects_models_dataset_lift_charts_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/models/{modelId}/datasetLiftCharts/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "bins" : [ {
      "actual" : 6.027456183070403,
      "binWeight" : 1.4658129805029452,
      "predicted" : 5.962133916683182
    }, {
      "actual" : 6.027456183070403,
      "binWeight" : 1.4658129805029452,
      "predicted" : 5.962133916683182
    } ],
    "datasetId" : "datasetId"
  }, {
    "bins" : [ {
      "actual" : 6.027456183070403,
      "binWeight" : 1.4658129805029452,
      "predicted" : 5.962133916683182
    }, {
      "actual" : 6.027456183070403,
      "binWeight" : 1.4658129805029452,
      "predicted" : 5.962133916683182
    } ],
    "datasetId" : "datasetId"
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0
})
    )
    result = InsightsApi.projects_models_dataset_lift_charts_list(project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, LiftChartForDatasetsList)


@responses.activate
def test_insights_api_projects_models_dataset_multiclass_lift_charts_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/models/{modelId}/datasetMulticlassLiftCharts/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "classBins" : [ {
      "bins" : [ {
        "actual" : 6.027456183070403,
        "binWeight" : 1.4658129805029452,
        "predicted" : 5.962133916683182
      }, {
        "actual" : 6.027456183070403,
        "binWeight" : 1.4658129805029452,
        "predicted" : 5.962133916683182
      } ],
      "targetClass" : "targetClass"
    }, {
      "bins" : [ {
        "actual" : 6.027456183070403,
        "binWeight" : 1.4658129805029452,
        "predicted" : 5.962133916683182
      }, {
        "actual" : 6.027456183070403,
        "binWeight" : 1.4658129805029452,
        "predicted" : 5.962133916683182
      } ],
      "targetClass" : "targetClass"
    } ],
    "datasetId" : "datasetId"
  }, {
    "classBins" : [ {
      "bins" : [ {
        "actual" : 6.027456183070403,
        "binWeight" : 1.4658129805029452,
        "predicted" : 5.962133916683182
      }, {
        "actual" : 6.027456183070403,
        "binWeight" : 1.4658129805029452,
        "predicted" : 5.962133916683182
      } ],
      "targetClass" : "targetClass"
    }, {
      "bins" : [ {
        "actual" : 6.027456183070403,
        "binWeight" : 1.4658129805029452,
        "predicted" : 5.962133916683182
      }, {
        "actual" : 6.027456183070403,
        "binWeight" : 1.4658129805029452,
        "predicted" : 5.962133916683182
      } ],
      "targetClass" : "targetClass"
    } ],
    "datasetId" : "datasetId"
  } ],
  "previous" : "https://openapi-generator.tech",
  "modelId" : "modelId",
  "count" : 0,
  "totalCount" : 6,
  "projectId" : "projectId"
})
    )
    result = InsightsApi.projects_models_dataset_multiclass_lift_charts_list(project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, MulticlassLiftChartForDatasetsList)


@responses.activate
def test_insights_api_projects_models_dataset_residuals_charts_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/models/{modelId}/datasetResidualsCharts/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "histogram" : [ {
      "occurrences" : 2,
      "intervalEnd" : 5.962133916683182,
      "intervalStart" : 5.637376656633329
    }, {
      "occurrences" : 2,
      "intervalEnd" : 5.962133916683182,
      "intervalStart" : 5.637376656633329
    } ],
    "data" : [ [ 1.4658129805029452, 1.4658129805029452 ], [ 1.4658129805029452, 1.4658129805029452 ] ],
    "datasetId" : "datasetId",
    "residualMean" : 7.061401241503109,
    "coefficientOfDetermination" : 6.027456183070403,
    "standardDeviation" : 9.301444243932576
  }, {
    "histogram" : [ {
      "occurrences" : 2,
      "intervalEnd" : 5.962133916683182,
      "intervalStart" : 5.637376656633329
    }, {
      "occurrences" : 2,
      "intervalEnd" : 5.962133916683182,
      "intervalStart" : 5.637376656633329
    } ],
    "data" : [ [ 1.4658129805029452, 1.4658129805029452 ], [ 1.4658129805029452, 1.4658129805029452 ] ],
    "datasetId" : "datasetId",
    "residualMean" : 7.061401241503109,
    "coefficientOfDetermination" : 6.027456183070403,
    "standardDeviation" : 9.301444243932576
  } ],
  "previous" : "https://openapi-generator.tech",
  "modelId" : "modelId",
  "count" : 0,
  "totalCount" : 3,
  "projectId" : "projectId"
})
    )
    result = InsightsApi.projects_models_dataset_residuals_charts_list(project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, ResidualsChartForDatasetsList)


@responses.activate
def test_insights_api_projects_models_dataset_roc_curves_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/models/{modelId}/datasetRocCurves/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "positiveClassPredictions" : [ 1.4658129805029452, 1.4658129805029452 ],
    "datasetId" : "datasetId",
    "negativeClassPredictions" : [ 6.027456183070403, 6.027456183070403 ],
    "rocPoints" : {
      "FalsePositiveRate" : 7.061401241503109,
      "liftNegative" : 4.145608029883936,
      "TruePositiveRate" : 4.965218492984954,
      "accuracy" : 5.962133916683182,
      "TrueNegativeScore" : 1,
      "threshold" : 6.84685269835264,
      "TruePositiveScore" : 5,
      "negativePredictiveValue" : 1.0246457001441578,
      "fractionPredictedAsNegative" : 3.616076749251911,
      "positivePredictiveValue" : 1.4894159098541704,
      "FalseNegativeScore" : 2,
      "FalsePositiveScore" : 9,
      "liftPositive" : 7.386281948385884,
      "matthewsCorrelationCoefficient" : 1.2315135367772556,
      "TrueNegativeRate" : 7.457744773683766,
      "f1Score" : 5.637376656633329,
      "fractionPredictedAsPositive" : 2.027123023002322
    }
  }, {
    "positiveClassPredictions" : [ 1.4658129805029452, 1.4658129805029452 ],
    "datasetId" : "datasetId",
    "negativeClassPredictions" : [ 6.027456183070403, 6.027456183070403 ],
    "rocPoints" : {
      "FalsePositiveRate" : 7.061401241503109,
      "liftNegative" : 4.145608029883936,
      "TruePositiveRate" : 4.965218492984954,
      "accuracy" : 5.962133916683182,
      "TrueNegativeScore" : 1,
      "threshold" : 6.84685269835264,
      "TruePositiveScore" : 5,
      "negativePredictiveValue" : 1.0246457001441578,
      "fractionPredictedAsNegative" : 3.616076749251911,
      "positivePredictiveValue" : 1.4894159098541704,
      "FalseNegativeScore" : 2,
      "FalsePositiveScore" : 9,
      "liftPositive" : 7.386281948385884,
      "matthewsCorrelationCoefficient" : 1.2315135367772556,
      "TrueNegativeRate" : 7.457744773683766,
      "f1Score" : 5.637376656633329,
      "fractionPredictedAsPositive" : 2.027123023002322
    }
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0
})
    )
    result = InsightsApi.projects_models_dataset_roc_curves_list(project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, RocCurveForDatasetsList)


@responses.activate
def test_insights_api_projects_models_fairness_insights_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/api/v2/projects/{projectId}/models/{modelId}/fairnessInsights/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=202,
        content_type='application/json',
        body=json.dumps({
  "statusId" : "statusId"
})
    )
    result = InsightsApi.projects_models_fairness_insights_create(project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, FairnessInsightsStartCalculationResponse)


@responses.activate
def test_insights_api_projects_models_fairness_insights_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/models/{modelId}/fairnessInsights/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "predictionThreshold" : 0.23021358869347652,
    "modelId" : "modelId",
    "protectedFeature" : "protectedFeature",
    "fairnessThreshold" : 0.6027456183070403,
    "perClassFairness" : [ {
      "entriesCount" : 0,
      "absoluteValue" : 0.14658129805029452,
      "className" : "className",
      "isStatisticallySignificant" : True,
      "value" : 0.5637376656633328
    }, {
      "entriesCount" : 0,
      "absoluteValue" : 0.14658129805029452,
      "className" : "className",
      "isStatisticallySignificant" : True,
      "value" : 0.5637376656633328
    } ],
    "fairnessMetric" : "proportionalParity"
  }, {
    "predictionThreshold" : 0.23021358869347652,
    "modelId" : "modelId",
    "protectedFeature" : "protectedFeature",
    "fairnessThreshold" : 0.6027456183070403,
    "perClassFairness" : [ {
      "entriesCount" : 0,
      "absoluteValue" : 0.14658129805029452,
      "className" : "className",
      "isStatisticallySignificant" : True,
      "value" : 0.5637376656633328
    }, {
      "entriesCount" : 0,
      "absoluteValue" : 0.14658129805029452,
      "className" : "className",
      "isStatisticallySignificant" : True,
      "value" : 0.5637376656633328
    } ],
    "fairnessMetric" : "proportionalParity"
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0,
  "totalCount" : 7
})
    )
    result = InsightsApi.projects_models_fairness_insights_list(project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, FairnessInsightsListResponse)


@responses.activate
def test_insights_api_projects_models_feature_effects_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/api/v2/projects/{projectId}/models/{modelId}/featureEffects/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=202,
        content_type='',
    )
    result = InsightsApi.projects_models_feature_effects_create(project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_insights_api_projects_models_feature_effects_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/models/{modelId}/featureEffects/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "modelId" : "modelId",
  "featureEffects" : [ {
    "isScalable" : True,
    "featureName" : "featureName",
    "predictedVsActual" : {
      "data" : [ {
        "actual" : 1.4658129805029452,
        "bin" : [ "bin", "bin" ],
        "label" : "label",
        "rowCount" : 5,
        "predicted" : 5.962133916683182
      }, {
        "actual" : 1.4658129805029452,
        "bin" : [ "bin", "bin" ],
        "label" : "label",
        "rowCount" : 5,
        "predicted" : 5.962133916683182
      } ],
      "isCapped" : True
    },
    "weightLabel" : "weightLabel",
    "featureType" : "featureType",
    "featureImpactScore" : 0.8008281904610115,
    "partialDependence" : {
      "data" : [ {
        "dependence" : 6.027456183070403,
        "label" : "label"
      }, {
        "dependence" : 6.027456183070403,
        "label" : "label"
      } ],
      "isCapped" : True
    }
  }, {
    "isScalable" : True,
    "featureName" : "featureName",
    "predictedVsActual" : {
      "data" : [ {
        "actual" : 1.4658129805029452,
        "bin" : [ "bin", "bin" ],
        "label" : "label",
        "rowCount" : 5,
        "predicted" : 5.962133916683182
      }, {
        "actual" : 1.4658129805029452,
        "bin" : [ "bin", "bin" ],
        "label" : "label",
        "rowCount" : 5,
        "predicted" : 5.962133916683182
      } ],
      "isCapped" : True
    },
    "weightLabel" : "weightLabel",
    "featureType" : "featureType",
    "featureImpactScore" : 0.8008281904610115,
    "partialDependence" : {
      "data" : [ {
        "dependence" : 6.027456183070403,
        "label" : "label"
      }, {
        "dependence" : 6.027456183070403,
        "label" : "label"
      } ],
      "isCapped" : True
    }
  } ],
  "source" : "source",
  "projectId" : "projectId"
})
    )
    result = InsightsApi.projects_models_feature_effects_list(project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, FeatureEffectsResponse)


@responses.activate
def test_insights_api_projects_models_feature_effects_metadata_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/models/{modelId}/featureEffectsMetadata/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "sources" : [ "training", "training" ],
  "status" : "INPROGRESS"
})
    )
    result = InsightsApi.projects_models_feature_effects_metadata_list(project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, ModelXrayMetadataResponse)


@responses.activate
def test_insights_api_projects_models_feature_fit_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/api/v2/projects/{projectId}/models/{modelId}/featureFit/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=202,
        content_type='',
    )
    result = InsightsApi.projects_models_feature_fit_create(project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_insights_api_projects_models_feature_fit_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/models/{modelId}/featureFit/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "modelId" : "modelId",
  "source" : "source",
  "projectId" : "projectId",
  "featureFit" : [ {
    "isScalable" : True,
    "featureName" : "featureName",
    "predictedVsActual" : {
      "data" : [ {
        "actual" : 1.4658129805029452,
        "bin" : [ "bin", "bin" ],
        "label" : "label",
        "rowCount" : 5,
        "predicted" : 5.962133916683182
      }, {
        "actual" : 1.4658129805029452,
        "bin" : [ "bin", "bin" ],
        "label" : "label",
        "rowCount" : 5,
        "predicted" : 5.962133916683182
      } ],
      "isCapped" : True
    },
    "weightLabel" : "weightLabel",
    "featureImportanceScore" : 0.8008281904610115,
    "featureType" : "featureType",
    "partialDependence" : {
      "data" : [ {
        "dependence" : 6.027456183070403,
        "label" : "label"
      }, {
        "dependence" : 6.027456183070403,
        "label" : "label"
      } ],
      "isCapped" : True
    }
  }, {
    "isScalable" : True,
    "featureName" : "featureName",
    "predictedVsActual" : {
      "data" : [ {
        "actual" : 1.4658129805029452,
        "bin" : [ "bin", "bin" ],
        "label" : "label",
        "rowCount" : 5,
        "predicted" : 5.962133916683182
      }, {
        "actual" : 1.4658129805029452,
        "bin" : [ "bin", "bin" ],
        "label" : "label",
        "rowCount" : 5,
        "predicted" : 5.962133916683182
      } ],
      "isCapped" : True
    },
    "weightLabel" : "weightLabel",
    "featureImportanceScore" : 0.8008281904610115,
    "featureType" : "featureType",
    "partialDependence" : {
      "data" : [ {
        "dependence" : 6.027456183070403,
        "label" : "label"
      }, {
        "dependence" : 6.027456183070403,
        "label" : "label"
      } ],
      "isCapped" : True
    }
  } ]
})
    )
    result = InsightsApi.projects_models_feature_fit_list(project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, FeatureFitResponse)


@responses.activate
def test_insights_api_projects_models_feature_fit_metadata_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/models/{modelId}/featureFitMetadata/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "sources" : [ "training", "training" ],
  "status" : "INPROGRESS"
})
    )
    result = InsightsApi.projects_models_feature_fit_metadata_list(project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, ModelXrayMetadataResponse)


@responses.activate
def test_insights_api_projects_models_feature_impact_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/api/v2/projects/{projectId}/models/{modelId}/featureImpact/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=202,
        content_type='',
    )
    result = InsightsApi.projects_models_feature_impact_create(project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_insights_api_projects_models_feature_impact_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/models/{modelId}/featureImpact/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "ranRedundancyDetection" : True,
  "previous" : "https://openapi-generator.tech",
  "featureImpacts" : [ {
    "redundantWith" : "redundantWith",
    "featureName" : "featureName",
    "impactUnnormalized" : 1.4658129805029452,
    "impactNormalized" : 0.6027456183070403
  }, {
    "redundantWith" : "redundantWith",
    "featureName" : "featureName",
    "impactUnnormalized" : 1.4658129805029452,
    "impactNormalized" : 0.6027456183070403
  }, {
    "redundantWith" : "redundantWith",
    "featureName" : "featureName",
    "impactUnnormalized" : 1.4658129805029452,
    "impactNormalized" : 0.6027456183070403
  }, {
    "redundantWith" : "redundantWith",
    "featureName" : "featureName",
    "impactUnnormalized" : 1.4658129805029452,
    "impactNormalized" : 0.6027456183070403
  }, {
    "redundantWith" : "redundantWith",
    "featureName" : "featureName",
    "impactUnnormalized" : 1.4658129805029452,
    "impactNormalized" : 0.6027456183070403
  } ],
  "count" : 0,
  "rowCount" : 5,
  "shapBased" : True
})
    )
    result = InsightsApi.projects_models_feature_impact_list(project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, FeatureImpactResponse)


@responses.activate
def test_insights_api_projects_models_multiclass_feature_impact_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/models/{modelId}/multiclassFeatureImpact/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "ranRedundancyDetection" : True,
  "classFeatureImpacts" : [ {
    "featureImpacts" : [ {
      "redundantWith" : "redundantWith",
      "featureName" : "featureName",
      "impactUnnormalized" : 1.4658129805029452,
      "impactNormalized" : 0.6027456183070403
    }, {
      "redundantWith" : "redundantWith",
      "featureName" : "featureName",
      "impactUnnormalized" : 1.4658129805029452,
      "impactNormalized" : 0.6027456183070403
    }, {
      "redundantWith" : "redundantWith",
      "featureName" : "featureName",
      "impactUnnormalized" : 1.4658129805029452,
      "impactNormalized" : 0.6027456183070403
    }, {
      "redundantWith" : "redundantWith",
      "featureName" : "featureName",
      "impactUnnormalized" : 1.4658129805029452,
      "impactNormalized" : 0.6027456183070403
    }, {
      "redundantWith" : "redundantWith",
      "featureName" : "featureName",
      "impactUnnormalized" : 1.4658129805029452,
      "impactNormalized" : 0.6027456183070403
    } ],
    "class" : "class"
  }, {
    "featureImpacts" : [ {
      "redundantWith" : "redundantWith",
      "featureName" : "featureName",
      "impactUnnormalized" : 1.4658129805029452,
      "impactNormalized" : 0.6027456183070403
    }, {
      "redundantWith" : "redundantWith",
      "featureName" : "featureName",
      "impactUnnormalized" : 1.4658129805029452,
      "impactNormalized" : 0.6027456183070403
    }, {
      "redundantWith" : "redundantWith",
      "featureName" : "featureName",
      "impactUnnormalized" : 1.4658129805029452,
      "impactNormalized" : 0.6027456183070403
    }, {
      "redundantWith" : "redundantWith",
      "featureName" : "featureName",
      "impactUnnormalized" : 1.4658129805029452,
      "impactNormalized" : 0.6027456183070403
    }, {
      "redundantWith" : "redundantWith",
      "featureName" : "featureName",
      "impactUnnormalized" : 1.4658129805029452,
      "impactNormalized" : 0.6027456183070403
    } ],
    "class" : "class"
  } ],
  "shapBased" : True
})
    )
    result = InsightsApi.projects_models_multiclass_feature_impact_list(project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, MulticlassFeatureImpactResponse)


@responses.activate
def test_insights_api_projects_models_prediction_explanations_initialization_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/api/v2/projects/{projectId}/models/{modelId}/predictionExplanationsInitialization/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=202,
        content_type='',
    )
    result = InsightsApi.projects_models_prediction_explanations_initialization_create(project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_insights_api_projects_models_prediction_explanations_initialization_delete_many(unittest_endpoint):
    responses.add(
        responses.DELETE,
        '{endpoint}/api/v2/projects/{projectId}/models/{modelId}/predictionExplanationsInitialization/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=204,
        content_type='',
    )
    result = InsightsApi.projects_models_prediction_explanations_initialization_delete_many(project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_insights_api_projects_models_prediction_explanations_initialization_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/models/{modelId}/predictionExplanationsInitialization/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=200,
        content_type='',
    )
    result = InsightsApi.projects_models_prediction_explanations_initialization_list(project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_insights_api_projects_models_shap_impact_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/api/v2/projects/{projectId}/models/{modelId}/shapImpact/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=200,
        content_type='',
    )
    result = InsightsApi.projects_models_shap_impact_create(project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_insights_api_projects_models_shap_impact_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/models/{modelId}/shapImpact/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "count" : 0,
  "rowCount" : 6,
  "shapImpacts" : [ {
    "featureName" : "featureName",
    "impactUnnormalized" : 5.962133916683182,
    "impactNormalized" : 1.4658129805029452
  }, {
    "featureName" : "featureName",
    "impactUnnormalized" : 5.962133916683182,
    "impactNormalized" : 1.4658129805029452
  }, {
    "featureName" : "featureName",
    "impactUnnormalized" : 5.962133916683182,
    "impactNormalized" : 1.4658129805029452
  }, {
    "featureName" : "featureName",
    "impactUnnormalized" : 5.962133916683182,
    "impactNormalized" : 1.4658129805029452
  }, {
    "featureName" : "featureName",
    "impactUnnormalized" : 5.962133916683182,
    "impactNormalized" : 1.4658129805029452
  } ]
})
    )
    result = InsightsApi.projects_models_shap_impact_list(project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, ShapImpactRetrieveResponse)


@responses.activate
def test_insights_api_projects_payoff_matrices_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/api/v2/projects/{projectId}/payoffMatrices/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", ),
        status=200,
        content_type='',
    )
    result = InsightsApi.projects_payoff_matrices_create(project_id="projectId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_insights_api_projects_payoff_matrices_delete(unittest_endpoint):
    responses.add(
        responses.DELETE,
        '{endpoint}/api/v2/projects/{projectId}/payoffMatrices/{payoffMatrixId}/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", payoffMatrixId="payoffMatrixId_example", ),
        status=204,
        content_type='',
    )
    result = InsightsApi.projects_payoff_matrices_delete(project_id="projectId_example", payoff_matrix_id="payoffMatrixId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_insights_api_projects_payoff_matrices_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/payoffMatrices/'.format(endpoint=unittest_endpoint,
        offset=0, limit=100, projectId="projectId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "TruePositiveValue" : 5.637376656633329,
    "TrueNegativeValue" : 5.962133916683182,
    "name" : "name",
    "FalsePositiveValue" : 1.4658129805029452,
    "FalseNegativeValue" : 6.027456183070403,
    "id" : "id",
    "projectId" : "projectId"
  }, {
    "TruePositiveValue" : 5.637376656633329,
    "TrueNegativeValue" : 5.962133916683182,
    "name" : "name",
    "FalsePositiveValue" : 1.4658129805029452,
    "FalseNegativeValue" : 6.027456183070403,
    "id" : "id",
    "projectId" : "projectId"
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0,
  "totalCount" : 2
})
    )
    result = InsightsApi.projects_payoff_matrices_list(offset=0, limit=100, project_id="projectId_example", )
    assert isinstance(result, PayoffMatricesListResponse)


@responses.activate
def test_insights_api_projects_payoff_matrices_put(unittest_endpoint):
    responses.add(
        responses.PUT,
        '{endpoint}/api/v2/projects/{projectId}/payoffMatrices/{payoffMatrixId}/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", payoffMatrixId="payoffMatrixId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "TruePositiveValue" : 5.637376656633329,
  "TrueNegativeValue" : 5.962133916683182,
  "name" : "name",
  "FalsePositiveValue" : 1.4658129805029452,
  "FalseNegativeValue" : 6.027456183070403,
  "id" : "id",
  "projectId" : "projectId"
})
    )
    result = InsightsApi.projects_payoff_matrices_put(project_id="projectId_example", payoff_matrix_id="payoffMatrixId_example", )
    assert isinstance(result, PayoffMatricesResponse)


@responses.activate
def test_insights_api_projects_prediction_explanations_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/api/v2/projects/{projectId}/predictionExplanations/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", ),
        status=202,
        content_type='',
    )
    result = InsightsApi.projects_prediction_explanations_create(project_id="projectId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_insights_api_projects_prediction_explanations_records_delete(unittest_endpoint):
    responses.add(
        responses.DELETE,
        '{endpoint}/api/v2/projects/{projectId}/predictionExplanationsRecords/{predictionExplanationsId}/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", predictionExplanationsId="predictionExplanationsId_example", ),
        status=204,
        content_type='',
    )
    result = InsightsApi.projects_prediction_explanations_records_delete(project_id="projectId_example", prediction_explanations_id="predictionExplanationsId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_insights_api_projects_prediction_explanations_records_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/predictionExplanationsRecords/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "next",
  "data" : [ {
    "predictionThreshold" : 5.637376656633329,
    "maxExplanations" : 1,
    "predictionExplanationsLocation" : "predictionExplanationsLocation",
    "finishTime" : 6.027456183070403,
    "modelId" : "modelId",
    "datasetId" : "datasetId",
    "id" : "id",
    "thresholdHigh" : 2.3021358869347655,
    "thresholdLow" : 7.061401241503109,
    "projectId" : "projectId",
    "numColumns" : 5
  }, {
    "predictionThreshold" : 5.637376656633329,
    "maxExplanations" : 1,
    "predictionExplanationsLocation" : "predictionExplanationsLocation",
    "finishTime" : 6.027456183070403,
    "modelId" : "modelId",
    "datasetId" : "datasetId",
    "id" : "id",
    "thresholdHigh" : 2.3021358869347655,
    "thresholdLow" : 7.061401241503109,
    "projectId" : "projectId",
    "numColumns" : 5
  } ],
  "previous" : "previous",
  "count" : 0
})
    )
    result = InsightsApi.projects_prediction_explanations_records_list(project_id="projectId_example", )
    assert isinstance(result, PredictionExplanationsRecordList)


@responses.activate
def test_insights_api_projects_prediction_explanations_records_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/predictionExplanationsRecords/{predictionExplanationsId}/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", predictionExplanationsId="predictionExplanationsId_example", ),
        status=200,
        content_type='',
    )
    result = InsightsApi.projects_prediction_explanations_records_retrieve(project_id="projectId_example", prediction_explanations_id="predictionExplanationsId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_insights_api_projects_prediction_explanations_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/predictionExplanations/{predictionExplanationsId}/'.format(endpoint=unittest_endpoint,
        limit=300000, projectId="projectId_example", predictionExplanationsId="predictionExplanationsId_example", ),
        status=200,
        content_type='',
    )
    result = InsightsApi.projects_prediction_explanations_retrieve(limit=300000, project_id="projectId_example", prediction_explanations_id="predictionExplanationsId_example", )
    assert isinstance(result, type(None))
