#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import json
import responses
from six.moves.urllib.parse import urljoin
from dateutil import parser
from datarobot.models.testing.generated.model.geometry_feature_p_lot_create_payload import GeometryFeaturePLotCreatePayload
from datarobot.models.testing.generated.model.geometry_feature_plot_retrieve_response import GeometryFeaturePlotRetrieveResponse
from datarobot.utils import from_api
from datarobot.models.testing.generated.model import *

from datarobot.models.testing.generated.api.location_ai_api import LocationAiApi




@responses.activate
def test_location_ai_api_projects_geometry_feature_plots_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/api/v2/projects/{projectId}/geometryFeaturePlots/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", ),
        status=202,
        content_type='',
    )
    result = LocationAiApi.projects_geometry_feature_plots_create(project_id="projectId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_location_ai_api_projects_geometry_feature_plots_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/geometryFeaturePlots/{featureName}/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", featureName="featureName_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "feature" : "feature",
  "plotData" : {
    "summary" : {
      "minCount" : 1,
      "totalCount" : 5,
      "maxCount" : 6
    },
    "features" : [ {
      "geometry" : {
        "coordinates" : [ "{}", "{}" ],
        "type" : "Point"
      },
      "type" : "type",
      "properties" : {
        "count" : 0
      }
    }, {
      "geometry" : {
        "coordinates" : [ "{}", "{}" ],
        "type" : "Point"
      },
      "type" : "type",
      "properties" : {
        "count" : 0
      }
    } ],
    "bbox" : "{}",
    "aggregation" : "grid",
    "valueAggregation" : "geometry",
    "type" : "type"
  },
  "projectId" : "projectId"
})
    )
    result = LocationAiApi.projects_geometry_feature_plots_retrieve(project_id="projectId_example", feature_name="featureName_example", )
    assert isinstance(result, GeometryFeaturePlotRetrieveResponse)
