#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import json
import responses
from six.moves.urllib.parse import urljoin
from dateutil import parser
from datarobot.models.testing.generated.model.accuracy_over_time_plots_data_response import AccuracyOverTimePlotsDataResponse
from datarobot.models.testing.generated.model.accuracy_over_time_plots_metadata_response import AccuracyOverTimePlotsMetadataResponse
from datarobot.models.testing.generated.model.advanced_tuning_arguments_retrieve_response import AdvancedTuningArgumentsRetrieveResponse
from datarobot.models.testing.generated.model.all_multiclass_model_lift_charts_response import AllMulticlassModelLiftChartsResponse
from datarobot.models.testing.generated.model.anomaly_insight_table_retrieve import AnomalyInsightTableRetrieve
from datarobot.models.testing.generated.model.anomaly_over_time_plots_data_response import AnomalyOverTimePlotsDataResponse
from datarobot.models.testing.generated.model.anomaly_over_time_plots_metadata_response import AnomalyOverTimePlotsMetadataResponse
from datarobot.models.testing.generated.model.anomaly_over_time_plots_preview_response import AnomalyOverTimePlotsPreviewResponse
from datarobot.models.testing.generated.model.backtest_stability_plot_response import BacktestStabilityPlotResponse
from datarobot.models.testing.generated.model.base_blender_builder_create import BaseBlenderBuilderCreate
from datarobot.models.testing.generated.model.blender_create import BlenderCreate
from datarobot.models.testing.generated.model.blender_info_retrieve_response import BlenderInfoRetrieveResponse
from datarobot.models.testing.generated.model.blender_list_response import BlenderListResponse
from datarobot.models.testing.generated.model.blender_retrieve_response import BlenderRetrieveResponse
from datarobot.models.testing.generated.model.create_shap_matrix_payload import CreateShapMatrixPayload
from datarobot.models.testing.generated.model.cross_validation_retrieve_response import CrossValidationRetrieveResponse
from datarobot.models.testing.generated.model.datetime_model_details_response import DatetimeModelDetailsResponse
from datarobot.models.testing.generated.model.datetime_model_submission_response import DatetimeModelSubmissionResponse
from datarobot.models.testing.generated.model.datetime_models_response import DatetimeModelsResponse
from datarobot.models.testing.generated.model.datetime_trend_plots_create import DatetimeTrendPlotsCreate
from datarobot.models.testing.generated.model.datetime_trend_plots_preview_response import DatetimeTrendPlotsPreviewResponse
from datarobot.models.testing.generated.model.datetime_trend_plots_response import DatetimeTrendPlotsResponse
from datarobot.models.testing.generated.model.forecast_distance_stability_plot_response import ForecastDistanceStabilityPlotResponse
from datarobot.models.testing.generated.model.forecast_vs_actual_plots_data_response import ForecastVsActualPlotsDataResponse
from datarobot.models.testing.generated.model.forecast_vs_actual_plots_metadata_response import ForecastVsActualPlotsMetadataResponse
from datarobot.models.testing.generated.model.frozen_model_create import FrozenModelCreate
from datarobot.models.testing.generated.model.frozen_model_list_response import FrozenModelListResponse
from datarobot.models.testing.generated.model.frozen_model_retrieve_response import FrozenModelRetrieveResponse
from datarobot.models.testing.generated.model.missing_report_retrieve import MissingReportRetrieve
from datarobot.models.testing.generated.model.model_advanced_tuning import ModelAdvancedTuning
from datarobot.models.testing.generated.model.model_capabilities_retrieve_response import ModelCapabilitiesRetrieveResponse
from datarobot.models.testing.generated.model.model_confusion_chart_class_details_retrieve_reponse_controller import ModelConfusionChartClassDetailsRetrieveReponseController
from datarobot.models.testing.generated.model.model_confusion_chart_list_response import ModelConfusionChartListResponse
from datarobot.models.testing.generated.model.model_confusion_chart_metadata_retrieve_response import ModelConfusionChartMetadataRetrieveResponse
from datarobot.models.testing.generated.model.model_confusion_chart_retrieve_response import ModelConfusionChartRetrieveResponse
from datarobot.models.testing.generated.model.model_details_response import ModelDetailsResponse
from datarobot.models.testing.generated.model.model_export import ModelExport
from datarobot.models.testing.generated.model.model_feature_list_response import ModelFeatureListResponse
from datarobot.models.testing.generated.model.model_job_response import ModelJobResponse
from datarobot.models.testing.generated.model.model_lift_chart_list_response import ModelLiftChartListResponse
from datarobot.models.testing.generated.model.model_lift_chart_response import ModelLiftChartResponse
from datarobot.models.testing.generated.model.model_parameters_retrieve_response import ModelParametersRetrieveResponse
from datarobot.models.testing.generated.model.model_residuals_list import ModelResidualsList
from datarobot.models.testing.generated.model.model_retrain_response import ModelRetrainResponse
from datarobot.models.testing.generated.model.model_roc_curve_list_response import ModelRocCurveListResponse
from datarobot.models.testing.generated.model.model_roc_curve_response import ModelRocCurveResponse
from datarobot.models.testing.generated.model.model_update import ModelUpdate
from datarobot.models.testing.generated.model.modeling_job_list_response import ModelingJobListResponse
from datarobot.models.testing.generated.model.multiclass_model_lift_chart_response import MulticlassModelLiftChartResponse
from datarobot.models.testing.generated.model.num_iterations_trained_response import NumIterationsTrainedResponse
from datarobot.models.testing.generated.model.prediction_intervals_create import PredictionIntervalsCreate
from datarobot.models.testing.generated.model.prediction_intervals_create_response import PredictionIntervalsCreateResponse
from datarobot.models.testing.generated.model.prediction_intervals_list_response import PredictionIntervalsListResponse
from datarobot.models.testing.generated.model.prepare_for_deployment import PrepareForDeployment
from datarobot.models.testing.generated.model.recommended_model_response import RecommendedModelResponse
from datarobot.models.testing.generated.model.retrain_datetime_model import RetrainDatetimeModel
from datarobot.models.testing.generated.model.retrain_model import RetrainModel
from datarobot.models.testing.generated.model.shap_matrix_list_response import ShapMatrixListResponse
from datarobot.models.testing.generated.model.shap_matrix_retrieve_response import ShapMatrixRetrieveResponse
from datarobot.models.testing.generated.model.train_datetime_frozen_model import TrainDatetimeFrozenModel
from datarobot.models.testing.generated.model.train_datetime_model import TrainDatetimeModel
from datarobot.models.testing.generated.model.train_model import TrainModel
from datarobot.models.testing.generated.model.word_cloud_retrieve_response import WordCloudRetrieveResponse
from datarobot.utils import from_api
from datarobot.models.testing.generated.model import *

from datarobot.models.testing.generated.api.models_api import ModelsApi




@responses.activate
def test_models_api_model_exports_create(unittest_endpoint):
    responses.add(
        responses.POST,
       '{endpoint}/api/v2/modelExports/'.format(endpoint=unittest_endpoint),
        status=202,
        content_type='',
    )
    result = ModelsApi.model_exports_create()
    assert isinstance(result, type(None))


@responses.activate
def test_models_api_projects_blender_builders_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/api/v2/projects/{projectId}/blenderBuilders/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", ),
        status=200,
        content_type='',
    )
    result = ModelsApi.projects_blender_builders_create(project_id="projectId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_models_api_projects_blender_builders_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/blenderBuilders/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", offset=0, limit=100, ),
        status=200,
        content_type='',
    )
    result = ModelsApi.projects_blender_builders_list(project_id="projectId_example", offset=0, limit=100, )
    assert isinstance(result, type(None))


@responses.activate
def test_models_api_projects_blender_builders_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/blenderBuilders/{buildId}/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", buildId="buildId_example", ),
        status=200,
        content_type='',
    )
    result = ModelsApi.projects_blender_builders_retrieve(project_id="projectId_example", build_id="buildId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_models_api_projects_blender_models_blend_check_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/api/v2/projects/{projectId}/blenderModels/blendCheck/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "blendable" : True,
  "reason" : "reason"
})
    )
    result = ModelsApi.projects_blender_models_blend_check_create(project_id="projectId_example", )
    assert isinstance(result, BlenderInfoRetrieveResponse)


@responses.activate
def test_models_api_projects_blender_models_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/api/v2/projects/{projectId}/blenderModels/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", ),
        status=202,
        content_type='',
    )
    result = ModelsApi.projects_blender_models_create(project_id="projectId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_models_api_projects_blender_models_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/blenderModels/'.format(endpoint=unittest_endpoint,
        offset=0, limit=0, projectId="projectId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "samplePct" : 59.621339166831824,
    "featurelistName" : "featurelistName",
    "modelFamily" : "modelFamily",
    "predictionThreshold" : 0.14658129805029452,
    "trainingEndDate" : "2000-01-23T04:56:07.000+00:00",
    "modelIds" : [ "modelIds", "modelIds" ],
    "blenderMethod" : "blenderMethod",
    "id" : "id",
    "isFrozen" : True,
    "modelCategory" : "modelCategory",
    "monotonicDecreasingFeaturelistId" : "monotonicDecreasingFeaturelistId",
    "supportsComposableMl" : True,
    "processes" : [ "processes", "processes" ],
    "linkFunction" : "linkFunction",
    "trainingDuration" : "trainingDuration",
    "parentModelId" : "parentModelId",
    "predictionThresholdReadOnly" : True,
    "isStarred" : True,
    "featurelistId" : "featurelistId",
    "modelType" : "modelType",
    "blueprintId" : "blueprintId",
    "supportsMonotonicConstraints" : True,
    "monotonicIncreasingFeaturelistId" : "monotonicIncreasingFeaturelistId",
    "trainingStartDate" : "2000-01-23T04:56:07.000+00:00",
    "trainingRowCount" : 0,
    "modelNumber" : 0,
    "metrics" : "\n        {\n            \"metrics\": {\n                \"RMSE\": {\n                    \"holdout\": 5000,\n                    \"validation\": 5100,\n                    \"backtesting\": null,\n                    \"backtestingScores\": null,\n                    \"crossValidation\": 6000,\n                    \"training\": null\n                },\n                \"FVE Poisson\": {\n                    \"holdout\": null,\n                    \"validation\": 0.56269,\n                    \"crossValidation\": 0.50166,\n                    \"backtesting\": null,\n                    \"backtestingScores\": null,\n                    \"training\": null\n                },\n            }\n        }\n",
    "projectId" : "projectId"
  }, {
    "samplePct" : 59.621339166831824,
    "featurelistName" : "featurelistName",
    "modelFamily" : "modelFamily",
    "predictionThreshold" : 0.14658129805029452,
    "trainingEndDate" : "2000-01-23T04:56:07.000+00:00",
    "modelIds" : [ "modelIds", "modelIds" ],
    "blenderMethod" : "blenderMethod",
    "id" : "id",
    "isFrozen" : True,
    "modelCategory" : "modelCategory",
    "monotonicDecreasingFeaturelistId" : "monotonicDecreasingFeaturelistId",
    "supportsComposableMl" : True,
    "processes" : [ "processes", "processes" ],
    "linkFunction" : "linkFunction",
    "trainingDuration" : "trainingDuration",
    "parentModelId" : "parentModelId",
    "predictionThresholdReadOnly" : True,
    "isStarred" : True,
    "featurelistId" : "featurelistId",
    "modelType" : "modelType",
    "blueprintId" : "blueprintId",
    "supportsMonotonicConstraints" : True,
    "monotonicIncreasingFeaturelistId" : "monotonicIncreasingFeaturelistId",
    "trainingStartDate" : "2000-01-23T04:56:07.000+00:00",
    "trainingRowCount" : 0,
    "modelNumber" : 0,
    "metrics" : "\n        {\n            \"metrics\": {\n                \"RMSE\": {\n                    \"holdout\": 5000,\n                    \"validation\": 5100,\n                    \"backtesting\": null,\n                    \"backtestingScores\": null,\n                    \"crossValidation\": 6000,\n                    \"training\": null\n                },\n                \"FVE Poisson\": {\n                    \"holdout\": null,\n                    \"validation\": 0.56269,\n                    \"crossValidation\": 0.50166,\n                    \"backtesting\": null,\n                    \"backtestingScores\": null,\n                    \"training\": null\n                },\n            }\n        }\n",
    "projectId" : "projectId"
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0
})
    )
    result = ModelsApi.projects_blender_models_list(offset=0, limit=0, project_id="projectId_example", )
    assert isinstance(result, BlenderListResponse)


@responses.activate
def test_models_api_projects_blender_models_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/blenderModels/{modelId}/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "samplePct" : 59.621339166831824,
  "featurelistName" : "featurelistName",
  "modelFamily" : "modelFamily",
  "predictionThreshold" : 0.14658129805029452,
  "trainingEndDate" : "2000-01-23T04:56:07.000+00:00",
  "modelIds" : [ "modelIds", "modelIds" ],
  "blenderMethod" : "blenderMethod",
  "id" : "id",
  "isFrozen" : True,
  "modelCategory" : "modelCategory",
  "monotonicDecreasingFeaturelistId" : "monotonicDecreasingFeaturelistId",
  "supportsComposableMl" : True,
  "processes" : [ "processes", "processes" ],
  "linkFunction" : "linkFunction",
  "trainingDuration" : "trainingDuration",
  "parentModelId" : "parentModelId",
  "predictionThresholdReadOnly" : True,
  "isStarred" : True,
  "featurelistId" : "featurelistId",
  "modelType" : "modelType",
  "blueprintId" : "blueprintId",
  "supportsMonotonicConstraints" : True,
  "monotonicIncreasingFeaturelistId" : "monotonicIncreasingFeaturelistId",
  "trainingStartDate" : "2000-01-23T04:56:07.000+00:00",
  "trainingRowCount" : 0,
  "modelNumber" : 0,
  "metrics" : "\n        {\n            \"metrics\": {\n                \"RMSE\": {\n                    \"holdout\": 5000,\n                    \"validation\": 5100,\n                    \"backtesting\": null,\n                    \"backtestingScores\": null,\n                    \"crossValidation\": 6000,\n                    \"training\": null\n                },\n                \"FVE Poisson\": {\n                    \"holdout\": null,\n                    \"validation\": 0.56269,\n                    \"crossValidation\": 0.50166,\n                    \"backtesting\": null,\n                    \"backtestingScores\": null,\n                    \"training\": null\n                },\n            }\n        }\n",
  "projectId" : "projectId"
})
    )
    result = ModelsApi.projects_blender_models_retrieve(project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, BlenderRetrieveResponse)


@responses.activate
def test_models_api_projects_datetime_models_accuracy_over_time_plots_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/datetimeModels/{modelId}/accuracyOverTimePlots/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "bins" : [ {
    "actual" : 0.8008281904610115,
    "endDate" : "2000-01-23T04:56:07.000+00:00",
    "predicted" : 1.4658129805029452,
    "startDate" : "2000-01-23T04:56:07.000+00:00",
    "frequency" : 6
  }, {
    "actual" : 0.8008281904610115,
    "endDate" : "2000-01-23T04:56:07.000+00:00",
    "predicted" : 1.4658129805029452,
    "startDate" : "2000-01-23T04:56:07.000+00:00",
    "frequency" : 6
  }, {
    "actual" : 0.8008281904610115,
    "endDate" : "2000-01-23T04:56:07.000+00:00",
    "predicted" : 1.4658129805029452,
    "startDate" : "2000-01-23T04:56:07.000+00:00",
    "frequency" : 6
  }, {
    "actual" : 0.8008281904610115,
    "endDate" : "2000-01-23T04:56:07.000+00:00",
    "predicted" : 1.4658129805029452,
    "startDate" : "2000-01-23T04:56:07.000+00:00",
    "frequency" : 6
  }, {
    "actual" : 0.8008281904610115,
    "endDate" : "2000-01-23T04:56:07.000+00:00",
    "predicted" : 1.4658129805029452,
    "startDate" : "2000-01-23T04:56:07.000+00:00",
    "frequency" : 6
  } ],
  "calendarEvents" : [ {
    "date" : "2000-01-23T04:56:07.000+00:00",
    "name" : "name",
    "seriesId" : "seriesId"
  }, {
    "date" : "2000-01-23T04:56:07.000+00:00",
    "name" : "name",
    "seriesId" : "seriesId"
  }, {
    "date" : "2000-01-23T04:56:07.000+00:00",
    "name" : "name",
    "seriesId" : "seriesId"
  }, {
    "date" : "2000-01-23T04:56:07.000+00:00",
    "name" : "name",
    "seriesId" : "seriesId"
  }, {
    "date" : "2000-01-23T04:56:07.000+00:00",
    "name" : "name",
    "seriesId" : "seriesId"
  } ],
  "endDate" : "2000-01-23T04:56:07.000+00:00",
  "resolution" : "milliseconds",
  "startDate" : "2000-01-23T04:56:07.000+00:00",
  "statistics" : {
    "durbinWatson" : 2.384853566673273
  }
})
    )
    result = ModelsApi.projects_datetime_models_accuracy_over_time_plots_list(project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, AccuracyOverTimePlotsDataResponse)


@responses.activate
def test_models_api_projects_datetime_models_accuracy_over_time_plots_metadata_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/datetimeModels/{modelId}/accuracyOverTimePlots/metadata/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "holdoutMetadata" : {
    "training" : {
      "endDate" : "2000-01-23T04:56:07.000+00:00",
      "startDate" : "2000-01-23T04:56:07.000+00:00"
    },
    "validation" : {
      "endDate" : "2000-01-23T04:56:07.000+00:00",
      "startDate" : "2000-01-23T04:56:07.000+00:00"
    }
  },
  "holdoutStatuses" : {
    "training" : "completed",
    "validation" : "completed"
  },
  "backtestStatuses" : [ {
    "training" : "completed",
    "validation" : "completed"
  }, {
    "training" : "completed",
    "validation" : "completed"
  }, {
    "training" : "completed",
    "validation" : "completed"
  }, {
    "training" : "completed",
    "validation" : "completed"
  }, {
    "training" : "completed",
    "validation" : "completed"
  } ],
  "resolutions" : [ "milliseconds", "milliseconds", "milliseconds", "milliseconds", "milliseconds" ],
  "backtestMetadata" : [ {
    "training" : {
      "endDate" : "2000-01-23T04:56:07.000+00:00",
      "startDate" : "2000-01-23T04:56:07.000+00:00"
    },
    "validation" : {
      "endDate" : "2000-01-23T04:56:07.000+00:00",
      "startDate" : "2000-01-23T04:56:07.000+00:00"
    }
  }, {
    "training" : {
      "endDate" : "2000-01-23T04:56:07.000+00:00",
      "startDate" : "2000-01-23T04:56:07.000+00:00"
    },
    "validation" : {
      "endDate" : "2000-01-23T04:56:07.000+00:00",
      "startDate" : "2000-01-23T04:56:07.000+00:00"
    }
  }, {
    "training" : {
      "endDate" : "2000-01-23T04:56:07.000+00:00",
      "startDate" : "2000-01-23T04:56:07.000+00:00"
    },
    "validation" : {
      "endDate" : "2000-01-23T04:56:07.000+00:00",
      "startDate" : "2000-01-23T04:56:07.000+00:00"
    }
  }, {
    "training" : {
      "endDate" : "2000-01-23T04:56:07.000+00:00",
      "startDate" : "2000-01-23T04:56:07.000+00:00"
    },
    "validation" : {
      "endDate" : "2000-01-23T04:56:07.000+00:00",
      "startDate" : "2000-01-23T04:56:07.000+00:00"
    }
  }, {
    "training" : {
      "endDate" : "2000-01-23T04:56:07.000+00:00",
      "startDate" : "2000-01-23T04:56:07.000+00:00"
    },
    "validation" : {
      "endDate" : "2000-01-23T04:56:07.000+00:00",
      "startDate" : "2000-01-23T04:56:07.000+00:00"
    }
  } ],
  "forecastDistance" : 80
})
    )
    result = ModelsApi.projects_datetime_models_accuracy_over_time_plots_metadata_list(project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, AccuracyOverTimePlotsMetadataResponse)


@responses.activate
def test_models_api_projects_datetime_models_accuracy_over_time_plots_preview_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/datetimeModels/{modelId}/accuracyOverTimePlots/preview/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "bins" : [ {
    "actual" : 0.8008281904610115,
    "endDate" : "2000-01-23T04:56:07.000+00:00",
    "predicted" : 6.027456183070403,
    "startDate" : "2000-01-23T04:56:07.000+00:00"
  }, {
    "actual" : 0.8008281904610115,
    "endDate" : "2000-01-23T04:56:07.000+00:00",
    "predicted" : 6.027456183070403,
    "startDate" : "2000-01-23T04:56:07.000+00:00"
  }, {
    "actual" : 0.8008281904610115,
    "endDate" : "2000-01-23T04:56:07.000+00:00",
    "predicted" : 6.027456183070403,
    "startDate" : "2000-01-23T04:56:07.000+00:00"
  }, {
    "actual" : 0.8008281904610115,
    "endDate" : "2000-01-23T04:56:07.000+00:00",
    "predicted" : 6.027456183070403,
    "startDate" : "2000-01-23T04:56:07.000+00:00"
  }, {
    "actual" : 0.8008281904610115,
    "endDate" : "2000-01-23T04:56:07.000+00:00",
    "predicted" : 6.027456183070403,
    "startDate" : "2000-01-23T04:56:07.000+00:00"
  } ],
  "endDate" : "2000-01-23T04:56:07.000+00:00",
  "startDate" : "2000-01-23T04:56:07.000+00:00"
})
    )
    result = ModelsApi.projects_datetime_models_accuracy_over_time_plots_preview_list(project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, DatetimeTrendPlotsPreviewResponse)


@responses.activate
def test_models_api_projects_datetime_models_anomaly_over_time_plots_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/datetimeModels/{modelId}/anomalyOverTimePlots/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "bins" : [ {
    "endDate" : "2000-01-23T04:56:07.000+00:00",
    "predicted" : 6.027456183070403,
    "startDate" : "2000-01-23T04:56:07.000+00:00",
    "frequency" : 0
  }, {
    "endDate" : "2000-01-23T04:56:07.000+00:00",
    "predicted" : 6.027456183070403,
    "startDate" : "2000-01-23T04:56:07.000+00:00",
    "frequency" : 0
  }, {
    "endDate" : "2000-01-23T04:56:07.000+00:00",
    "predicted" : 6.027456183070403,
    "startDate" : "2000-01-23T04:56:07.000+00:00",
    "frequency" : 0
  }, {
    "endDate" : "2000-01-23T04:56:07.000+00:00",
    "predicted" : 6.027456183070403,
    "startDate" : "2000-01-23T04:56:07.000+00:00",
    "frequency" : 0
  }, {
    "endDate" : "2000-01-23T04:56:07.000+00:00",
    "predicted" : 6.027456183070403,
    "startDate" : "2000-01-23T04:56:07.000+00:00",
    "frequency" : 0
  } ],
  "calendarEvents" : [ {
    "date" : "2000-01-23T04:56:07.000+00:00",
    "name" : "name",
    "seriesId" : "seriesId"
  }, {
    "date" : "2000-01-23T04:56:07.000+00:00",
    "name" : "name",
    "seriesId" : "seriesId"
  }, {
    "date" : "2000-01-23T04:56:07.000+00:00",
    "name" : "name",
    "seriesId" : "seriesId"
  }, {
    "date" : "2000-01-23T04:56:07.000+00:00",
    "name" : "name",
    "seriesId" : "seriesId"
  }, {
    "date" : "2000-01-23T04:56:07.000+00:00",
    "name" : "name",
    "seriesId" : "seriesId"
  } ],
  "endDate" : "2000-01-23T04:56:07.000+00:00",
  "resolution" : "milliseconds",
  "startDate" : "2000-01-23T04:56:07.000+00:00"
})
    )
    result = ModelsApi.projects_datetime_models_anomaly_over_time_plots_list(project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, AnomalyOverTimePlotsDataResponse)


@responses.activate
def test_models_api_projects_datetime_models_anomaly_over_time_plots_metadata_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/datetimeModels/{modelId}/anomalyOverTimePlots/metadata/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "holdoutMetadata" : {
    "training" : {
      "endDate" : "2000-01-23T04:56:07.000+00:00",
      "startDate" : "2000-01-23T04:56:07.000+00:00"
    },
    "validation" : {
      "endDate" : "2000-01-23T04:56:07.000+00:00",
      "startDate" : "2000-01-23T04:56:07.000+00:00"
    }
  },
  "holdoutStatuses" : {
    "training" : "completed",
    "validation" : "completed"
  },
  "backtestStatuses" : [ {
    "training" : "completed",
    "validation" : "completed"
  }, {
    "training" : "completed",
    "validation" : "completed"
  }, {
    "training" : "completed",
    "validation" : "completed"
  }, {
    "training" : "completed",
    "validation" : "completed"
  }, {
    "training" : "completed",
    "validation" : "completed"
  } ],
  "resolutions" : [ "milliseconds", "milliseconds", "milliseconds", "milliseconds", "milliseconds" ],
  "backtestMetadata" : [ {
    "training" : {
      "endDate" : "2000-01-23T04:56:07.000+00:00",
      "startDate" : "2000-01-23T04:56:07.000+00:00"
    },
    "validation" : {
      "endDate" : "2000-01-23T04:56:07.000+00:00",
      "startDate" : "2000-01-23T04:56:07.000+00:00"
    }
  }, {
    "training" : {
      "endDate" : "2000-01-23T04:56:07.000+00:00",
      "startDate" : "2000-01-23T04:56:07.000+00:00"
    },
    "validation" : {
      "endDate" : "2000-01-23T04:56:07.000+00:00",
      "startDate" : "2000-01-23T04:56:07.000+00:00"
    }
  }, {
    "training" : {
      "endDate" : "2000-01-23T04:56:07.000+00:00",
      "startDate" : "2000-01-23T04:56:07.000+00:00"
    },
    "validation" : {
      "endDate" : "2000-01-23T04:56:07.000+00:00",
      "startDate" : "2000-01-23T04:56:07.000+00:00"
    }
  }, {
    "training" : {
      "endDate" : "2000-01-23T04:56:07.000+00:00",
      "startDate" : "2000-01-23T04:56:07.000+00:00"
    },
    "validation" : {
      "endDate" : "2000-01-23T04:56:07.000+00:00",
      "startDate" : "2000-01-23T04:56:07.000+00:00"
    }
  }, {
    "training" : {
      "endDate" : "2000-01-23T04:56:07.000+00:00",
      "startDate" : "2000-01-23T04:56:07.000+00:00"
    },
    "validation" : {
      "endDate" : "2000-01-23T04:56:07.000+00:00",
      "startDate" : "2000-01-23T04:56:07.000+00:00"
    }
  } ]
})
    )
    result = ModelsApi.projects_datetime_models_anomaly_over_time_plots_metadata_list(project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, AnomalyOverTimePlotsMetadataResponse)


@responses.activate
def test_models_api_projects_datetime_models_anomaly_over_time_plots_preview_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/datetimeModels/{modelId}/anomalyOverTimePlots/preview/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "predictionThreshold" : 0.08008281904610115,
  "bins" : [ {
    "endDate" : "2000-01-23T04:56:07.000+00:00",
    "startDate" : "2000-01-23T04:56:07.000+00:00"
  }, {
    "endDate" : "2000-01-23T04:56:07.000+00:00",
    "startDate" : "2000-01-23T04:56:07.000+00:00"
  }, {
    "endDate" : "2000-01-23T04:56:07.000+00:00",
    "startDate" : "2000-01-23T04:56:07.000+00:00"
  }, {
    "endDate" : "2000-01-23T04:56:07.000+00:00",
    "startDate" : "2000-01-23T04:56:07.000+00:00"
  }, {
    "endDate" : "2000-01-23T04:56:07.000+00:00",
    "startDate" : "2000-01-23T04:56:07.000+00:00"
  } ],
  "endDate" : "2000-01-23T04:56:07.000+00:00",
  "startDate" : "2000-01-23T04:56:07.000+00:00"
})
    )
    result = ModelsApi.projects_datetime_models_anomaly_over_time_plots_preview_list(project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, AnomalyOverTimePlotsPreviewResponse)


@responses.activate
def test_models_api_projects_datetime_models_backtest_stability_plot_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/datetimeModels/{modelId}/backtestStabilityPlot/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "metricName" : "metricName",
  "endDate" : "2000-01-23T04:56:07.000+00:00",
  "backtestPlotData" : [ {
    "score" : 6.027456183070403,
    "backtestIndex" : 0,
    "partition" : "partition",
    "scoringStartDate" : "2000-01-23T04:56:07.000+00:00",
    "scoringEndDate" : "2000-01-23T04:56:07.000+00:00"
  }, {
    "score" : 6.027456183070403,
    "backtestIndex" : 0,
    "partition" : "partition",
    "scoringStartDate" : "2000-01-23T04:56:07.000+00:00",
    "scoringEndDate" : "2000-01-23T04:56:07.000+00:00"
  } ],
  "startDate" : "2000-01-23T04:56:07.000+00:00"
})
    )
    result = ModelsApi.projects_datetime_models_backtest_stability_plot_list(project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, BacktestStabilityPlotResponse)


@responses.activate
def test_models_api_projects_datetime_models_backtests_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/api/v2/projects/{projectId}/datetimeModels/{modelId}/backtests/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=202,
        content_type='',
    )
    result = ModelsApi.projects_datetime_models_backtests_create(project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_models_api_projects_datetime_models_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/api/v2/projects/{projectId}/datetimeModels/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", ),
        status=202,
        content_type='application/json',
        body=json.dumps({
  "message" : "message"
})
    )
    result = ModelsApi.projects_datetime_models_create(project_id="projectId_example", )
    assert isinstance(result, DatetimeModelSubmissionResponse)


@responses.activate
def test_models_api_projects_datetime_models_datetime_trend_plots_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/api/v2/projects/{projectId}/datetimeModels/{modelId}/datetimeTrendPlots/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=202,
        content_type='application/json',
        body=json.dumps({
  "message" : "message"
})
    )
    result = ModelsApi.projects_datetime_models_datetime_trend_plots_create(project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, DatetimeTrendPlotsResponse)


@responses.activate
def test_models_api_projects_datetime_models_forecast_distance_stability_plot_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/datetimeModels/{modelId}/forecastDistanceStabilityPlot/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "metricName" : "metricName",
  "endDate" : "2000-01-23T04:56:07.000+00:00",
  "forecastDistancePlotData" : [ {
    "backtestingScore" : 0.8008281904610115,
    "validationScore" : 5.962133916683182,
    "holdoutScore" : 1.4658129805029452,
    "forecastDistance" : 6
  }, {
    "backtestingScore" : 0.8008281904610115,
    "validationScore" : 5.962133916683182,
    "holdoutScore" : 1.4658129805029452,
    "forecastDistance" : 6
  } ],
  "startDate" : "2000-01-23T04:56:07.000+00:00"
})
    )
    result = ModelsApi.projects_datetime_models_forecast_distance_stability_plot_list(project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, ForecastDistanceStabilityPlotResponse)


@responses.activate
def test_models_api_projects_datetime_models_forecast_vs_actual_plots_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/datetimeModels/{modelId}/forecastVsActualPlots/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "bins" : [ {
    "actual" : 0.8008281904610115,
    "endDate" : "2000-01-23T04:56:07.000+00:00",
    "error" : 0.6027456183070403,
    "startDate" : "2000-01-23T04:56:07.000+00:00",
    "forecasts" : [ 1.4658129805029452, 1.4658129805029452, 1.4658129805029452, 1.4658129805029452, 1.4658129805029452 ],
    "frequency" : 5,
    "normalizedError" : 0.5637376656633328
  }, {
    "actual" : 0.8008281904610115,
    "endDate" : "2000-01-23T04:56:07.000+00:00",
    "error" : 0.6027456183070403,
    "startDate" : "2000-01-23T04:56:07.000+00:00",
    "forecasts" : [ 1.4658129805029452, 1.4658129805029452, 1.4658129805029452, 1.4658129805029452, 1.4658129805029452 ],
    "frequency" : 5,
    "normalizedError" : 0.5637376656633328
  }, {
    "actual" : 0.8008281904610115,
    "endDate" : "2000-01-23T04:56:07.000+00:00",
    "error" : 0.6027456183070403,
    "startDate" : "2000-01-23T04:56:07.000+00:00",
    "forecasts" : [ 1.4658129805029452, 1.4658129805029452, 1.4658129805029452, 1.4658129805029452, 1.4658129805029452 ],
    "frequency" : 5,
    "normalizedError" : 0.5637376656633328
  }, {
    "actual" : 0.8008281904610115,
    "endDate" : "2000-01-23T04:56:07.000+00:00",
    "error" : 0.6027456183070403,
    "startDate" : "2000-01-23T04:56:07.000+00:00",
    "forecasts" : [ 1.4658129805029452, 1.4658129805029452, 1.4658129805029452, 1.4658129805029452, 1.4658129805029452 ],
    "frequency" : 5,
    "normalizedError" : 0.5637376656633328
  }, {
    "actual" : 0.8008281904610115,
    "endDate" : "2000-01-23T04:56:07.000+00:00",
    "error" : 0.6027456183070403,
    "startDate" : "2000-01-23T04:56:07.000+00:00",
    "forecasts" : [ 1.4658129805029452, 1.4658129805029452, 1.4658129805029452, 1.4658129805029452, 1.4658129805029452 ],
    "frequency" : 5,
    "normalizedError" : 0.5637376656633328
  } ],
  "calendarEvents" : [ {
    "date" : "2000-01-23T04:56:07.000+00:00",
    "name" : "name",
    "seriesId" : "seriesId"
  }, {
    "date" : "2000-01-23T04:56:07.000+00:00",
    "name" : "name",
    "seriesId" : "seriesId"
  }, {
    "date" : "2000-01-23T04:56:07.000+00:00",
    "name" : "name",
    "seriesId" : "seriesId"
  }, {
    "date" : "2000-01-23T04:56:07.000+00:00",
    "name" : "name",
    "seriesId" : "seriesId"
  }, {
    "date" : "2000-01-23T04:56:07.000+00:00",
    "name" : "name",
    "seriesId" : "seriesId"
  } ],
  "endDate" : "2000-01-23T04:56:07.000+00:00",
  "forecastDistances" : [ 230, 230, 230, 230, 230 ],
  "resolution" : "milliseconds",
  "startDate" : "2000-01-23T04:56:07.000+00:00"
})
    )
    result = ModelsApi.projects_datetime_models_forecast_vs_actual_plots_list(project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, ForecastVsActualPlotsDataResponse)


@responses.activate
def test_models_api_projects_datetime_models_forecast_vs_actual_plots_metadata_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/datetimeModels/{modelId}/forecastVsActualPlots/metadata/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "holdoutMetadata" : {
    "training" : {
      "endDate" : "2000-01-23T04:56:07.000+00:00",
      "startDate" : "2000-01-23T04:56:07.000+00:00"
    },
    "validation" : {
      "endDate" : "2000-01-23T04:56:07.000+00:00",
      "startDate" : "2000-01-23T04:56:07.000+00:00"
    }
  },
  "holdoutStatuses" : {
    "training" : {
      "notCompleted" : [ 564, 564, 564, 564, 564 ],
      "inProgress" : [ 147, 147, 147, 147, 147 ],
      "insufficientData" : [ 596, 596, 596, 596, 596 ],
      "completed" : [ 81, 81, 81, 81, 81 ],
      "errored" : [ 603, 603, 603, 603, 603 ]
    },
    "validation" : {
      "notCompleted" : [ 564, 564, 564, 564, 564 ],
      "inProgress" : [ 147, 147, 147, 147, 147 ],
      "insufficientData" : [ 596, 596, 596, 596, 596 ],
      "completed" : [ 81, 81, 81, 81, 81 ],
      "errored" : [ 603, 603, 603, 603, 603 ]
    }
  },
  "backtestStatuses" : [ {
    "training" : {
      "notCompleted" : [ 564, 564, 564, 564, 564 ],
      "inProgress" : [ 147, 147, 147, 147, 147 ],
      "insufficientData" : [ 596, 596, 596, 596, 596 ],
      "completed" : [ 81, 81, 81, 81, 81 ],
      "errored" : [ 603, 603, 603, 603, 603 ]
    },
    "validation" : {
      "notCompleted" : [ 564, 564, 564, 564, 564 ],
      "inProgress" : [ 147, 147, 147, 147, 147 ],
      "insufficientData" : [ 596, 596, 596, 596, 596 ],
      "completed" : [ 81, 81, 81, 81, 81 ],
      "errored" : [ 603, 603, 603, 603, 603 ]
    }
  }, {
    "training" : {
      "notCompleted" : [ 564, 564, 564, 564, 564 ],
      "inProgress" : [ 147, 147, 147, 147, 147 ],
      "insufficientData" : [ 596, 596, 596, 596, 596 ],
      "completed" : [ 81, 81, 81, 81, 81 ],
      "errored" : [ 603, 603, 603, 603, 603 ]
    },
    "validation" : {
      "notCompleted" : [ 564, 564, 564, 564, 564 ],
      "inProgress" : [ 147, 147, 147, 147, 147 ],
      "insufficientData" : [ 596, 596, 596, 596, 596 ],
      "completed" : [ 81, 81, 81, 81, 81 ],
      "errored" : [ 603, 603, 603, 603, 603 ]
    }
  }, {
    "training" : {
      "notCompleted" : [ 564, 564, 564, 564, 564 ],
      "inProgress" : [ 147, 147, 147, 147, 147 ],
      "insufficientData" : [ 596, 596, 596, 596, 596 ],
      "completed" : [ 81, 81, 81, 81, 81 ],
      "errored" : [ 603, 603, 603, 603, 603 ]
    },
    "validation" : {
      "notCompleted" : [ 564, 564, 564, 564, 564 ],
      "inProgress" : [ 147, 147, 147, 147, 147 ],
      "insufficientData" : [ 596, 596, 596, 596, 596 ],
      "completed" : [ 81, 81, 81, 81, 81 ],
      "errored" : [ 603, 603, 603, 603, 603 ]
    }
  }, {
    "training" : {
      "notCompleted" : [ 564, 564, 564, 564, 564 ],
      "inProgress" : [ 147, 147, 147, 147, 147 ],
      "insufficientData" : [ 596, 596, 596, 596, 596 ],
      "completed" : [ 81, 81, 81, 81, 81 ],
      "errored" : [ 603, 603, 603, 603, 603 ]
    },
    "validation" : {
      "notCompleted" : [ 564, 564, 564, 564, 564 ],
      "inProgress" : [ 147, 147, 147, 147, 147 ],
      "insufficientData" : [ 596, 596, 596, 596, 596 ],
      "completed" : [ 81, 81, 81, 81, 81 ],
      "errored" : [ 603, 603, 603, 603, 603 ]
    }
  }, {
    "training" : {
      "notCompleted" : [ 564, 564, 564, 564, 564 ],
      "inProgress" : [ 147, 147, 147, 147, 147 ],
      "insufficientData" : [ 596, 596, 596, 596, 596 ],
      "completed" : [ 81, 81, 81, 81, 81 ],
      "errored" : [ 603, 603, 603, 603, 603 ]
    },
    "validation" : {
      "notCompleted" : [ 564, 564, 564, 564, 564 ],
      "inProgress" : [ 147, 147, 147, 147, 147 ],
      "insufficientData" : [ 596, 596, 596, 596, 596 ],
      "completed" : [ 81, 81, 81, 81, 81 ],
      "errored" : [ 603, 603, 603, 603, 603 ]
    }
  } ],
  "resolutions" : [ "milliseconds", "milliseconds", "milliseconds", "milliseconds", "milliseconds" ],
  "backtestMetadata" : [ {
    "training" : {
      "endDate" : "2000-01-23T04:56:07.000+00:00",
      "startDate" : "2000-01-23T04:56:07.000+00:00"
    },
    "validation" : {
      "endDate" : "2000-01-23T04:56:07.000+00:00",
      "startDate" : "2000-01-23T04:56:07.000+00:00"
    }
  }, {
    "training" : {
      "endDate" : "2000-01-23T04:56:07.000+00:00",
      "startDate" : "2000-01-23T04:56:07.000+00:00"
    },
    "validation" : {
      "endDate" : "2000-01-23T04:56:07.000+00:00",
      "startDate" : "2000-01-23T04:56:07.000+00:00"
    }
  }, {
    "training" : {
      "endDate" : "2000-01-23T04:56:07.000+00:00",
      "startDate" : "2000-01-23T04:56:07.000+00:00"
    },
    "validation" : {
      "endDate" : "2000-01-23T04:56:07.000+00:00",
      "startDate" : "2000-01-23T04:56:07.000+00:00"
    }
  }, {
    "training" : {
      "endDate" : "2000-01-23T04:56:07.000+00:00",
      "startDate" : "2000-01-23T04:56:07.000+00:00"
    },
    "validation" : {
      "endDate" : "2000-01-23T04:56:07.000+00:00",
      "startDate" : "2000-01-23T04:56:07.000+00:00"
    }
  }, {
    "training" : {
      "endDate" : "2000-01-23T04:56:07.000+00:00",
      "startDate" : "2000-01-23T04:56:07.000+00:00"
    },
    "validation" : {
      "endDate" : "2000-01-23T04:56:07.000+00:00",
      "startDate" : "2000-01-23T04:56:07.000+00:00"
    }
  } ]
})
    )
    result = ModelsApi.projects_datetime_models_forecast_vs_actual_plots_metadata_list(project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, ForecastVsActualPlotsMetadataResponse)


@responses.activate
def test_models_api_projects_datetime_models_forecast_vs_actual_plots_preview_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/datetimeModels/{modelId}/forecastVsActualPlots/preview/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "bins" : [ {
    "actual" : 0.8008281904610115,
    "endDate" : "2000-01-23T04:56:07.000+00:00",
    "predicted" : 6.027456183070403,
    "startDate" : "2000-01-23T04:56:07.000+00:00"
  }, {
    "actual" : 0.8008281904610115,
    "endDate" : "2000-01-23T04:56:07.000+00:00",
    "predicted" : 6.027456183070403,
    "startDate" : "2000-01-23T04:56:07.000+00:00"
  }, {
    "actual" : 0.8008281904610115,
    "endDate" : "2000-01-23T04:56:07.000+00:00",
    "predicted" : 6.027456183070403,
    "startDate" : "2000-01-23T04:56:07.000+00:00"
  }, {
    "actual" : 0.8008281904610115,
    "endDate" : "2000-01-23T04:56:07.000+00:00",
    "predicted" : 6.027456183070403,
    "startDate" : "2000-01-23T04:56:07.000+00:00"
  }, {
    "actual" : 0.8008281904610115,
    "endDate" : "2000-01-23T04:56:07.000+00:00",
    "predicted" : 6.027456183070403,
    "startDate" : "2000-01-23T04:56:07.000+00:00"
  } ],
  "endDate" : "2000-01-23T04:56:07.000+00:00",
  "startDate" : "2000-01-23T04:56:07.000+00:00"
})
    )
    result = ModelsApi.projects_datetime_models_forecast_vs_actual_plots_preview_list(project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, DatetimeTrendPlotsPreviewResponse)


@responses.activate
def test_models_api_projects_datetime_models_from_model_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/api/v2/projects/{projectId}/datetimeModels/fromModel/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", ),
        status=202,
        content_type='application/json',
        body=json.dumps({
  "message" : "message"
})
    )
    result = ModelsApi.projects_datetime_models_from_model_create(project_id="projectId_example", )
    assert isinstance(result, DatetimeModelSubmissionResponse)


@responses.activate
def test_models_api_projects_datetime_models_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/datetimeModels/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "timeWindowSamplePct" : 73,
    "featurelistName" : "featurelistName",
    "modelFamily" : "modelFamily",
    "trainingInfo" : {
      "predictionTrainingEndDate" : "2000-01-23T04:56:07.000+00:00",
      "holdoutTrainingDuration" : "holdoutTrainingDuration",
      "holdoutTrainingEndDate" : "2000-01-23T04:56:07.000+00:00",
      "predictionTrainingDuration" : "predictionTrainingDuration",
      "predictionTrainingRowCount" : 1,
      "predictionTrainingStartDate" : "2000-01-23T04:56:07.000+00:00",
      "holdoutTrainingRowCount" : 1,
      "holdoutTrainingStartDate" : "2000-01-23T04:56:07.000+00:00"
    },
    "holdoutStatus" : "COMPLETED",
    "effectiveFeatureDerivationWindowStart" : 0,
    "predictionThreshold" : 4.145608029883936,
    "trainingEndDate" : "2000-01-23T04:56:07.000+00:00",
    "effectiveFeatureDerivationWindowEnd" : 0,
    "dataSelectionMethod" : "duration",
    "id" : "id",
    "isFrozen" : True,
    "modelCategory" : "model",
    "monotonicDecreasingFeaturelistId" : "monotonicDecreasingFeaturelistId",
    "supportsComposableMl" : True,
    "forecastWindowStart" : 0,
    "processes" : [ "processes", "processes" ],
    "linkFunction" : "linkFunction",
    "trainingDuration" : "trainingDuration",
    "parentModelId" : "parentModelId",
    "predictionThresholdReadOnly" : True,
    "isStarred" : True,
    "featurelistId" : "featurelistId",
    "modelType" : "modelType",
    "backtests" : [ {
      "score" : 1.4658129805029452,
      "trainingDuration" : "trainingDuration",
      "trainingEndDate" : "2000-01-23T04:56:07.000+00:00",
      "trainingStartDate" : "2000-01-23T04:56:07.000+00:00",
      "trainingRowCount" : 5,
      "index" : 6,
      "status" : "COMPLETED"
    }, {
      "score" : 1.4658129805029452,
      "trainingDuration" : "trainingDuration",
      "trainingEndDate" : "2000-01-23T04:56:07.000+00:00",
      "trainingStartDate" : "2000-01-23T04:56:07.000+00:00",
      "trainingRowCount" : 5,
      "index" : 6,
      "status" : "COMPLETED"
    } ],
    "blueprintId" : "blueprintId",
    "supportsMonotonicConstraints" : True,
    "monotonicIncreasingFeaturelistId" : "monotonicIncreasingFeaturelistId",
    "forecastWindowEnd" : 0,
    "trainingStartDate" : "2000-01-23T04:56:07.000+00:00",
    "windowsBasisUnit" : "MILLISECOND",
    "trainingRowCount" : 1,
    "holdoutScore" : 3.616076749251911,
    "modelNumber" : 2,
    "metrics" : "\n        {\n            \"metrics\": {\n                \"FVE Poisson\": {\n                    \"holdout\": null,\n                    \"validation\": 0.56269,\n                    \"backtesting\": 0.50166,\n                    \"backtestingScores\": [0.51206, 0.49436, null, 0.62516],\n                    \"crossValidation\": null\n                },\n                \"RMSE\": {\n                    \"holdout\": null,\n                    \"validation\": 21.0836,\n                    \"backtesting\": 23.361932,\n                    \"backtestingScores\": [0.4403, 0.4213, null, 0.5132],\n                    \"crossValidation\": null\n                }\n            }\n        }\n",
    "samplingMethod" : "random",
    "projectId" : "projectId"
  }, {
    "timeWindowSamplePct" : 73,
    "featurelistName" : "featurelistName",
    "modelFamily" : "modelFamily",
    "trainingInfo" : {
      "predictionTrainingEndDate" : "2000-01-23T04:56:07.000+00:00",
      "holdoutTrainingDuration" : "holdoutTrainingDuration",
      "holdoutTrainingEndDate" : "2000-01-23T04:56:07.000+00:00",
      "predictionTrainingDuration" : "predictionTrainingDuration",
      "predictionTrainingRowCount" : 1,
      "predictionTrainingStartDate" : "2000-01-23T04:56:07.000+00:00",
      "holdoutTrainingRowCount" : 1,
      "holdoutTrainingStartDate" : "2000-01-23T04:56:07.000+00:00"
    },
    "holdoutStatus" : "COMPLETED",
    "effectiveFeatureDerivationWindowStart" : 0,
    "predictionThreshold" : 4.145608029883936,
    "trainingEndDate" : "2000-01-23T04:56:07.000+00:00",
    "effectiveFeatureDerivationWindowEnd" : 0,
    "dataSelectionMethod" : "duration",
    "id" : "id",
    "isFrozen" : True,
    "modelCategory" : "model",
    "monotonicDecreasingFeaturelistId" : "monotonicDecreasingFeaturelistId",
    "supportsComposableMl" : True,
    "forecastWindowStart" : 0,
    "processes" : [ "processes", "processes" ],
    "linkFunction" : "linkFunction",
    "trainingDuration" : "trainingDuration",
    "parentModelId" : "parentModelId",
    "predictionThresholdReadOnly" : True,
    "isStarred" : True,
    "featurelistId" : "featurelistId",
    "modelType" : "modelType",
    "backtests" : [ {
      "score" : 1.4658129805029452,
      "trainingDuration" : "trainingDuration",
      "trainingEndDate" : "2000-01-23T04:56:07.000+00:00",
      "trainingStartDate" : "2000-01-23T04:56:07.000+00:00",
      "trainingRowCount" : 5,
      "index" : 6,
      "status" : "COMPLETED"
    }, {
      "score" : 1.4658129805029452,
      "trainingDuration" : "trainingDuration",
      "trainingEndDate" : "2000-01-23T04:56:07.000+00:00",
      "trainingStartDate" : "2000-01-23T04:56:07.000+00:00",
      "trainingRowCount" : 5,
      "index" : 6,
      "status" : "COMPLETED"
    } ],
    "blueprintId" : "blueprintId",
    "supportsMonotonicConstraints" : True,
    "monotonicIncreasingFeaturelistId" : "monotonicIncreasingFeaturelistId",
    "forecastWindowEnd" : 0,
    "trainingStartDate" : "2000-01-23T04:56:07.000+00:00",
    "windowsBasisUnit" : "MILLISECOND",
    "trainingRowCount" : 1,
    "holdoutScore" : 3.616076749251911,
    "modelNumber" : 2,
    "metrics" : "\n        {\n            \"metrics\": {\n                \"FVE Poisson\": {\n                    \"holdout\": null,\n                    \"validation\": 0.56269,\n                    \"backtesting\": 0.50166,\n                    \"backtestingScores\": [0.51206, 0.49436, null, 0.62516],\n                    \"crossValidation\": null\n                },\n                \"RMSE\": {\n                    \"holdout\": null,\n                    \"validation\": 21.0836,\n                    \"backtesting\": 23.361932,\n                    \"backtestingScores\": [0.4403, 0.4213, null, 0.5132],\n                    \"crossValidation\": null\n                }\n            }\n        }\n",
    "samplingMethod" : "random",
    "projectId" : "projectId"
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0
})
    )
    result = ModelsApi.projects_datetime_models_list(project_id="projectId_example", )
    assert isinstance(result, DatetimeModelsResponse)


@responses.activate
def test_models_api_projects_datetime_models_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/datetimeModels/{modelId}/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "timeWindowSamplePct" : 73,
  "featurelistName" : "featurelistName",
  "modelFamily" : "modelFamily",
  "trainingInfo" : {
    "predictionTrainingEndDate" : "2000-01-23T04:56:07.000+00:00",
    "holdoutTrainingDuration" : "holdoutTrainingDuration",
    "holdoutTrainingEndDate" : "2000-01-23T04:56:07.000+00:00",
    "predictionTrainingDuration" : "predictionTrainingDuration",
    "predictionTrainingRowCount" : 1,
    "predictionTrainingStartDate" : "2000-01-23T04:56:07.000+00:00",
    "holdoutTrainingRowCount" : 1,
    "holdoutTrainingStartDate" : "2000-01-23T04:56:07.000+00:00"
  },
  "holdoutStatus" : "COMPLETED",
  "effectiveFeatureDerivationWindowStart" : 0,
  "predictionThreshold" : 4.145608029883936,
  "trainingEndDate" : "2000-01-23T04:56:07.000+00:00",
  "effectiveFeatureDerivationWindowEnd" : 0,
  "dataSelectionMethod" : "duration",
  "id" : "id",
  "isFrozen" : True,
  "modelCategory" : "model",
  "monotonicDecreasingFeaturelistId" : "monotonicDecreasingFeaturelistId",
  "supportsComposableMl" : True,
  "forecastWindowStart" : 0,
  "processes" : [ "processes", "processes" ],
  "linkFunction" : "linkFunction",
  "trainingDuration" : "trainingDuration",
  "parentModelId" : "parentModelId",
  "predictionThresholdReadOnly" : True,
  "isStarred" : True,
  "featurelistId" : "featurelistId",
  "modelType" : "modelType",
  "backtests" : [ {
    "score" : 1.4658129805029452,
    "trainingDuration" : "trainingDuration",
    "trainingEndDate" : "2000-01-23T04:56:07.000+00:00",
    "trainingStartDate" : "2000-01-23T04:56:07.000+00:00",
    "trainingRowCount" : 5,
    "index" : 6,
    "status" : "COMPLETED"
  }, {
    "score" : 1.4658129805029452,
    "trainingDuration" : "trainingDuration",
    "trainingEndDate" : "2000-01-23T04:56:07.000+00:00",
    "trainingStartDate" : "2000-01-23T04:56:07.000+00:00",
    "trainingRowCount" : 5,
    "index" : 6,
    "status" : "COMPLETED"
  } ],
  "blueprintId" : "blueprintId",
  "supportsMonotonicConstraints" : True,
  "monotonicIncreasingFeaturelistId" : "monotonicIncreasingFeaturelistId",
  "forecastWindowEnd" : 0,
  "trainingStartDate" : "2000-01-23T04:56:07.000+00:00",
  "windowsBasisUnit" : "MILLISECOND",
  "trainingRowCount" : 1,
  "holdoutScore" : 3.616076749251911,
  "modelNumber" : 2,
  "metrics" : "\n        {\n            \"metrics\": {\n                \"FVE Poisson\": {\n                    \"holdout\": null,\n                    \"validation\": 0.56269,\n                    \"backtesting\": 0.50166,\n                    \"backtestingScores\": [0.51206, 0.49436, null, 0.62516],\n                    \"crossValidation\": null\n                },\n                \"RMSE\": {\n                    \"holdout\": null,\n                    \"validation\": 21.0836,\n                    \"backtesting\": 23.361932,\n                    \"backtestingScores\": [0.4403, 0.4213, null, 0.5132],\n                    \"crossValidation\": null\n                }\n            }\n        }\n",
  "samplingMethod" : "random",
  "projectId" : "projectId"
})
    )
    result = ModelsApi.projects_datetime_models_retrieve(project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, DatetimeModelDetailsResponse)


@responses.activate
def test_models_api_projects_deployment_ready_models_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/api/v2/projects/{projectId}/deploymentReadyModels/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", ),
        status=201,
        content_type='',
    )
    result = ModelsApi.projects_deployment_ready_models_create(project_id="projectId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_models_api_projects_frozen_datetime_models_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/api/v2/projects/{projectId}/frozenDatetimeModels/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", ),
        status=202,
        content_type='application/json',
        body=json.dumps({
  "message" : "message"
})
    )
    result = ModelsApi.projects_frozen_datetime_models_create(project_id="projectId_example", )
    assert isinstance(result, DatetimeModelSubmissionResponse)


@responses.activate
def test_models_api_projects_frozen_models_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/api/v2/projects/{projectId}/frozenModels/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", ),
        status=204,
        content_type='',
    )
    result = ModelsApi.projects_frozen_models_create(project_id="projectId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_models_api_projects_frozen_models_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/frozenModels/'.format(endpoint=unittest_endpoint,
        offset=0, limit=0, projectId="projectId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "next",
  "data" : [ {
    "monotonicDecreasingFeaturelistId" : "monotonicDecreasingFeaturelistId",
    "supportsComposableMl" : True,
    "samplePct" : 5.962133916683182,
    "featurelistName" : "featurelistName",
    "processes" : [ "processes", "processes" ],
    "trainingDuration" : "trainingDuration",
    "parentModelId" : "parentModelId",
    "predictionThresholdReadOnly" : True,
    "isStarred" : True,
    "featurelistId" : "featurelistId",
    "modelType" : "modelType",
    "blueprintId" : "blueprintId",
    "supportsMonotonicConstraints" : True,
    "monotonicIncreasingFeaturelistId" : "monotonicIncreasingFeaturelistId",
    "predictionThreshold" : 1.4658129805029452,
    "trainingEndDate" : "trainingEndDate",
    "trainingStartDate" : "trainingStartDate",
    "trainingRowCount" : 5,
    "modelNumber" : 0,
    "id" : "id",
    "metrics" : "\n        {\n            \"metrics\": {\n                \"RMSE\": {\n                    \"holdout\": 5000,\n                    \"validation\": 5100,\n                    \"backtesting\": null,\n                    \"backtestingScores\": null,\n                    \"crossValidation\": 6000,\n                    \"training\": null\n                },\n                \"FVE Poisson\": {\n                    \"holdout\": null,\n                    \"validation\": 0.56269,\n                    \"crossValidation\": 0.50166,\n                    \"backtesting\": null,\n                    \"backtestingScores\": null,\n                    \"training\": null\n                },\n            }\n        }\n",
    "isFrozen" : True,
    "modelCategory" : "model",
    "projectId" : "projectId"
  }, {
    "monotonicDecreasingFeaturelistId" : "monotonicDecreasingFeaturelistId",
    "supportsComposableMl" : True,
    "samplePct" : 5.962133916683182,
    "featurelistName" : "featurelistName",
    "processes" : [ "processes", "processes" ],
    "trainingDuration" : "trainingDuration",
    "parentModelId" : "parentModelId",
    "predictionThresholdReadOnly" : True,
    "isStarred" : True,
    "featurelistId" : "featurelistId",
    "modelType" : "modelType",
    "blueprintId" : "blueprintId",
    "supportsMonotonicConstraints" : True,
    "monotonicIncreasingFeaturelistId" : "monotonicIncreasingFeaturelistId",
    "predictionThreshold" : 1.4658129805029452,
    "trainingEndDate" : "trainingEndDate",
    "trainingStartDate" : "trainingStartDate",
    "trainingRowCount" : 5,
    "modelNumber" : 0,
    "id" : "id",
    "metrics" : "\n        {\n            \"metrics\": {\n                \"RMSE\": {\n                    \"holdout\": 5000,\n                    \"validation\": 5100,\n                    \"backtesting\": null,\n                    \"backtestingScores\": null,\n                    \"crossValidation\": 6000,\n                    \"training\": null\n                },\n                \"FVE Poisson\": {\n                    \"holdout\": null,\n                    \"validation\": 0.56269,\n                    \"crossValidation\": 0.50166,\n                    \"backtesting\": null,\n                    \"backtestingScores\": null,\n                    \"training\": null\n                },\n            }\n        }\n",
    "isFrozen" : True,
    "modelCategory" : "model",
    "projectId" : "projectId"
  } ],
  "previous" : "previous",
  "count" : 0,
  "totalCount" : 2
})
    )
    result = ModelsApi.projects_frozen_models_list(offset=0, limit=0, project_id="projectId_example", )
    assert isinstance(result, FrozenModelListResponse)


@responses.activate
def test_models_api_projects_frozen_models_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/frozenModels/{modelId}/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "monotonicDecreasingFeaturelistId" : "monotonicDecreasingFeaturelistId",
  "supportsComposableMl" : True,
  "samplePct" : 5.962133916683182,
  "featurelistName" : "featurelistName",
  "processes" : [ "processes", "processes" ],
  "trainingDuration" : "trainingDuration",
  "parentModelId" : "parentModelId",
  "predictionThresholdReadOnly" : True,
  "isStarred" : True,
  "featurelistId" : "featurelistId",
  "modelType" : "modelType",
  "blueprintId" : "blueprintId",
  "supportsMonotonicConstraints" : True,
  "monotonicIncreasingFeaturelistId" : "monotonicIncreasingFeaturelistId",
  "predictionThreshold" : 1.4658129805029452,
  "trainingEndDate" : "trainingEndDate",
  "trainingStartDate" : "trainingStartDate",
  "trainingRowCount" : 5,
  "modelNumber" : 0,
  "id" : "id",
  "metrics" : "\n        {\n            \"metrics\": {\n                \"RMSE\": {\n                    \"holdout\": 5000,\n                    \"validation\": 5100,\n                    \"backtesting\": null,\n                    \"backtestingScores\": null,\n                    \"crossValidation\": 6000,\n                    \"training\": null\n                },\n                \"FVE Poisson\": {\n                    \"holdout\": null,\n                    \"validation\": 0.56269,\n                    \"crossValidation\": 0.50166,\n                    \"backtesting\": null,\n                    \"backtestingScores\": null,\n                    \"training\": null\n                },\n            }\n        }\n",
  "isFrozen" : True,
  "modelCategory" : "model",
  "projectId" : "projectId"
})
    )
    result = ModelsApi.projects_frozen_models_retrieve(project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, FrozenModelRetrieveResponse)


@responses.activate
def test_models_api_projects_model_jobs_delete(unittest_endpoint):
    responses.add(
        responses.DELETE,
        '{endpoint}/api/v2/projects/{projectId}/modelJobs/{jobId}/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", jobId="jobId_example", ),
        status=204,
        content_type='',
    )
    result = ModelsApi.projects_model_jobs_delete(project_id="projectId_example", job_id="jobId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_models_api_projects_model_jobs_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/modelJobs/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "data" : [ {
    "samplePct" : 0.8008281904610115,
    "processes" : [ "processes", "processes" ],
    "modelId" : "modelId",
    "isBlocked" : True,
    "featurelistId" : "featurelistId",
    "id" : "id",
    "modelType" : "modelType",
    "modelCategory" : "model",
    "blueprintId" : "blueprintId",
    "projectId" : "projectId",
    "status" : "queue"
  }, {
    "samplePct" : 0.8008281904610115,
    "processes" : [ "processes", "processes" ],
    "modelId" : "modelId",
    "isBlocked" : True,
    "featurelistId" : "featurelistId",
    "id" : "id",
    "modelType" : "modelType",
    "modelCategory" : "model",
    "blueprintId" : "blueprintId",
    "projectId" : "projectId",
    "status" : "queue"
  } ]
})
    )
    result = ModelsApi.projects_model_jobs_list(project_id="projectId_example", )
    assert isinstance(result, ModelingJobListResponse)


@responses.activate
def test_models_api_projects_model_jobs_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/modelJobs/{jobId}/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", jobId="jobId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "samplePct" : 0.8008281904610115,
  "processes" : [ "processes", "processes" ],
  "modelId" : "modelId",
  "isBlocked" : True,
  "featurelistId" : "featurelistId",
  "id" : "id",
  "modelType" : "modelType",
  "modelCategory" : "model",
  "blueprintId" : "blueprintId",
  "projectId" : "projectId",
  "status" : "queue"
})
    )
    result = ModelsApi.projects_model_jobs_retrieve(project_id="projectId_example", job_id="jobId_example", )
    assert isinstance(result, ModelJobResponse)


@responses.activate
def test_models_api_projects_models_advanced_tuning_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/api/v2/projects/{projectId}/models/{modelId}/advancedTuning/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=202,
        content_type='',
    )
    result = ModelsApi.projects_models_advanced_tuning_create(project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_models_api_projects_models_advanced_tuning_parameters_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/models/{modelId}/advancedTuning/parameters/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "tuningDescription" : "tuningDescription",
  "tuningParameters" : [ {
    "parameterId" : "parameterId",
    "defaultValue" : "",
    "taskName" : "taskName",
    "parameterName" : "parameterName",
    "constraints" : {
      "select" : {
        "values" : [ "values", "values" ],
        "supportsGridSearch" : True
      },
      "selectgrid" : {
        "values" : [ "values", "values" ],
        "supportsGridSearch" : True
      },
      "intList" : {
        "maxVal" : 2,
        "minVal" : 7,
        "minLength" : 0,
        "supportsGridSearch" : True,
        "maxLength" : 0
      },
      "floatList" : {
        "maxVal" : 5.962133916683182,
        "minVal" : 2.3021358869347655,
        "minLength" : 0,
        "supportsGridSearch" : True,
        "maxLength" : 0
      },
      "unicode" : {
        "supportsGridSearch" : True
      },
      "float" : {
        "min" : 6.027456183070403,
        "max" : 0.8008281904610115,
        "supportsGridSearch" : True
      },
      "ascii" : {
        "supportsGridSearch" : True
      },
      "int" : {
        "min" : 9,
        "max" : 7,
        "supportsGridSearch" : True
      }
    },
    "currentValue" : ""
  }, {
    "parameterId" : "parameterId",
    "defaultValue" : "",
    "taskName" : "taskName",
    "parameterName" : "parameterName",
    "constraints" : {
      "select" : {
        "values" : [ "values", "values" ],
        "supportsGridSearch" : True
      },
      "selectgrid" : {
        "values" : [ "values", "values" ],
        "supportsGridSearch" : True
      },
      "intList" : {
        "maxVal" : 2,
        "minVal" : 7,
        "minLength" : 0,
        "supportsGridSearch" : True,
        "maxLength" : 0
      },
      "floatList" : {
        "maxVal" : 5.962133916683182,
        "minVal" : 2.3021358869347655,
        "minLength" : 0,
        "supportsGridSearch" : True,
        "maxLength" : 0
      },
      "unicode" : {
        "supportsGridSearch" : True
      },
      "float" : {
        "min" : 6.027456183070403,
        "max" : 0.8008281904610115,
        "supportsGridSearch" : True
      },
      "ascii" : {
        "supportsGridSearch" : True
      },
      "int" : {
        "min" : 9,
        "max" : 7,
        "supportsGridSearch" : True
      }
    },
    "currentValue" : ""
  } ]
})
    )
    result = ModelsApi.projects_models_advanced_tuning_parameters_list(project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, AdvancedTuningArgumentsRetrieveResponse)


@responses.activate
def test_models_api_projects_models_anomaly_insights_file_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/models/{modelId}/anomalyInsightsFile/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=200,
        content_type='',
    )
    result = ModelsApi.projects_models_anomaly_insights_file_list(project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_models_api_projects_models_anomaly_insights_table_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/models/{modelId}/anomalyInsightsTable/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "modelId" : "modelId",
  "table" : [ {
    "data" : [ 0.8008281904610115, 0.8008281904610115 ],
    "columns" : [ "columns", "columns" ],
    "rowId" : [ 6, 6 ]
  }, {
    "data" : [ 0.8008281904610115, 0.8008281904610115 ],
    "columns" : [ "columns", "columns" ],
    "rowId" : [ 6, 6 ]
  } ]
})
    )
    result = ModelsApi.projects_models_anomaly_insights_table_list(project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, AnomalyInsightTableRetrieve)


@responses.activate
def test_models_api_projects_models_confusion_charts_class_details_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/models/{modelId}/confusionCharts/{source}/classDetails/'.format(endpoint=unittest_endpoint,
        className="className_example", projectId="projectId_example", modelId="modelId_example", source="backtest_19", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "predictedFrequency" : [ {
    "percentage" : 14.658129805029452,
    "otherClassName" : "otherClassName",
    "value" : 0
  }, {
    "percentage" : 14.658129805029452,
    "otherClassName" : "otherClassName",
    "value" : 0
  } ],
  "className" : "className",
  "actualFrequency" : [ {
    "percentage" : 8.008281904610115,
    "otherClassName" : "otherClassName",
    "value" : 0
  }, {
    "percentage" : 8.008281904610115,
    "otherClassName" : "otherClassName",
    "value" : 0
  } ]
})
    )
    result = ModelsApi.projects_models_confusion_charts_class_details_list(class_name="className_example", project_id="projectId_example", model_id="modelId_example", source="backtest_19", )
    assert isinstance(result, ModelConfusionChartClassDetailsRetrieveReponseController)


@responses.activate
def test_models_api_projects_models_confusion_charts_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/models/{modelId}/confusionCharts/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "charts" : [ {
    "data" : {
      "classMetrics" : [ {
        "wasPredictedPercentages" : [ {
          "percentage" : 3.616076749251911,
          "otherClassName" : "otherClassName"
        }, {
          "percentage" : 3.616076749251911,
          "otherClassName" : "otherClassName"
        } ],
        "wasActualPercentages" : [ {
          "percentage" : 9.301444243932576,
          "otherClassName" : "otherClassName"
        }, {
          "percentage" : 9.301444243932576,
          "otherClassName" : "otherClassName"
        } ],
        "confusionMatrixOneVsAll" : [ [ 1, 1 ], [ 1, 1 ] ],
        "actualCount" : 6,
        "precision" : 5.637376656633329,
        "recall" : 7.061401241503109,
        "className" : "className",
        "f1" : 5.962133916683182,
        "predictedCount" : 2
      }, {
        "wasPredictedPercentages" : [ {
          "percentage" : 3.616076749251911,
          "otherClassName" : "otherClassName"
        }, {
          "percentage" : 3.616076749251911,
          "otherClassName" : "otherClassName"
        } ],
        "wasActualPercentages" : [ {
          "percentage" : 9.301444243932576,
          "otherClassName" : "otherClassName"
        }, {
          "percentage" : 9.301444243932576,
          "otherClassName" : "otherClassName"
        } ],
        "confusionMatrixOneVsAll" : [ [ 1, 1 ], [ 1, 1 ] ],
        "actualCount" : 6,
        "precision" : 5.637376656633329,
        "recall" : 7.061401241503109,
        "className" : "className",
        "f1" : 5.962133916683182,
        "predictedCount" : 2
      } ],
      "classes" : [ "classes", "classes" ],
      "confusionMatrix" : [ [ 2, 2 ], [ 2, 2 ] ],
      "rowClasses" : [ "rowClasses", "rowClasses" ],
      "colClasses" : [ "colClasses", "colClasses" ]
    },
    "totalMatrixSum" : 1,
    "columns" : [ 0, 0 ],
    "numberOfClasses" : 4,
    "source" : "validation",
    "rows" : [ 7, 7 ]
  }, {
    "data" : {
      "classMetrics" : [ {
        "wasPredictedPercentages" : [ {
          "percentage" : 3.616076749251911,
          "otherClassName" : "otherClassName"
        }, {
          "percentage" : 3.616076749251911,
          "otherClassName" : "otherClassName"
        } ],
        "wasActualPercentages" : [ {
          "percentage" : 9.301444243932576,
          "otherClassName" : "otherClassName"
        }, {
          "percentage" : 9.301444243932576,
          "otherClassName" : "otherClassName"
        } ],
        "confusionMatrixOneVsAll" : [ [ 1, 1 ], [ 1, 1 ] ],
        "actualCount" : 6,
        "precision" : 5.637376656633329,
        "recall" : 7.061401241503109,
        "className" : "className",
        "f1" : 5.962133916683182,
        "predictedCount" : 2
      }, {
        "wasPredictedPercentages" : [ {
          "percentage" : 3.616076749251911,
          "otherClassName" : "otherClassName"
        }, {
          "percentage" : 3.616076749251911,
          "otherClassName" : "otherClassName"
        } ],
        "wasActualPercentages" : [ {
          "percentage" : 9.301444243932576,
          "otherClassName" : "otherClassName"
        }, {
          "percentage" : 9.301444243932576,
          "otherClassName" : "otherClassName"
        } ],
        "confusionMatrixOneVsAll" : [ [ 1, 1 ], [ 1, 1 ] ],
        "actualCount" : 6,
        "precision" : 5.637376656633329,
        "recall" : 7.061401241503109,
        "className" : "className",
        "f1" : 5.962133916683182,
        "predictedCount" : 2
      } ],
      "classes" : [ "classes", "classes" ],
      "confusionMatrix" : [ [ 2, 2 ], [ 2, 2 ] ],
      "rowClasses" : [ "rowClasses", "rowClasses" ],
      "colClasses" : [ "colClasses", "colClasses" ]
    },
    "totalMatrixSum" : 1,
    "columns" : [ 0, 0 ],
    "numberOfClasses" : 4,
    "source" : "validation",
    "rows" : [ 7, 7 ]
  } ]
})
    )
    result = ModelsApi.projects_models_confusion_charts_list(project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, ModelConfusionChartListResponse)


@responses.activate
def test_models_api_projects_models_confusion_charts_metadata_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/models/{modelId}/confusionCharts/{source}/metadata/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", source="backtest_19", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "relevantClassesPositions" : [ [ 0, 0 ], [ 0, 0 ] ],
  "totalMatrixSum" : 0,
  "classNames" : [ "classNames", "classNames" ],
  "source" : "validation"
})
    )
    result = ModelsApi.projects_models_confusion_charts_metadata_list(project_id="projectId_example", model_id="modelId_example", source="backtest_19", )
    assert isinstance(result, ModelConfusionChartMetadataRetrieveResponse)


@responses.activate
def test_models_api_projects_models_confusion_charts_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/models/{modelId}/confusionCharts/{source}/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", source="backtest_19", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "data" : {
    "classMetrics" : [ {
      "wasPredictedPercentages" : [ {
        "percentage" : 3.616076749251911,
        "otherClassName" : "otherClassName"
      }, {
        "percentage" : 3.616076749251911,
        "otherClassName" : "otherClassName"
      } ],
      "wasActualPercentages" : [ {
        "percentage" : 9.301444243932576,
        "otherClassName" : "otherClassName"
      }, {
        "percentage" : 9.301444243932576,
        "otherClassName" : "otherClassName"
      } ],
      "confusionMatrixOneVsAll" : [ [ 1, 1 ], [ 1, 1 ] ],
      "actualCount" : 6,
      "precision" : 5.637376656633329,
      "recall" : 7.061401241503109,
      "className" : "className",
      "f1" : 5.962133916683182,
      "predictedCount" : 2
    }, {
      "wasPredictedPercentages" : [ {
        "percentage" : 3.616076749251911,
        "otherClassName" : "otherClassName"
      }, {
        "percentage" : 3.616076749251911,
        "otherClassName" : "otherClassName"
      } ],
      "wasActualPercentages" : [ {
        "percentage" : 9.301444243932576,
        "otherClassName" : "otherClassName"
      }, {
        "percentage" : 9.301444243932576,
        "otherClassName" : "otherClassName"
      } ],
      "confusionMatrixOneVsAll" : [ [ 1, 1 ], [ 1, 1 ] ],
      "actualCount" : 6,
      "precision" : 5.637376656633329,
      "recall" : 7.061401241503109,
      "className" : "className",
      "f1" : 5.962133916683182,
      "predictedCount" : 2
    } ],
    "classes" : [ "classes", "classes" ],
    "confusionMatrix" : [ [ 2, 2 ], [ 2, 2 ] ],
    "rowClasses" : [ "rowClasses", "rowClasses" ],
    "colClasses" : [ "colClasses", "colClasses" ]
  },
  "totalMatrixSum" : 1,
  "columns" : [ 0, 0 ],
  "numberOfClasses" : 4,
  "source" : "validation",
  "rows" : [ 7, 7 ]
})
    )
    result = ModelsApi.projects_models_confusion_charts_retrieve(project_id="projectId_example", model_id="modelId_example", source="backtest_19", )
    assert isinstance(result, ModelConfusionChartRetrieveResponse)


@responses.activate
def test_models_api_projects_models_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/api/v2/projects/{projectId}/models/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", ),
        status=202,
        content_type='',
    )
    result = ModelsApi.projects_models_create(project_id="projectId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_models_api_projects_models_cross_validation_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/api/v2/projects/{projectId}/models/{modelId}/crossValidation/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=202,
        content_type='',
    )
    result = ModelsApi.projects_models_cross_validation_create(project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_models_api_projects_models_cross_validation_scores_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/models/{modelId}/crossValidationScores/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "cvScores" : "\n        {\n            \"cvScores\": {\n                \"FVE Gamma\": {\n                    \"0.0\": 0.24334,\n                    \"1.0\": 0.17757,\n                    \"2.0\": 0.21803,\n                    \"3.0\": 0.20185,\n                    \"4.0\": 0.20576\n                },\n                \"FVE Poisson\": {\n                    \"0.0\": 0.24527,\n                    \"1.0\": 0.22092,\n                    \"2.0\": 0.22451,\n                    \"3.0\": 0.24417,\n                    \"4.0\": 0.21654\n                }\n            }\n        }\n"
})
    )
    result = ModelsApi.projects_models_cross_validation_scores_list(project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, CrossValidationRetrieveResponse)


@responses.activate
def test_models_api_projects_models_delete(unittest_endpoint):
    responses.add(
        responses.DELETE,
        '{endpoint}/api/v2/projects/{projectId}/models/{modelId}/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=204,
        content_type='',
    )
    result = ModelsApi.projects_models_delete(project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_models_api_projects_models_export_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/models/{modelId}/export/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=200,
        content_type='',
    )
    result = ModelsApi.projects_models_export_list(project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_models_api_projects_models_features_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/models/{modelId}/features/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "featureNames" : [ "featureNames", "featureNames" ],
  "knownInAdvanceFeatureNames" : [ "knownInAdvanceFeatureNames", "knownInAdvanceFeatureNames" ],
  "aPrioriFeatureNames" : [ "aPrioriFeatureNames", "aPrioriFeatureNames" ]
})
    )
    result = ModelsApi.projects_models_features_list(project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, ModelFeatureListResponse)


@responses.activate
def test_models_api_projects_models_from_model_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/api/v2/projects/{projectId}/models/fromModel/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", ),
        status=202,
        content_type='application/json',
        body=json.dumps({
  "message" : "message"
})
    )
    result = ModelsApi.projects_models_from_model_create(project_id="projectId_example", )
    assert isinstance(result, ModelRetrainResponse)


@responses.activate
def test_models_api_projects_models_lift_chart_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/models/{modelId}/liftChart/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "charts" : [ {
    "bins" : [ {
      "actual" : 0.8008281904610115,
      "binWeight" : 6.027456183070403,
      "predicted" : 1.4658129805029452
    }, {
      "actual" : 0.8008281904610115,
      "binWeight" : 6.027456183070403,
      "predicted" : 1.4658129805029452
    } ],
    "source" : "backtest_19"
  }, {
    "bins" : [ {
      "actual" : 0.8008281904610115,
      "binWeight" : 6.027456183070403,
      "predicted" : 1.4658129805029452
    }, {
      "actual" : 0.8008281904610115,
      "binWeight" : 6.027456183070403,
      "predicted" : 1.4658129805029452
    } ],
    "source" : "backtest_19"
  } ]
})
    )
    result = ModelsApi.projects_models_lift_chart_list(project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, ModelLiftChartListResponse)


@responses.activate
def test_models_api_projects_models_lift_chart_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/models/{modelId}/liftChart/{source}/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", source="backtest_19", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "bins" : [ {
    "actual" : 0.8008281904610115,
    "binWeight" : 6.027456183070403,
    "predicted" : 1.4658129805029452
  }, {
    "actual" : 0.8008281904610115,
    "binWeight" : 6.027456183070403,
    "predicted" : 1.4658129805029452
  } ],
  "source" : "backtest_19"
})
    )
    result = ModelsApi.projects_models_lift_chart_retrieve(project_id="projectId_example", model_id="modelId_example", source="backtest_19", )
    assert isinstance(result, ModelLiftChartResponse)


@responses.activate
def test_models_api_projects_models_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/models/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "samplePct" : 6.027456183070403,
  "featurelistName" : "featurelistName",
  "modelFamily" : "modelFamily",
  "predictionThreshold" : 0.8008281904610115,
  "trainingEndDate" : "2000-01-23T04:56:07.000+00:00",
  "id" : "id",
  "isFrozen" : True,
  "modelCategory" : "model",
  "monotonicDecreasingFeaturelistId" : "monotonicDecreasingFeaturelistId",
  "supportsComposableMl" : True,
  "processes" : [ "processes", "processes" ],
  "linkFunction" : "linkFunction",
  "trainingDuration" : "trainingDuration",
  "parentModelId" : "parentModelId",
  "predictionThresholdReadOnly" : True,
  "isStarred" : True,
  "featurelistId" : "featurelistId",
  "modelType" : "modelType",
  "blueprintId" : "blueprintId",
  "supportsMonotonicConstraints" : True,
  "monotonicIncreasingFeaturelistId" : "monotonicIncreasingFeaturelistId",
  "trainingStartDate" : "2000-01-23T04:56:07.000+00:00",
  "trainingRowCount" : 1,
  "metrics" : "\n        {\n            \"metrics\": {\n                \"RMSE\": {\n                    \"holdout\": 5000,\n                    \"validation\": 5100,\n                    \"backtesting\": null,\n                    \"backtestingScores\": null,\n                    \"crossValidation\": 6000,\n                    \"training\": null\n                },\n                \"FVE Poisson\": {\n                    \"holdout\": null,\n                    \"validation\": 0.56269,\n                    \"crossValidation\": 0.50166,\n                    \"backtesting\": null,\n                    \"backtestingScores\": null,\n                    \"training\": null\n                },\n            }\n        }\n",
  "projectId" : "projectId"
})
    )
    result = ModelsApi.projects_models_list(project_id="projectId_example", )
    assert isinstance(result, ModelDetailsResponse)


@responses.activate
def test_models_api_projects_models_missing_report_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/models/{modelId}/missingReport/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "missingValuesReport" : [ {
    "missingPercentage" : 0.6027456183070403,
    "feature" : "feature",
    "missingCount" : 0,
    "type" : "type",
    "tasks" : {
      "key" : {
        "name" : "name",
        "descriptions" : [ "descriptions", "descriptions" ]
      }
    }
  }, {
    "missingPercentage" : 0.6027456183070403,
    "feature" : "feature",
    "missingCount" : 0,
    "type" : "type",
    "tasks" : {
      "key" : {
        "name" : "name",
        "descriptions" : [ "descriptions", "descriptions" ]
      }
    }
  } ]
})
    )
    result = ModelsApi.projects_models_missing_report_list(project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, MissingReportRetrieve)


@responses.activate
def test_models_api_projects_models_multiclass_lift_chart_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/models/{modelId}/multiclassLiftChart/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "charts" : [ {
    "classBins" : [ {
      "bins" : [ {
        "actual" : 0.8008281904610115,
        "binWeight" : 6.027456183070403,
        "predicted" : 1.4658129805029452
      }, {
        "actual" : 0.8008281904610115,
        "binWeight" : 6.027456183070403,
        "predicted" : 1.4658129805029452
      } ],
      "targetClass" : "targetClass"
    }, {
      "bins" : [ {
        "actual" : 0.8008281904610115,
        "binWeight" : 6.027456183070403,
        "predicted" : 1.4658129805029452
      }, {
        "actual" : 0.8008281904610115,
        "binWeight" : 6.027456183070403,
        "predicted" : 1.4658129805029452
      } ],
      "targetClass" : "targetClass"
    } ],
    "source" : "validation"
  }, {
    "classBins" : [ {
      "bins" : [ {
        "actual" : 0.8008281904610115,
        "binWeight" : 6.027456183070403,
        "predicted" : 1.4658129805029452
      }, {
        "actual" : 0.8008281904610115,
        "binWeight" : 6.027456183070403,
        "predicted" : 1.4658129805029452
      } ],
      "targetClass" : "targetClass"
    }, {
      "bins" : [ {
        "actual" : 0.8008281904610115,
        "binWeight" : 6.027456183070403,
        "predicted" : 1.4658129805029452
      }, {
        "actual" : 0.8008281904610115,
        "binWeight" : 6.027456183070403,
        "predicted" : 1.4658129805029452
      } ],
      "targetClass" : "targetClass"
    } ],
    "source" : "validation"
  } ]
})
    )
    result = ModelsApi.projects_models_multiclass_lift_chart_list(project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, AllMulticlassModelLiftChartsResponse)


@responses.activate
def test_models_api_projects_models_multiclass_lift_chart_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/models/{modelId}/multiclassLiftChart/{source}/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", source="validation", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "classBins" : [ {
    "bins" : [ {
      "actual" : 0.8008281904610115,
      "binWeight" : 6.027456183070403,
      "predicted" : 1.4658129805029452
    }, {
      "actual" : 0.8008281904610115,
      "binWeight" : 6.027456183070403,
      "predicted" : 1.4658129805029452
    } ],
    "targetClass" : "targetClass"
  }, {
    "bins" : [ {
      "actual" : 0.8008281904610115,
      "binWeight" : 6.027456183070403,
      "predicted" : 1.4658129805029452
    }, {
      "actual" : 0.8008281904610115,
      "binWeight" : 6.027456183070403,
      "predicted" : 1.4658129805029452
    } ],
    "targetClass" : "targetClass"
  } ],
  "source" : "validation"
})
    )
    result = ModelsApi.projects_models_multiclass_lift_chart_retrieve(project_id="projectId_example", model_id="modelId_example", source="validation", )
    assert isinstance(result, MulticlassModelLiftChartResponse)


@responses.activate
def test_models_api_projects_models_num_iterations_trained_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/models/{modelId}/numIterationsTrained/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "data" : [ {
    "numIterations" : 0,
    "stage" : "stage"
  }, {
    "numIterations" : 0,
    "stage" : "stage"
  } ],
  "modelId" : "modelId",
  "projectId" : "projectId"
})
    )
    result = ModelsApi.projects_models_num_iterations_trained_list(project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, NumIterationsTrainedResponse)


@responses.activate
def test_models_api_projects_models_parameters_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/models/{modelId}/parameters/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "derivedFeatures" : [ {
    "originalFeature" : "originalFeature",
    "stageCoefficients" : [ {
      "stage" : "stage",
      "coefficient" : 6.027456183070403
    }, {
      "stage" : "stage",
      "coefficient" : 6.027456183070403
    } ],
    "transformations" : [ {
      "name" : "name",
      "value" : "value"
    }, {
      "name" : "name",
      "value" : "value"
    } ],
    "coefficient" : 0.8008281904610115,
    "type" : "type",
    "derivedFeature" : "derivedFeature"
  }, {
    "originalFeature" : "originalFeature",
    "stageCoefficients" : [ {
      "stage" : "stage",
      "coefficient" : 6.027456183070403
    }, {
      "stage" : "stage",
      "coefficient" : 6.027456183070403
    } ],
    "transformations" : [ {
      "name" : "name",
      "value" : "value"
    }, {
      "name" : "name",
      "value" : "value"
    } ],
    "coefficient" : 0.8008281904610115,
    "type" : "type",
    "derivedFeature" : "derivedFeature"
  } ],
  "parameters" : [ {
    "name" : "name",
    "value" : "value"
  }, {
    "name" : "name",
    "value" : "value"
  } ]
})
    )
    result = ModelsApi.projects_models_parameters_list(project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, ModelParametersRetrieveResponse)


@responses.activate
def test_models_api_projects_models_patch(unittest_endpoint):
    responses.add(
        responses.PATCH,
        '{endpoint}/api/v2/projects/{projectId}/models/{modelId}/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=204,
        content_type='',
    )
    result = ModelsApi.projects_models_patch(project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_models_api_projects_models_prediction_intervals_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/api/v2/projects/{projectId}/models/{modelId}/predictionIntervals/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=202,
        content_type='application/json',
        body=json.dumps({
  "message" : "message"
})
    )
    result = ModelsApi.projects_models_prediction_intervals_create(project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, PredictionIntervalsCreateResponse)


@responses.activate
def test_models_api_projects_models_prediction_intervals_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/models/{modelId}/predictionIntervals/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ 60, 60 ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0,
  "totalCount" : 1
})
    )
    result = ModelsApi.projects_models_prediction_intervals_list(project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, PredictionIntervalsListResponse)


@responses.activate
def test_models_api_projects_models_residuals_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/models/{modelId}/residuals/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "residuals" : {
    "crossValidation" : {
      "histogram" : [ {
        "occurrences" : 5,
        "intervalEnd" : 1.4658129805029452,
        "intervalStart" : 5.962133916683182
      }, {
        "occurrences" : 5,
        "intervalEnd" : 1.4658129805029452,
        "intervalStart" : 5.962133916683182
      } ],
      "data" : [ [ 6.027456183070403, 6.027456183070403, 6.027456183070403, 6.027456183070403 ], [ 6.027456183070403, 6.027456183070403, 6.027456183070403, 6.027456183070403 ] ],
      "residualMean" : 2.3021358869347655,
      "coefficientOfDetermination" : 0.8008281904610115,
      "standardDeviation" : 7.061401241503109
    },
    "holdout" : {
      "histogram" : [ {
        "occurrences" : 5,
        "intervalEnd" : 1.4658129805029452,
        "intervalStart" : 5.962133916683182
      }, {
        "occurrences" : 5,
        "intervalEnd" : 1.4658129805029452,
        "intervalStart" : 5.962133916683182
      } ],
      "data" : [ [ 6.027456183070403, 6.027456183070403, 6.027456183070403, 6.027456183070403 ], [ 6.027456183070403, 6.027456183070403, 6.027456183070403, 6.027456183070403 ] ],
      "residualMean" : 2.3021358869347655,
      "coefficientOfDetermination" : 0.8008281904610115,
      "standardDeviation" : 7.061401241503109
    },
    "validation" : {
      "histogram" : [ {
        "occurrences" : 5,
        "intervalEnd" : 1.4658129805029452,
        "intervalStart" : 5.962133916683182
      }, {
        "occurrences" : 5,
        "intervalEnd" : 1.4658129805029452,
        "intervalStart" : 5.962133916683182
      } ],
      "data" : [ [ 6.027456183070403, 6.027456183070403, 6.027456183070403, 6.027456183070403 ], [ 6.027456183070403, 6.027456183070403, 6.027456183070403, 6.027456183070403 ] ],
      "residualMean" : 2.3021358869347655,
      "coefficientOfDetermination" : 0.8008281904610115,
      "standardDeviation" : 7.061401241503109
    }
  }
})
    )
    result = ModelsApi.projects_models_residuals_list(project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, ModelResidualsList)


@responses.activate
def test_models_api_projects_models_residuals_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/models/{modelId}/residuals/{source}/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", source="validation", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "residuals" : {
    "crossValidation" : {
      "histogram" : [ {
        "occurrences" : 5,
        "intervalEnd" : 1.4658129805029452,
        "intervalStart" : 5.962133916683182
      }, {
        "occurrences" : 5,
        "intervalEnd" : 1.4658129805029452,
        "intervalStart" : 5.962133916683182
      } ],
      "data" : [ [ 6.027456183070403, 6.027456183070403, 6.027456183070403, 6.027456183070403 ], [ 6.027456183070403, 6.027456183070403, 6.027456183070403, 6.027456183070403 ] ],
      "residualMean" : 2.3021358869347655,
      "coefficientOfDetermination" : 0.8008281904610115,
      "standardDeviation" : 7.061401241503109
    },
    "holdout" : {
      "histogram" : [ {
        "occurrences" : 5,
        "intervalEnd" : 1.4658129805029452,
        "intervalStart" : 5.962133916683182
      }, {
        "occurrences" : 5,
        "intervalEnd" : 1.4658129805029452,
        "intervalStart" : 5.962133916683182
      } ],
      "data" : [ [ 6.027456183070403, 6.027456183070403, 6.027456183070403, 6.027456183070403 ], [ 6.027456183070403, 6.027456183070403, 6.027456183070403, 6.027456183070403 ] ],
      "residualMean" : 2.3021358869347655,
      "coefficientOfDetermination" : 0.8008281904610115,
      "standardDeviation" : 7.061401241503109
    },
    "validation" : {
      "histogram" : [ {
        "occurrences" : 5,
        "intervalEnd" : 1.4658129805029452,
        "intervalStart" : 5.962133916683182
      }, {
        "occurrences" : 5,
        "intervalEnd" : 1.4658129805029452,
        "intervalStart" : 5.962133916683182
      } ],
      "data" : [ [ 6.027456183070403, 6.027456183070403, 6.027456183070403, 6.027456183070403 ], [ 6.027456183070403, 6.027456183070403, 6.027456183070403, 6.027456183070403 ] ],
      "residualMean" : 2.3021358869347655,
      "coefficientOfDetermination" : 0.8008281904610115,
      "standardDeviation" : 7.061401241503109
    }
  }
})
    )
    result = ModelsApi.projects_models_residuals_retrieve(project_id="projectId_example", model_id="modelId_example", source="validation", )
    assert isinstance(result, ModelResidualsList)


@responses.activate
def test_models_api_projects_models_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/models/{modelId}/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "samplePct" : 6.027456183070403,
  "featurelistName" : "featurelistName",
  "modelFamily" : "modelFamily",
  "predictionThreshold" : 0.8008281904610115,
  "trainingEndDate" : "2000-01-23T04:56:07.000+00:00",
  "id" : "id",
  "isFrozen" : True,
  "modelCategory" : "model",
  "monotonicDecreasingFeaturelistId" : "monotonicDecreasingFeaturelistId",
  "supportsComposableMl" : True,
  "processes" : [ "processes", "processes" ],
  "linkFunction" : "linkFunction",
  "trainingDuration" : "trainingDuration",
  "parentModelId" : "parentModelId",
  "predictionThresholdReadOnly" : True,
  "isStarred" : True,
  "featurelistId" : "featurelistId",
  "modelType" : "modelType",
  "blueprintId" : "blueprintId",
  "supportsMonotonicConstraints" : True,
  "monotonicIncreasingFeaturelistId" : "monotonicIncreasingFeaturelistId",
  "trainingStartDate" : "2000-01-23T04:56:07.000+00:00",
  "trainingRowCount" : 1,
  "metrics" : "\n        {\n            \"metrics\": {\n                \"RMSE\": {\n                    \"holdout\": 5000,\n                    \"validation\": 5100,\n                    \"backtesting\": null,\n                    \"backtestingScores\": null,\n                    \"crossValidation\": 6000,\n                    \"training\": null\n                },\n                \"FVE Poisson\": {\n                    \"holdout\": null,\n                    \"validation\": 0.56269,\n                    \"crossValidation\": 0.50166,\n                    \"backtesting\": null,\n                    \"backtestingScores\": null,\n                    \"training\": null\n                },\n            }\n        }\n",
  "projectId" : "projectId"
})
    )
    result = ModelsApi.projects_models_retrieve(project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, ModelDetailsResponse)


@responses.activate
def test_models_api_projects_models_roc_curve_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/models/{modelId}/rocCurve/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "charts" : [ {
    "positiveClassPredictions" : [ 5.962133916683182, 5.962133916683182 ],
    "source" : "backtest_19",
    "kolmogorovSmirnovMetric" : 6.027456183070403,
    "auc" : 0.8008281904610115,
    "negativeClassPredictions" : [ 1.4658129805029452, 1.4658129805029452 ],
    "rocPoints" : [ {
      "FalsePositiveRate" : 7.061401241503109,
      "liftNegative" : 4.145608029883936,
      "TruePositiveRate" : 4.965218492984954,
      "accuracy" : 5.962133916683182,
      "TrueNegativeScore" : 1,
      "threshold" : 6.84685269835264,
      "TruePositiveScore" : 5,
      "negativePredictiveValue" : 1.0246457001441578,
      "fractionPredictedAsNegative" : 3.616076749251911,
      "positivePredictiveValue" : 1.4894159098541704,
      "FalseNegativeScore" : 2,
      "FalsePositiveScore" : 9,
      "liftPositive" : 7.386281948385884,
      "matthewsCorrelationCoefficient" : 1.2315135367772556,
      "TrueNegativeRate" : 7.457744773683766,
      "f1Score" : 5.637376656633329,
      "fractionPredictedAsPositive" : 2.027123023002322
    }, {
      "FalsePositiveRate" : 7.061401241503109,
      "liftNegative" : 4.145608029883936,
      "TruePositiveRate" : 4.965218492984954,
      "accuracy" : 5.962133916683182,
      "TrueNegativeScore" : 1,
      "threshold" : 6.84685269835264,
      "TruePositiveScore" : 5,
      "negativePredictiveValue" : 1.0246457001441578,
      "fractionPredictedAsNegative" : 3.616076749251911,
      "positivePredictiveValue" : 1.4894159098541704,
      "FalseNegativeScore" : 2,
      "FalsePositiveScore" : 9,
      "liftPositive" : 7.386281948385884,
      "matthewsCorrelationCoefficient" : 1.2315135367772556,
      "TrueNegativeRate" : 7.457744773683766,
      "f1Score" : 5.637376656633329,
      "fractionPredictedAsPositive" : 2.027123023002322
    } ]
  }, {
    "positiveClassPredictions" : [ 5.962133916683182, 5.962133916683182 ],
    "source" : "backtest_19",
    "kolmogorovSmirnovMetric" : 6.027456183070403,
    "auc" : 0.8008281904610115,
    "negativeClassPredictions" : [ 1.4658129805029452, 1.4658129805029452 ],
    "rocPoints" : [ {
      "FalsePositiveRate" : 7.061401241503109,
      "liftNegative" : 4.145608029883936,
      "TruePositiveRate" : 4.965218492984954,
      "accuracy" : 5.962133916683182,
      "TrueNegativeScore" : 1,
      "threshold" : 6.84685269835264,
      "TruePositiveScore" : 5,
      "negativePredictiveValue" : 1.0246457001441578,
      "fractionPredictedAsNegative" : 3.616076749251911,
      "positivePredictiveValue" : 1.4894159098541704,
      "FalseNegativeScore" : 2,
      "FalsePositiveScore" : 9,
      "liftPositive" : 7.386281948385884,
      "matthewsCorrelationCoefficient" : 1.2315135367772556,
      "TrueNegativeRate" : 7.457744773683766,
      "f1Score" : 5.637376656633329,
      "fractionPredictedAsPositive" : 2.027123023002322
    }, {
      "FalsePositiveRate" : 7.061401241503109,
      "liftNegative" : 4.145608029883936,
      "TruePositiveRate" : 4.965218492984954,
      "accuracy" : 5.962133916683182,
      "TrueNegativeScore" : 1,
      "threshold" : 6.84685269835264,
      "TruePositiveScore" : 5,
      "negativePredictiveValue" : 1.0246457001441578,
      "fractionPredictedAsNegative" : 3.616076749251911,
      "positivePredictiveValue" : 1.4894159098541704,
      "FalseNegativeScore" : 2,
      "FalsePositiveScore" : 9,
      "liftPositive" : 7.386281948385884,
      "matthewsCorrelationCoefficient" : 1.2315135367772556,
      "TrueNegativeRate" : 7.457744773683766,
      "f1Score" : 5.637376656633329,
      "fractionPredictedAsPositive" : 2.027123023002322
    } ]
  } ]
})
    )
    result = ModelsApi.projects_models_roc_curve_list(project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, ModelRocCurveListResponse)


@responses.activate
def test_models_api_projects_models_roc_curve_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/models/{modelId}/rocCurve/{source}/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", source="backtest_19", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "positiveClassPredictions" : [ 5.962133916683182, 5.962133916683182 ],
  "source" : "backtest_19",
  "kolmogorovSmirnovMetric" : 6.027456183070403,
  "auc" : 0.8008281904610115,
  "negativeClassPredictions" : [ 1.4658129805029452, 1.4658129805029452 ],
  "rocPoints" : [ {
    "FalsePositiveRate" : 7.061401241503109,
    "liftNegative" : 4.145608029883936,
    "TruePositiveRate" : 4.965218492984954,
    "accuracy" : 5.962133916683182,
    "TrueNegativeScore" : 1,
    "threshold" : 6.84685269835264,
    "TruePositiveScore" : 5,
    "negativePredictiveValue" : 1.0246457001441578,
    "fractionPredictedAsNegative" : 3.616076749251911,
    "positivePredictiveValue" : 1.4894159098541704,
    "FalseNegativeScore" : 2,
    "FalsePositiveScore" : 9,
    "liftPositive" : 7.386281948385884,
    "matthewsCorrelationCoefficient" : 1.2315135367772556,
    "TrueNegativeRate" : 7.457744773683766,
    "f1Score" : 5.637376656633329,
    "fractionPredictedAsPositive" : 2.027123023002322
  }, {
    "FalsePositiveRate" : 7.061401241503109,
    "liftNegative" : 4.145608029883936,
    "TruePositiveRate" : 4.965218492984954,
    "accuracy" : 5.962133916683182,
    "TrueNegativeScore" : 1,
    "threshold" : 6.84685269835264,
    "TruePositiveScore" : 5,
    "negativePredictiveValue" : 1.0246457001441578,
    "fractionPredictedAsNegative" : 3.616076749251911,
    "positivePredictiveValue" : 1.4894159098541704,
    "FalseNegativeScore" : 2,
    "FalsePositiveScore" : 9,
    "liftPositive" : 7.386281948385884,
    "matthewsCorrelationCoefficient" : 1.2315135367772556,
    "TrueNegativeRate" : 7.457744773683766,
    "f1Score" : 5.637376656633329,
    "fractionPredictedAsPositive" : 2.027123023002322
  } ]
})
    )
    result = ModelsApi.projects_models_roc_curve_retrieve(project_id="projectId_example", model_id="modelId_example", source="backtest_19", )
    assert isinstance(result, ModelRocCurveResponse)


@responses.activate
def test_models_api_projects_models_scoring_code_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/models/{modelId}/scoringCode/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=200,
        content_type='',
    )
    result = ModelsApi.projects_models_scoring_code_list(project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_models_api_projects_models_supported_capabilities_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/models/{modelId}/supportedCapabilities/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "reasons" : {
    "supportsImageEmbedding" : "supportsImageEmbedding",
    "supportsImageActivationMaps" : "supportsImageActivationMaps"
  },
  "supportsBlending" : True,
  "supportsModelTrainingMetrics" : True,
  "supportsEarlyStopping" : True,
  "supportsMonotonicConstraints" : True,
  "supportsNNVisualizations" : True,
  "supportsCodeGeneration" : True,
  "eligibleForPrime" : True,
  "hasWordCloud" : True,
  "supportsShap" : True,
  "hasParameters" : True,
  "supportsModelPackageExport" : True,
  "supportsImageEmbedding" : True,
  "supportsImageActivationMaps" : True
})
    )
    result = ModelsApi.projects_models_supported_capabilities_list(project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, ModelCapabilitiesRetrieveResponse)


@responses.activate
def test_models_api_projects_models_word_cloud_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/models/{modelId}/wordCloud/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", modelId="modelId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "ngrams" : [ {
    "coefficient" : -0.8398343619077977,
    "count" : 6,
    "variable" : "variable",
    "isStopword" : True,
    "ngram" : "ngram",
    "class" : "class",
    "frequency" : 0.14658129805029452
  }, {
    "coefficient" : -0.8398343619077977,
    "count" : 6,
    "variable" : "variable",
    "isStopword" : True,
    "ngram" : "ngram",
    "class" : "class",
    "frequency" : 0.14658129805029452
  } ]
})
    )
    result = ModelsApi.projects_models_word_cloud_list(project_id="projectId_example", model_id="modelId_example", )
    assert isinstance(result, WordCloudRetrieveResponse)


@responses.activate
def test_models_api_projects_recommended_models_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/recommendedModels/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "modelId" : "modelId",
  "recommendationType" : "MOSTACCURATE"
})
    )
    result = ModelsApi.projects_recommended_models_list(project_id="projectId_example", )
    assert isinstance(result, RecommendedModelResponse)


@responses.activate
def test_models_api_projects_recommended_models_recommended_model_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/recommendedModels/recommendedModel/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "modelId" : "modelId",
  "recommendationType" : "MOSTACCURATE"
})
    )
    result = ModelsApi.projects_recommended_models_recommended_model_list(project_id="projectId_example", )
    assert isinstance(result, RecommendedModelResponse)


@responses.activate
def test_models_api_projects_shap_matrices_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/api/v2/projects/{projectId}/shapMatrices/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", ),
        status=202,
        content_type='',
    )
    result = ModelsApi.projects_shap_matrices_create(project_id="projectId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_models_api_projects_shap_matrices_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/shapMatrices/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "metadata" : {
      "mismatchRowCount" : 1,
      "maxNormalizedMismatch" : 6.027456183070403
    },
    "modelId" : "modelId",
    "datasetId" : "datasetId",
    "id" : "id",
    "projectId" : "projectId",
    "url" : "https://openapi-generator.tech"
  }, {
    "metadata" : {
      "mismatchRowCount" : 1,
      "maxNormalizedMismatch" : 6.027456183070403
    },
    "modelId" : "modelId",
    "datasetId" : "datasetId",
    "id" : "id",
    "projectId" : "projectId",
    "url" : "https://openapi-generator.tech"
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0
})
    )
    result = ModelsApi.projects_shap_matrices_list(project_id="projectId_example", )
    assert isinstance(result, ShapMatrixListResponse)


@responses.activate
def test_models_api_projects_shap_matrices_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/shapMatrices/{shapMatrixId}/'.format(endpoint=unittest_endpoint,
        projectId="projectId_example", shapMatrixId="shapMatrixId_example", ),
        status=200,
        content_type='application/jsontext/csv',
        body=json.dumps({
  "columnNames" : [ "columnNames", "columnNames" ]
})
    )
    result = ModelsApi.projects_shap_matrices_retrieve(project_id="projectId_example", shap_matrix_id="shapMatrixId_example", )
    assert isinstance(result, ShapMatrixRetrieveResponse)
