#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import json
import responses
from six.moves.urllib.parse import urljoin
from dateutil import parser
from datarobot.models.testing.generated.model.organization_job_list_response import OrganizationJobListResponse
from datarobot.models.testing.generated.model.organization_list_response import OrganizationListResponse
from datarobot.models.testing.generated.model.organization_retrieve import OrganizationRetrieve
from datarobot.utils import from_api
from datarobot.models.testing.generated.model import *

from datarobot.models.testing.generated.api.organizations_api import OrganizationsApi




@responses.activate
def test_organizations_api_organizations_jobs_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/organizations/{organizationId}/jobs/'.format(endpoint=unittest_endpoint,
        offset=0, limit=0, organizationId="organizationId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "jobId" : "jobId",
    "projectOwnerUserId" : "projectOwnerUserId",
    "projectOwnerUsername" : "projectOwnerUsername",
    "projectId" : "projectId",
    "userId" : "userId",
    "username" : "username"
  }, {
    "jobId" : "jobId",
    "projectOwnerUserId" : "projectOwnerUserId",
    "projectOwnerUsername" : "projectOwnerUsername",
    "projectId" : "projectId",
    "userId" : "userId",
    "username" : "username"
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0
})
    )
    result = OrganizationsApi.organizations_jobs_list(offset=0, limit=0, organization_id="organizationId_example", )
    assert isinstance(result, OrganizationJobListResponse)


@responses.activate
def test_organizations_api_organizations_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/organizations/'.format(endpoint=unittest_endpoint,
        limit=100, ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "defaultUserMaxGpuWorkers" : 5,
    "defaultUserMaxWorkers" : 5,
    "maxUploadSize" : 6,
    "agreementStatus" : "NEEDED",
    "maxGpuWorkers" : 1,
    "restrictedSharing" : True,
    "snapshotLimit" : 6,
    "maxWorkers" : 1,
    "ormVersion" : "v1",
    "desiredCustomModelContainerSize" : 2147483647,
    "enableSso" : True,
    "maxPipelineModuleRuntimes" : 1,
    "inactiveUsersCount" : 9,
    "id" : "id",
    "maximumActiveUsers" : 4,
    "prepaidDeploymentLimit" : 9,
    "maxCustomModelContainerSize" : 2147483647,
    "membersCount" : 5,
    "mlopsEventStorageRetentionDays" : 0,
    "maxCustomModelReplicasPerDeployment" : 1,
    "maxEdaWorkers" : 1,
    "groupsCount" : 7,
    "supportEmail" : "supportEmail",
    "maxDeploymentLimit" : 7,
    "maxUploadSizeCatalog" : 7,
    "datasetRefreshJobUserLimit" : 1,
    "name" : "name",
    "maxCustomModelReplicasPerDeploymentForBatchPredictions" : 3,
    "datasetRefreshJobLimit" : 6,
    "accountPermissions" : {
      "key" : True
    }
  }, {
    "defaultUserMaxGpuWorkers" : 5,
    "defaultUserMaxWorkers" : 5,
    "maxUploadSize" : 6,
    "agreementStatus" : "NEEDED",
    "maxGpuWorkers" : 1,
    "restrictedSharing" : True,
    "snapshotLimit" : 6,
    "maxWorkers" : 1,
    "ormVersion" : "v1",
    "desiredCustomModelContainerSize" : 2147483647,
    "enableSso" : True,
    "maxPipelineModuleRuntimes" : 1,
    "inactiveUsersCount" : 9,
    "id" : "id",
    "maximumActiveUsers" : 4,
    "prepaidDeploymentLimit" : 9,
    "maxCustomModelContainerSize" : 2147483647,
    "membersCount" : 5,
    "mlopsEventStorageRetentionDays" : 0,
    "maxCustomModelReplicasPerDeployment" : 1,
    "maxEdaWorkers" : 1,
    "groupsCount" : 7,
    "supportEmail" : "supportEmail",
    "maxDeploymentLimit" : 7,
    "maxUploadSizeCatalog" : 7,
    "datasetRefreshJobUserLimit" : 1,
    "name" : "name",
    "maxCustomModelReplicasPerDeploymentForBatchPredictions" : 3,
    "datasetRefreshJobLimit" : 6,
    "accountPermissions" : {
      "key" : True
    }
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0
})
    )
    result = OrganizationsApi.organizations_list(limit=100, )
    assert isinstance(result, OrganizationListResponse)


@responses.activate
def test_organizations_api_organizations_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/organizations/{organizationId}/'.format(endpoint=unittest_endpoint,
        organizationId="organizationId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "defaultUserMaxGpuWorkers" : 5,
  "defaultUserMaxWorkers" : 5,
  "maxUploadSize" : 6,
  "agreementStatus" : "NEEDED",
  "maxGpuWorkers" : 1,
  "restrictedSharing" : True,
  "snapshotLimit" : 6,
  "maxWorkers" : 1,
  "ormVersion" : "v1",
  "desiredCustomModelContainerSize" : 2147483647,
  "enableSso" : True,
  "maxPipelineModuleRuntimes" : 1,
  "inactiveUsersCount" : 9,
  "id" : "id",
  "maximumActiveUsers" : 4,
  "prepaidDeploymentLimit" : 9,
  "maxCustomModelContainerSize" : 2147483647,
  "membersCount" : 5,
  "mlopsEventStorageRetentionDays" : 0,
  "maxCustomModelReplicasPerDeployment" : 1,
  "maxEdaWorkers" : 1,
  "groupsCount" : 7,
  "supportEmail" : "supportEmail",
  "maxDeploymentLimit" : 7,
  "maxUploadSizeCatalog" : 7,
  "datasetRefreshJobUserLimit" : 1,
  "name" : "name",
  "maxCustomModelReplicasPerDeploymentForBatchPredictions" : 3,
  "datasetRefreshJobLimit" : 6,
  "accountPermissions" : {
    "key" : True
  }
})
    )
    result = OrganizationsApi.organizations_retrieve(organization_id="organizationId_example", )
    assert isinstance(result, OrganizationRetrieve)
