#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import json
import responses
from six.moves.urllib.parse import urljoin
from dateutil import parser
from datarobot.models.testing.generated.model.retrieve_list_prediction_metadata_objects_response import RetrieveListPredictionMetadataObjectsResponse
from datarobot.models.testing.generated.model.retrieve_prediction_metadata_object import RetrievePredictionMetadataObject
from datarobot.utils import from_api
from datarobot.models.testing.generated.model import *

from datarobot.models.testing.generated.api.predictions_metadata_api import PredictionsMetadataApi




@responses.activate
def test_predictions_metadata_api_projects_predictions_metadata_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/predictionsMetadata/'.format(endpoint=unittest_endpoint,
        offset=0, limit=1000, projectId="projectId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "modelId" : "modelId",
    "predictionsStartDate" : "2000-01-23T04:56:07.000+00:00",
    "predictionIntervalsSize" : 5,
    "url" : "url",
    "predictionDatasetId" : "predictionDatasetId",
    "predictionThreshold" : 5.637376656633329,
    "maxExplanations" : 1,
    "predictionsEndDate" : "2000-01-23T04:56:07.000+00:00",
    "includesPredictionIntervals" : True,
    "actualValueColumn" : "actualValueColumn",
    "explanationAlgorithm" : "explanationAlgorithm",
    "featureDerivationWindowCounts" : 6,
    "datasetId" : "datasetId",
    "forecastPoint" : "2000-01-23T04:56:07.000+00:00",
    "id" : "id",
    "projectId" : "projectId",
    "shapWarnings" : {
      "mismatchRowCount" : 7,
      "maxNormalizedMismatch" : 2.3021358869347655
    }
  }, {
    "modelId" : "modelId",
    "predictionsStartDate" : "2000-01-23T04:56:07.000+00:00",
    "predictionIntervalsSize" : 5,
    "url" : "url",
    "predictionDatasetId" : "predictionDatasetId",
    "predictionThreshold" : 5.637376656633329,
    "maxExplanations" : 1,
    "predictionsEndDate" : "2000-01-23T04:56:07.000+00:00",
    "includesPredictionIntervals" : True,
    "actualValueColumn" : "actualValueColumn",
    "explanationAlgorithm" : "explanationAlgorithm",
    "featureDerivationWindowCounts" : 6,
    "datasetId" : "datasetId",
    "forecastPoint" : "2000-01-23T04:56:07.000+00:00",
    "id" : "id",
    "projectId" : "projectId",
    "shapWarnings" : {
      "mismatchRowCount" : 7,
      "maxNormalizedMismatch" : 2.3021358869347655
    }
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0
})
    )
    result = PredictionsMetadataApi.projects_predictions_metadata_list(offset=0, limit=1000, project_id="projectId_example", )
    assert isinstance(result, RetrieveListPredictionMetadataObjectsResponse)


@responses.activate
def test_predictions_metadata_api_projects_predictions_metadata_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/projects/{projectId}/predictionsMetadata/{predictionId}/'.format(endpoint=unittest_endpoint,
        predictionId="predictionId_example", projectId="projectId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "modelId" : "modelId",
  "predictionsStartDate" : "2000-01-23T04:56:07.000+00:00",
  "predictionIntervalsSize" : 5,
  "url" : "url",
  "predictionDatasetId" : "predictionDatasetId",
  "predictionThreshold" : 5.637376656633329,
  "maxExplanations" : 1,
  "predictionsEndDate" : "2000-01-23T04:56:07.000+00:00",
  "includesPredictionIntervals" : True,
  "actualValueColumn" : "actualValueColumn",
  "explanationAlgorithm" : "explanationAlgorithm",
  "featureDerivationWindowCounts" : 6,
  "datasetId" : "datasetId",
  "forecastPoint" : "2000-01-23T04:56:07.000+00:00",
  "id" : "id",
  "projectId" : "projectId",
  "shapWarnings" : {
    "mismatchRowCount" : 7,
    "maxNormalizedMismatch" : 2.3021358869347655
  }
})
    )
    result = PredictionsMetadataApi.projects_predictions_metadata_retrieve(prediction_id="predictionId_example", project_id="projectId_example", )
    assert isinstance(result, RetrievePredictionMetadataObject)
