#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import json
import responses
from six.moves.urllib.parse import urljoin
from dateutil import parser
from datarobot.models.testing.generated.model.create_use_case_attachment import CreateUseCaseAttachment
from datarobot.models.testing.generated.model.use_case import UseCase
from datarobot.models.testing.generated.model.use_case_activity_list_response import UseCaseActivityListResponse
from datarobot.models.testing.generated.model.use_case_attachment import UseCaseAttachment
from datarobot.models.testing.generated.model.use_case_attachment_list_response import UseCaseAttachmentListResponse
from datarobot.models.testing.generated.model.use_case_attachment_response import UseCaseAttachmentResponse
from datarobot.models.testing.generated.model.use_case_create_response import UseCaseCreateResponse
from datarobot.models.testing.generated.model.use_case_list_response import UseCaseListResponse
from datarobot.models.testing.generated.model.use_case_realized_values_over_time_response import UseCaseRealizedValuesOverTimeResponse
from datarobot.models.testing.generated.model.use_case_response import UseCaseResponse
from datarobot.models.testing.generated.model.use_case_sharing_list_response import UseCaseSharingListResponse
from datarobot.models.testing.generated.model.use_case_sharing_update import UseCaseSharingUpdate
from datarobot.models.testing.generated.model.use_case_update import UseCaseUpdate
from datarobot.models.testing.generated.model.use_case_value_template_calculate_response import UseCaseValueTemplateCalculateResponse
from datarobot.models.testing.generated.model.use_case_value_template_response import UseCaseValueTemplateResponse
from datarobot.utils import from_api
from datarobot.models.testing.generated.model import *

from datarobot.models.testing.generated.api.use_case_api import UseCaseApi




@responses.activate
def test_use_case_api_use_case_value_templates_calculation_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/useCaseValueTemplates/{templateType}/calculation/'.format(endpoint=unittest_endpoint,
        accuracyImprovement=3.14, decisionsCount=1, templateType="classification", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "template" : {
    "templateType" : "classification",
    "data" : ""
  },
  "savedAnnually" : 6.027456183070403,
  "averageValuePerDecision" : 0.8008281904610115
})
    )
    result = UseCaseApi.use_case_value_templates_calculation_list(accuracy_improvement=3.14, decisions_count=1, template_type="classification", )
    assert isinstance(result, UseCaseValueTemplateCalculateResponse)


@responses.activate
def test_use_case_api_use_case_value_templates_list(unittest_endpoint):
    responses.add(
        responses.GET,
       '{endpoint}/api/v2/useCaseValueTemplates/'.format(endpoint=unittest_endpoint),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "schema" : [ {
    "schema" : {
      "unit" : "unit",
      "maximum" : 0,
      "label" : "label",
      "placeholder" : "placeholder",
      "elementType" : "integer",
      "minimum" : 6
    },
    "parameterName" : "parameterName"
  }, {
    "schema" : {
      "unit" : "unit",
      "maximum" : 0,
      "label" : "label",
      "placeholder" : "placeholder",
      "elementType" : "integer",
      "minimum" : 6
    },
    "parameterName" : "parameterName"
  } ],
  "templateType" : "classification",
  "description" : "description",
  "title" : "title"
})
    )
    result = UseCaseApi.use_case_value_templates_list()
    assert isinstance(result, UseCaseValueTemplateResponse)


@responses.activate
def test_use_case_api_use_case_value_templates_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/useCaseValueTemplates/{templateType}/'.format(endpoint=unittest_endpoint,
        templateType="classification", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "schema" : [ {
    "schema" : {
      "unit" : "unit",
      "maximum" : 0,
      "label" : "label",
      "placeholder" : "placeholder",
      "elementType" : "integer",
      "minimum" : 6
    },
    "parameterName" : "parameterName"
  }, {
    "schema" : {
      "unit" : "unit",
      "maximum" : 0,
      "label" : "label",
      "placeholder" : "placeholder",
      "elementType" : "integer",
      "minimum" : 6
    },
    "parameterName" : "parameterName"
  } ],
  "templateType" : "classification",
  "description" : "description",
  "title" : "title"
})
    )
    result = UseCaseApi.use_case_value_templates_retrieve(template_type="classification", )
    assert isinstance(result, UseCaseValueTemplateResponse)


@responses.activate
def test_use_case_api_use_cases_activities_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/useCases/{useCaseId}/activities/'.format(endpoint=unittest_endpoint,
        useCaseId="useCaseId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "firstName" : "firstName",
    "lastName" : "lastName",
    "eventDescription" : {
      "owner" : {
        "firstName" : "firstName",
        "lastName" : "lastName",
        "id" : "id",
        "username" : "username"
      },
      "notes" : "notes",
      "description" : "description",
      "businessImpact" : 3,
      "potentialValueTemplate" : "",
      "content" : "content",
      "targetDates" : [ {
        "date" : "2000-01-23T04:56:07.000+00:00",
        "stage" : "ideation"
      }, {
        "date" : "2000-01-23T04:56:07.000+00:00",
        "stage" : "ideation"
      } ],
      "feasibility" : 1,
      "predictionTargets" : [ "predictionTargets", "predictionTargets" ],
      "realizedValue" : "",
      "stage" : "ideation",
      "permissions" : [ "permissions", "permissions" ],
      "mentions" : [ {
        "firstName" : "firstName",
        "lastName" : "lastName",
        "id" : "id",
        "username" : "username"
      }, {
        "firstName" : "firstName",
        "lastName" : "lastName",
        "id" : "id",
        "username" : "username"
      } ],
      "name" : "name",
      "commentId" : "commentId",
      "id" : "id",
      "potentialValue" : {
        "currency" : "EUR",
        "details" : "details",
        "value" : 5.962133916683182
      }
    },
    "eventType" : "eventType",
    "id" : "id",
    "user" : {
      "firstName" : "firstName",
      "lastName" : "lastName",
      "id" : "id",
      "username" : "username"
    },
    "timestamp" : "2000-01-23T04:56:07.000+00:00",
    "username" : "username"
  }, {
    "firstName" : "firstName",
    "lastName" : "lastName",
    "eventDescription" : {
      "owner" : {
        "firstName" : "firstName",
        "lastName" : "lastName",
        "id" : "id",
        "username" : "username"
      },
      "notes" : "notes",
      "description" : "description",
      "businessImpact" : 3,
      "potentialValueTemplate" : "",
      "content" : "content",
      "targetDates" : [ {
        "date" : "2000-01-23T04:56:07.000+00:00",
        "stage" : "ideation"
      }, {
        "date" : "2000-01-23T04:56:07.000+00:00",
        "stage" : "ideation"
      } ],
      "feasibility" : 1,
      "predictionTargets" : [ "predictionTargets", "predictionTargets" ],
      "realizedValue" : "",
      "stage" : "ideation",
      "permissions" : [ "permissions", "permissions" ],
      "mentions" : [ {
        "firstName" : "firstName",
        "lastName" : "lastName",
        "id" : "id",
        "username" : "username"
      }, {
        "firstName" : "firstName",
        "lastName" : "lastName",
        "id" : "id",
        "username" : "username"
      } ],
      "name" : "name",
      "commentId" : "commentId",
      "id" : "id",
      "potentialValue" : {
        "currency" : "EUR",
        "details" : "details",
        "value" : 5.962133916683182
      }
    },
    "eventType" : "eventType",
    "id" : "id",
    "user" : {
      "firstName" : "firstName",
      "lastName" : "lastName",
      "id" : "id",
      "username" : "username"
    },
    "timestamp" : "2000-01-23T04:56:07.000+00:00",
    "username" : "username"
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0,
  "totalCount" : 5
})
    )
    result = UseCaseApi.use_cases_activities_list(use_case_id="useCaseId_example", )
    assert isinstance(result, UseCaseActivityListResponse)


@responses.activate
def test_use_case_api_use_cases_attachments_create(unittest_endpoint):
    responses.add(
        responses.POST,
        '{endpoint}/api/v2/useCases/{useCaseId}/attachments/'.format(endpoint=unittest_endpoint,
        useCaseId="useCaseId_example", ),
        status=201,
        content_type='application/json',
        body=json.dumps({
  "attachedObjectId" : "attachedObjectId",
  "type" : "dataset"
})
    )
    result = UseCaseApi.use_cases_attachments_create(use_case_id="useCaseId_example", )
    assert isinstance(result, UseCaseAttachment)


@responses.activate
def test_use_case_api_use_cases_attachments_delete(unittest_endpoint):
    responses.add(
        responses.DELETE,
        '{endpoint}/api/v2/useCases/{useCaseId}/attachments/{attachmentId}/'.format(endpoint=unittest_endpoint,
        useCaseId="useCaseId_example", attachmentId="attachmentId_example", ),
        status=204,
        content_type='',
    )
    result = UseCaseApi.use_cases_attachments_delete(use_case_id="useCaseId_example", attachment_id="attachmentId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_use_case_api_use_cases_attachments_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/useCases/{useCaseId}/attachments/'.format(endpoint=unittest_endpoint,
        useCaseId="useCaseId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "next",
  "data" : [ {
    "canView" : True,
    "overview" : "",
    "useCaseId" : "useCaseId",
    "isAccessRequested" : True,
    "attachedObjectId" : "attachedObjectId",
    "id" : "id",
    "type" : "dataset"
  }, {
    "canView" : True,
    "overview" : "",
    "useCaseId" : "useCaseId",
    "isAccessRequested" : True,
    "attachedObjectId" : "attachedObjectId",
    "id" : "id",
    "type" : "dataset"
  } ],
  "previous" : "previous",
  "count" : 0,
  "totalCount" : 6
})
    )
    result = UseCaseApi.use_cases_attachments_list(use_case_id="useCaseId_example", )
    assert isinstance(result, UseCaseAttachmentListResponse)


@responses.activate
def test_use_case_api_use_cases_attachments_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/useCases/{useCaseId}/attachments/{attachmentId}/'.format(endpoint=unittest_endpoint,
        useCaseId="useCaseId_example", attachmentId="attachmentId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "canView" : True,
  "overview" : "",
  "useCaseId" : "useCaseId",
  "isAccessRequested" : True,
  "attachedObjectId" : "attachedObjectId",
  "id" : "id",
  "type" : "dataset"
})
    )
    result = UseCaseApi.use_cases_attachments_retrieve(use_case_id="useCaseId_example", attachment_id="attachmentId_example", )
    assert isinstance(result, UseCaseAttachmentResponse)


@responses.activate
def test_use_case_api_use_cases_create(unittest_endpoint):
    responses.add(
        responses.POST,
       '{endpoint}/api/v2/useCases/'.format(endpoint=unittest_endpoint),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "modelHealth" : "",
  "owner" : {
    "firstName" : "firstName",
    "lastName" : "lastName",
    "id" : "id",
    "username" : "username"
  },
  "notes" : "notes",
  "accuracyHealth" : "",
  "predictionsCount" : "",
  "serviceHealth" : "",
  "description" : "description",
  "businessImpact" : 1,
  "potentialValueTemplate" : "",
  "content" : "content",
  "targetDates" : [ {
    "date" : "2000-01-23T04:56:07.000+00:00",
    "stage" : "ideation"
  }, {
    "date" : "2000-01-23T04:56:07.000+00:00",
    "stage" : "ideation"
  } ],
  "feasibility" : 3,
  "predictionTargets" : [ "predictionTargets", "predictionTargets" ],
  "realizedValue" : "",
  "stage" : "ideation",
  "permissions" : [ "permissions", "permissions" ],
  "mentions" : [ {
    "firstName" : "firstName",
    "lastName" : "lastName",
    "id" : "id",
    "username" : "username"
  }, {
    "firstName" : "firstName",
    "lastName" : "lastName",
    "id" : "id",
    "username" : "username"
  } ],
  "name" : "name",
  "commentId" : "commentId",
  "id" : "id",
  "inProductionWarning" : "inProductionWarning",
  "potentialValue" : {
    "currency" : "EUR",
    "details" : "details",
    "value" : 5.962133916683182
  }
})
    )
    result = UseCaseApi.use_cases_create()
    assert isinstance(result, UseCaseCreateResponse)


@responses.activate
def test_use_case_api_use_cases_delete(unittest_endpoint):
    responses.add(
        responses.DELETE,
        '{endpoint}/api/v2/useCases/{useCaseId}/'.format(endpoint=unittest_endpoint,
        useCaseId="useCaseId_example", ),
        status=200,
        content_type='',
    )
    result = UseCaseApi.use_cases_delete(use_case_id="useCaseId_example", )
    assert isinstance(result, type(None))


@responses.activate
def test_use_case_api_use_cases_list(unittest_endpoint):
    responses.add(
        responses.GET,
       '{endpoint}/api/v2/useCases/'.format(endpoint=unittest_endpoint),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "modelHealth" : "",
    "owner" : {
      "firstName" : "firstName",
      "lastName" : "lastName",
      "id" : "id",
      "username" : "username"
    },
    "notes" : "notes",
    "accuracyHealth" : "",
    "predictionsCount" : "",
    "serviceHealth" : "",
    "description" : "description",
    "businessImpact" : 3,
    "potentialValueTemplate" : "",
    "content" : "content",
    "targetDates" : [ {
      "date" : "2000-01-23T04:56:07.000+00:00",
      "stage" : "ideation"
    }, {
      "date" : "2000-01-23T04:56:07.000+00:00",
      "stage" : "ideation"
    } ],
    "feasibility" : 1,
    "predictionTargets" : [ "predictionTargets", "predictionTargets" ],
    "realizedValue" : "",
    "stage" : "ideation",
    "permissions" : [ "permissions", "permissions" ],
    "mentions" : [ {
      "firstName" : "firstName",
      "lastName" : "lastName",
      "id" : "id",
      "username" : "username"
    }, {
      "firstName" : "firstName",
      "lastName" : "lastName",
      "id" : "id",
      "username" : "username"
    } ],
    "name" : "name",
    "commentId" : "commentId",
    "id" : "id",
    "inProductionWarning" : "inProductionWarning",
    "potentialValue" : {
      "currency" : "EUR",
      "details" : "details",
      "value" : 5.962133916683182
    }
  }, {
    "modelHealth" : "",
    "owner" : {
      "firstName" : "firstName",
      "lastName" : "lastName",
      "id" : "id",
      "username" : "username"
    },
    "notes" : "notes",
    "accuracyHealth" : "",
    "predictionsCount" : "",
    "serviceHealth" : "",
    "description" : "description",
    "businessImpact" : 3,
    "potentialValueTemplate" : "",
    "content" : "content",
    "targetDates" : [ {
      "date" : "2000-01-23T04:56:07.000+00:00",
      "stage" : "ideation"
    }, {
      "date" : "2000-01-23T04:56:07.000+00:00",
      "stage" : "ideation"
    } ],
    "feasibility" : 1,
    "predictionTargets" : [ "predictionTargets", "predictionTargets" ],
    "realizedValue" : "",
    "stage" : "ideation",
    "permissions" : [ "permissions", "permissions" ],
    "mentions" : [ {
      "firstName" : "firstName",
      "lastName" : "lastName",
      "id" : "id",
      "username" : "username"
    }, {
      "firstName" : "firstName",
      "lastName" : "lastName",
      "id" : "id",
      "username" : "username"
    } ],
    "name" : "name",
    "commentId" : "commentId",
    "id" : "id",
    "inProductionWarning" : "inProductionWarning",
    "potentialValue" : {
      "currency" : "EUR",
      "details" : "details",
      "value" : 5.962133916683182
    }
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0,
  "totalCount" : 5
})
    )
    result = UseCaseApi.use_cases_list()
    assert isinstance(result, UseCaseListResponse)


@responses.activate
def test_use_case_api_use_cases_patch(unittest_endpoint):
    responses.add(
        responses.PATCH,
        '{endpoint}/api/v2/useCases/{useCaseId}/'.format(endpoint=unittest_endpoint,
        useCaseId="useCaseId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "modelHealth" : "",
  "owner" : {
    "firstName" : "firstName",
    "lastName" : "lastName",
    "id" : "id",
    "username" : "username"
  },
  "notes" : "notes",
  "accuracyHealth" : "",
  "predictionsCount" : "",
  "serviceHealth" : "",
  "description" : "description",
  "businessImpact" : 3,
  "potentialValueTemplate" : "",
  "content" : "content",
  "targetDates" : [ {
    "date" : "2000-01-23T04:56:07.000+00:00",
    "stage" : "ideation"
  }, {
    "date" : "2000-01-23T04:56:07.000+00:00",
    "stage" : "ideation"
  } ],
  "feasibility" : 1,
  "predictionTargets" : [ "predictionTargets", "predictionTargets" ],
  "realizedValue" : "",
  "stage" : "ideation",
  "permissions" : [ "permissions", "permissions" ],
  "mentions" : [ {
    "firstName" : "firstName",
    "lastName" : "lastName",
    "id" : "id",
    "username" : "username"
  }, {
    "firstName" : "firstName",
    "lastName" : "lastName",
    "id" : "id",
    "username" : "username"
  } ],
  "name" : "name",
  "commentId" : "commentId",
  "id" : "id",
  "inProductionWarning" : "inProductionWarning",
  "potentialValue" : {
    "currency" : "EUR",
    "details" : "details",
    "value" : 5.962133916683182
  }
})
    )
    result = UseCaseApi.use_cases_patch(use_case_id="useCaseId_example", )
    assert isinstance(result, UseCaseResponse)


@responses.activate
def test_use_case_api_use_cases_realized_value_over_time_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/useCases/{useCaseId}/realizedValueOverTime/'.format(endpoint=unittest_endpoint,
        useCaseId="useCaseId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "summary" : {
    "period" : {
      "start" : "2000-01-23T04:56:07.000+00:00",
      "end" : "2000-01-23T04:56:07.000+00:00"
    },
    "averageRealizedValue" : 5,
    "averagePredictionsCount" : 1,
    "totalRealizedValue" : 2,
    "totalPredictionsCount" : 5
  },
  "previousTimeRangeSummary" : {
    "period" : {
      "start" : "2000-01-23T04:56:07.000+00:00",
      "end" : "2000-01-23T04:56:07.000+00:00"
    },
    "averageRealizedValue" : 5,
    "averagePredictionsCount" : 1,
    "totalRealizedValue" : 2,
    "totalPredictionsCount" : 5
  },
  "buckets" : [ {
    "period" : {
      "start" : "2000-01-23T04:56:07.000+00:00",
      "end" : "2000-01-23T04:56:07.000+00:00"
    },
    "realizedValue" : 6,
    "predictionsCount" : 0
  }, {
    "period" : {
      "start" : "2000-01-23T04:56:07.000+00:00",
      "end" : "2000-01-23T04:56:07.000+00:00"
    },
    "realizedValue" : 6,
    "predictionsCount" : 0
  } ]
})
    )
    result = UseCaseApi.use_cases_realized_value_over_time_list(use_case_id="useCaseId_example", )
    assert isinstance(result, UseCaseRealizedValuesOverTimeResponse)


@responses.activate
def test_use_case_api_use_cases_retrieve(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/useCases/{useCaseId}/'.format(endpoint=unittest_endpoint,
        useCaseId="useCaseId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "modelHealth" : "",
  "owner" : {
    "firstName" : "firstName",
    "lastName" : "lastName",
    "id" : "id",
    "username" : "username"
  },
  "notes" : "notes",
  "accuracyHealth" : "",
  "predictionsCount" : "",
  "serviceHealth" : "",
  "description" : "description",
  "businessImpact" : 3,
  "potentialValueTemplate" : "",
  "content" : "content",
  "targetDates" : [ {
    "date" : "2000-01-23T04:56:07.000+00:00",
    "stage" : "ideation"
  }, {
    "date" : "2000-01-23T04:56:07.000+00:00",
    "stage" : "ideation"
  } ],
  "feasibility" : 1,
  "predictionTargets" : [ "predictionTargets", "predictionTargets" ],
  "realizedValue" : "",
  "stage" : "ideation",
  "permissions" : [ "permissions", "permissions" ],
  "mentions" : [ {
    "firstName" : "firstName",
    "lastName" : "lastName",
    "id" : "id",
    "username" : "username"
  }, {
    "firstName" : "firstName",
    "lastName" : "lastName",
    "id" : "id",
    "username" : "username"
  } ],
  "name" : "name",
  "commentId" : "commentId",
  "id" : "id",
  "inProductionWarning" : "inProductionWarning",
  "potentialValue" : {
    "currency" : "EUR",
    "details" : "details",
    "value" : 5.962133916683182
  }
})
    )
    result = UseCaseApi.use_cases_retrieve(use_case_id="useCaseId_example", )
    assert isinstance(result, UseCaseResponse)


@responses.activate
def test_use_case_api_use_cases_shared_roles_list(unittest_endpoint):
    responses.add(
        responses.GET,
        '{endpoint}/api/v2/useCases/{useCaseId}/sharedRoles/'.format(endpoint=unittest_endpoint,
        offset=0, limit=10, useCaseId="useCaseId_example", ),
        status=200,
        content_type='application/json',
        body=json.dumps({
  "next" : "https://openapi-generator.tech",
  "data" : [ {
    "shareRecipientType" : "user",
    "role" : "OWNER",
    "name" : "name",
    "id" : "id"
  }, {
    "shareRecipientType" : "user",
    "role" : "OWNER",
    "name" : "name",
    "id" : "id"
  } ],
  "previous" : "https://openapi-generator.tech",
  "count" : 0,
  "totalCount" : 6
})
    )
    result = UseCaseApi.use_cases_shared_roles_list(offset=0, limit=10, use_case_id="useCaseId_example", )
    assert isinstance(result, UseCaseSharingListResponse)


@responses.activate
def test_use_case_api_use_cases_shared_roles_patch_many(unittest_endpoint):
    responses.add(
        responses.PATCH,
        '{endpoint}/api/v2/useCases/{useCaseId}/sharedRoles/'.format(endpoint=unittest_endpoint,
        useCaseId="useCaseId_example", ),
        status=200,
        content_type='',
    )
    result = UseCaseApi.use_cases_shared_roles_patch_many(use_case_id="useCaseId_example", )
    assert isinstance(result, type(None))
